# coding: utf-8

from __future__ import annotations

from datetime import date, datetime  # noqa: F401

import re  # noqa: F401
from typing import Any, Dict, List, Optional, Union, Literal  # noqa: F401

from pydantic import AnyUrl, BaseModel, EmailStr, validator, Field, Extra  # noqa: F401


class ConnRecord(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.

    ConnRecord - a model defined in OpenAPI
        accept: Connection acceptance: manual or auto [Optional].
        alias: Optional alias to apply to connection for later use [Optional].
        connection_id: Connection identifier [Optional].
        connection_protocol: Connection protocol used [Optional].
        created_at: Time of record creation [Optional].
        error_msg: Error message [Optional].
        inbound_connection_id: Inbound routing connection id to use [Optional].
        invitation_key: Public key for connection [Optional].
        invitation_mode: Invitation mode [Optional].
        invitation_msg_id: ID of out-of-band invitation message [Optional].
        my_did: Our DID for connection [Optional].
        request_id: Connection request identifier [Optional].
        rfc23_state: State per RFC 23 [Optional].
        routing_state: Routing state of connection [Optional].
        state: Current record state [Optional].
        their_did: Their DID for connection [Optional].
        their_label: Their label for connection [Optional].
        their_public_did: Other agent&#39;s public DID for connection [Optional].
        their_role: Their role in the connection protocol [Optional].
        updated_at: Time of last record update [Optional].
    """

    accept: Optional[Literal["manual", "auto"]] = None
    alias: Optional[str] = None
    connection_id: Optional[str] = None
    connection_protocol: Optional[Literal["connections/1.0", "didexchange/1.0"]] = None
    created_at: Optional[str] = None
    error_msg: Optional[str] = None
    inbound_connection_id: Optional[str] = None
    invitation_key: Optional[str] = None
    invitation_mode: Optional[Literal["once", "multi", "static"]] = None
    invitation_msg_id: Optional[str] = None
    my_did: Optional[str] = None
    request_id: Optional[str] = None
    rfc23_state: Optional[str] = None
    routing_state: Optional[Literal["none", "request", "active", "error"]] = None
    state: Optional[str] = None
    their_did: Optional[str] = None
    their_label: Optional[str] = None
    their_public_did: Optional[str] = None
    their_role: Optional[Literal["invitee", "requester", "inviter", "responder"]] = None
    updated_at: Optional[str] = None

    def __init__(
        self,
        *,
        accept: Optional[Literal["manual", "auto"]] = None,
        alias: Optional[str] = None,
        connection_id: Optional[str] = None,
        connection_protocol: Optional[
            Literal["connections/1.0", "didexchange/1.0"]
        ] = None,
        created_at: Optional[str] = None,
        error_msg: Optional[str] = None,
        inbound_connection_id: Optional[str] = None,
        invitation_key: Optional[str] = None,
        invitation_mode: Optional[Literal["once", "multi", "static"]] = None,
        invitation_msg_id: Optional[str] = None,
        my_did: Optional[str] = None,
        request_id: Optional[str] = None,
        rfc23_state: Optional[str] = None,
        routing_state: Optional[Literal["none", "request", "active", "error"]] = None,
        state: Optional[str] = None,
        their_did: Optional[str] = None,
        their_label: Optional[str] = None,
        their_public_did: Optional[str] = None,
        their_role: Optional[
            Literal["invitee", "requester", "inviter", "responder"]
        ] = None,
        updated_at: Optional[str] = None,
        **kwargs,
    ):
        super().__init__(
            accept=accept,
            alias=alias,
            connection_id=connection_id,
            connection_protocol=connection_protocol,
            created_at=created_at,
            error_msg=error_msg,
            inbound_connection_id=inbound_connection_id,
            invitation_key=invitation_key,
            invitation_mode=invitation_mode,
            invitation_msg_id=invitation_msg_id,
            my_did=my_did,
            request_id=request_id,
            rfc23_state=rfc23_state,
            routing_state=routing_state,
            state=state,
            their_did=their_did,
            their_label=their_label,
            their_public_did=their_public_did,
            their_role=their_role,
            updated_at=updated_at,
            **kwargs,
        )

    @validator("created_at")
    def created_at_pattern(cls, value):
        # Property is optional
        if value is None:
            return

        pattern = r"^\d{4}-\d\d-\d\d[T ]\d\d:\d\d(?:\:(?:\d\d(?:\.\d{1,6})?))?(?:[+-]\d\d:?\d\d|Z|)$"
        if not re.match(pattern, value):
            raise ValueError(
                f"Value of created_at does not match regex pattern ('{pattern}')"
            )
        return value

    @validator("invitation_key")
    def invitation_key_pattern(cls, value):
        # Property is optional
        if value is None:
            return

        pattern = (
            r"^[123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz]{43,44}$"
        )
        if not re.match(pattern, value):
            raise ValueError(
                f"Value of invitation_key does not match regex pattern ('{pattern}')"
            )
        return value

    @validator("my_did")
    def my_did_pattern(cls, value):
        # Property is optional
        if value is None:
            return

        pattern = r"^(did:sov:)?[123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz]{21,22}$"
        if not re.match(pattern, value):
            raise ValueError(
                f"Value of my_did does not match regex pattern ('{pattern}')"
            )
        return value

    @validator("their_did")
    def their_did_pattern(cls, value):
        # Property is optional
        if value is None:
            return

        pattern = r"^(did:sov:)?[123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz]{21,22}$"
        if not re.match(pattern, value):
            raise ValueError(
                f"Value of their_did does not match regex pattern ('{pattern}')"
            )
        return value

    @validator("updated_at")
    def updated_at_pattern(cls, value):
        # Property is optional
        if value is None:
            return

        pattern = r"^\d{4}-\d\d-\d\d[T ]\d\d:\d\d(?:\:(?:\d\d(?:\.\d{1,6})?))?(?:[+-]\d\d:?\d\d|Z|)$"
        if not re.match(pattern, value):
            raise ValueError(
                f"Value of updated_at does not match regex pattern ('{pattern}')"
            )
        return value

    class Config:
        allow_population_by_field_name = True


ConnRecord.update_forward_refs()
