# -*- coding: utf-8 -*-
"""
doc
"""
# pylint: disable=import-error,wrong-import-order,no-name-in-module

import pytest
import numpy as np

from efermi import pyefermi


def test_efermi_import():
    """test efermi_module working"""
    bands = np.array(
        [[
            -85.39990157, -36.73700546, -36.73700543, -36.7370054, 9.76035271,
            15.16638246, 15.16638247, 15.16638248, 16.60627013, 16.60627015,
            33.44912684, 37.11647673, 37.11647674, 37.11647675
        ],
         [
             -85.39125695, -36.91325724, -36.7641251, -36.76412506,
             12.52166417, 15.13221622, 15.13221624, 17.72172404, 17.72172407,
             18.2509223, 22.09837349, 32.84238067, 35.66056113, 35.66056114
         ],
         [
             -85.39125695, -36.9132572, -36.76412512, -36.76412509,
             12.52166418, 15.13221621, 15.13221622, 17.72172406, 17.72172408,
             18.2509223, 22.0983735, 32.84238068, 35.66056113, 35.66056114
         ],
         [
             -85.38839039, -36.9050697, -36.80543399, -36.80543397, 12.8329073,
             13.20528077, 17.68836536, 18.01799658, 18.01799659, 20.15672333,
             24.52935083, 28.80586708, 28.80586709, 35.514056
         ],
         [
             -85.39125695, -36.91325725, -36.76412509, -36.76412507,
             12.52166418, 15.13221623, 15.13221624, 17.72172405, 17.72172407,
             18.25092229, 22.09837348, 32.84238068, 35.66056113, 35.66056113
         ],
         [
             -85.38839039, -36.90506969, -36.80543401, -36.80543396,
             12.8329073, 13.20528076, 17.68836534, 18.01799658, 18.0179966,
             20.15672334, 24.52935084, 28.80586708, 28.80586709, 35.51405601
         ],
         [
             -85.38839039, -36.90506971, -36.80543399, -36.80543397,
             12.83290729, 13.20528076, 17.68836536, 18.01799658, 18.01799659,
             20.15672334, 24.52935083, 28.80586708, 28.8058671, 35.514056
         ],
         [
             -85.39125695, -36.91325722, -36.76412512, -36.76412507,
             12.52166418, 15.13221622, 15.13221623, 17.72172405, 17.72172408,
             18.2509223, 22.09837349, 32.84238068, 35.66056113, 35.66056114
         ]])
    bands = bands - 18.3253
    nkps = 8
    nelectrons = 19
    weights = np.ones(nkps) / nkps
    swidth = 0.002721
    meth = 2  # fermi-dirac

    got_fl = pyefermi(bands, weights, nelectrons, swidth, meth)
    assert got_fl == pytest.approx(-0.071388, 1e-4)


def test_pyefermi():
    """test pyefermi"""
    #yapf: disable

    # a random metal (magnesium) emulation
    # lattice = [-3.0179389205999998 -3.0179389205999998 0.0000000000000000;
    #         -5.2272235447000002 5.2272235447000002 0.0000000000000000;
    #         0.0000000000000000 0.0000000000000000 -9.7736219469000005],
    bands = np.array(
                [[-0.08063210585291,  0.11227915155236, 0.13057816014162, 0.57672256037074],
                [ 0.09509047528102,  0.09538152469111, 0.27197836572013, 0.28750689088845],
                [-0.00144586520885,  0.18640677556553, 0.19603060374450, 0.24422060327989],
                [ 0.05693643182609,  0.16919740718547, 0.24190245274401, 0.25674283154835],
                [-0.06756541677784,  0.03381889875058, 0.23162853469956, 0.50981867707851],
                [ 0.10685980948954,  0.10728887405642, 0.20784971952147, 0.20786603845828],
                [ 0.01122399002894,  0.11011069317735, 0.24016826005369, 0.30770620467001],
                [ 0.06925846412968,  0.16087157153058, 0.19146746736359, 0.27463770659603],
                [-0.02937886574534, -0.02937886574483, 0.36206906745747, 0.36206906745749],
                [ 0.13314087354890,  0.13314087354890, 0.15834732772541, 0.15834732772541],
                [ 0.04869672986772,  0.04869672986772, 0.27749728805752, 0.27749728805768],
                [ 0.10585630776222,  0.10585630776223, 0.22191839818805, 0.22191839818822]]
    )
    # yapf: enable

    nelectrons = 4
    weights = np.array([
        1 / 24, 1 / 24, 1 / 12, 1 / 12, 1 / 12, 1 / 12, 1 / 6, 1 / 6, 1 / 24,
        1 / 24, 1 / 12, 1 / 12
    ])

    # (:method, :swidth, :expected)
    fermi_dirac = 2
    parameters = [
        (fermi_dirac, 0.01, 0.17251898225370),
        (fermi_dirac, 0.02, 0.17020763046058),
        (fermi_dirac, 0.03, 0.16865552281082),
    ]

    for meth, swidth, expected_ef in parameters:
        got_ef = pyefermi(bands, weights, nelectrons, swidth, meth)

        assert got_ef == pytest.approx(expected_ef, 1e-3)
