"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.S3EventSource = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const notifs = require("@aws-cdk/aws-s3-notifications");
/**
 * Use S3 bucket notifications as an event source for AWS Lambda.
 */
class S3EventSource {
    constructor(bucket, props) {
        this.bucket = bucket;
        this.props = props;
        jsiiDeprecationWarnings._aws_cdk_aws_lambda_event_sources_S3EventSourceProps(props);
    }
    bind(target) {
        const filters = this.props.filters || [];
        for (const event of this.props.events) {
            this.bucket.addEventNotification(event, new notifs.LambdaDestination(target), ...filters);
        }
    }
}
exports.S3EventSource = S3EventSource;
_a = JSII_RTTI_SYMBOL_1;
S3EventSource[_a] = { fqn: "@aws-cdk/aws-lambda-event-sources.S3EventSource", version: "1.147.0" };
//# sourceMappingURL=data:application/json;base64,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