/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.threads;

import com.twosigma.beakerx.jvm.object.EvaluationObject;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.MessageCreatorService;
import com.twosigma.beakerx.kernel.SocketEnum;
import com.twosigma.beakerx.kernel.msg.MessageHolder;
import com.twosigma.beakerx.kernel.threads.ResultSender;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionResultSender
implements ResultSender {
    public static Logger logger = LoggerFactory.getLogger(ExecutionResultSender.class);
    private KernelFunctionality kernel;
    private MessageCreatorService messageCreatorService;

    public ExecutionResultSender(KernelFunctionality kernel, MessageCreatorService messageCreatorService) {
        this.kernel = kernel;
        this.messageCreatorService = messageCreatorService;
    }

    @Override
    public void update(EvaluationObject seo) {
        if (seo != null) {
            List<MessageHolder> message = this.messageCreatorService.createMessage(seo);
            message.forEach(job -> {
                if (SocketEnum.IOPUB_SOCKET.equals((Object)job.getSocketType())) {
                    this.kernel.publish(Collections.singletonList(job.getMessage()));
                } else if (SocketEnum.SHELL_SOCKET.equals((Object)job.getSocketType())) {
                    this.kernel.send(job.getMessage());
                }
            });
        }
    }

    @Override
    public void exit() {
    }
}

