/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.magic.command;

import com.twosigma.beakerx.evaluator.EvaluationObjectFactory;
import com.twosigma.beakerx.kernel.Code;
import com.twosigma.beakerx.kernel.CodeFrame;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.MessageCreatorService;
import com.twosigma.beakerx.kernel.PlainCode;
import com.twosigma.beakerx.kernel.magic.command.ErrorCodeFrame;
import com.twosigma.beakerx.kernel.magic.command.MagicCommand;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandFunctionality;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandType;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutcomeItem;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutput;
import com.twosigma.beakerx.message.Message;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Scanner;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class CodeFactory {
    public static final String CELL_COMMAND_MAGIC = "%%";
    public static final String LINE_COMMAND_MAGIC = "%";
    private MessageCreatorService messageCreatorService;
    private EvaluationObjectFactory evaluationObjectFactory;

    public CodeFactory(MessageCreatorService messageCreatorService, EvaluationObjectFactory evaluationObjectFactory) {
        this.messageCreatorService = messageCreatorService;
        this.evaluationObjectFactory = evaluationObjectFactory;
    }

    public Code create(String allCode, Message message, KernelFunctionality kernel) {
        List<CodeFrame> frames = this.takeCodeFrames(allCode, kernel);
        List<MagicCommandOutcomeItem> errors = frames.stream().filter(x -> x.getError().isPresent()).map(y -> y.getError().get()).collect(Collectors.toList());
        return Code.createCode(allCode, frames, errors, message, this.messageCreatorService, this.evaluationObjectFactory);
    }

    private List<CodeFrame> takeCodeFrames(String allCode, KernelFunctionality kernel) {
        Scanner scanner = new Scanner(allCode);
        ArrayList<CodeFrame> result = new ArrayList<CodeFrame>();
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine().trim();
            if (line.startsWith(CELL_COMMAND_MAGIC)) {
                result.add(this.createFrameForCellMagic(line, scanner, kernel));
                continue;
            }
            if (line.startsWith(LINE_COMMAND_MAGIC)) {
                result.add(this.createFrameForLineMagic(line, kernel));
                continue;
            }
            result.add(this.createFrameForPlainCode(line, scanner));
        }
        return result;
    }

    private CodeFrame createFrameForPlainCode(String line, Scanner scanner) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(line);
        Pattern p = Pattern.compile("\\s*%.*");
        while (scanner.hasNext() && !scanner.hasNext(p)) {
            String str = scanner.nextLine().trim();
            result.add(str);
        }
        return new PlainCode(String.join((CharSequence)System.lineSeparator(), result), this.evaluationObjectFactory);
    }

    private CodeFrame createFrameForLineMagic(String line, KernelFunctionality kernel) {
        Optional<MagicCommandFunctionality> mcOption = this.findMagicCommandFunctionality(kernel.getMagicCommandTypes(), line);
        return mcOption.map(magicCommandFunctionality -> new MagicCommand((MagicCommandFunctionality)magicCommandFunctionality, line)).orElseGet(() -> new ErrorCodeFrame(this.processIllegalCommand("Inline magic " + line + " not found", this.messageCreatorService)));
    }

    private CodeFrame createFrameForCellMagic(String line, Scanner scanner, KernelFunctionality kernel) {
        Optional<MagicCommandFunctionality> mcOption = this.findMagicCommandFunctionality(kernel.getMagicCommandTypes(), line);
        return mcOption.map(magicCommandFunctionality -> new MagicCommand((MagicCommandFunctionality)magicCommandFunctionality, line, this.takeRestOfTheCode(scanner))).orElseGet(() -> new ErrorCodeFrame(this.processIllegalCommand("Cell magic " + line + " not found", this.messageCreatorService)));
    }

    private String takeRestOfTheCode(Scanner scanner) {
        ArrayList<String> result = new ArrayList<String>();
        while (scanner.hasNextLine()) {
            result.add(scanner.nextLine());
        }
        return String.join((CharSequence)System.lineSeparator(), result);
    }

    public Optional<MagicCommandFunctionality> findMagicCommandFunctionality(List<MagicCommandType> commands, String command) {
        return commands.stream().filter(c -> c.getMagicCommandFunctionality().matchCommand(command)).map(MagicCommandType::getMagicCommandFunctionality).findFirst();
    }

    private MagicCommandOutcomeItem processIllegalCommand(String errorMessage, MessageCreatorService messageCreatorService) {
        return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, errorMessage, messageCreatorService);
    }
}

