/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.handler;

import com.twosigma.beakerx.handler.KernelHandler;
import com.twosigma.beakerx.handler.KernelHandlerWrapper;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.MagicKernelManager;
import com.twosigma.beakerx.kernel.comm.Comm;
import com.twosigma.beakerx.message.Message;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommMsgHandler
extends KernelHandler<Message> {
    private static final Logger logger = LoggerFactory.getLogger(CommMsgHandler.class);

    public CommMsgHandler(KernelFunctionality kernel) {
        super(kernel);
    }

    public void handle(Message message) {
        KernelHandlerWrapper.wrapBusyIdle((KernelFunctionality)this.kernel, (Message)message, () -> {
            try {
                this.kernel.startEvaluation();
                this.handleMsg(message);
            }
            finally {
                this.kernel.endEvaluation();
            }
        });
    }

    private void handleMsg(Message message) {
        Map commMap = message.getContent();
        String commId = CommMsgHandler.getString(commMap, "comm_id");
        Comm comm = this.kernel.getComm(commId);
        logger.debug("Comm message handling, target name: " + (comm != null ? comm.getTargetName() : "undefined"));
        if (comm != null) {
            comm.handleMsg(message);
        } else {
            List messages;
            MagicKernelManager magicKernelManager = this.kernel.getManagerByCommId(commId);
            if (magicKernelManager != null && !(messages = magicKernelManager.handleMsg(message)).isEmpty()) {
                this.kernel.publish(messages);
                return;
            }
            logger.warn("No such comm: " + CommMsgHandler.getString(commMap, "comm_id"));
        }
    }

    public static String getString(Map<String, Serializable> map, String name) {
        String ret = null;
        if (map != null && name != null && map.containsKey(name)) {
            ret = (String)((Object)map.get(name));
        }
        return ret;
    }
}

