/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.chart.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.twosigma.beakerx.chart.histogram.Histogram;
import com.twosigma.beakerx.chart.serializer.AbstractChartSerializer;
import com.twosigma.beakerx.chart.serializer.HistogramReducer;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.OptionalInt;

public class HistogramSerializer
extends AbstractChartSerializer<Histogram> {
    public static final String GRAPHICS_LIST = "graphics_list";
    public static final String BIN_COUNT = "bin_count";
    public static final String COLOR = "color";
    public static final String COLORS = "colors";
    public static final String NAMES = "names";
    public static final String DISPLAY_MODE = "displayMode";
    public static final String CUMULATIVE = "cumulative";
    public static final String NORMED = "normed";
    public static final String LOG = "log";
    public static final String ITEMS = " items";
    private HistogramReducer histogramReducer = new HistogramReducer(1000000, 10000);

    public void serialize(Histogram histogram, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        this.serialize(histogram, jgen);
        if (histogram.getColors() != null) {
            jgen.writeObjectField(COLORS, histogram.getColors());
        } else {
            jgen.writeObjectField(COLOR, (Object)histogram.getColor());
        }
        if (histogram.getListData() != null) {
            this.serializeListData(jgen, histogram.getListData());
        } else {
            this.serializeData(jgen, histogram.getData() != null ? histogram.getData() : Collections.emptyList());
        }
        jgen.writeObjectField("right_close", (Object)histogram.getRightClose());
        if (histogram.getRangeMin() != null) {
            jgen.writeObjectField("range_min", (Object)histogram.getRangeMin());
        }
        if (histogram.getRangeMax() != null) {
            jgen.writeObjectField("range_max", (Object)histogram.getRangeMax());
        }
        jgen.writeObjectField(BIN_COUNT, (Object)histogram.getBinCount());
        jgen.writeObjectField(CUMULATIVE, (Object)histogram.getCumulative());
        jgen.writeObjectField(NORMED, (Object)histogram.getNormed());
        jgen.writeObjectField(LOG, (Object)histogram.getLog());
        jgen.writeObjectField(DISPLAY_MODE, (Object)histogram.getDisplayMode());
        jgen.writeObjectField(NAMES, histogram.getNames());
        jgen.writeEndObject();
    }

    private void serializeData(JsonGenerator jgen, List<Number> list) throws IOException {
        if (1000000 < list.size()) {
            jgen.writeObjectField(GRAPHICS_LIST, this.histogramReducer.limitData(list));
            jgen.writeBooleanField("tooManyRows", true);
            jgen.writeObjectField("rowsLimitItems", (Object)1000000);
            jgen.writeObjectField("numberOfPointsToDisplay", (Object)"10000 items");
        } else {
            jgen.writeObjectField(GRAPHICS_LIST, Collections.singletonList(list));
            jgen.writeBooleanField("tooManyRows", false);
        }
        jgen.writeObjectField("totalNumberOfPoints", (Object)list.size());
    }

    private void serializeListData(JsonGenerator jgen, List<List<Number>> listData) throws IOException {
        OptionalInt max = this.histogramReducer.totalPoints(listData);
        List<List<Number>> limited = this.histogramReducer.limitListData(listData);
        jgen.writeObjectField(GRAPHICS_LIST, limited);
        jgen.writeObjectField("totalNumberOfPoints", (Object)max.orElse(0));
        jgen.writeBooleanField("tooManyRows", max.isPresent() && 1000000 <= max.getAsInt());
        jgen.writeObjectField("rowsLimitItems", (Object)1000000);
        jgen.writeObjectField("numberOfPointsToDisplay", (Object)"10000 items");
    }
}

