/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.magic.command.functionality;

import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.MessageCreatorService;
import com.twosigma.beakerx.kernel.Repos;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandExecutionParam;
import com.twosigma.beakerx.kernel.magic.command.MavenJarResolver;
import com.twosigma.beakerx.kernel.magic.command.PomFactory;
import com.twosigma.beakerx.kernel.magic.command.functionality.ClasspathMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.MagicCommandUtils;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutcomeItem;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutput;
import com.twosigma.beakerx.kernel.msg.MessageCreator;
import com.twosigma.beakerx.message.Message;
import com.twosigma.beakerx.util.Preconditions;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ClasspathAddMvnMagicCommand
extends ClasspathMagicCommand {
    public static final String ADD = "add";
    public static final String MVN = "mvn";
    public static final String CLASSPATH_ADD_MVN = "%classpath add mvn";
    public static final String ADD_MVN_FORMAT_ERROR_MESSAGE = "Wrong command format, should be%classpath add mvn group name version [type classifier] or %classpath add mvn group:name:version[:type:classifier]";
    public static Map<String, String> DEFAULT_MAVEN_REPOS = Collections.unmodifiableMap(new HashMap<String, String>(){
        {
            this.put("jitpack.io", "https://jitpack.io");
        }
    });
    private MavenJarResolver.ResolverParams commandParams;
    private PomFactory pomFactory;
    private Repos repos;

    public ClasspathAddMvnMagicCommand(MavenJarResolver.ResolverParams commandParams, KernelFunctionality kernel, MessageCreatorService messageCreatorService) {
        super(kernel, messageCreatorService);
        this.commandParams = (MavenJarResolver.ResolverParams)Preconditions.checkNotNull((Object)commandParams);
        this.pomFactory = new PomFactory();
        this.resetRepo();
    }

    public String getMagicCommandName() {
        return CLASSPATH_ADD_MVN;
    }

    public boolean matchCommand(String command) {
        String[] commandParts = MagicCommandUtils.splitPath((String)command);
        return commandParts.length > 3 && commandParts[0].equals("%classpath") && commandParts[1].equals(ADD) && commandParts[2].equals(MVN);
    }

    public MagicCommandOutcomeItem execute(MagicCommandExecutionParam param) {
        String command = param.getCommand();
        Message message = param.getCode().getMessage();
        return this.execute(command, message);
    }

    public MagicCommandOutcomeItem execute(String command, Message message) {
        String[] split = MagicCommandUtils.splitPath((String)command);
        if (!this.isGradleFormat(split) && !this.isMavenFormat(split)) {
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, ADD_MVN_FORMAT_ERROR_MESSAGE, MessageCreator.get());
        }
        this.commandParams.setRepos(this.getRepos().get());
        MavenJarResolver classpathAddMvnCommand = new MavenJarResolver(this.commandParams, this.pomFactory);
        MavenJarResolver.AddMvnCommandResult result = this.retrieve(this.getDependency(split), classpathAddMvnCommand, message);
        if (result.isJarRetrieved()) {
            return this.handleAddedJars(result.getAddedJarPaths());
        }
        return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, result.getErrorMessage(), MessageCreator.get());
    }

    private MavenJarResolver.Dependency getDependency(String[] split) {
        if (this.isGradleFormat(split)) {
            String[] valuesFromGradlePattern = split[3].split(":");
            return MavenJarResolver.Dependency.create(Arrays.asList(valuesFromGradlePattern));
        }
        return MavenJarResolver.Dependency.create(Arrays.asList(split).subList(3, split.length));
    }

    private boolean isMavenFormat(String[] split) {
        return split.length > 5;
    }

    private boolean isGradleFormat(String[] split) {
        if (split.length == 4) {
            String[] valuesFromGradlePattern = split[3].split(":");
            return valuesFromGradlePattern.length > 2;
        }
        return false;
    }

    private MavenJarResolver.AddMvnCommandResult retrieve(MavenJarResolver.Dependency dependency, MavenJarResolver classpathAddMvnCommand, Message parent) {
        return classpathAddMvnCommand.retrieve(dependency, parent);
    }

    public MavenJarResolver.ResolverParams getCommandParams() {
        return this.commandParams;
    }

    public Repos getRepos() {
        return this.repos;
    }

    public String addRepo(String name, String url) {
        return this.repos.add(name, url);
    }

    public void resetRepo() {
        this.repos = new Repos();
        DEFAULT_MAVEN_REPOS.entrySet().stream().forEach(x -> this.repos.add((String)x.getKey(), (String)x.getValue()));
    }
}

