/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.magic.autocomplete;

import com.twosigma.beakerx.autocomplete.AutocompleteNode;
import com.twosigma.beakerx.autocomplete.AutocompleteResult;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class AutocompleteNodeFileSystem
extends AutocompleteNode {
    private DirectoryStream.Filter<Path> filter = path -> {
        if (path.toFile().isFile()) {
            return path.toString().endsWith(".jar");
        }
        return true;
    };

    public AutocompleteNodeFileSystem(String name, List<AutocompleteNode> children) {
        super(name, children);
    }

    public Optional<AutocompleteResult> matchToTheWord(String text, LinkedList<String> parts, String last) {
        List<String> result = this.list(parts, last);
        if (!result.isEmpty()) {
            return Optional.of(new AutocompleteResult(result, text.length() - last.length()));
        }
        return Optional.empty();
    }

    public Optional<AutocompleteResult> findNextWord(String text, LinkedList<String> parts) {
        String dir = ".";
        List<String> result = this.list(parts, dir);
        if (!result.isEmpty()) {
            return Optional.of(new AutocompleteResult(result, text.length()));
        }
        return Optional.empty();
    }

    @NotNull
    private List<String> list(LinkedList<String> parts, String dir) {
        if (parts.isEmpty()) {
            try {
                Path path = Paths.get(dir, new String[0]);
                if (Files.exists(path, new LinkOption[0])) {
                    return this.listDirectory(path);
                }
                return this.listParentDirectory(path);
            }
            catch (Exception e) {
                return new ArrayList<String>();
            }
        }
        return new ArrayList<String>();
    }

    @NotNull
    private List<String> listParentDirectory(Path path) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        Path parent = path.getParent();
        Files.newDirectoryStream(parent, p -> {
            if (p.toString().startsWith(path.toString())) {
                if (p.toFile().isFile()) {
                    return p.toString().endsWith(".jar");
                }
                return true;
            }
            return false;
        }).forEach(x -> result.add(x.toString()));
        return result;
    }

    @NotNull
    private List<String> listDirectory(Path path) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        Files.newDirectoryStream(path, this.filter).forEach(x -> result.add(x.toString()));
        return result;
    }
}

