/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel;

import com.twosigma.beakerx.handler.CompleteHandler;
import com.twosigma.beakerx.handler.Handler;
import com.twosigma.beakerx.handler.HistoryHandler;
import com.twosigma.beakerx.handler.InspectHandler;
import com.twosigma.beakerx.handler.IsCompleteRequestHandler;
import com.twosigma.beakerx.handler.KernelHandler;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.handler.CommCloseHandler;
import com.twosigma.beakerx.kernel.handler.CommInfoHandler;
import com.twosigma.beakerx.kernel.handler.CommMsgHandler;
import com.twosigma.beakerx.kernel.handler.CommOpenHandler;
import com.twosigma.beakerx.kernel.handler.ExecuteRequestHandler;
import com.twosigma.beakerx.kernel.handler.InterruptMsgHandler;
import com.twosigma.beakerx.kernel.msg.JupyterMessages;
import com.twosigma.beakerx.message.Message;
import java.util.HashMap;
import java.util.Map;

public class KernelHandlers {
    private Map<JupyterMessages, KernelHandler<Message>> handlers;
    private KernelFunctionality kernel;

    public KernelHandlers(KernelFunctionality kernel, CommOpenHandler commOpenHandler, KernelHandler<Message> kernelInfoHandler) {
        this.kernel = kernel;
        this.handlers = this.createHandlers(commOpenHandler, kernelInfoHandler);
    }

    private Map<JupyterMessages, KernelHandler<Message>> createHandlers(CommOpenHandler commOpenHandler, KernelHandler<Message> kernelInfoHandler) {
        HashMap<JupyterMessages, KernelHandler<Message>> handlers = new HashMap<JupyterMessages, KernelHandler<Message>>();
        if (kernelInfoHandler != null) {
            handlers.put(JupyterMessages.KERNEL_INFO_REQUEST, kernelInfoHandler);
        }
        if (commOpenHandler != null) {
            handlers.put(JupyterMessages.COMM_OPEN, commOpenHandler);
        }
        handlers.put(JupyterMessages.EXECUTE_REQUEST, new ExecuteRequestHandler(this.kernel));
        handlers.put(JupyterMessages.COMPLETE_REQUEST, new CompleteHandler(this.kernel));
        handlers.put(JupyterMessages.INSPECT_REQUEST, new InspectHandler(this.kernel));
        handlers.put(JupyterMessages.HISTORY_REQUEST, new HistoryHandler(this.kernel));
        handlers.put(JupyterMessages.COMM_INFO_REQUEST, new CommInfoHandler(this.kernel));
        handlers.put(JupyterMessages.COMM_CLOSE, new CommCloseHandler(this.kernel));
        handlers.put(JupyterMessages.COMM_MSG, new CommMsgHandler(this.kernel));
        handlers.put(JupyterMessages.IS_COMPLETE_REQUEST, new IsCompleteRequestHandler(this.kernel));
        handlers.put(JupyterMessages.INTERRUPT_REQUEST, new InterruptMsgHandler(this.kernel));
        return handlers;
    }

    public Handler<Message> get(JupyterMessages type) {
        return this.handlers.get(type);
    }

    public ExecuteRequestHandler getExecuteRequestHandler() {
        return (ExecuteRequestHandler)this.handlers.get(JupyterMessages.EXECUTE_REQUEST);
    }

    public void exit() {
        for (KernelHandler<Message> handler : this.handlers.values()) {
            handler.exit();
        }
    }
}

