/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel;

import com.twosigma.beakerx.evaluator.EvaluationObjectFactory;
import com.twosigma.beakerx.kernel.CodeFrame;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.MessageCreatorService;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutcomeItem;
import com.twosigma.beakerx.message.Message;
import com.twosigma.beakerx.util.Preconditions;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class Code {
    private final String allCode;
    private final List<MagicCommandOutcomeItem> errors;
    private final Message message;
    private final MessageCreatorService mesasgeCreatorService;
    private List<CodeFrame> codeFrames;

    private Code(String allCode, List<CodeFrame> codeFrames, List<MagicCommandOutcomeItem> errors, Message message, MessageCreatorService mesasgeCreatorService) {
        this.allCode = allCode;
        this.codeFrames = Preconditions.checkNotNull(codeFrames);
        this.errors = Preconditions.checkNotNull(errors);
        this.message = message;
        this.mesasgeCreatorService = mesasgeCreatorService;
    }

    public static Code createCode(String allCode, List<CodeFrame> codeFrames, List<MagicCommandOutcomeItem> errors, Message message, MessageCreatorService mesasgeCreatorService, EvaluationObjectFactory evaluationObjectFactory) {
        return new Code(allCode, codeFrames, errors, message, mesasgeCreatorService);
    }

    public List<CodeFrame> getCodeFrames() {
        return this.codeFrames;
    }

    public String asString() {
        return this.allCode;
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public List<MagicCommandOutcomeItem> getErrors() {
        return this.errors;
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public Message getMessage() {
        return this.message;
    }

    public void execute(KernelFunctionality kernel, int executionCount) {
        if (this.hasErrors()) {
            this.errors.forEach(item -> {
                item.sendMagicCommandOutcome(kernel, this.message, executionCount);
                kernel.send(this.mesasgeCreatorService.buildReplyWithErrorStatus(this.message, executionCount));
            });
        } else {
            try {
                kernel.startEvaluation();
                this.takeCodeFramesWithoutLast().forEach(frame -> frame.executeFrame(this, kernel, this.message, executionCount));
                this.takeLastCodeFrame().executeLastFrame(this, kernel, this.message, executionCount);
            }
            finally {
                kernel.endEvaluation();
            }
        }
    }

    private CodeFrame takeLastCodeFrame() {
        return this.getCodeFrames().get(this.getCodeFrames().size() - 1);
    }

    private List<CodeFrame> takeCodeFramesWithoutLast() {
        return this.getCodeFrames().subList(0, this.getCodeFrames().size() - 1);
    }
}

