/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel;

import com.twosigma.beakerx.kernel.BeakerXClasspath;
import com.twosigma.beakerx.kernel.PathToJar;
import com.twosigma.beakerx.util.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class Classpath
implements BeakerXClasspath {
    public static final String DELIMITER = System.lineSeparator();
    private List<PathToJar> paths = new ArrayList<PathToJar>();

    @Override
    public boolean add(PathToJar path) {
        Preconditions.checkNotNull(path);
        if (!this.paths.contains(path)) {
            return this.paths.add(path);
        }
        return false;
    }

    @Override
    public List<PathToJar> getPaths() {
        return this.paths;
    }

    @Override
    public List<String> getPathsAsStrings() {
        return this.paths.stream().map(PathToJar::getPath).collect(Collectors.toList());
    }

    @Override
    public int size() {
        return this.paths.size();
    }

    @Override
    public String get(int index) {
        return this.paths.get(index).getPath();
    }

    @Override
    public boolean isEmpty() {
        return this.paths.isEmpty();
    }

    public String toString() {
        return this.paths.stream().map(PathToJar::getPath).collect(Collectors.joining(DELIMITER));
    }

    @Override
    public boolean isJarOnClasspath(String jarName) {
        return this.getPathsAsStrings().stream().anyMatch(x -> x.contains(jarName));
    }
}

