/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.widget;

import com.twosigma.beakerx.widget.SparkSessionBuilder;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.SparkSession;
import scala.Tuple2;
import scala.collection.Iterator;

public class SparkSessionBuilderImpl
implements SparkSessionBuilder {
    private SparkSession.Builder sparkSessionBuilder;

    public SparkSessionBuilderImpl(SparkSession.Builder sparkSessionBuilder) {
        this.sparkSessionBuilder = sparkSessionBuilder;
    }

    @Override
    public SparkSession getOrCreate() {
        return this.sparkSessionBuilder.getOrCreate();
    }

    @Override
    public void config(String key, String value) {
        this.sparkSessionBuilder.config(key, value);
    }

    @Override
    public void enableHiveSupport() {
        this.sparkSessionBuilder.enableHiveSupport();
    }

    @Override
    public Map<String, Object> getSparkConfAsMap() {
        HashMap<String, Object> sparkConf = new HashMap<String, Object>();
        Iterator iterator = this.getConfigIterator();
        while (iterator.hasNext()) {
            Tuple2 x = (Tuple2)iterator.next();
            sparkConf.put((String)x._1, x._2);
        }
        return sparkConf;
    }

    @Override
    public SparkConf getSparkConf() {
        SparkConf sparkConf = new SparkConf();
        Iterator iterator = this.getConfigIterator();
        while (iterator.hasNext()) {
            Tuple2 x = (Tuple2)iterator.next();
            sparkConf.set((String)x._1, (String)x._2);
        }
        return sparkConf;
    }

    @Override
    public void stop() {
        this.getOrCreate().sparkContext().stop();
    }

    @Override
    public void cancelAllJobs() {
        this.getOrCreate().sparkContext().cancelAllJobs();
    }

    @Override
    public void cancelStage(int stageid) {
        this.getOrCreate().sparkContext().cancelStage(stageid);
    }

    private Iterator getConfigIterator() {
        try {
            Field options = this.getOptionsField(this.sparkSessionBuilder);
            options.setAccessible(true);
            return ((scala.collection.mutable.HashMap)options.get(this.sparkSessionBuilder)).iterator();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Field getOptionsField(SparkSession.Builder sparkSessionBuilder) {
        Field[] declaredFields = sparkSessionBuilder.getClass().getDeclaredFields();
        Optional<Field> options = Arrays.stream(declaredFields).filter(f -> f.getName().contains("options")).findFirst();
        if (options.isPresent()) {
            return options.get();
        }
        throw new RuntimeException("SparkSession.builder does not contain 'options' field.");
    }
}

