/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.widget;

import com.twosigma.beakerx.TryResult;
import com.twosigma.beakerx.evaluator.SimpleEvaluationObjectFactory;
import com.twosigma.beakerx.jvm.object.EvaluationObject;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.KernelManager;
import com.twosigma.beakerx.kernel.msg.JupyterMessages;
import com.twosigma.beakerx.message.Header;
import com.twosigma.beakerx.message.Message;
import com.twosigma.beakerx.scala.magic.command.JobLinkFactory;
import com.twosigma.beakerx.scala.magic.command.SparkUiWebUrlFactory;
import com.twosigma.beakerx.scala.magic.command.StageLinkFactory;
import com.twosigma.beakerx.widget.ErrorPrinter;
import com.twosigma.beakerx.widget.SparkEngine;
import com.twosigma.beakerx.widget.SparkEngineConf;
import com.twosigma.beakerx.widget.SparkSessionBuilder;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.RuntimeConfig;
import org.apache.spark.sql.SparkSession;
import org.jetbrains.annotations.NotNull;

abstract class SparkEngineBase
implements SparkEngine {
    public static final String STOP = "stop";
    protected SparkSessionBuilder userSparkSessionBuilder;
    protected SparkSessionBuilder sparkSessionBuilder;
    private ErrorPrinter errorPrinter;
    protected SparkEngineConf conf = new SparkEngineConf();
    private StageLinkFactory stageLinkFactory;
    private JobLinkFactory jobLinkFactory;
    private SparkUiWebUrlFactory sparkUiWebUrlFactory;
    protected String stopContext = "stop";

    SparkEngineBase(SparkSessionBuilder sparkSessionBuilder, ErrorPrinter errorPrinter) {
        this.userSparkSessionBuilder = sparkSessionBuilder;
        this.errorPrinter = errorPrinter;
        this.jobLinkFactory(this.createJobLinkFactory());
        this.stageLinkFactory(this.createStageLinkFactory());
        this.sparkUiWebUrlFactory(this.createSparkUiWebUrl());
    }

    @Override
    public String getConf(String name) {
        SparkSession sparkSession = this.getOrCreate();
        if (sparkSession != null && sparkSession.sparkContext().getConf().contains(name)) {
            return this.getOrCreate().sparkContext().getConf().get(name);
        }
        return "";
    }

    @Override
    public String stageLink(int stageId) {
        return this.stageLinkFactory.create(stageId);
    }

    @Override
    public String jobLink(int jobId) {
        return this.jobLinkFactory.create(jobId);
    }

    @Override
    public void additionalConf(SparkEngineConf conf) {
        this.conf = conf;
    }

    @Override
    public SparkEngineConf getSparkEngineConf() {
        return this.conf;
    }

    @Override
    public void configAutoStart() {
    }

    protected TryResult createSparkSession() {
        try {
            SparkSession sparkSession = this.getOrCreate();
            return TryResult.createResult((Object)sparkSession);
        }
        catch (Exception e) {
            return TryResult.createError((String)this.errorPrinter.print(e));
        }
    }

    private SparkSession getOrCreate() {
        return this.sparkSessionBuilder.getOrCreate();
    }

    @Override
    public String getSparkAppId() {
        RuntimeConfig conf = this.getOrCreate().conf();
        return (String)conf.getAll().get((Object)"spark.app.id").get();
    }

    @Override
    public String getSparkUiWebUrl() {
        return this.sparkUiWebUrlFactory.create();
    }

    @Override
    public String sparkVersion() {
        try {
            InputStream sparkProps = Thread.currentThread().getContextClassLoader().getResourceAsStream("spark-version-info.properties");
            Properties props = new Properties();
            props.load(sparkProps);
            return props.getProperty("version");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected TryResult initSparkContextInShell(KernelFunctionality kernel, Message parent) {
        String addSc = String.format("import com.twosigma.beakerx.widget.SparkVariable\nval %s = SparkVariable.getSparkSession()\nval %s = %s.sparkContext\nimport org.apache.spark.SparkContext._\nimport %s.implicits._\nimport %s.sql\nimport org.apache.spark.sql.functions._\n", "spark", "sc", "spark", "spark", "spark");
        EvaluationObject seo = SimpleEvaluationObjectFactory.get().createSeo(addSc, kernel, new Message(new Header(JupyterMessages.COMM_MSG, parent.getHeader().getSession())), 1);
        return kernel.executeCode(addSc, seo);
    }

    protected SparkConf createSparkConf(Map<String, Object> sparkOptions) {
        SparkConf sparkConf = new SparkConf();
        sparkOptions.forEach((k, v) -> {
            if (k.equals("properties")) {
                List properties = (List)v;
                properties.forEach(p -> {
                    Map m = (Map)p;
                    sparkConf.set((String)m.get("name"), (String)m.get("value"));
                });
            } else {
                sparkConf.set(k, v != null ? v.toString() : "");
            }
        });
        return sparkConf;
    }

    @Override
    public Map<String, Object> getUserSparkConfAsMap() {
        return this.userSparkSessionBuilder.getSparkConfAsMap();
    }

    protected void configureSparkConf(SparkConf sparkConf) {
        if (!sparkConf.contains("spark.app.name")) {
            sparkConf.setAppName("beaker_" + UUID.randomUUID().toString());
        }
        if (sparkConf.contains("spark.master") && !SparkEngineBase.isLocalSpark(sparkConf)) {
            sparkConf.set("spark.repl.class.outputDir", KernelManager.get().getOutDir());
        }
    }

    private static boolean isLocalSpark(SparkConf sparkConf) {
        return sparkConf.contains("spark.master") && sparkConf.get("spark.master") != null && sparkConf.get("spark.master").startsWith("local");
    }

    @Override
    public void jobLinkFactory(JobLinkFactory jobLinkFactory) {
        this.jobLinkFactory = jobLinkFactory;
    }

    @Override
    public void stageLinkFactory(StageLinkFactory stageLinkFactory) {
        this.stageLinkFactory = stageLinkFactory;
    }

    @Override
    public void sparkUiWebUrlFactory(SparkUiWebUrlFactory factory) {
        this.sparkUiWebUrlFactory = factory;
    }

    @NotNull
    protected StageLinkFactory createStageLinkFactory() {
        return stageId -> {
            if (this.getOrCreate().sparkContext().uiWebUrl().isDefined()) {
                return (String)this.getOrCreate().sparkContext().uiWebUrl().get() + "/stages/stage/?id=" + stageId + "&attempt=0";
            }
            return "";
        };
    }

    @NotNull
    protected JobLinkFactory createJobLinkFactory() {
        return jobId -> {
            if (this.getOrCreate().sparkContext().uiWebUrl().isDefined()) {
                return (String)this.getOrCreate().sparkContext().uiWebUrl().get() + "/jobs/job/?id=" + jobId;
            }
            return "";
        };
    }

    @NotNull
    protected SparkUiWebUrlFactory createSparkUiWebUrl() {
        return () -> (String)this.getOrCreate().sparkContext().uiWebUrl().get();
    }

    @Override
    public String getStopContext() {
        return this.stopContext;
    }
}

