/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.widget;

import com.twosigma.beakerx.table.TableDisplay;
import com.twosigma.beakerx.widget.Button;
import com.twosigma.beakerx.widget.Output;
import com.twosigma.beakerx.widget.Widget;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class PreviewTableDisplay {
    public static final String PREVIEW = "Preview";
    public static int ROWS = 10;
    private final List<Widget> previewContent;
    private Output panel;
    private Collection<Map<String, Object>> preview;
    private Rows allRows;

    public PreviewTableDisplay(Collection<Map<String, Object>> previewRows, Rows allRows, Button button) {
        this.allRows = allRows;
        this.preview = previewRows;
        this.previewContent = Arrays.asList(this.configureShowRowsButton(button), new TableDisplay(this.preview));
        this.panel = new Output();
        this.panel.display();
    }

    public PreviewTableDisplay(Collection<Map<String, Object>> previewRows, Rows allRows) {
        this(previewRows, allRows, new Button());
    }

    private Button configureShowRowsButton(Button button) {
        button.setDescription((Object)("Preview " + ROWS + " Rows"));
        button.registerOnClick((content, message) -> {
            TableDisplay tableDisplay = new TableDisplay((Map[])this.allRows.get(ROWS + 1));
            tableDisplay.ROWS_LIMIT = ROWS;
            tableDisplay.ROW_LIMIT_TO_INDEX = ROWS;
            tableDisplay.setRowLimitMsg(String.format("Note: materializing a %s row preview of a Spark RDD", ROWS));
            this.panel.clearOutput();
            this.panel.display((Widget)tableDisplay);
        });
        return button;
    }

    public void display() {
        this.panel.displayWidgets(this.previewContent);
    }

    public static interface Rows {
        public Map<String, Object>[] get(int var1);
    }
}

