/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.scala.magic.command;

import com.twosigma.beakerx.kernel.KernelInfo;
import com.twosigma.beakerx.message.Message;
import com.twosigma.beakerx.scala.magic.command.SparkMagicCommandOptions;
import com.twosigma.beakerx.widget.SparkEngine;
import com.twosigma.beakerx.widget.SparkEngineConf;
import org.apache.spark.SparkConf;

public class YarnSparkOptionCommand
implements SparkMagicCommandOptions.SparkOptionCommand {
    private static final String PROXY_URI_BASES = "spark.org.apache.hadoop.yarn.server.webproxy.amfilter.AmIpFilter.param.PROXY_URI_BASES";

    @Override
    public void run(SparkEngine sparkEngine, Message parent) {
        SparkEngineConf conf = new SparkEngineConf();
        conf.setMaster("yarn");
        conf.setExecutorCores("4");
        conf.setExecutorMemory("1g");
        sparkEngine.additionalConf(conf);
    }

    public static void runtimeConfiguration(SparkEngine sparkEngine, SparkConf sparkConf) {
        sparkConf.set("spark.submit.deployMode", "client");
        sparkConf.set("spark.yarn.jars", KernelInfo.mvnRepoPath() + "/*");
        sparkEngine.sparkUiWebUrlFactory(() -> sparkEngine.getConf(PROXY_URI_BASES));
        sparkEngine.stageLinkFactory(stageId -> {
            String url = sparkEngine.getSparkUiWebUrl();
            return url + "/stages/stage/?id=" + stageId + "&attempt=0";
        });
        sparkEngine.jobLinkFactory(jobId -> {
            String url = sparkEngine.getSparkUiWebUrl();
            return url + "/jobs/job/?id=" + jobId;
        });
    }

    @Override
    public String getName() {
        return "yarn";
    }
}

