/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.scala.magic.command;

import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandExecutionParam;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandFunctionality;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutcomeItem;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutput;
import com.twosigma.beakerx.kernel.msg.MessageCreator;
import com.twosigma.beakerx.scala.magic.command.SparkFactory;
import com.twosigma.beakerx.scala.magic.command.SparkFactoryImpl;
import com.twosigma.beakerx.scala.magic.command.SparkMagicCommandOptions;
import com.twosigma.beakerx.scala.magic.command.SparkSessionBuilderFactoryImpl;
import com.twosigma.beakerx.widget.SingleSparkSession;
import com.twosigma.beakerx.widget.SparkEngineNoUIImpl;
import com.twosigma.beakerx.widget.SparkEngineWithUIImpl;
import com.twosigma.beakerx.widget.SparkListenerServiceImpl;
import com.twosigma.beakerx.widget.SparkUI;
import com.twosigma.beakerx.widget.SparkUiDefaultsImpl;
import java.util.Arrays;

public class SparkMagicCommand
implements MagicCommandFunctionality {
    public static final String SPARK = "%%sparkRunner";
    public static final SingleSparkSession SINGLE_SPARK_SESSION = new SingleSparkSessionImpl();
    private KernelFunctionality kernel;
    private SparkFactory sparkFactory;
    private SparkMagicCommandOptions sparkMagicCommandOptions;

    public SparkMagicCommand(KernelFunctionality kernel) {
        this(kernel, new SparkFactoryImpl(kernel, new SparkEngineNoUIImpl.SparkEngineNoUIFactoryImpl(), new SparkEngineWithUIImpl.SparkEngineWithUIFactoryImpl(), new SparkUI.SparkUIFactoryImpl(SINGLE_SPARK_SESSION), new SparkUiDefaultsImpl(kernel.getBeakerXJson()), new SparkSessionBuilderFactoryImpl(), new SparkListenerServiceImpl()));
    }

    SparkMagicCommand(KernelFunctionality kernel, SparkFactory sparkFactory) {
        this.kernel = kernel;
        this.sparkFactory = sparkFactory;
        this.sparkMagicCommandOptions = new SparkMagicCommandOptions();
    }

    public String getMagicCommandName() {
        return SPARK;
    }

    public MagicCommandOutcomeItem execute(MagicCommandExecutionParam param) {
        String[] options = this.getOptions(param);
        SparkMagicCommandOptions.OptionsResult optionsResult = this.sparkMagicCommandOptions.parseOptions(options);
        if (optionsResult.hasError()) {
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, optionsResult.errorMsg(), MessageCreator.get());
        }
        return this.sparkFactory.createSpark(param, optionsResult.options());
    }

    private String[] getOptions(MagicCommandExecutionParam param) {
        String[] parts = param.getCommand().split(" ");
        if (parts.length == 1) {
            return new String[0];
        }
        return Arrays.copyOfRange(parts, 1, parts.length);
    }

    public static class SingleSparkSessionImpl
    implements SingleSparkSession {
        private boolean active = false;

        @Override
        public boolean isActive() {
            return this.active;
        }

        @Override
        public void activate() {
            this.active = true;
        }

        @Override
        public void inActivate() {
            this.active = false;
        }
    }
}

