/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.scala.magic.command;

import com.twosigma.beakerx.Display;
import com.twosigma.beakerx.TryResult;
import com.twosigma.beakerx.evaluator.InternalVariable;
import com.twosigma.beakerx.evaluator.SimpleEvaluationObjectFactory;
import com.twosigma.beakerx.jvm.object.EvaluationObject;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandExecutionParam;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutcomeItem;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutput;
import com.twosigma.beakerx.kernel.msg.MessageCreator;
import com.twosigma.beakerx.message.Message;
import com.twosigma.beakerx.scala.magic.command.SparkFactory;
import com.twosigma.beakerx.scala.magic.command.SparkMagicCommandOptions;
import com.twosigma.beakerx.widget.SparkEngineNoUI;
import com.twosigma.beakerx.widget.SparkEngineNoUIImpl;
import com.twosigma.beakerx.widget.SparkEngineWithUI;
import com.twosigma.beakerx.widget.SparkEngineWithUIFactory;
import com.twosigma.beakerx.widget.SparkListenerService;
import com.twosigma.beakerx.widget.SparkSessionBuilder;
import com.twosigma.beakerx.widget.SparkSessionBuilderFactory;
import com.twosigma.beakerx.widget.SparkUIApi;
import com.twosigma.beakerx.widget.SparkUIFactory;
import com.twosigma.beakerx.widget.SparkUiDefaults;
import java.util.List;
import java.util.Optional;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.SparkSession;

public class SparkFactoryImpl
implements SparkFactory {
    public static final String SPARK_SESSION_AVAILABLE_BY_SPARK = "SparkSession is available by 'spark'";
    public static final String CONFIGURATION_MUST_BE_PROVIDED = "Body of  %%spark magic command must return SparkConf object or SparkSession.Builder object";
    private final SparkEngineWithUIFactory sparkEngineWithUIFactory;
    private KernelFunctionality kernel;
    private SparkEngineNoUIImpl.SparkEngineNoUIFactory sparkEngineNoUIFactory;
    private SparkUIFactory sparkUIFactory;
    private SparkUiDefaults sparkUiDefaults;
    private SparkSessionBuilderFactory sparkSessionBuilderFactory;
    private SparkListenerService sparkListenerService;

    public SparkFactoryImpl(KernelFunctionality kernel, SparkEngineNoUIImpl.SparkEngineNoUIFactory sparkEngineNoUIFactory, SparkEngineWithUIFactory sparkEngineWithUIFactory, SparkUIFactory sparkUIFactory, SparkUiDefaults sparkUiDefaults, SparkSessionBuilderFactory sparkSessionBuilderFactory, SparkListenerService sparkListenerService) {
        this.kernel = kernel;
        this.sparkEngineNoUIFactory = sparkEngineNoUIFactory;
        this.sparkEngineWithUIFactory = sparkEngineWithUIFactory;
        this.sparkUIFactory = sparkUIFactory;
        this.sparkUiDefaults = sparkUiDefaults;
        this.sparkSessionBuilderFactory = sparkSessionBuilderFactory;
        this.sparkListenerService = sparkListenerService;
    }

    @Override
    public MagicCommandOutcomeItem createSpark(MagicCommandExecutionParam param, List<SparkMagicCommandOptions.SparkOptionCommand> options) {
        if (this.noUi(options)) {
            return this.createSparkWithoutUI(param, options);
        }
        return this.createSparkUI(param, options);
    }

    private MagicCommandOutcomeItem createSparkUI(MagicCommandExecutionParam param, List<SparkMagicCommandOptions.SparkOptionCommand> options) {
        if (param.getCommandCodeBlock().isEmpty()) {
            return this.createSparkBasedOnEmptyConfiguration(param, options);
        }
        return this.createSparkBasedOnUserSparkConfiguration(param, (builder, message) -> {
            this.createAndDisplaySparkUI(options, builder, message);
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.OK, MessageCreator.get());
        });
    }

    private MagicCommandOutcomeItem createSparkWithoutUI(MagicCommandExecutionParam param, List<SparkMagicCommandOptions.SparkOptionCommand> options) {
        return this.createSparkBasedOnUserSparkConfiguration(param, (builder, message) -> {
            SparkEngineNoUI sparkEngine = this.sparkEngineNoUIFactory.create(builder, this.sparkSessionBuilderFactory);
            options.forEach(option -> option.run(sparkEngine, message));
            TryResult configure = sparkEngine.configure(this.kernel, param.getCode().getMessage());
            if (configure.isError()) {
                return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, configure.error(), MessageCreator.get());
            }
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.OK, SPARK_SESSION_AVAILABLE_BY_SPARK, MessageCreator.get());
        });
    }

    private void createAndDisplaySparkUI(List<SparkMagicCommandOptions.SparkOptionCommand> options, SparkSessionBuilder builder, Message message) {
        this.sparkUiDefaults.loadDefaults();
        SparkEngineWithUI sparkEngineWithUI = this.sparkEngineWithUIFactory.create(builder, this.sparkSessionBuilderFactory, this.sparkListenerService);
        options.forEach(option -> option.run(sparkEngineWithUI, message));
        SparkUIApi sparkUI = this.sparkUIFactory.create(builder, sparkEngineWithUI, this.sparkUiDefaults);
        this.displaySparkUI(sparkUI, message);
    }

    private MagicCommandOutcomeItem createSparkBasedOnEmptyConfiguration(MagicCommandExecutionParam param, List<SparkMagicCommandOptions.SparkOptionCommand> options) {
        EvaluationObject seo = this.createSEO(param);
        InternalVariable.setValue((EvaluationObject)seo);
        SparkSessionBuilder config = this.sparkSessionBuilderFactory.newInstance(new SparkConf());
        this.createAndDisplaySparkUI(options, config, param.getCode().getMessage());
        return new MagicCommandOutput(MagicCommandOutcomeItem.Status.OK, MessageCreator.get());
    }

    private MagicCommandOutcomeItem createSparkBasedOnUserSparkConfiguration(MagicCommandExecutionParam param, SparkRunner sparkRunner) {
        EvaluationObject seo = this.createSEO(param);
        TryResult either = this.kernel.executeCode(param.getCommandCodeBlock(), seo);
        if (either.isResult()) {
            Optional<SparkSessionBuilder> builderFromUser = this.getBuilderFromUser(either.result());
            if (builderFromUser.isPresent()) {
                SparkSessionBuilder builder = builderFromUser.get();
                return sparkRunner.run(builder, param.getCode().getMessage());
            }
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, CONFIGURATION_MUST_BE_PROVIDED, MessageCreator.get());
        }
        return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, "There occurs problem during execution of %%spark : " + either.error(), MessageCreator.get());
    }

    private Optional<SparkSessionBuilder> getBuilderFromUser(Object result) {
        if (result instanceof SparkConf) {
            return Optional.of(this.sparkSessionBuilderFactory.newInstance((SparkConf)result));
        }
        if (result instanceof SparkSession.Builder) {
            return Optional.of(this.sparkSessionBuilderFactory.newInstance((SparkSession.Builder)result));
        }
        return Optional.empty();
    }

    private SparkUIApi displaySparkUI(SparkUIApi sparkUI, Message message) {
        Display.display((Object)sparkUI);
        sparkUI.afterDisplay(message);
        return sparkUI;
    }

    private EvaluationObject createSEO(MagicCommandExecutionParam param) {
        return SimpleEvaluationObjectFactory.get().createSeo(param.getCommandCodeBlock(), this.kernel, param.getCode().getMessage(), param.getExecutionCount());
    }

    private boolean noUi(List<SparkMagicCommandOptions.SparkOptionCommand> options) {
        return options.stream().anyMatch(x -> x.getName().equals("noUI"));
    }

    public static interface SparkRunner {
        public MagicCommandOutput run(SparkSessionBuilder var1, Message var2);
    }
}

