/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.scala.magic.command;

import com.twosigma.beakerx.TryResult;
import com.twosigma.beakerx.evaluator.EvaluationObjectFactory;
import com.twosigma.beakerx.evaluator.SimpleEvaluationObjectFactory;
import com.twosigma.beakerx.jvm.object.EvaluationObject;
import com.twosigma.beakerx.kernel.ImportPath;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.magic.command.CodeFactory;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandExecutionParam;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandFunctionality;
import com.twosigma.beakerx.kernel.magic.command.functionality.LoadMagicMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutcomeItem;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutput;
import com.twosigma.beakerx.kernel.msg.JupyterMessages;
import com.twosigma.beakerx.kernel.msg.MessageCreator;
import com.twosigma.beakerx.message.Header;
import com.twosigma.beakerx.message.Message;
import com.twosigma.beakerx.scala.magic.command.SparkMagicCommand;
import com.twosigma.beakerx.scala.spark.SparkDisplayers;
import com.twosigma.beakerx.scala.spark.SparkImplicit;
import com.twosigma.beakerx.scala.spark.TimeSeriesRDDDisplayer;
import java.util.Optional;

public class LoadSparkSupportMagicCommand
implements MagicCommandFunctionality {
    public static final String LOAD_SPARK_SUPPORT = "%loadSparkSupport";
    private KernelFunctionality kernel;

    public LoadSparkSupportMagicCommand(KernelFunctionality kernel) {
        this.kernel = kernel;
    }

    public String getMagicCommandName() {
        return LOAD_SPARK_SUPPORT;
    }

    public MagicCommandOutcomeItem execute(MagicCommandExecutionParam param) {
        TryResult implicits = this.addImplicits(param.getCode().getMessage(), new SparkImplicit().codeAsString());
        if (implicits.isError()) {
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, implicits.error(), MessageCreator.get());
        }
        MagicCommandOutcomeItem loadSpark = this.loadSparkMagic();
        if (!loadSpark.getStatus().equals((Object)MagicCommandOutcomeItem.Status.OK)) {
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, "Can not run spark support", MessageCreator.get());
        }
        this.loadTwosigmaFlintSupport(param.getCode().getMessage());
        SparkDisplayers.register();
        this.addDefaultImports();
        return new MagicCommandOutput(MagicCommandOutcomeItem.Status.OK, "Spark support enabled", MessageCreator.get());
    }

    private void loadTwosigmaFlintSupport(Message parent) {
        if (this.kernel.checkIfClassExistsInClassloader("com.twosigma.flint.timeseries.TimeSeriesRDD")) {
            TimeSeriesRDDDisplayer.register();
            this.addImplicits(parent, TimeSeriesRDDDisplayer.implicitCodeAsString());
        }
    }

    private MagicCommandOutcomeItem loadSparkMagic() {
        CodeFactory codeFactory = new CodeFactory(MessageCreator.get(), (EvaluationObjectFactory)new SimpleEvaluationObjectFactory());
        Optional magic = codeFactory.findMagicCommandFunctionality(this.kernel.getMagicCommandTypes(), "%load_magic");
        MagicCommandOutcomeItem magicCommandOutcomeItem = ((LoadMagicMagicCommand)magic.get()).load(SparkMagicCommand.class.getName());
        return magicCommandOutcomeItem;
    }

    private TryResult addImplicits(Message parent, String codeToExecute) {
        EvaluationObject seo = SimpleEvaluationObjectFactory.get().createSeo(codeToExecute, this.kernel, new Message(new Header(JupyterMessages.COMM_MSG, parent.getHeader().getSession())), 1);
        return this.kernel.executeCode(codeToExecute, seo);
    }

    private void addDefaultImports() {
        this.kernel.addImport(new ImportPath("org.apache.spark.sql.SparkSession"));
    }
}

