/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.error.OptionalShouldBeEmpty;
import org.assertj.core.error.OptionalShouldBePresent;
import org.assertj.core.error.OptionalShouldContain;
import org.assertj.core.error.OptionalShouldContainInstanceOf;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.FieldByFieldComparator;
import org.assertj.core.internal.StandardComparisonStrategy;

public abstract class AbstractOptionalAssert<S extends AbstractOptionalAssert<S, T>, T>
extends AbstractAssert<S, Optional<T>> {
    private ComparisonStrategy optionalValueComparisonStrategy = StandardComparisonStrategy.instance();

    protected AbstractOptionalAssert(Optional<T> actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public S isPresent() {
        this.assertValueIsPresent();
        return (S)((AbstractOptionalAssert)this.myself);
    }

    public S isNotEmpty() {
        return this.isPresent();
    }

    public S isEmpty() {
        this.isNotNull();
        if (((Optional)this.actual).isPresent()) {
            this.throwAssertionError(OptionalShouldBeEmpty.shouldBeEmpty((Optional)this.actual));
        }
        return (S)((AbstractOptionalAssert)this.myself);
    }

    public S isNotPresent() {
        return this.isEmpty();
    }

    public S contains(T expectedValue) {
        this.isNotNull();
        this.checkNotNull(expectedValue);
        if (!((Optional)this.actual).isPresent()) {
            this.throwAssertionError(OptionalShouldContain.shouldContain(expectedValue));
        }
        if (!this.optionalValueComparisonStrategy.areEqual(((Optional)this.actual).get(), expectedValue)) {
            this.throwAssertionError(OptionalShouldContain.shouldContain((Optional)this.actual, expectedValue));
        }
        return (S)((AbstractOptionalAssert)this.myself);
    }

    public S hasValueSatisfying(Consumer<T> requirement) {
        this.assertValueIsPresent();
        requirement.accept(((Optional)this.actual).get());
        return (S)((AbstractOptionalAssert)this.myself);
    }

    public S hasValueSatisfying(Condition<? super T> condition) {
        this.assertValueIsPresent();
        this.conditions.assertIs(this.info, ((Optional)this.actual).get(), condition);
        return (S)((AbstractOptionalAssert)this.myself);
    }

    public S hasValue(T expectedValue) {
        return this.contains(expectedValue);
    }

    public S containsInstanceOf(Class<?> clazz) {
        this.assertValueIsPresent();
        if (!clazz.isInstance(((Optional)this.actual).get())) {
            this.throwAssertionError(OptionalShouldContainInstanceOf.shouldContainInstanceOf(this.actual, clazz));
        }
        return (S)((AbstractOptionalAssert)this.myself);
    }

    public S usingFieldByFieldValueComparator() {
        return this.usingValueComparator(new FieldByFieldComparator());
    }

    public S usingValueComparator(Comparator<? super T> customComparator) {
        this.optionalValueComparisonStrategy = new ComparatorBasedComparisonStrategy(customComparator);
        return (S)((AbstractOptionalAssert)this.myself);
    }

    public S usingDefaultValueComparator() {
        this.optionalValueComparisonStrategy = StandardComparisonStrategy.instance();
        return (S)((AbstractOptionalAssert)this.myself);
    }

    public S containsSame(T expectedValue) {
        this.isNotNull();
        this.checkNotNull(expectedValue);
        if (!((Optional)this.actual).isPresent()) {
            this.throwAssertionError(OptionalShouldContain.shouldContain(expectedValue));
        }
        if (((Optional)this.actual).get() != expectedValue) {
            this.throwAssertionError(OptionalShouldContain.shouldContainSame((Optional)this.actual, expectedValue));
        }
        return (S)((AbstractOptionalAssert)this.myself);
    }

    public <U> AbstractOptionalAssert<?, U> flatMap(Function<? super T, Optional<U>> mapper) {
        this.isNotNull();
        return Assertions.assertThat(((Optional)this.actual).flatMap(mapper));
    }

    public <U> AbstractOptionalAssert<?, U> map(Function<? super T, ? extends U> mapper) {
        this.isNotNull();
        return Assertions.assertThat(((Optional)this.actual).map(mapper));
    }

    private void checkNotNull(T expectedValue) {
        if (expectedValue == null) {
            throw new IllegalArgumentException("The expected value should not be <null>.");
        }
    }

    private void assertValueIsPresent() {
        this.isNotNull();
        if (!((Optional)this.actual).isPresent()) {
            this.throwAssertionError(OptionalShouldBePresent.shouldBePresent(this.actual));
        }
    }
}

