/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.scala.magic.command;

import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutcomeItem;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutput;
import com.twosigma.beakerx.kernel.msg.MessageCreator;
import com.twosigma.beakerx.message.Message;
import com.twosigma.beakerx.mimetype.MIMEContainer;
import com.twosigma.beakerx.scala.magic.command.EnableSparkSupportOptions;
import com.twosigma.beakerx.scala.magic.command.SparkInitCommandFactory;
import java.util.Arrays;

class RunOptionsCommand
implements SparkInitCommandFactory.Command {
    private EnableSparkSupportOptions enableSparkSupportOptions;
    private String command;
    private final Message message;
    private String error;

    public RunOptionsCommand(EnableSparkSupportOptions enableSparkSupportOptions, String command, Message message) {
        this.enableSparkSupportOptions = enableSparkSupportOptions;
        this.command = command;
        this.message = message;
        this.error = "";
    }

    @Override
    public MagicCommandOutcomeItem run() {
        EnableSparkSupportOptions.OptionsResult optionsResult = this.enableSparkSupportOptions.parseOptions(this.getOptions(this.command));
        if (optionsResult.hasError()) {
            this.error = optionsResult.errorMsg();
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, this.error, MessageCreator.get());
        }
        for (EnableSparkSupportOptions.EnableSparkSupportCommand x : optionsResult.options()) {
            MagicCommandOutcomeItem item = x.run(this.message);
            if (item.getStatus().equals((Object)MagicCommandOutcomeItem.Status.OK)) continue;
            this.error = ((MIMEContainer)item.getMIMEContainer().get()).getData().toString();
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, this.error, MessageCreator.get());
        }
        return new MagicCommandOutput(MagicCommandOutcomeItem.Status.OK, MessageCreator.get());
    }

    @Override
    public String getErrorMessage() {
        return this.error;
    }

    private String[] getOptions(String command) {
        String[] parts = command.split(" ");
        if (parts.length == 1) {
            return new String[0];
        }
        return Arrays.copyOfRange(parts, 1, parts.length);
    }
}

