/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.scala.magic.command;

import com.twosigma.beakerx.kernel.BeakerXClasspath;
import com.twosigma.beakerx.kernel.magic.command.functionality.ClasspathAddJarMagic;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutcomeItem;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutput;
import com.twosigma.beakerx.kernel.msg.MessageCreator;
import com.twosigma.beakerx.mimetype.MIMEContainer;
import com.twosigma.beakerx.scala.magic.command.SparkInitCommandFactory;
import com.twosigma.beakerx.util.BeakerXSystem;
import java.io.File;

class LoadSparkFrom_SPARK_HOME_Command
implements SparkInitCommandFactory.Command {
    private String error = "";
    private BeakerXClasspath classpath;
    private BeakerXSystem beakerXSystem;
    private ClasspathAddJarMagic command;

    public LoadSparkFrom_SPARK_HOME_Command(ClasspathAddJarMagic command, BeakerXClasspath classpath, BeakerXSystem beakerXSystem) {
        this.command = command;
        this.classpath = classpath;
        this.beakerXSystem = beakerXSystem;
    }

    @Override
    public MagicCommandOutcomeItem run() {
        String spark_home = this.beakerXSystem.getenv("SPARK_HOME");
        if (!this.classpath.isJarOnClasspath("spark-sql") && spark_home != null) {
            String sparkJarsPath = spark_home + File.separator + "jars" + File.separator + "*";
            MagicCommandOutcomeItem classpath = this.command.addJar(sparkJarsPath);
            if (!classpath.getStatus().equals((Object)MagicCommandOutcomeItem.Status.OK)) {
                this.error = ((MIMEContainer)classpath.getMIMEContainer().get()).getData().toString();
                return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, this.error, MessageCreator.get());
            }
            return classpath;
        }
        return new MagicCommandOutput(MagicCommandOutcomeItem.Status.OK, MessageCreator.get());
    }

    @Override
    public String getErrorMessage() {
        return this.error;
    }
}

