/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.scala.evaluator;

import com.twosigma.beakerx.TryResult;
import com.twosigma.beakerx.evaluator.BaseEvaluator;
import com.twosigma.beakerx.jvm.object.EvaluationObject;
import com.twosigma.beakerx.scala.evaluator.ScalaEvaluator;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.NotNull;

class ScalaCodeRunner
implements Callable<TryResult> {
    private ScalaEvaluator scalaEvaluator;
    private final String theCode;
    private final EvaluationObject theOutput;

    public ScalaCodeRunner(ScalaEvaluator scalaEvaluator, String code, EvaluationObject out) {
        this.scalaEvaluator = scalaEvaluator;
        this.theCode = code;
        this.theOutput = out;
    }

    @Override
    public TryResult call() throws Exception {
        TryResult either;
        try {
            this.theOutput.setOutputHandler();
            either = this.scalaEvaluator.getShell().evaluate(this.theOutput, this.theCode);
        }
        catch (Throwable e) {
            either = this.handleError(e);
        }
        finally {
            this.theOutput.clrOutputHandler();
        }
        return this.scalaEvaluator.processResult(either);
    }

    @NotNull
    private TryResult handleError(Throwable e) {
        TryResult.CellError either;
        if (e instanceof InterruptedException || e instanceof InvocationTargetException || e instanceof ThreadDeath) {
            either = TryResult.createError((String)BaseEvaluator.INTERUPTED_MSG);
        } else {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            either = TryResult.createError((String)sw.toString());
        }
        return either;
    }
}

