"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CertificateBase = void 0;
const cloudwatch = require("@aws-cdk/aws-cloudwatch");
const aws_cloudwatch_1 = require("@aws-cdk/aws-cloudwatch");
const core_1 = require("@aws-cdk/core");
/**
 * Shared implementation details of ICertificate implementations.
 *
 * @internal
 */
class CertificateBase extends core_1.Resource {
    /**
     * Return the DaysToExpiry metric for this AWS Certificate Manager Certificate. By default, this is the minimum value over 1 day.
     *
     * This metric is no longer emitted once the certificate has effectively
     * expired, so alarms configured on this metric should probably treat missing
     * data as "breaching".
     *
     * @stability stable
     */
    metricDaysToExpiry(props) {
        return new cloudwatch.Metric({
            period: core_1.Duration.days(1),
            ...props,
            dimensions: { CertificateArn: this.certificateArn },
            metricName: 'DaysToExpiry',
            namespace: 'AWS/CertificateManager',
            region: this.region,
            statistic: aws_cloudwatch_1.Statistic.MINIMUM,
        });
    }
}
exports.CertificateBase = CertificateBase;
//# sourceMappingURL=data:application/json;base64,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