"use strict";
const assert_1 = require("@aws-cdk/assert");
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
module.exports = {
    'Can use addMetrics() to add a metric configuration'(test) {
        // GIVEN
        const stack = new core_1.Stack();
        // WHEN
        const bucket = new lib_1.Bucket(stack, 'Bucket');
        bucket.addMetric({
            id: 'test',
        });
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('AWS::S3::Bucket', {
            MetricsConfigurations: [{
                    Id: 'test',
                }],
        }));
        test.done();
    },
    'Bucket with metrics on prefix'(test) {
        // GIVEN
        const stack = new core_1.Stack();
        // WHEN
        new lib_1.Bucket(stack, 'Bucket', {
            metrics: [{
                    id: 'test',
                    prefix: 'prefix',
                }],
        });
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('AWS::S3::Bucket', {
            MetricsConfigurations: [{
                    Id: 'test',
                    Prefix: 'prefix',
                }],
        }));
        test.done();
    },
    'Bucket with metrics on tag filter'(test) {
        // GIVEN
        const stack = new core_1.Stack();
        // WHEN
        new lib_1.Bucket(stack, 'Bucket', {
            metrics: [{
                    id: 'test',
                    tagFilters: { tagname1: 'tagvalue1', tagname2: 'tagvalue2' },
                }],
        });
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('AWS::S3::Bucket', {
            MetricsConfigurations: [{
                    Id: 'test',
                    TagFilters: [
                        { Key: 'tagname1', Value: 'tagvalue1' },
                        { Key: 'tagname2', Value: 'tagvalue2' },
                    ],
                }],
        }));
        test.done();
    },
    'Bucket with multiple metric configurations'(test) {
        // GIVEN
        const stack = new core_1.Stack();
        // WHEN
        new lib_1.Bucket(stack, 'Bucket', {
            metrics: [
                {
                    id: 'test',
                    tagFilters: { tagname1: 'tagvalue1', tagname2: 'tagvalue2' },
                },
                {
                    id: 'test2',
                    prefix: 'prefix',
                },
            ],
        });
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('AWS::S3::Bucket', {
            MetricsConfigurations: [{
                    Id: 'test',
                    TagFilters: [
                        { Key: 'tagname1', Value: 'tagvalue1' },
                        { Key: 'tagname2', Value: 'tagvalue2' },
                    ],
                },
                {
                    Id: 'test2',
                    Prefix: 'prefix',
                }],
        }));
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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