"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseBucketName = exports.parseBucketArn = void 0;
const cdk = require("@aws-cdk/core");
function parseBucketArn(construct, props) {
    // if we have an explicit bucket ARN, use it.
    if (props.bucketArn) {
        return props.bucketArn;
    }
    if (props.bucketName) {
        return cdk.Stack.of(construct).formatArn({
            // S3 Bucket names are globally unique in a partition,
            // and so their ARNs have empty region and account components
            region: '',
            account: '',
            service: 's3',
            resource: props.bucketName,
        });
    }
    throw new Error('Cannot determine bucket ARN. At least `bucketArn` or `bucketName` is needed');
}
exports.parseBucketArn = parseBucketArn;
function parseBucketName(construct, props) {
    // if we have an explicit bucket name, use it.
    if (props.bucketName) {
        return props.bucketName;
    }
    // extract bucket name from bucket arn
    if (props.bucketArn) {
        return cdk.Stack.of(construct).parseArn(props.bucketArn).resource;
    }
    // no bucket name is okay since it's optional.
    return undefined;
}
exports.parseBucketName = parseBucketName;
//# sourceMappingURL=data:application/json;base64,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