import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::Lightsail::Disk`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-disk.html
 */
export interface CfnDiskProps {
    /**
     * `AWS::Lightsail::Disk.DiskName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-disk.html#cfn-lightsail-disk-diskname
     */
    readonly diskName: string;
    /**
     * `AWS::Lightsail::Disk.SizeInGb`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-disk.html#cfn-lightsail-disk-sizeingb
     */
    readonly sizeInGb: number;
    /**
     * `AWS::Lightsail::Disk.AddOns`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-disk.html#cfn-lightsail-disk-addons
     */
    readonly addOns?: Array<CfnDisk.AddOnProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Lightsail::Disk.AvailabilityZone`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-disk.html#cfn-lightsail-disk-availabilityzone
     */
    readonly availabilityZone?: string;
    /**
     * `AWS::Lightsail::Disk.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-disk.html#cfn-lightsail-disk-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::Lightsail::Disk`.
 *
 * @external
 * @cloudformationResource AWS::Lightsail::Disk
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-disk.html
 */
export declare class CfnDisk extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Lightsail::Disk";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDisk;
    /**
     * @external
     * @cloudformationAttribute AttachedTo
     */
    readonly attrAttachedTo: string;
    /**
     * @external
     * @cloudformationAttribute AttachmentState
     */
    readonly attrAttachmentState: string;
    /**
     * @external
     * @cloudformationAttribute DiskArn
     */
    readonly attrDiskArn: string;
    /**
     * @external
     * @cloudformationAttribute Iops
     */
    readonly attrIops: number;
    /**
     * @external
     * @cloudformationAttribute IsAttached
     */
    readonly attrIsAttached: cdk.IResolvable;
    /**
     * @external
     * @cloudformationAttribute Path
     */
    readonly attrPath: string;
    /**
     * @external
     * @cloudformationAttribute ResourceType
     */
    readonly attrResourceType: string;
    /**
     * @external
     * @cloudformationAttribute State
     */
    readonly attrState: string;
    /**
     * @external
     * @cloudformationAttribute SupportCode
     */
    readonly attrSupportCode: string;
    /**
     * `AWS::Lightsail::Disk.DiskName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-disk.html#cfn-lightsail-disk-diskname
     */
    diskName: string;
    /**
     * `AWS::Lightsail::Disk.SizeInGb`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-disk.html#cfn-lightsail-disk-sizeingb
     */
    sizeInGb: number;
    /**
     * `AWS::Lightsail::Disk.AddOns`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-disk.html#cfn-lightsail-disk-addons
     */
    addOns: Array<CfnDisk.AddOnProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::Lightsail::Disk.AvailabilityZone`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-disk.html#cfn-lightsail-disk-availabilityzone
     */
    availabilityZone: string | undefined;
    /**
     * `AWS::Lightsail::Disk.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-disk.html#cfn-lightsail-disk-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Lightsail::Disk`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDiskProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Lightsail::Disk`.
 *
 * @external
 * @cloudformationResource AWS::Lightsail::Disk
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-disk.html
 */
export declare namespace CfnDisk {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-disk-addon.html
     */
    interface AddOnProperty {
        /**
         * `CfnDisk.AddOnProperty.AddOnType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-disk-addon.html#cfn-lightsail-disk-addon-addontype
         */
        readonly addOnType: string;
        /**
         * `CfnDisk.AddOnProperty.AutoSnapshotAddOnRequest`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-disk-addon.html#cfn-lightsail-disk-addon-autosnapshotaddonrequest
         */
        readonly autoSnapshotAddOnRequest?: CfnDisk.AutoSnapshotAddOnProperty | cdk.IResolvable;
        /**
         * `CfnDisk.AddOnProperty.Status`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-disk-addon.html#cfn-lightsail-disk-addon-status
         */
        readonly status?: string;
    }
}
/**
 * A CloudFormation `AWS::Lightsail::Disk`.
 *
 * @external
 * @cloudformationResource AWS::Lightsail::Disk
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-disk.html
 */
export declare namespace CfnDisk {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-disk-autosnapshotaddon.html
     */
    interface AutoSnapshotAddOnProperty {
        /**
         * `CfnDisk.AutoSnapshotAddOnProperty.SnapshotTimeOfDay`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-disk-autosnapshotaddon.html#cfn-lightsail-disk-autosnapshotaddon-snapshottimeofday
         */
        readonly snapshotTimeOfDay?: string;
    }
}
/**
 * Properties for defining a `AWS::Lightsail::Instance`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html
 */
export interface CfnInstanceProps {
    /**
     * `AWS::Lightsail::Instance.BlueprintId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html#cfn-lightsail-instance-blueprintid
     */
    readonly blueprintId: string;
    /**
     * `AWS::Lightsail::Instance.BundleId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html#cfn-lightsail-instance-bundleid
     */
    readonly bundleId: string;
    /**
     * `AWS::Lightsail::Instance.InstanceName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html#cfn-lightsail-instance-instancename
     */
    readonly instanceName: string;
    /**
     * `AWS::Lightsail::Instance.AddOns`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html#cfn-lightsail-instance-addons
     */
    readonly addOns?: Array<CfnInstance.AddOnProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Lightsail::Instance.AvailabilityZone`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html#cfn-lightsail-instance-availabilityzone
     */
    readonly availabilityZone?: string;
    /**
     * `AWS::Lightsail::Instance.Hardware`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html#cfn-lightsail-instance-hardware
     */
    readonly hardware?: CfnInstance.HardwareProperty | cdk.IResolvable;
    /**
     * `AWS::Lightsail::Instance.Location`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html#cfn-lightsail-instance-location
     */
    readonly location?: CfnInstance.LocationProperty | cdk.IResolvable;
    /**
     * `AWS::Lightsail::Instance.Networking`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html#cfn-lightsail-instance-networking
     */
    readonly networking?: CfnInstance.NetworkingProperty | cdk.IResolvable;
    /**
     * `AWS::Lightsail::Instance.State`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html#cfn-lightsail-instance-state
     */
    readonly state?: CfnInstance.StateProperty | cdk.IResolvable;
    /**
     * `AWS::Lightsail::Instance.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html#cfn-lightsail-instance-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::Lightsail::Instance`.
 *
 * @external
 * @cloudformationResource AWS::Lightsail::Instance
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html
 */
export declare class CfnInstance extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Lightsail::Instance";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnInstance;
    /**
     * @external
     * @cloudformationAttribute Hardware.CpuCount
     */
    readonly attrHardwareCpuCount: number;
    /**
     * @external
     * @cloudformationAttribute Hardware.RamSizeInGb
     */
    readonly attrHardwareRamSizeInGb: number;
    /**
     * @external
     * @cloudformationAttribute InstanceArn
     */
    readonly attrInstanceArn: string;
    /**
     * @external
     * @cloudformationAttribute IsStaticIp
     */
    readonly attrIsStaticIp: cdk.IResolvable;
    /**
     * @external
     * @cloudformationAttribute KeyPairName
     */
    readonly attrKeyPairName: string;
    /**
     * @external
     * @cloudformationAttribute Location.AvailabilityZone
     */
    readonly attrLocationAvailabilityZone: string;
    /**
     * @external
     * @cloudformationAttribute Location.RegionName
     */
    readonly attrLocationRegionName: string;
    /**
     * @external
     * @cloudformationAttribute Networking.MonthlyTransfer.GbPerMonthAllocated
     */
    readonly attrNetworkingMonthlyTransferGbPerMonthAllocated: string;
    /**
     * @external
     * @cloudformationAttribute PrivateIpAddress
     */
    readonly attrPrivateIpAddress: string;
    /**
     * @external
     * @cloudformationAttribute PublicIpAddress
     */
    readonly attrPublicIpAddress: string;
    /**
     * @external
     * @cloudformationAttribute ResourceType
     */
    readonly attrResourceType: string;
    /**
     * @external
     * @cloudformationAttribute SshKeyName
     */
    readonly attrSshKeyName: string;
    /**
     * @external
     * @cloudformationAttribute State.Code
     */
    readonly attrStateCode: number;
    /**
     * @external
     * @cloudformationAttribute State.Name
     */
    readonly attrStateName: string;
    /**
     * @external
     * @cloudformationAttribute SupportCode
     */
    readonly attrSupportCode: string;
    /**
     * @external
     * @cloudformationAttribute UserData
     */
    readonly attrUserData: string;
    /**
     * @external
     * @cloudformationAttribute UserName
     */
    readonly attrUserName: string;
    /**
     * `AWS::Lightsail::Instance.BlueprintId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html#cfn-lightsail-instance-blueprintid
     */
    blueprintId: string;
    /**
     * `AWS::Lightsail::Instance.BundleId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html#cfn-lightsail-instance-bundleid
     */
    bundleId: string;
    /**
     * `AWS::Lightsail::Instance.InstanceName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html#cfn-lightsail-instance-instancename
     */
    instanceName: string;
    /**
     * `AWS::Lightsail::Instance.AddOns`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html#cfn-lightsail-instance-addons
     */
    addOns: Array<CfnInstance.AddOnProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::Lightsail::Instance.AvailabilityZone`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html#cfn-lightsail-instance-availabilityzone
     */
    availabilityZone: string | undefined;
    /**
     * `AWS::Lightsail::Instance.Hardware`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html#cfn-lightsail-instance-hardware
     */
    hardware: CfnInstance.HardwareProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Lightsail::Instance.Location`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html#cfn-lightsail-instance-location
     */
    location: CfnInstance.LocationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Lightsail::Instance.Networking`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html#cfn-lightsail-instance-networking
     */
    networking: CfnInstance.NetworkingProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Lightsail::Instance.State`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html#cfn-lightsail-instance-state
     */
    state: CfnInstance.StateProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Lightsail::Instance.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html#cfn-lightsail-instance-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Lightsail::Instance`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnInstanceProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Lightsail::Instance`.
 *
 * @external
 * @cloudformationResource AWS::Lightsail::Instance
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html
 */
export declare namespace CfnInstance {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-instance-addon.html
     */
    interface AddOnProperty {
        /**
         * `CfnInstance.AddOnProperty.AddOnType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-instance-addon.html#cfn-lightsail-instance-addon-addontype
         */
        readonly addOnType: string;
        /**
         * `CfnInstance.AddOnProperty.AutoSnapshotAddOnRequest`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-instance-addon.html#cfn-lightsail-instance-addon-autosnapshotaddonrequest
         */
        readonly autoSnapshotAddOnRequest?: CfnInstance.AutoSnapshotAddOnProperty | cdk.IResolvable;
        /**
         * `CfnInstance.AddOnProperty.Status`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-instance-addon.html#cfn-lightsail-instance-addon-status
         */
        readonly status?: string;
    }
}
/**
 * A CloudFormation `AWS::Lightsail::Instance`.
 *
 * @external
 * @cloudformationResource AWS::Lightsail::Instance
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html
 */
export declare namespace CfnInstance {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-instance-autosnapshotaddon.html
     */
    interface AutoSnapshotAddOnProperty {
        /**
         * `CfnInstance.AutoSnapshotAddOnProperty.SnapshotTimeOfDay`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-instance-autosnapshotaddon.html#cfn-lightsail-instance-autosnapshotaddon-snapshottimeofday
         */
        readonly snapshotTimeOfDay?: string;
    }
}
/**
 * A CloudFormation `AWS::Lightsail::Instance`.
 *
 * @external
 * @cloudformationResource AWS::Lightsail::Instance
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html
 */
export declare namespace CfnInstance {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-instance-disk.html
     */
    interface DiskProperty {
        /**
         * `CfnInstance.DiskProperty.AttachedTo`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-instance-disk.html#cfn-lightsail-instance-disk-attachedto
         */
        readonly attachedTo?: string;
        /**
         * `CfnInstance.DiskProperty.AttachmentState`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-instance-disk.html#cfn-lightsail-instance-disk-attachmentstate
         */
        readonly attachmentState?: string;
        /**
         * `CfnInstance.DiskProperty.DiskName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-instance-disk.html#cfn-lightsail-instance-disk-diskname
         */
        readonly diskName: string;
        /**
         * `CfnInstance.DiskProperty.IOPS`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-instance-disk.html#cfn-lightsail-instance-disk-iops
         */
        readonly iops?: number;
        /**
         * `CfnInstance.DiskProperty.IsSystemDisk`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-instance-disk.html#cfn-lightsail-instance-disk-issystemdisk
         */
        readonly isSystemDisk?: boolean | cdk.IResolvable;
        /**
         * `CfnInstance.DiskProperty.Path`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-instance-disk.html#cfn-lightsail-instance-disk-path
         */
        readonly path: string;
        /**
         * `CfnInstance.DiskProperty.SizeInGb`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-instance-disk.html#cfn-lightsail-instance-disk-sizeingb
         */
        readonly sizeInGb?: string;
    }
}
/**
 * A CloudFormation `AWS::Lightsail::Instance`.
 *
 * @external
 * @cloudformationResource AWS::Lightsail::Instance
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html
 */
export declare namespace CfnInstance {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-instance-hardware.html
     */
    interface HardwareProperty {
        /**
         * `CfnInstance.HardwareProperty.CpuCount`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-instance-hardware.html#cfn-lightsail-instance-hardware-cpucount
         */
        readonly cpuCount?: number;
        /**
         * `CfnInstance.HardwareProperty.Disks`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-instance-hardware.html#cfn-lightsail-instance-hardware-disks
         */
        readonly disks?: Array<CfnInstance.DiskProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnInstance.HardwareProperty.RamSizeInGb`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-instance-hardware.html#cfn-lightsail-instance-hardware-ramsizeingb
         */
        readonly ramSizeInGb?: number;
    }
}
/**
 * A CloudFormation `AWS::Lightsail::Instance`.
 *
 * @external
 * @cloudformationResource AWS::Lightsail::Instance
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html
 */
export declare namespace CfnInstance {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-instance-location.html
     */
    interface LocationProperty {
        /**
         * `CfnInstance.LocationProperty.AvailabilityZone`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-instance-location.html#cfn-lightsail-instance-location-availabilityzone
         */
        readonly availabilityZone?: string;
        /**
         * `CfnInstance.LocationProperty.RegionName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-instance-location.html#cfn-lightsail-instance-location-regionname
         */
        readonly regionName?: string;
    }
}
/**
 * A CloudFormation `AWS::Lightsail::Instance`.
 *
 * @external
 * @cloudformationResource AWS::Lightsail::Instance
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html
 */
export declare namespace CfnInstance {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-instance-monthlytransfer.html
     */
    interface MonthlyTransferProperty {
        /**
         * `CfnInstance.MonthlyTransferProperty.GbPerMonthAllocated`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-instance-monthlytransfer.html#cfn-lightsail-instance-monthlytransfer-gbpermonthallocated
         */
        readonly gbPerMonthAllocated?: string;
    }
}
/**
 * A CloudFormation `AWS::Lightsail::Instance`.
 *
 * @external
 * @cloudformationResource AWS::Lightsail::Instance
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html
 */
export declare namespace CfnInstance {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-instance-networking.html
     */
    interface NetworkingProperty {
        /**
         * `CfnInstance.NetworkingProperty.MonthlyTransfer`.
         *
         * @external
         */
        readonly monthlyTransfer?: number;
        /**
         * `CfnInstance.NetworkingProperty.Ports`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-instance-networking.html#cfn-lightsail-instance-networking-ports
         */
        readonly ports: Array<CfnInstance.PortProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Lightsail::Instance`.
 *
 * @external
 * @cloudformationResource AWS::Lightsail::Instance
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html
 */
export declare namespace CfnInstance {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-instance-port.html
     */
    interface PortProperty {
        /**
         * `CfnInstance.PortProperty.AccessDirection`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-instance-port.html#cfn-lightsail-instance-port-accessdirection
         */
        readonly accessDirection?: string;
        /**
         * `CfnInstance.PortProperty.AccessFrom`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-instance-port.html#cfn-lightsail-instance-port-accessfrom
         */
        readonly accessFrom?: string;
        /**
         * `CfnInstance.PortProperty.AccessType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-instance-port.html#cfn-lightsail-instance-port-accesstype
         */
        readonly accessType?: string;
        /**
         * `CfnInstance.PortProperty.CidrListAliases`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-instance-port.html#cfn-lightsail-instance-port-cidrlistaliases
         */
        readonly cidrListAliases?: string[];
        /**
         * `CfnInstance.PortProperty.Cidrs`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-instance-port.html#cfn-lightsail-instance-port-cidrs
         */
        readonly cidrs?: string[];
        /**
         * `CfnInstance.PortProperty.CommonName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-instance-port.html#cfn-lightsail-instance-port-commonname
         */
        readonly commonName?: string;
        /**
         * `CfnInstance.PortProperty.FromPort`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-instance-port.html#cfn-lightsail-instance-port-fromport
         */
        readonly fromPort?: number;
        /**
         * `CfnInstance.PortProperty.Ipv6Cidrs`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-instance-port.html#cfn-lightsail-instance-port-ipv6cidrs
         */
        readonly ipv6Cidrs?: string[];
        /**
         * `CfnInstance.PortProperty.Protocol`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-instance-port.html#cfn-lightsail-instance-port-protocol
         */
        readonly protocol?: string;
        /**
         * `CfnInstance.PortProperty.ToPort`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-instance-port.html#cfn-lightsail-instance-port-toport
         */
        readonly toPort?: number;
    }
}
/**
 * A CloudFormation `AWS::Lightsail::Instance`.
 *
 * @external
 * @cloudformationResource AWS::Lightsail::Instance
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html
 */
export declare namespace CfnInstance {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-instance-state.html
     */
    interface StateProperty {
        /**
         * `CfnInstance.StateProperty.Code`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-instance-state.html#cfn-lightsail-instance-state-code
         */
        readonly code?: number;
        /**
         * `CfnInstance.StateProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-instance-state.html#cfn-lightsail-instance-state-name
         */
        readonly name?: string;
    }
}
