"use strict";
/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
/// !cdk-integ *
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
const core_2 = require("@aws-cdk/core");
const tasks = require("@aws-cdk/aws-stepfunctions-tasks");
const lambda = require("@aws-cdk/aws-lambda");
const core_3 = require("@aws-solutions-constructs/core");
const stepfunctions = require("@aws-cdk/aws-stepfunctions");
const core_4 = require("@aws-solutions-constructs/core");
const app = new core_1.App();
const stack = new core_1.Stack(app, core_4.generateIntegStackName(__filename));
const submitLambda = core_3.deployLambdaFunction(stack, {
    runtime: lambda.Runtime.NODEJS_12_X,
    code: lambda.Code.fromAsset(`${__dirname}/lambda`),
    handler: 'index.handler'
});
const submitJob = new tasks.LambdaInvoke(stack, 'LambdaTask', {
    lambdaFunction: submitLambda
});
const startState = new stepfunctions.Pass(stack, 'StartState');
startState.next(submitJob);
const props = {
    stateMachineProps: {
        definition: startState,
        timeout: core_2.Duration.minutes(5)
    },
    eventRuleProps: {
        eventPattern: {
            source: ['solutionsconstructs']
        }
    },
    eventBusProps: { eventBusName: 'test' },
    logGroupProps: {
        removalPolicy: core_1.RemovalPolicy.DESTROY
    },
};
new lib_1.EventbridgeToStepfunctions(stack, 'test-eventbridge-stepfunctions-new-eventbus-construct', props);
app.synth();
//# sourceMappingURL=data:application/json;base64,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