import unittest
from andes.utils.paths import list_cases
import andes
import os


class TestPaths(unittest.TestCase):
    def setUp(self) -> None:
        self.kundur = 'kundur/'
        self.matpower = 'matpower/'
        self.ieee14 = andes.get_case("ieee14/ieee14.raw")

    def test_tree(self):
        list_cases(self.kundur, no_print=True)
        list_cases(self.matpower, no_print=True)

    def test_addfile_path(self):
        path, case = os.path.split(self.ieee14)
        andes.load('ieee14.raw', addfile='ieee14.dyr',
                   input_path=path, default_config=True,
                   )

        andes.run('ieee14.raw', addfile='ieee14.dyr',
                  input_path=path,
                  no_output=True, default_config=True,
                  )

    def test_pert_file(self):
        """Test path of pert file"""
        path, case = os.path.split(self.ieee14)

        # --- with pert file ---
        ss = andes.run('ieee14.raw', pert='pert.py',
                       input_path=path, no_output=True, default_config=True,
                       )
        ss.TDS.init()
        self.assertIsNotNone(ss.TDS.callpert)

        # --- without pert file ---
        ss = andes.run('ieee14.raw',
                       input_path=path, no_output=True, default_config=True,
                       )
        ss.TDS.init()
        self.assertIsNone(ss.TDS.callpert)
