import * as appscaling from 'aws-cdk-lib/aws-applicationautoscaling';
import { Construct } from 'constructs';
/**
 * The properties of a scalable attribute representing task count.
 */
export interface ScalableInstanceCountProps extends appscaling.BaseScalableAttributeProps {
}
/**
 * A scalable sagemaker endpoint attribute
 */
export declare class ScalableInstanceCount extends appscaling.BaseScalableAttribute {
    /**
     * Constructs a new instance of the ScalableInstanceCount class.
     */
    constructor(scope: Construct, id: string, props: ScalableInstanceCountProps);
    /**
     * Scales in or out to achieve a target requests per second per instance.
     */
    scaleOnInvocations(id: string, props: InvocationsScalingProps): void;
    /**
     * Calculate target value based on a ScalableProductionVariant
     *
     * Documentation for the equation is here: https://docs.aws.amazon.com/sagemaker/latest/dg/endpoint-scaling-loadtest.html
     * @param props the scaling properties.
     */
    private calculateScalingTarget;
}
/**
 * Properties for enabling SageMaker Endpoint utilization tracking
 */
export interface InvocationsScalingProps extends appscaling.BaseTargetTrackingProps {
    /**
     * Max RPS per instance used for calculating the target SageMaker variant invocation per instance
     *
     * More documentation available here: https://docs.aws.amazon.com/sagemaker/latest/dg/endpoint-scaling-loadtest.html
     */
    readonly maxRequestsPerSecond: number;
    /**
     * Safty factor for calculating the target SageMaker variant invocation per instance
     *
     * More documentation available here: https://docs.aws.amazon.com/sagemaker/latest/dg/endpoint-scaling-loadtest.html
     * @default 0.5
     */
    readonly safetyFactor?: number;
}
