/**
 * Supported instance types for SageMaker instance-based production variants.
 */
export declare class InstanceType {
    /**
     * ml.c4.2xlarge
     */
    static readonly C4_2XLARGE: InstanceType;
    /**
     * ml.c4.4xlarge
     */
    static readonly C4_4XLARGE: InstanceType;
    /**
     * ml.c4.8xlarge
     */
    static readonly C4_8XLARGE: InstanceType;
    /**
     * ml.c4.large
     */
    static readonly C4_LARGE: InstanceType;
    /**
     * ml.c4.xlarge
     */
    static readonly C4_XLARGE: InstanceType;
    /**
     * ml.c5.18xlarge
     */
    static readonly C5_18XLARGE: InstanceType;
    /**
     * ml.c5.2xlarge
     */
    static readonly C5_2XLARGE: InstanceType;
    /**
     * ml.c5.4xlarge
     */
    static readonly C5_4XLARGE: InstanceType;
    /**
     * ml.c5.9xlarge
     */
    static readonly C5_9XLARGE: InstanceType;
    /**
     * ml.c5.large
     */
    static readonly C5_LARGE: InstanceType;
    /**
     * ml.c5.xlarge
     */
    static readonly C5_XLARGE: InstanceType;
    /**
     * ml.c5d.18xlarge
     */
    static readonly C5D_18XLARGE: InstanceType;
    /**
     * ml.c5d.2xlarge
     */
    static readonly C5D_2XLARGE: InstanceType;
    /**
     * ml.c5d.4xlarge
     */
    static readonly C5D_4XLARGE: InstanceType;
    /**
     * ml.c5d.9xlarge
     */
    static readonly C5D_9XLARGE: InstanceType;
    /**
     * ml.c5d.large
     */
    static readonly C5D_LARGE: InstanceType;
    /**
     * ml.c5d.xlarge
     */
    static readonly C5D_XLARGE: InstanceType;
    /**
     * ml.c6i.12xlarge
     */
    static readonly C6I_12XLARGE: InstanceType;
    /**
     * ml.c6i.16xlarge
     */
    static readonly C6I_16XLARGE: InstanceType;
    /**
     * ml.c6i.24xlarge
     */
    static readonly C6I_24XLARGE: InstanceType;
    /**
     * ml.c6i.2xlarge
     */
    static readonly C6I_2XLARGE: InstanceType;
    /**
     * ml.c6i.32xlarge
     */
    static readonly C6I_32XLARGE: InstanceType;
    /**
     * ml.c6i.4xlarge
     */
    static readonly C6I_4XLARGE: InstanceType;
    /**
     * ml.c6i.8xlarge
     */
    static readonly C6I_8XLARGE: InstanceType;
    /**
     * ml.c6i.large
     */
    static readonly C6I_LARGE: InstanceType;
    /**
     * ml.c6i.xlarge
     */
    static readonly C6I_XLARGE: InstanceType;
    /**
     * ml.g4dn.12xlarge
     */
    static readonly G4DN_12XLARGE: InstanceType;
    /**
     * ml.g4dn.16xlarge
     */
    static readonly G4DN_16XLARGE: InstanceType;
    /**
     * ml.g4dn.2xlarge
     */
    static readonly G4DN_2XLARGE: InstanceType;
    /**
     * ml.g4dn.4xlarge
     */
    static readonly G4DN_4XLARGE: InstanceType;
    /**
     * ml.g4dn.8xlarge
     */
    static readonly G4DN_8XLARGE: InstanceType;
    /**
     * ml.g4dn.xlarge
     */
    static readonly G4DN_XLARGE: InstanceType;
    /**
     * ml.g5.12xlarge
     */
    static readonly G5_12XLARGE: InstanceType;
    /**
     * ml.g5.16xlarge
     */
    static readonly G5_16XLARGE: InstanceType;
    /**
     * ml.g5.24xlarge
     */
    static readonly G5_24XLARGE: InstanceType;
    /**
     * ml.g5.2xlarge
     */
    static readonly G5_2XLARGE: InstanceType;
    /**
     * ml.g5.48xlarge
     */
    static readonly G5_48XLARGE: InstanceType;
    /**
     * ml.g5.4xlarge
     */
    static readonly G5_4XLARGE: InstanceType;
    /**
     * ml.g5.8xlarge
     */
    static readonly G5_8XLARGE: InstanceType;
    /**
     * ml.g5.xlarge
     */
    static readonly G5_XLARGE: InstanceType;
    /**
     * ml.inf1.24xlarge
     */
    static readonly INF1_24XLARGE: InstanceType;
    /**
     * ml.inf1.2xlarge
     */
    static readonly INF1_2XLARGE: InstanceType;
    /**
     * ml.inf1.6xlarge
     */
    static readonly INF1_6XLARGE: InstanceType;
    /**
     * ml.inf1.xlarge
     */
    static readonly INF1_XLARGE: InstanceType;
    /**
     * ml.m4.10xlarge
     */
    static readonly M4_10XLARGE: InstanceType;
    /**
     * ml.m4.16xlarge
     */
    static readonly M4_16XLARGE: InstanceType;
    /**
     * ml.m4.2xlarge
     */
    static readonly M4_2XLARGE: InstanceType;
    /**
     * ml.m4.4xlarge
     */
    static readonly M4_4XLARGE: InstanceType;
    /**
     * ml.m4.xlarge
     */
    static readonly M4_XLARGE: InstanceType;
    /**
     * ml.m5.12xlarge
     */
    static readonly M5_12XLARGE: InstanceType;
    /**
     * ml.m5.24xlarge
     */
    static readonly M5_24XLARGE: InstanceType;
    /**
     * ml.m5.2xlarge
     */
    static readonly M5_2XLARGE: InstanceType;
    /**
     * ml.m5.4xlarge
     */
    static readonly M5_4XLARGE: InstanceType;
    /**
     * ml.m5.large
     */
    static readonly M5_LARGE: InstanceType;
    /**
     * ml.m5.xlarge
     */
    static readonly M5_XLARGE: InstanceType;
    /**
     * ml.m5d.12xlarge
     */
    static readonly M5D_12XLARGE: InstanceType;
    /**
     * ml.m5d.24xlarge
     */
    static readonly M5D_24XLARGE: InstanceType;
    /**
     * ml.m5d.2xlarge
     */
    static readonly M5D_2XLARGE: InstanceType;
    /**
     * ml.m5d.4xlarge
     */
    static readonly M5D_4XLARGE: InstanceType;
    /**
     * ml.m5d.large
     */
    static readonly M5D_LARGE: InstanceType;
    /**
     * ml.m5d.xlarge
     */
    static readonly M5D_XLARGE: InstanceType;
    /**
     * ml.p2.16xlarge
     */
    static readonly P2_16XLARGE: InstanceType;
    /**
     * ml.p2.8xlarge
     */
    static readonly P2_8XLARGE: InstanceType;
    /**
     * ml.p2.xlarge
     */
    static readonly P2_XLARGE: InstanceType;
    /**
     * ml.p3.16xlarge
     */
    static readonly P3_16XLARGE: InstanceType;
    /**
     * ml.p3.2xlarge
     */
    static readonly P3_2XLARGE: InstanceType;
    /**
     * ml.p3.8xlarge
     */
    static readonly P3_8XLARGE: InstanceType;
    /**
     * ml.p4d.24xlarge
     */
    static readonly P4D_24XLARGE: InstanceType;
    /**
     * ml.r5.12xlarge
     */
    static readonly R5_12XLARGE: InstanceType;
    /**
     * ml.r5.24xlarge
     */
    static readonly R5_24XLARGE: InstanceType;
    /**
     * ml.r5.2xlarge
     */
    static readonly R5_2XLARGE: InstanceType;
    /**
     * ml.r5.4xlarge
     */
    static readonly R5_4XLARGE: InstanceType;
    /**
     * ml.r5.large
     */
    static readonly R5_LARGE: InstanceType;
    /**
     * ml.r5.xlarge
     */
    static readonly R5_XLARGE: InstanceType;
    /**
     * ml.r5d.12xlarge
     */
    static readonly R5D_12XLARGE: InstanceType;
    /**
     * ml.r5d.24xlarge
     */
    static readonly R5D_24XLARGE: InstanceType;
    /**
     * ml.r5d.2xlarge
     */
    static readonly R5D_2XLARGE: InstanceType;
    /**
     * ml.r5d.4xlarge
     */
    static readonly R5D_4XLARGE: InstanceType;
    /**
     * ml.r5d.large
     */
    static readonly R5D_LARGE: InstanceType;
    /**
     * ml.r5d.xlarge
     */
    static readonly R5D_XLARGE: InstanceType;
    /**
     * ml.t2.2xlarge
     */
    static readonly T2_2XLARGE: InstanceType;
    /**
     * ml.t2.large
     */
    static readonly T2_LARGE: InstanceType;
    /**
     * ml.t2.medium
     */
    static readonly T2_MEDIUM: InstanceType;
    /**
     * ml.t2.xlarge
     */
    static readonly T2_XLARGE: InstanceType;
    /**
     * Builds an InstanceType from a given string or token (such as a CfnParameter).
     * @param instanceType An instance type as string
     * @returns A strongly typed InstanceType
     */
    static of(instanceType: string): InstanceType;
    private readonly instanceTypeIdentifier;
    constructor(instanceType: string);
    /**
     * Return the instance type as a string
     * @returns The instance type as a string
     */
    toString(): string;
}
