class VK(object):
    """Keyboard virtual code"""
    # https://docs.microsoft.com/zh-cn/windows/win32/inputdev/virtual-key-codes

    BACK = 0x08  # BACKSPACE key
    TAB = 0x09  # TAB key
    ENTER = 0x0D  # ENTER key
    SHIFT = 0x10  # SHIFT key
    CONTROL = 0x11  # CTRL key
    MENU = 0x12  # ALT key
    PAUSE = 0x13  # PAUSE key
    CAPITAL = 0x14  # CAPS LOCK key
    ESCAPE = 0x1B  # ESC key
    SPACE = 0x20  # SPACEBAR
    END = 0x23  # END key

    HOME = 0x24  # HOME key
    LEFT = 0x25  # LEFT ARROW key
    UP = 0x26  # UP ARROW key
    RIGHT = 0x27  # RIGHT ARROW key
    DOWN = 0x28  # DOWN ARROW key
    INSERT = 0x2D  # INS key
    DELETE = 0x2E  # DEL key

    NUM0 = 0x60  # Numeric keypad 0 key
    NUM1 = 0x61  # Numeric keypad 1 key
    NUM2 = 0x62  # Numeric keypad 2 key
    NUM3 = 0x63  # Numeric keypad 3 key
    NUM4 = 0x64  # Numeric keypad 4 key
    NUM5 = 0x65  # Numeric keypad 5 key
    NUM6 = 0x66  # Numeric keypad 6 key
    NUM7 = 0x67  # Numeric keypad 7 key
    NUM8 = 0x68  # Numeric keypad 8 key
    NUM9 = 0x69  # Numeric keypad 9 key

    F1 = 0x70  # F1 key
    F2 = 0x71  # F2 key
    F3 = 0x72  # F3 key
    F4 = 0x73  # F4 key
    F5 = 0x74  # F5 key
    F6 = 0x75  # F6 key
    F7 = 0x76  # F7 key
    F8 = 0x77  # F8 key
    F9 = 0x78  # F9 key
    F10 = 0x79  # F10 key
    F11 = 0x7A  # F11 key
    F12 = 0x7B  # F12 key

    NUMLOCK = 0x90  # NUM LOCK key
    LSHIFT = 0xA0  # Left SHIFT key
    RSHIFT = 0xA1  # Right SHIFT key
    LMENU = 0xA4  # Left MENU key
    RMENU = 0xA5  # Right MENU key

