import * as lambda from '@aws-cdk/aws-lambda';
import * as sns from '@aws-cdk/aws-sns';
import * as subs from '@aws-cdk/aws-sns-subscriptions';
/**
 * Properties forwarded to the Lambda Subscription.
 */
export interface SnsEventSourceProps extends subs.LambdaSubscriptionProps {
}
/**
 * Use an Amazon SNS topic as an event source for AWS Lambda.
 */
export declare class SnsEventSource implements lambda.IEventSource {
    readonly topic: sns.ITopic;
    private readonly props?;
    /**
     *
     */
    constructor(topic: sns.ITopic, props?: SnsEventSourceProps);
    /**
     * Called by `lambda.addEventSource` to allow the event source to bind to this function.
     */
    bind(target: lambda.IFunction): void;
}
