"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * An SNS dead letter queue destination configuration for a Lambda event source
 */
class SnsDlq {
    constructor(topic) {
        this.topic = topic;
    }
    /**
     * Returns a destination configuration for the DLQ
     */
    bind(_target, targetHandler) {
        this.topic.grantPublish(targetHandler);
        return {
            destination: this.topic.topicArn
        };
    }
}
exports.SnsDlq = SnsDlq;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic25zLWRscS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInNucy1kbHEudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFHQTs7R0FFRztBQUNILE1BQWEsTUFBTTtJQUNqQixZQUE2QixLQUFpQjtRQUFqQixVQUFLLEdBQUwsS0FBSyxDQUFZO0lBQzlDLENBQUM7SUFFRDs7T0FFRztJQUNJLElBQUksQ0FBQyxPQUE0QixFQUFFLGFBQXdCO1FBQ2hFLElBQUksQ0FBQyxLQUFLLENBQUMsWUFBWSxDQUFDLGFBQWEsQ0FBQyxDQUFDO1FBRXZDLE9BQU87WUFDTCxXQUFXLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxRQUFRO1NBQ2pDLENBQUM7SUFDSixDQUFDO0NBQ0Y7QUFkRCx3QkFjQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IERscURlc3RpbmF0aW9uQ29uZmlnLCBJRXZlbnRTb3VyY2VEbHEsIElFdmVudFNvdXJjZU1hcHBpbmcsIElGdW5jdGlvbiB9IGZyb20gJ0Bhd3MtY2RrL2F3cy1sYW1iZGEnO1xuaW1wb3J0ICogYXMgc25zIGZyb20gJ0Bhd3MtY2RrL2F3cy1zbnMnO1xuXG4vKipcbiAqIEFuIFNOUyBkZWFkIGxldHRlciBxdWV1ZSBkZXN0aW5hdGlvbiBjb25maWd1cmF0aW9uIGZvciBhIExhbWJkYSBldmVudCBzb3VyY2VcbiAqL1xuZXhwb3J0IGNsYXNzIFNuc0RscSBpbXBsZW1lbnRzIElFdmVudFNvdXJjZURscSB7XG4gIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgdG9waWM6IHNucy5JVG9waWMpIHtcbiAgfVxuXG4gIC8qKlxuICAgKiBSZXR1cm5zIGEgZGVzdGluYXRpb24gY29uZmlndXJhdGlvbiBmb3IgdGhlIERMUVxuICAgKi9cbiAgcHVibGljIGJpbmQoX3RhcmdldDogSUV2ZW50U291cmNlTWFwcGluZywgdGFyZ2V0SGFuZGxlcjogSUZ1bmN0aW9uKTogRGxxRGVzdGluYXRpb25Db25maWcge1xuICAgIHRoaXMudG9waWMuZ3JhbnRQdWJsaXNoKHRhcmdldEhhbmRsZXIpO1xuXG4gICAgcmV0dXJuIHtcbiAgICAgIGRlc3RpbmF0aW9uOiB0aGlzLnRvcGljLnRvcGljQXJuXG4gICAgfTtcbiAgfVxufVxuIl19