"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InputValidator = void 0;
const cdk = require("aws-cdk-lib");
/**
 * Class to validate that inputs match requirements.
 */
class InputValidator {
    /**
     * Validates length is between allowed min and max lengths.
     */
    static validateLength(resourceName, inputName, minLength, maxLength, inputString) {
        if (!cdk.Token.isUnresolved(inputString) && inputString !== undefined && (inputString.length < minLength || inputString.length > maxLength)) {
            throw new Error(`Invalid ${inputName} for resource ${resourceName}, must have length between ${minLength} and ${maxLength}, got: '${this.truncateString(inputString, 100)}'`);
        }
    }
    /**
     * Validates a regex.
     */
    static validateRegex(resourceName, inputName, regex, inputString) {
        if (!cdk.Token.isUnresolved(inputString) && inputString !== undefined && !regex.test(inputString)) {
            throw new Error(`Invalid ${inputName} for resource ${resourceName}, must match regex pattern ${regex}, got: '${this.truncateString(inputString, 100)}'`);
        }
    }
    static truncateString(string, maxLength) {
        if (string.length > maxLength) {
            return string.substring(0, maxLength) + '[truncated]';
        }
        return string;
    }
}
exports.InputValidator = InputValidator;
//# sourceMappingURL=data:application/json;base64,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