"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AttributeGroup = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const validation_1 = require("./private/validation");
const aws_servicecatalogappregistry_1 = require("aws-cdk-lib/aws-servicecatalogappregistry");
class AttributeGroupBase extends cdk.Resource {
}
/**
 * A Service Catalog AppRegistry Attribute Group.
 */
class AttributeGroup extends AttributeGroupBase {
    constructor(scope, id, props) {
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_servicecatalogappregistry_alpha_AttributeGroupProps(props);
        this.validateAttributeGroupProps(props);
        const attributeGroup = new aws_servicecatalogappregistry_1.CfnAttributeGroup(this, 'Resource', {
            name: props.attributeGroupName,
            description: props.description,
            attributes: props.attributes,
        });
        this.attributeGroupArn = attributeGroup.attrArn;
        this.attributeGroupId = attributeGroup.attrId;
    }
    /**
     * Imports an attribute group construct that represents an external attribute group.
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param attributeGroupArn the Amazon Resource Name of the existing AppRegistry attribute group
     */
    static fromAttributeGroupArn(scope, id, attributeGroupArn) {
        const arn = cdk.Stack.of(scope).splitArn(attributeGroupArn, cdk.ArnFormat.SLASH_RESOURCE_SLASH_RESOURCE_NAME);
        const attributeGroupId = arn.resourceName;
        if (!attributeGroupId) {
            throw new Error('Missing required Attribute Group ID from Attribute Group ARN: ' + attributeGroupArn);
        }
        class Import extends AttributeGroupBase {
            constructor() {
                super(...arguments);
                this.attributeGroupArn = attributeGroupArn;
                this.attributeGroupId = attributeGroupId;
            }
        }
        return new Import(scope, id, {
            environmentFromArn: attributeGroupArn,
        });
    }
    validateAttributeGroupProps(props) {
        validation_1.InputValidator.validateLength(this.node.path, 'attribute group name', 1, 256, props.attributeGroupName);
        validation_1.InputValidator.validateRegex(this.node.path, 'attribute group name', /^[a-zA-Z0-9-_]+$/, props.attributeGroupName);
        validation_1.InputValidator.validateLength(this.node.path, 'attribute group description', 0, 1024, props.description);
    }
}
exports.AttributeGroup = AttributeGroup;
_a = JSII_RTTI_SYMBOL_1;
AttributeGroup[_a] = { fqn: "@aws-cdk/aws-servicecatalogappregistry-alpha.AttributeGroup", version: "2.13.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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