import * as cdk from 'aws-cdk-lib';
import { IAttributeGroup } from './attribute-group';
import { Construct } from 'constructs';
/**
 * A Service Catalog AppRegistry Application.
 */
export interface IApplication extends cdk.IResource {
    /**
     * The ARN of the application.
     * @attribute
     */
    readonly applicationArn: string;
    /**
     * The ID of the application.
     * @attribute
     */
    readonly applicationId: string;
    /**
     * Associate thisapplication with an attribute group.
     * @param attributeGroup AppRegistry attribute group
     */
    associateAttributeGroup(attributeGroup: IAttributeGroup): void;
    /**
     * Associate this application with a CloudFormation stack.
     * @param stack a CFN stack
     */
    associateStack(stack: cdk.Stack): void;
}
/**
 * Properties for a Service Catalog AppRegistry Application
 */
export interface ApplicationProps {
    /**
     * Enforces a particular physical application name.
     */
    readonly applicationName: string;
    /**
     * Description for application.
     * @default - No description provided
     */
    readonly description?: string;
}
declare abstract class ApplicationBase extends cdk.Resource implements IApplication {
    abstract readonly applicationArn: string;
    abstract readonly applicationId: string;
    private readonly associatedAttributeGroups;
    private readonly associatedResources;
    /**
     * Associate an attribute group with application
     * If the attribute group is already associated, it will ignore duplicate request.
     */
    associateAttributeGroup(attributeGroup: IAttributeGroup): void;
    /**
     * Associate a stack with the application
     * If the resource is already associated, it will ignore duplicate request.
     * A stack can only be associated with one application.
     */
    associateStack(stack: cdk.Stack): void;
    /**
     * Create a unique id
     */
    protected abstract generateUniqueHash(resourceAddress: string): string;
}
/**
 * A Service Catalog AppRegistry Application.
 */
export declare class Application extends ApplicationBase {
    /**
     * Imports an Application construct that represents an external application.
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param applicationArn the Amazon Resource Name of the existing AppRegistry Application
     */
    static fromApplicationArn(scope: Construct, id: string, applicationArn: string): IApplication;
    readonly applicationArn: string;
    readonly applicationId: string;
    private readonly nodeAddress;
    constructor(scope: Construct, id: string, props: ApplicationProps);
    protected generateUniqueHash(resourceAddress: string): string;
    private validateApplicationProps;
}
export {};
