# coding: utf-8

"""
    Automox Console API

    API for use with the Automox Console  # noqa: E501

    OpenAPI spec version: 2021-11-16
    Contact: support@automox.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class ServerGroupCreateOrUpdateRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'refresh_interval': 'int',
        'parent_server_group_id': 'int',
        'ui_color': 'str',
        'notes': 'str',
        'enable_os_auto_update': 'bool',
        'enable_wsus': 'bool',
        'wsus_server': 'str',
        'policies': 'list[int]'
    }

    attribute_map = {
        'name': 'name',
        'refresh_interval': 'refresh_interval',
        'parent_server_group_id': 'parent_server_group_id',
        'ui_color': 'ui_color',
        'notes': 'notes',
        'enable_os_auto_update': 'enable_os_auto_update',
        'enable_wsus': 'enable_wsus',
        'wsus_server': 'wsus_server',
        'policies': 'policies'
    }

    def __init__(self, name=None, refresh_interval=None, parent_server_group_id=None, ui_color=None, notes=None, enable_os_auto_update=None, enable_wsus=None, wsus_server=None, policies=None):  # noqa: E501
        """ServerGroupCreateOrUpdateRequest - a model defined in Swagger"""  # noqa: E501
        self._name = None
        self._refresh_interval = None
        self._parent_server_group_id = None
        self._ui_color = None
        self._notes = None
        self._enable_os_auto_update = None
        self._enable_wsus = None
        self._wsus_server = None
        self._policies = None
        self.discriminator = None
        self.name = name
        self.refresh_interval = refresh_interval
        self.parent_server_group_id = parent_server_group_id
        if ui_color is not None:
            self.ui_color = ui_color
        if notes is not None:
            self.notes = notes
        if enable_os_auto_update is not None:
            self.enable_os_auto_update = enable_os_auto_update
        if enable_wsus is not None:
            self.enable_wsus = enable_wsus
        if wsus_server is not None:
            self.wsus_server = wsus_server
        if policies is not None:
            self.policies = policies

    @property
    def name(self):
        """Gets the name of this ServerGroupCreateOrUpdateRequest.  # noqa: E501

        Name of the group  # noqa: E501

        :return: The name of this ServerGroupCreateOrUpdateRequest.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ServerGroupCreateOrUpdateRequest.

        Name of the group  # noqa: E501

        :param name: The name of this ServerGroupCreateOrUpdateRequest.  # noqa: E501
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def refresh_interval(self):
        """Gets the refresh_interval of this ServerGroupCreateOrUpdateRequest.  # noqa: E501

        Frequency of device refreshes (scans) in minutes. Minimum: 360 Maximum: 1440  # noqa: E501

        :return: The refresh_interval of this ServerGroupCreateOrUpdateRequest.  # noqa: E501
        :rtype: int
        """
        return self._refresh_interval

    @refresh_interval.setter
    def refresh_interval(self, refresh_interval):
        """Sets the refresh_interval of this ServerGroupCreateOrUpdateRequest.

        Frequency of device refreshes (scans) in minutes. Minimum: 360 Maximum: 1440  # noqa: E501

        :param refresh_interval: The refresh_interval of this ServerGroupCreateOrUpdateRequest.  # noqa: E501
        :type: int
        """
        if refresh_interval is None:
            raise ValueError("Invalid value for `refresh_interval`, must not be `None`")  # noqa: E501

        self._refresh_interval = refresh_interval

    @property
    def parent_server_group_id(self):
        """Gets the parent_server_group_id of this ServerGroupCreateOrUpdateRequest.  # noqa: E501

        ID of the parent group. Use the organization's Default Group ID to make this a top-level group. See [About Automox API - Default Group ID](/developer-portal/about-ax-api#Default-Group-ID)  # noqa: E501

        :return: The parent_server_group_id of this ServerGroupCreateOrUpdateRequest.  # noqa: E501
        :rtype: int
        """
        return self._parent_server_group_id

    @parent_server_group_id.setter
    def parent_server_group_id(self, parent_server_group_id):
        """Sets the parent_server_group_id of this ServerGroupCreateOrUpdateRequest.

        ID of the parent group. Use the organization's Default Group ID to make this a top-level group. See [About Automox API - Default Group ID](/developer-portal/about-ax-api#Default-Group-ID)  # noqa: E501

        :param parent_server_group_id: The parent_server_group_id of this ServerGroupCreateOrUpdateRequest.  # noqa: E501
        :type: int
        """
        if parent_server_group_id is None:
            raise ValueError("Invalid value for `parent_server_group_id`, must not be `None`")  # noqa: E501

        self._parent_server_group_id = parent_server_group_id

    @property
    def ui_color(self):
        """Gets the ui_color of this ServerGroupCreateOrUpdateRequest.  # noqa: E501

        The highlight color for the group. Primarily used on the System Management view. Format: #059F1D  # noqa: E501

        :return: The ui_color of this ServerGroupCreateOrUpdateRequest.  # noqa: E501
        :rtype: str
        """
        return self._ui_color

    @ui_color.setter
    def ui_color(self, ui_color):
        """Sets the ui_color of this ServerGroupCreateOrUpdateRequest.

        The highlight color for the group. Primarily used on the System Management view. Format: #059F1D  # noqa: E501

        :param ui_color: The ui_color of this ServerGroupCreateOrUpdateRequest.  # noqa: E501
        :type: str
        """

        self._ui_color = ui_color

    @property
    def notes(self):
        """Gets the notes of this ServerGroupCreateOrUpdateRequest.  # noqa: E501

        Use to define notes that are displayed while editing the policy  # noqa: E501

        :return: The notes of this ServerGroupCreateOrUpdateRequest.  # noqa: E501
        :rtype: str
        """
        return self._notes

    @notes.setter
    def notes(self, notes):
        """Sets the notes of this ServerGroupCreateOrUpdateRequest.

        Use to define notes that are displayed while editing the policy  # noqa: E501

        :param notes: The notes of this ServerGroupCreateOrUpdateRequest.  # noqa: E501
        :type: str
        """

        self._notes = notes

    @property
    def enable_os_auto_update(self):
        """Gets the enable_os_auto_update of this ServerGroupCreateOrUpdateRequest.  # noqa: E501

        Enforce automatic update settings Options: `null`: Keep Device's Setting. `true`: Enable OS automatic updates. `false`: Disable OS automatic updates.  # noqa: E501

        :return: The enable_os_auto_update of this ServerGroupCreateOrUpdateRequest.  # noqa: E501
        :rtype: bool
        """
        return self._enable_os_auto_update

    @enable_os_auto_update.setter
    def enable_os_auto_update(self, enable_os_auto_update):
        """Sets the enable_os_auto_update of this ServerGroupCreateOrUpdateRequest.

        Enforce automatic update settings Options: `null`: Keep Device's Setting. `true`: Enable OS automatic updates. `false`: Disable OS automatic updates.  # noqa: E501

        :param enable_os_auto_update: The enable_os_auto_update of this ServerGroupCreateOrUpdateRequest.  # noqa: E501
        :type: bool
        """

        self._enable_os_auto_update = enable_os_auto_update

    @property
    def enable_wsus(self):
        """Gets the enable_wsus of this ServerGroupCreateOrUpdateRequest.  # noqa: E501

        Enforce WSUS settings for Windows devices. Options: `null`: Keep Device's Setting. `true`: force WSUS. `false`: force Windows Update.  # noqa: E501

        :return: The enable_wsus of this ServerGroupCreateOrUpdateRequest.  # noqa: E501
        :rtype: bool
        """
        return self._enable_wsus

    @enable_wsus.setter
    def enable_wsus(self, enable_wsus):
        """Sets the enable_wsus of this ServerGroupCreateOrUpdateRequest.

        Enforce WSUS settings for Windows devices. Options: `null`: Keep Device's Setting. `true`: force WSUS. `false`: force Windows Update.  # noqa: E501

        :param enable_wsus: The enable_wsus of this ServerGroupCreateOrUpdateRequest.  # noqa: E501
        :type: bool
        """

        self._enable_wsus = enable_wsus

    @property
    def wsus_server(self):
        """Gets the wsus_server of this ServerGroupCreateOrUpdateRequest.  # noqa: E501

        WSUS server address. Use with `enable_wsus`. Format: `\"https://myserver.com:8530\"`  # noqa: E501

        :return: The wsus_server of this ServerGroupCreateOrUpdateRequest.  # noqa: E501
        :rtype: str
        """
        return self._wsus_server

    @wsus_server.setter
    def wsus_server(self, wsus_server):
        """Sets the wsus_server of this ServerGroupCreateOrUpdateRequest.

        WSUS server address. Use with `enable_wsus`. Format: `\"https://myserver.com:8530\"`  # noqa: E501

        :param wsus_server: The wsus_server of this ServerGroupCreateOrUpdateRequest.  # noqa: E501
        :type: str
        """

        self._wsus_server = wsus_server

    @property
    def policies(self):
        """Gets the policies of this ServerGroupCreateOrUpdateRequest.  # noqa: E501

        List of Policies to link to this group.  # noqa: E501

        :return: The policies of this ServerGroupCreateOrUpdateRequest.  # noqa: E501
        :rtype: list[int]
        """
        return self._policies

    @policies.setter
    def policies(self, policies):
        """Sets the policies of this ServerGroupCreateOrUpdateRequest.

        List of Policies to link to this group.  # noqa: E501

        :param policies: The policies of this ServerGroupCreateOrUpdateRequest.  # noqa: E501
        :type: list[int]
        """

        self._policies = policies

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ServerGroupCreateOrUpdateRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ServerGroupCreateOrUpdateRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
