# coding: utf-8

"""
    Automox Console API

    API for use with the Automox Console  # noqa: E501

    OpenAPI spec version: 2021-11-16
    Contact: support@automox.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from automox_console_sdk.api_client import ApiClient


class ReportsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_needs_attention_report(self, o, **kwargs):  # noqa: E501
        """Needs Attention Report  # noqa: E501

        Retrieve a report containing devices that need attention.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_needs_attention_report(o, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int o: Organization ID. If omitted, results will include all organizations for the authenticated user. (required)
        :param int group_id: Group ID. If omitted, results will include all groups for the authenticated user.
        :param int limit: Limit number of results returned per page. Typically used in combination with offset
        :param int offset: Specifies the offset. For example, if you are paging 250 at a time, you could specify 250 for the 2nd page and 500 for the 3rd, etc.
        :return: list[NeedsAttention]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_needs_attention_report_with_http_info(o, **kwargs)  # noqa: E501
        else:
            (data) = self.get_needs_attention_report_with_http_info(o, **kwargs)  # noqa: E501
            return data

    def get_needs_attention_report_with_http_info(self, o, **kwargs):  # noqa: E501
        """Needs Attention Report  # noqa: E501

        Retrieve a report containing devices that need attention.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_needs_attention_report_with_http_info(o, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int o: Organization ID. If omitted, results will include all organizations for the authenticated user. (required)
        :param int group_id: Group ID. If omitted, results will include all groups for the authenticated user.
        :param int limit: Limit number of results returned per page. Typically used in combination with offset
        :param int offset: Specifies the offset. For example, if you are paging 250 at a time, you could specify 250 for the 2nd page and 500 for the 3rd, etc.
        :return: list[NeedsAttention]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['o', 'group_id', 'limit', 'offset']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_needs_attention_report" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'o' is set
        if ('o' not in params or
                params['o'] is None):
            raise ValueError("Missing the required parameter `o` when calling `get_needs_attention_report`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'o' in params:
            query_params.append(('o', params['o']))  # noqa: E501
        if 'group_id' in params:
            query_params.append(('groupId', params['group_id']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/reports/needs-attention', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[NeedsAttention]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_non_compliance_report(self, o, **kwargs):  # noqa: E501
        """Non-Compliance Report  # noqa: E501

        Retrieve the non-compliant devices report. This endpoint is deprecated. Please use [GET /reports/needs-attention](/openapi/axconsole/operation/getNeedsAttentionReport) instead.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_non_compliance_report(o, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int o: Organization ID. If omitted, results will include all organizations for the authenticated user. (required)
        :param int group_id: Group ID. If omitted, results will include all groups for the authenticated user.
        :param int limit: Limit number of results returned per page. Typically used in combination with offset
        :param int offset: Specifies the offset. For example, if you are paging 250 at a time, you could specify 250 for the 2nd page and 500 for the 3rd, etc.
        :return: list[NonCompliant]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_non_compliance_report_with_http_info(o, **kwargs)  # noqa: E501
        else:
            (data) = self.get_non_compliance_report_with_http_info(o, **kwargs)  # noqa: E501
            return data

    def get_non_compliance_report_with_http_info(self, o, **kwargs):  # noqa: E501
        """Non-Compliance Report  # noqa: E501

        Retrieve the non-compliant devices report. This endpoint is deprecated. Please use [GET /reports/needs-attention](/openapi/axconsole/operation/getNeedsAttentionReport) instead.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_non_compliance_report_with_http_info(o, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int o: Organization ID. If omitted, results will include all organizations for the authenticated user. (required)
        :param int group_id: Group ID. If omitted, results will include all groups for the authenticated user.
        :param int limit: Limit number of results returned per page. Typically used in combination with offset
        :param int offset: Specifies the offset. For example, if you are paging 250 at a time, you could specify 250 for the 2nd page and 500 for the 3rd, etc.
        :return: list[NonCompliant]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['o', 'group_id', 'limit', 'offset']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_non_compliance_report" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'o' is set
        if ('o' not in params or
                params['o'] is None):
            raise ValueError("Missing the required parameter `o` when calling `get_non_compliance_report`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'o' in params:
            query_params.append(('o', params['o']))  # noqa: E501
        if 'group_id' in params:
            query_params.append(('groupId', params['group_id']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/reports/noncompliance', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[NonCompliant]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_pre_patch_report(self, o, **kwargs):  # noqa: E501
        """Pre-Patch Report  # noqa: E501

        Retrieve the pre-patch report.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_pre_patch_report(o, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int o: Organization ID. If omitted, results will include all organizations for the authenticated user. (required)
        :param int group_id: The ID of the server group for limiting results
        :param int limit: Limit number of results returned per page. Typically used in combination with offset
        :param int offset: Specifies the offset. For example, if you are paging 250 at a time, you could specify 250 for the 2nd page and 500 for the 3rd, etc.
        :return: PrePatch
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_pre_patch_report_with_http_info(o, **kwargs)  # noqa: E501
        else:
            (data) = self.get_pre_patch_report_with_http_info(o, **kwargs)  # noqa: E501
            return data

    def get_pre_patch_report_with_http_info(self, o, **kwargs):  # noqa: E501
        """Pre-Patch Report  # noqa: E501

        Retrieve the pre-patch report.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_pre_patch_report_with_http_info(o, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int o: Organization ID. If omitted, results will include all organizations for the authenticated user. (required)
        :param int group_id: The ID of the server group for limiting results
        :param int limit: Limit number of results returned per page. Typically used in combination with offset
        :param int offset: Specifies the offset. For example, if you are paging 250 at a time, you could specify 250 for the 2nd page and 500 for the 3rd, etc.
        :return: PrePatch
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['o', 'group_id', 'limit', 'offset']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_pre_patch_report" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'o' is set
        if ('o' not in params or
                params['o'] is None):
            raise ValueError("Missing the required parameter `o` when calling `get_pre_patch_report`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'o' in params:
            query_params.append(('o', params['o']))  # noqa: E501
        if 'group_id' in params:
            query_params.append(('groupId', params['group_id']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/reports/prepatch', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PrePatch',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
