"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PackageManager = void 0;
const os = require("os");
const path = require("path");
/**
 * A node package manager
 */
class PackageManager {
    constructor(props) {
        this.lockFile = props.lockFile;
        this.installCommand = props.installCommand;
        this.runCommand = props.runCommand;
        this.argsSeparator = props.argsSeparator;
    }
    static fromLockFile(lockFilePath) {
        const lockFile = path.basename(lockFilePath);
        switch (lockFile) {
            case PackageManager.NPM.lockFile:
                return PackageManager.NPM;
            case PackageManager.YARN.lockFile:
                return PackageManager.YARN;
            case PackageManager.PNPM.lockFile:
                return PackageManager.PNPM;
            default:
                return PackageManager.NPM;
        }
    }
    runBinCommand(bin) {
        const [runCommand, ...runArgs] = this.runCommand;
        return [
            os.platform() === 'win32' ? `${runCommand}.cmd` : runCommand,
            ...runArgs,
            bin,
            ...(this.argsSeparator ? [this.argsSeparator] : []),
        ].join(' ');
    }
}
exports.PackageManager = PackageManager;
PackageManager.NPM = new PackageManager({
    lockFile: 'package-lock.json',
    installCommand: ['npm', 'ci'],
    runCommand: ['npx', '--no-install'],
});
PackageManager.YARN = new PackageManager({
    lockFile: 'yarn.lock',
    installCommand: ['yarn', 'install'],
    runCommand: ['yarn', 'run'],
});
PackageManager.PNPM = new PackageManager({
    lockFile: 'pnpm-lock.yaml',
    installCommand: ['pnpm', 'install'],
    runCommand: ['pnpm', 'exec'],
    argsSeparator: '--',
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicGFja2FnZS1tYW5hZ2VyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsicGFja2FnZS1tYW5hZ2VyLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLHlCQUF5QjtBQUN6Qiw2QkFBNkI7QUFTN0I7O0dBRUc7QUFDSCxNQUFhLGNBQWM7SUF3Q3pCLFlBQVksS0FBMEI7UUFDcEMsSUFBSSxDQUFDLFFBQVEsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDO1FBQy9CLElBQUksQ0FBQyxjQUFjLEdBQUcsS0FBSyxDQUFDLGNBQWMsQ0FBQztRQUMzQyxJQUFJLENBQUMsVUFBVSxHQUFHLEtBQUssQ0FBQyxVQUFVLENBQUM7UUFDbkMsSUFBSSxDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUMsYUFBYSxDQUFDO0lBQzNDLENBQUM7SUF6Qk0sTUFBTSxDQUFDLFlBQVksQ0FBQyxZQUFvQjtRQUM3QyxNQUFNLFFBQVEsR0FBRyxJQUFJLENBQUMsUUFBUSxDQUFDLFlBQVksQ0FBQyxDQUFDO1FBRTdDLFFBQVEsUUFBUSxFQUFFO1lBQ2hCLEtBQUssY0FBYyxDQUFDLEdBQUcsQ0FBQyxRQUFRO2dCQUM5QixPQUFPLGNBQWMsQ0FBQyxHQUFHLENBQUM7WUFDNUIsS0FBSyxjQUFjLENBQUMsSUFBSSxDQUFDLFFBQVE7Z0JBQy9CLE9BQU8sY0FBYyxDQUFDLElBQUksQ0FBQztZQUM3QixLQUFLLGNBQWMsQ0FBQyxJQUFJLENBQUMsUUFBUTtnQkFDL0IsT0FBTyxjQUFjLENBQUMsSUFBSSxDQUFDO1lBQzdCO2dCQUNFLE9BQU8sY0FBYyxDQUFDLEdBQUcsQ0FBQztTQUM3QjtJQUNILENBQUM7SUFjTSxhQUFhLENBQUMsR0FBVztRQUM5QixNQUFNLENBQUMsVUFBVSxFQUFFLEdBQUcsT0FBTyxDQUFDLEdBQUcsSUFBSSxDQUFDLFVBQVUsQ0FBQztRQUNqRCxPQUFPO1lBQ0wsRUFBRSxDQUFDLFFBQVEsRUFBRSxLQUFLLE9BQU8sQ0FBQyxDQUFDLENBQUMsR0FBRyxVQUFVLE1BQU0sQ0FBQyxDQUFDLENBQUMsVUFBVTtZQUM1RCxHQUFHLE9BQU87WUFDVixHQUFHO1lBQ0gsR0FBRyxDQUFDLElBQUksQ0FBQyxhQUFhLENBQUMsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUM7U0FDcEQsQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUM7SUFDZCxDQUFDOztBQXZESCx3Q0F3REM7QUF2RGUsa0JBQUcsR0FBRyxJQUFJLGNBQWMsQ0FBQztJQUNyQyxRQUFRLEVBQUUsbUJBQW1CO0lBQzdCLGNBQWMsRUFBRSxDQUFDLEtBQUssRUFBRSxJQUFJLENBQUM7SUFDN0IsVUFBVSxFQUFFLENBQUMsS0FBSyxFQUFFLGNBQWMsQ0FBQztDQUNwQyxDQUFDLENBQUM7QUFFVyxtQkFBSSxHQUFHLElBQUksY0FBYyxDQUFDO0lBQ3RDLFFBQVEsRUFBRSxXQUFXO0lBQ3JCLGNBQWMsRUFBRSxDQUFDLE1BQU0sRUFBRSxTQUFTLENBQUM7SUFDbkMsVUFBVSxFQUFFLENBQUMsTUFBTSxFQUFFLEtBQUssQ0FBQztDQUM1QixDQUFDLENBQUM7QUFFVyxtQkFBSSxHQUFHLElBQUksY0FBYyxDQUFDO0lBQ3RDLFFBQVEsRUFBRSxnQkFBZ0I7SUFDMUIsY0FBYyxFQUFFLENBQUMsTUFBTSxFQUFFLFNBQVMsQ0FBQztJQUNuQyxVQUFVLEVBQUUsQ0FBQyxNQUFNLEVBQUUsTUFBTSxDQUFDO0lBQzVCLGFBQWEsRUFBRSxJQUFJO0NBQ3BCLENBQUMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIG9zIGZyb20gJ29zJztcbmltcG9ydCAqIGFzIHBhdGggZnJvbSAncGF0aCc7XG5cbmludGVyZmFjZSBQYWNrYWdlTWFuYWdlclByb3BzIHtcbiAgcmVhZG9ubHkgbG9ja0ZpbGU6IHN0cmluZztcbiAgcmVhZG9ubHkgaW5zdGFsbENvbW1hbmQ6IHN0cmluZ1tdO1xuICByZWFkb25seSBydW5Db21tYW5kOiBzdHJpbmdbXTtcbiAgcmVhZG9ubHkgYXJnc1NlcGFyYXRvcj86IHN0cmluZ1xufVxuXG4vKipcbiAqIEEgbm9kZSBwYWNrYWdlIG1hbmFnZXJcbiAqL1xuZXhwb3J0IGNsYXNzIFBhY2thZ2VNYW5hZ2VyIHtcbiAgcHVibGljIHN0YXRpYyBOUE0gPSBuZXcgUGFja2FnZU1hbmFnZXIoe1xuICAgIGxvY2tGaWxlOiAncGFja2FnZS1sb2NrLmpzb24nLFxuICAgIGluc3RhbGxDb21tYW5kOiBbJ25wbScsICdjaSddLFxuICAgIHJ1bkNvbW1hbmQ6IFsnbnB4JywgJy0tbm8taW5zdGFsbCddLFxuICB9KTtcblxuICBwdWJsaWMgc3RhdGljIFlBUk4gPSBuZXcgUGFja2FnZU1hbmFnZXIoe1xuICAgIGxvY2tGaWxlOiAneWFybi5sb2NrJyxcbiAgICBpbnN0YWxsQ29tbWFuZDogWyd5YXJuJywgJ2luc3RhbGwnXSxcbiAgICBydW5Db21tYW5kOiBbJ3lhcm4nLCAncnVuJ10sXG4gIH0pO1xuXG4gIHB1YmxpYyBzdGF0aWMgUE5QTSA9IG5ldyBQYWNrYWdlTWFuYWdlcih7XG4gICAgbG9ja0ZpbGU6ICdwbnBtLWxvY2sueWFtbCcsXG4gICAgaW5zdGFsbENvbW1hbmQ6IFsncG5wbScsICdpbnN0YWxsJ10sXG4gICAgcnVuQ29tbWFuZDogWydwbnBtJywgJ2V4ZWMnXSxcbiAgICBhcmdzU2VwYXJhdG9yOiAnLS0nLFxuICB9KTtcblxuICBwdWJsaWMgc3RhdGljIGZyb21Mb2NrRmlsZShsb2NrRmlsZVBhdGg6IHN0cmluZyk6IFBhY2thZ2VNYW5hZ2VyIHtcbiAgICBjb25zdCBsb2NrRmlsZSA9IHBhdGguYmFzZW5hbWUobG9ja0ZpbGVQYXRoKTtcblxuICAgIHN3aXRjaCAobG9ja0ZpbGUpIHtcbiAgICAgIGNhc2UgUGFja2FnZU1hbmFnZXIuTlBNLmxvY2tGaWxlOlxuICAgICAgICByZXR1cm4gUGFja2FnZU1hbmFnZXIuTlBNO1xuICAgICAgY2FzZSBQYWNrYWdlTWFuYWdlci5ZQVJOLmxvY2tGaWxlOlxuICAgICAgICByZXR1cm4gUGFja2FnZU1hbmFnZXIuWUFSTjtcbiAgICAgIGNhc2UgUGFja2FnZU1hbmFnZXIuUE5QTS5sb2NrRmlsZTpcbiAgICAgICAgcmV0dXJuIFBhY2thZ2VNYW5hZ2VyLlBOUE07XG4gICAgICBkZWZhdWx0OlxuICAgICAgICByZXR1cm4gUGFja2FnZU1hbmFnZXIuTlBNO1xuICAgIH1cbiAgfVxuXG4gIHB1YmxpYyByZWFkb25seSBsb2NrRmlsZTogc3RyaW5nO1xuICBwdWJsaWMgcmVhZG9ubHkgaW5zdGFsbENvbW1hbmQ6IHN0cmluZ1tdO1xuICBwdWJsaWMgcmVhZG9ubHkgcnVuQ29tbWFuZDogc3RyaW5nW107XG4gIHB1YmxpYyByZWFkb25seSBhcmdzU2VwYXJhdG9yPzogc3RyaW5nO1xuXG4gIGNvbnN0cnVjdG9yKHByb3BzOiBQYWNrYWdlTWFuYWdlclByb3BzKSB7XG4gICAgdGhpcy5sb2NrRmlsZSA9IHByb3BzLmxvY2tGaWxlO1xuICAgIHRoaXMuaW5zdGFsbENvbW1hbmQgPSBwcm9wcy5pbnN0YWxsQ29tbWFuZDtcbiAgICB0aGlzLnJ1bkNvbW1hbmQgPSBwcm9wcy5ydW5Db21tYW5kO1xuICAgIHRoaXMuYXJnc1NlcGFyYXRvciA9IHByb3BzLmFyZ3NTZXBhcmF0b3I7XG4gIH1cblxuICBwdWJsaWMgcnVuQmluQ29tbWFuZChiaW46IHN0cmluZyk6IHN0cmluZyB7XG4gICAgY29uc3QgW3J1bkNvbW1hbmQsIC4uLnJ1bkFyZ3NdID0gdGhpcy5ydW5Db21tYW5kO1xuICAgIHJldHVybiBbXG4gICAgICBvcy5wbGF0Zm9ybSgpID09PSAnd2luMzInID8gYCR7cnVuQ29tbWFuZH0uY21kYCA6IHJ1bkNvbW1hbmQsXG4gICAgICAuLi5ydW5BcmdzLFxuICAgICAgYmluLFxuICAgICAgLi4uKHRoaXMuYXJnc1NlcGFyYXRvciA/IFt0aGlzLmFyZ3NTZXBhcmF0b3JdIDogW10pLFxuICAgIF0uam9pbignICcpO1xuICB9XG59XG4iXX0=