"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KubectlAsset = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const crypto = require("crypto");
const fs = require("fs");
const path = require("path");
const s3_assets = require("aws-cdk-lib/aws-s3-assets");
/**
 * A CDK Asset construct that contains `kubectl` and `helm`.
 */
class KubectlAsset extends s3_assets.Asset {
    constructor(scope, id, options = {}) {
        super(scope, id, {
            path: path.join(__dirname, 'layer.zip'),
            // we hash the Dockerfile (it contains the tools versions) because hashing the zip is non-deterministic
            assetHash: hashFile(path.join(__dirname, '..', 'layer', 'Dockerfile')),
            ...options,
        });
    }
}
exports.KubectlAsset = KubectlAsset;
_a = JSII_RTTI_SYMBOL_1;
KubectlAsset[_a] = { fqn: "@aws-cdk/asset-kubectl-v21.KubectlAsset", version: "0.0.3" };
function hashFile(fileName) {
    return crypto
        .createHash('sha256')
        .update(fs.readFileSync(fileName))
        .digest('hex');
}
//# sourceMappingURL=data:application/json;base64,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