# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel
from typing import List, Dict


class BatchAddDeviceGroupRelationsRequestDevice(TeaModel):
    def __init__(
        self,
        product_key: str = None,
        device_name: str = None,
    ):
        self.product_key = product_key
        self.device_name = device_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        return self


class BatchAddDeviceGroupRelationsRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        group_id: str = None,
        device: List[BatchAddDeviceGroupRelationsRequestDevice] = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.group_id = group_id
        self.device = device

    def validate(self):
        if self.device:
            for k in self.device:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        result['Device'] = []
        if self.device is not None:
            for k in self.device:
                result['Device'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        self.device = []
        if m.get('Device') is not None:
            for k in m.get('Device'):
                temp_model = BatchAddDeviceGroupRelationsRequestDevice()
                self.device.append(temp_model.from_map(k))
        return self


class BatchAddDeviceGroupRelationsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        valid_device_count: int = None,
        exceed_ten_group_device_count: int = None,
        already_related_group_device_count: int = None,
        success_added_device_count: int = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.valid_device_count = valid_device_count
        self.exceed_ten_group_device_count = exceed_ten_group_device_count
        self.already_related_group_device_count = already_related_group_device_count
        self.success_added_device_count = success_added_device_count
        self.error_message = error_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.valid_device_count is not None:
            result['ValidDeviceCount'] = self.valid_device_count
        if self.exceed_ten_group_device_count is not None:
            result['ExceedTenGroupDeviceCount'] = self.exceed_ten_group_device_count
        if self.already_related_group_device_count is not None:
            result['AlreadyRelatedGroupDeviceCount'] = self.already_related_group_device_count
        if self.success_added_device_count is not None:
            result['SuccessAddedDeviceCount'] = self.success_added_device_count
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ValidDeviceCount') is not None:
            self.valid_device_count = m.get('ValidDeviceCount')
        if m.get('ExceedTenGroupDeviceCount') is not None:
            self.exceed_ten_group_device_count = m.get('ExceedTenGroupDeviceCount')
        if m.get('AlreadyRelatedGroupDeviceCount') is not None:
            self.already_related_group_device_count = m.get('AlreadyRelatedGroupDeviceCount')
        if m.get('SuccessAddedDeviceCount') is not None:
            self.success_added_device_count = m.get('SuccessAddedDeviceCount')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class BatchAddDeviceGroupRelationsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BatchAddDeviceGroupRelationsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchAddDeviceGroupRelationsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchAddThingTopoRequestTopoAddItem(TeaModel):
    def __init__(
        self,
        product_key: str = None,
        device_name: str = None,
        sign: str = None,
        sign_method: str = None,
        timestamp: str = None,
        client_id: str = None,
    ):
        self.product_key = product_key
        self.device_name = device_name
        self.sign = sign
        self.sign_method = sign_method
        self.timestamp = timestamp
        self.client_id = client_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.sign is not None:
            result['Sign'] = self.sign
        if self.sign_method is not None:
            result['SignMethod'] = self.sign_method
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.client_id is not None:
            result['ClientId'] = self.client_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('Sign') is not None:
            self.sign = m.get('Sign')
        if m.get('SignMethod') is not None:
            self.sign_method = m.get('SignMethod')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('ClientId') is not None:
            self.client_id = m.get('ClientId')
        return self


class BatchAddThingTopoRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        topo_add_item: List[BatchAddThingTopoRequestTopoAddItem] = None,
        gw_product_key: str = None,
        gw_device_name: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.topo_add_item = topo_add_item
        self.gw_product_key = gw_product_key
        self.gw_device_name = gw_device_name

    def validate(self):
        if self.topo_add_item:
            for k in self.topo_add_item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        result['TopoAddItem'] = []
        if self.topo_add_item is not None:
            for k in self.topo_add_item:
                result['TopoAddItem'].append(k.to_map() if k else None)
        if self.gw_product_key is not None:
            result['GwProductKey'] = self.gw_product_key
        if self.gw_device_name is not None:
            result['GwDeviceName'] = self.gw_device_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        self.topo_add_item = []
        if m.get('TopoAddItem') is not None:
            for k in m.get('TopoAddItem'):
                temp_model = BatchAddThingTopoRequestTopoAddItem()
                self.topo_add_item.append(temp_model.from_map(k))
        if m.get('GwProductKey') is not None:
            self.gw_product_key = m.get('GwProductKey')
        if m.get('GwDeviceName') is not None:
            self.gw_device_name = m.get('GwDeviceName')
        return self


class BatchAddThingTopoResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class BatchAddThingTopoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BatchAddThingTopoResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchAddThingTopoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchBindDevicesIntoProjectRequestDevices(TeaModel):
    def __init__(
        self,
        product_key: str = None,
        device_name: str = None,
    ):
        self.product_key = product_key
        self.device_name = device_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        return self


class BatchBindDevicesIntoProjectRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        devices: List[BatchBindDevicesIntoProjectRequestDevices] = None,
        project_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.devices = devices
        self.project_id = project_id

    def validate(self):
        if self.devices:
            for k in self.devices:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        result['Devices'] = []
        if self.devices is not None:
            for k in self.devices:
                result['Devices'].append(k.to_map() if k else None)
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        self.devices = []
        if m.get('Devices') is not None:
            for k in m.get('Devices'):
                temp_model = BatchBindDevicesIntoProjectRequestDevices()
                self.devices.append(temp_model.from_map(k))
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class BatchBindDevicesIntoProjectResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: bool = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class BatchBindDevicesIntoProjectResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BatchBindDevicesIntoProjectResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchBindDevicesIntoProjectResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchBindDeviceToEdgeInstanceWithDriverRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
        driver_id: str = None,
        iot_ids: List[str] = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.driver_id = driver_id
        self.iot_ids = iot_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        return self


class BatchBindDeviceToEdgeInstanceWithDriverResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class BatchBindDeviceToEdgeInstanceWithDriverResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BatchBindDeviceToEdgeInstanceWithDriverResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchBindDeviceToEdgeInstanceWithDriverResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchBindProductsIntoProjectRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_keys: List[str] = None,
        project_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_keys = product_keys
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_keys is not None:
            result['ProductKeys'] = self.product_keys
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKeys') is not None:
            self.product_keys = m.get('ProductKeys')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class BatchBindProductsIntoProjectResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: bool = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class BatchBindProductsIntoProjectResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BatchBindProductsIntoProjectResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchBindProductsIntoProjectResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchCheckDeviceNamesRequestDeviceNameList(TeaModel):
    def __init__(
        self,
        device_name: str = None,
        device_nickname: str = None,
    ):
        self.device_name = device_name
        self.device_nickname = device_nickname

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.device_nickname is not None:
            result['DeviceNickname'] = self.device_nickname
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('DeviceNickname') is not None:
            self.device_nickname = m.get('DeviceNickname')
        return self


class BatchCheckDeviceNamesRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
        device_name: List[str] = None,
        device_name_list: List[BatchCheckDeviceNamesRequestDeviceNameList] = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.device_name = device_name
        self.device_name_list = device_name_list

    def validate(self):
        if self.device_name_list:
            for k in self.device_name_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        result['DeviceNameList'] = []
        if self.device_name_list is not None:
            for k in self.device_name_list:
                result['DeviceNameList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        self.device_name_list = []
        if m.get('DeviceNameList') is not None:
            for k in m.get('DeviceNameList'):
                temp_model = BatchCheckDeviceNamesRequestDeviceNameList()
                self.device_name_list.append(temp_model.from_map(k))
        return self


class BatchCheckDeviceNamesResponseBodyDataInvalidDeviceNameList(TeaModel):
    def __init__(
        self,
        invalid_device_name: List[str] = None,
    ):
        self.invalid_device_name = invalid_device_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.invalid_device_name is not None:
            result['InvalidDeviceName'] = self.invalid_device_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InvalidDeviceName') is not None:
            self.invalid_device_name = m.get('InvalidDeviceName')
        return self


class BatchCheckDeviceNamesResponseBodyDataInvalidDeviceNicknameList(TeaModel):
    def __init__(
        self,
        invalid_device_nickname: List[str] = None,
    ):
        self.invalid_device_nickname = invalid_device_nickname

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.invalid_device_nickname is not None:
            result['InvalidDeviceNickname'] = self.invalid_device_nickname
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InvalidDeviceNickname') is not None:
            self.invalid_device_nickname = m.get('InvalidDeviceNickname')
        return self


class BatchCheckDeviceNamesResponseBodyData(TeaModel):
    def __init__(
        self,
        apply_id: int = None,
        invalid_device_name_list: BatchCheckDeviceNamesResponseBodyDataInvalidDeviceNameList = None,
        invalid_device_nickname_list: BatchCheckDeviceNamesResponseBodyDataInvalidDeviceNicknameList = None,
    ):
        self.apply_id = apply_id
        self.invalid_device_name_list = invalid_device_name_list
        self.invalid_device_nickname_list = invalid_device_nickname_list

    def validate(self):
        if self.invalid_device_name_list:
            self.invalid_device_name_list.validate()
        if self.invalid_device_nickname_list:
            self.invalid_device_nickname_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_id is not None:
            result['ApplyId'] = self.apply_id
        if self.invalid_device_name_list is not None:
            result['InvalidDeviceNameList'] = self.invalid_device_name_list.to_map()
        if self.invalid_device_nickname_list is not None:
            result['InvalidDeviceNicknameList'] = self.invalid_device_nickname_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplyId') is not None:
            self.apply_id = m.get('ApplyId')
        if m.get('InvalidDeviceNameList') is not None:
            temp_model = BatchCheckDeviceNamesResponseBodyDataInvalidDeviceNameList()
            self.invalid_device_name_list = temp_model.from_map(m['InvalidDeviceNameList'])
        if m.get('InvalidDeviceNicknameList') is not None:
            temp_model = BatchCheckDeviceNamesResponseBodyDataInvalidDeviceNicknameList()
            self.invalid_device_nickname_list = temp_model.from_map(m['InvalidDeviceNicknameList'])
        return self


class BatchCheckDeviceNamesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: BatchCheckDeviceNamesResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = BatchCheckDeviceNamesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class BatchCheckDeviceNamesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BatchCheckDeviceNamesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchCheckDeviceNamesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchClearEdgeInstanceDeviceConfigRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
        iot_ids: List[str] = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.iot_ids = iot_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        return self


class BatchClearEdgeInstanceDeviceConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class BatchClearEdgeInstanceDeviceConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BatchClearEdgeInstanceDeviceConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchClearEdgeInstanceDeviceConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchDeleteDeviceGroupRelationsRequestDevice(TeaModel):
    def __init__(
        self,
        product_key: str = None,
        device_name: str = None,
    ):
        self.product_key = product_key
        self.device_name = device_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        return self


class BatchDeleteDeviceGroupRelationsRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        group_id: str = None,
        device: List[BatchDeleteDeviceGroupRelationsRequestDevice] = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.group_id = group_id
        self.device = device

    def validate(self):
        if self.device:
            for k in self.device:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        result['Device'] = []
        if self.device is not None:
            for k in self.device:
                result['Device'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        self.device = []
        if m.get('Device') is not None:
            for k in m.get('Device'):
                temp_model = BatchDeleteDeviceGroupRelationsRequestDevice()
                self.device.append(temp_model.from_map(k))
        return self


class BatchDeleteDeviceGroupRelationsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        valid_device_count: int = None,
        already_related_group_device_count: int = None,
        success_device_count: int = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.valid_device_count = valid_device_count
        self.already_related_group_device_count = already_related_group_device_count
        self.success_device_count = success_device_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.valid_device_count is not None:
            result['ValidDeviceCount'] = self.valid_device_count
        if self.already_related_group_device_count is not None:
            result['AlreadyRelatedGroupDeviceCount'] = self.already_related_group_device_count
        if self.success_device_count is not None:
            result['SuccessDeviceCount'] = self.success_device_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ValidDeviceCount') is not None:
            self.valid_device_count = m.get('ValidDeviceCount')
        if m.get('AlreadyRelatedGroupDeviceCount') is not None:
            self.already_related_group_device_count = m.get('AlreadyRelatedGroupDeviceCount')
        if m.get('SuccessDeviceCount') is not None:
            self.success_device_count = m.get('SuccessDeviceCount')
        return self


class BatchDeleteDeviceGroupRelationsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BatchDeleteDeviceGroupRelationsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchDeleteDeviceGroupRelationsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchDeleteEdgeInstanceChannelRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
        driver_id: str = None,
        channel_ids: List[str] = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.driver_id = driver_id
        self.channel_ids = channel_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.channel_ids is not None:
            result['ChannelIds'] = self.channel_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('ChannelIds') is not None:
            self.channel_ids = m.get('ChannelIds')
        return self


class BatchDeleteEdgeInstanceChannelResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class BatchDeleteEdgeInstanceChannelResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BatchDeleteEdgeInstanceChannelResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchDeleteEdgeInstanceChannelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchGetDeviceBindStatusRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        iot_ids: List[str] = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.iot_ids = iot_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        return self


class BatchGetDeviceBindStatusResponseBodyData(TeaModel):
    def __init__(
        self,
        iot_id: str = None,
        bind_status: int = None,
    ):
        self.iot_id = iot_id
        self.bind_status = bind_status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.bind_status is not None:
            result['BindStatus'] = self.bind_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('BindStatus') is not None:
            self.bind_status = m.get('BindStatus')
        return self


class BatchGetDeviceBindStatusResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: List[BatchGetDeviceBindStatusResponseBodyData] = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = BatchGetDeviceBindStatusResponseBodyData()
                self.data.append(temp_model.from_map(k))
        return self


class BatchGetDeviceBindStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BatchGetDeviceBindStatusResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchGetDeviceBindStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchGetDeviceStateRequest(TeaModel):
    def __init__(
        self,
        device_name: List[str] = None,
        iot_instance_id: str = None,
        product_key: str = None,
        iot_id: List[str] = None,
    ):
        self.device_name = device_name
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.iot_id = iot_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class BatchGetDeviceStateResponseBodyDeviceStatusListDeviceStatus(TeaModel):
    def __init__(
        self,
        device_id: str = None,
        device_name: str = None,
        status: str = None,
        as_address: str = None,
        last_online_time: str = None,
        iot_id: str = None,
    ):
        self.device_id = device_id
        self.device_name = device_name
        self.status = status
        self.as_address = as_address
        self.last_online_time = last_online_time
        self.iot_id = iot_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.status is not None:
            result['Status'] = self.status
        if self.as_address is not None:
            result['AsAddress'] = self.as_address
        if self.last_online_time is not None:
            result['LastOnlineTime'] = self.last_online_time
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('AsAddress') is not None:
            self.as_address = m.get('AsAddress')
        if m.get('LastOnlineTime') is not None:
            self.last_online_time = m.get('LastOnlineTime')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class BatchGetDeviceStateResponseBodyDeviceStatusList(TeaModel):
    def __init__(
        self,
        device_status: List[BatchGetDeviceStateResponseBodyDeviceStatusListDeviceStatus] = None,
    ):
        self.device_status = device_status

    def validate(self):
        if self.device_status:
            for k in self.device_status:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DeviceStatus'] = []
        if self.device_status is not None:
            for k in self.device_status:
                result['DeviceStatus'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.device_status = []
        if m.get('DeviceStatus') is not None:
            for k in m.get('DeviceStatus'):
                temp_model = BatchGetDeviceStateResponseBodyDeviceStatusListDeviceStatus()
                self.device_status.append(temp_model.from_map(k))
        return self


class BatchGetDeviceStateResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        device_status_list: BatchGetDeviceStateResponseBodyDeviceStatusList = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.device_status_list = device_status_list

    def validate(self):
        if self.device_status_list:
            self.device_status_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.device_status_list is not None:
            result['DeviceStatusList'] = self.device_status_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('DeviceStatusList') is not None:
            temp_model = BatchGetDeviceStateResponseBodyDeviceStatusList()
            self.device_status_list = temp_model.from_map(m['DeviceStatusList'])
        return self


class BatchGetDeviceStateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BatchGetDeviceStateResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchGetDeviceStateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchGetEdgeDriverRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        driver_ids: List[str] = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.driver_ids = driver_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.driver_ids is not None:
            result['DriverIds'] = self.driver_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('DriverIds') is not None:
            self.driver_ids = m.get('DriverIds')
        return self


class BatchGetEdgeDriverResponseBodyDriverList(TeaModel):
    def __init__(
        self,
        driver_id: str = None,
        driver_name: str = None,
        driver_protocol: str = None,
        runtime: str = None,
        cpu_arch: str = None,
        type: int = None,
        is_built_in: bool = None,
        gmt_create_timestamp: int = None,
        gmt_modified_timestamp: int = None,
    ):
        self.driver_id = driver_id
        self.driver_name = driver_name
        self.driver_protocol = driver_protocol
        self.runtime = runtime
        self.cpu_arch = cpu_arch
        self.type = type
        self.is_built_in = is_built_in
        self.gmt_create_timestamp = gmt_create_timestamp
        self.gmt_modified_timestamp = gmt_modified_timestamp

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.driver_name is not None:
            result['DriverName'] = self.driver_name
        if self.driver_protocol is not None:
            result['DriverProtocol'] = self.driver_protocol
        if self.runtime is not None:
            result['Runtime'] = self.runtime
        if self.cpu_arch is not None:
            result['CpuArch'] = self.cpu_arch
        if self.type is not None:
            result['Type'] = self.type
        if self.is_built_in is not None:
            result['IsBuiltIn'] = self.is_built_in
        if self.gmt_create_timestamp is not None:
            result['GmtCreateTimestamp'] = self.gmt_create_timestamp
        if self.gmt_modified_timestamp is not None:
            result['GmtModifiedTimestamp'] = self.gmt_modified_timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('DriverName') is not None:
            self.driver_name = m.get('DriverName')
        if m.get('DriverProtocol') is not None:
            self.driver_protocol = m.get('DriverProtocol')
        if m.get('Runtime') is not None:
            self.runtime = m.get('Runtime')
        if m.get('CpuArch') is not None:
            self.cpu_arch = m.get('CpuArch')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('IsBuiltIn') is not None:
            self.is_built_in = m.get('IsBuiltIn')
        if m.get('GmtCreateTimestamp') is not None:
            self.gmt_create_timestamp = m.get('GmtCreateTimestamp')
        if m.get('GmtModifiedTimestamp') is not None:
            self.gmt_modified_timestamp = m.get('GmtModifiedTimestamp')
        return self


class BatchGetEdgeDriverResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        driver_list: List[BatchGetEdgeDriverResponseBodyDriverList] = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.driver_list = driver_list

    def validate(self):
        if self.driver_list:
            for k in self.driver_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        result['DriverList'] = []
        if self.driver_list is not None:
            for k in self.driver_list:
                result['DriverList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        self.driver_list = []
        if m.get('DriverList') is not None:
            for k in m.get('DriverList'):
                temp_model = BatchGetEdgeDriverResponseBodyDriverList()
                self.driver_list.append(temp_model.from_map(k))
        return self


class BatchGetEdgeDriverResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BatchGetEdgeDriverResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchGetEdgeDriverResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchGetEdgeInstanceChannelRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
        driver_id: str = None,
        channel_ids: List[str] = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.driver_id = driver_id
        self.channel_ids = channel_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.channel_ids is not None:
            result['ChannelIds'] = self.channel_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('ChannelIds') is not None:
            self.channel_ids = m.get('ChannelIds')
        return self


class BatchGetEdgeInstanceChannelResponseBodyDataChannelConfigListConfig(TeaModel):
    def __init__(
        self,
        config_id: str = None,
        format: str = None,
        content: str = None,
        key: str = None,
    ):
        self.config_id = config_id
        self.format = format
        self.content = content
        self.key = key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_id is not None:
            result['ConfigId'] = self.config_id
        if self.format is not None:
            result['Format'] = self.format
        if self.content is not None:
            result['Content'] = self.content
        if self.key is not None:
            result['Key'] = self.key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigId') is not None:
            self.config_id = m.get('ConfigId')
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        return self


class BatchGetEdgeInstanceChannelResponseBodyDataChannelConfigList(TeaModel):
    def __init__(
        self,
        config: List[BatchGetEdgeInstanceChannelResponseBodyDataChannelConfigListConfig] = None,
    ):
        self.config = config

    def validate(self):
        if self.config:
            for k in self.config:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Config'] = []
        if self.config is not None:
            for k in self.config:
                result['Config'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.config = []
        if m.get('Config') is not None:
            for k in m.get('Config'):
                temp_model = BatchGetEdgeInstanceChannelResponseBodyDataChannelConfigListConfig()
                self.config.append(temp_model.from_map(k))
        return self


class BatchGetEdgeInstanceChannelResponseBodyDataChannel(TeaModel):
    def __init__(
        self,
        channel_id: str = None,
        channel_name: str = None,
        config_list: BatchGetEdgeInstanceChannelResponseBodyDataChannelConfigList = None,
    ):
        self.channel_id = channel_id
        self.channel_name = channel_name
        self.config_list = config_list

    def validate(self):
        if self.config_list:
            self.config_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.channel_name is not None:
            result['ChannelName'] = self.channel_name
        if self.config_list is not None:
            result['ConfigList'] = self.config_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('ChannelName') is not None:
            self.channel_name = m.get('ChannelName')
        if m.get('ConfigList') is not None:
            temp_model = BatchGetEdgeInstanceChannelResponseBodyDataChannelConfigList()
            self.config_list = temp_model.from_map(m['ConfigList'])
        return self


class BatchGetEdgeInstanceChannelResponseBodyData(TeaModel):
    def __init__(
        self,
        channel: List[BatchGetEdgeInstanceChannelResponseBodyDataChannel] = None,
    ):
        self.channel = channel

    def validate(self):
        if self.channel:
            for k in self.channel:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Channel'] = []
        if self.channel is not None:
            for k in self.channel:
                result['Channel'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.channel = []
        if m.get('Channel') is not None:
            for k in m.get('Channel'):
                temp_model = BatchGetEdgeInstanceChannelResponseBodyDataChannel()
                self.channel.append(temp_model.from_map(k))
        return self


class BatchGetEdgeInstanceChannelResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: BatchGetEdgeInstanceChannelResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = BatchGetEdgeInstanceChannelResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class BatchGetEdgeInstanceChannelResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BatchGetEdgeInstanceChannelResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchGetEdgeInstanceChannelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchGetEdgeInstanceDeviceChannelRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
        driver_id: str = None,
        iot_ids: List[str] = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.driver_id = driver_id
        self.iot_ids = iot_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        return self


class BatchGetEdgeInstanceDeviceChannelResponseBodyDeviceChannelList(TeaModel):
    def __init__(
        self,
        channel_id: str = None,
        channel_name: str = None,
        iot_id: str = None,
    ):
        self.channel_id = channel_id
        self.channel_name = channel_name
        self.iot_id = iot_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.channel_name is not None:
            result['ChannelName'] = self.channel_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('ChannelName') is not None:
            self.channel_name = m.get('ChannelName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class BatchGetEdgeInstanceDeviceChannelResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        device_channel_list: List[BatchGetEdgeInstanceDeviceChannelResponseBodyDeviceChannelList] = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.device_channel_list = device_channel_list

    def validate(self):
        if self.device_channel_list:
            for k in self.device_channel_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        result['DeviceChannelList'] = []
        if self.device_channel_list is not None:
            for k in self.device_channel_list:
                result['DeviceChannelList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        self.device_channel_list = []
        if m.get('DeviceChannelList') is not None:
            for k in m.get('DeviceChannelList'):
                temp_model = BatchGetEdgeInstanceDeviceChannelResponseBodyDeviceChannelList()
                self.device_channel_list.append(temp_model.from_map(k))
        return self


class BatchGetEdgeInstanceDeviceChannelResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BatchGetEdgeInstanceDeviceChannelResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchGetEdgeInstanceDeviceChannelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchGetEdgeInstanceDeviceConfigRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
        iot_ids: List[str] = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.iot_ids = iot_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        return self


class BatchGetEdgeInstanceDeviceConfigResponseBodyDeviceConfigListConfig(TeaModel):
    def __init__(
        self,
        format: str = None,
        content: str = None,
    ):
        self.format = format
        self.content = content

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.format is not None:
            result['Format'] = self.format
        if self.content is not None:
            result['Content'] = self.content
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        return self


class BatchGetEdgeInstanceDeviceConfigResponseBodyDeviceConfigList(TeaModel):
    def __init__(
        self,
        iot_id: str = None,
        config: BatchGetEdgeInstanceDeviceConfigResponseBodyDeviceConfigListConfig = None,
    ):
        self.iot_id = iot_id
        self.config = config

    def validate(self):
        if self.config:
            self.config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.config is not None:
            result['Config'] = self.config.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('Config') is not None:
            temp_model = BatchGetEdgeInstanceDeviceConfigResponseBodyDeviceConfigListConfig()
            self.config = temp_model.from_map(m['Config'])
        return self


class BatchGetEdgeInstanceDeviceConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        device_config_list: List[BatchGetEdgeInstanceDeviceConfigResponseBodyDeviceConfigList] = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.device_config_list = device_config_list

    def validate(self):
        if self.device_config_list:
            for k in self.device_config_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        result['DeviceConfigList'] = []
        if self.device_config_list is not None:
            for k in self.device_config_list:
                result['DeviceConfigList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        self.device_config_list = []
        if m.get('DeviceConfigList') is not None:
            for k in m.get('DeviceConfigList'):
                temp_model = BatchGetEdgeInstanceDeviceConfigResponseBodyDeviceConfigList()
                self.device_config_list.append(temp_model.from_map(k))
        return self


class BatchGetEdgeInstanceDeviceConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BatchGetEdgeInstanceDeviceConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchGetEdgeInstanceDeviceConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchGetEdgeInstanceDeviceDriverRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
        iot_ids: List[str] = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.iot_ids = iot_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        return self


class BatchGetEdgeInstanceDeviceDriverResponseBodyDeviceDriverList(TeaModel):
    def __init__(
        self,
        driver_id: str = None,
        iot_id: str = None,
    ):
        self.driver_id = driver_id
        self.iot_id = iot_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class BatchGetEdgeInstanceDeviceDriverResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        device_driver_list: List[BatchGetEdgeInstanceDeviceDriverResponseBodyDeviceDriverList] = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.device_driver_list = device_driver_list

    def validate(self):
        if self.device_driver_list:
            for k in self.device_driver_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        result['DeviceDriverList'] = []
        if self.device_driver_list is not None:
            for k in self.device_driver_list:
                result['DeviceDriverList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        self.device_driver_list = []
        if m.get('DeviceDriverList') is not None:
            for k in m.get('DeviceDriverList'):
                temp_model = BatchGetEdgeInstanceDeviceDriverResponseBodyDeviceDriverList()
                self.device_driver_list.append(temp_model.from_map(k))
        return self


class BatchGetEdgeInstanceDeviceDriverResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BatchGetEdgeInstanceDeviceDriverResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchGetEdgeInstanceDeviceDriverResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchGetEdgeInstanceDriverConfigsRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
        driver_ids: List[str] = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.driver_ids = driver_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.driver_ids is not None:
            result['DriverIds'] = self.driver_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DriverIds') is not None:
            self.driver_ids = m.get('DriverIds')
        return self


class BatchGetEdgeInstanceDriverConfigsResponseBodyDriverConfigListConfigList(TeaModel):
    def __init__(
        self,
        config_id: str = None,
        format: str = None,
        content: str = None,
        key: str = None,
    ):
        self.config_id = config_id
        self.format = format
        self.content = content
        self.key = key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_id is not None:
            result['ConfigId'] = self.config_id
        if self.format is not None:
            result['Format'] = self.format
        if self.content is not None:
            result['Content'] = self.content
        if self.key is not None:
            result['Key'] = self.key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigId') is not None:
            self.config_id = m.get('ConfigId')
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        return self


class BatchGetEdgeInstanceDriverConfigsResponseBodyDriverConfigList(TeaModel):
    def __init__(
        self,
        driver_id: str = None,
        config_list: List[BatchGetEdgeInstanceDriverConfigsResponseBodyDriverConfigListConfigList] = None,
    ):
        self.driver_id = driver_id
        self.config_list = config_list

    def validate(self):
        if self.config_list:
            for k in self.config_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        result['ConfigList'] = []
        if self.config_list is not None:
            for k in self.config_list:
                result['ConfigList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        self.config_list = []
        if m.get('ConfigList') is not None:
            for k in m.get('ConfigList'):
                temp_model = BatchGetEdgeInstanceDriverConfigsResponseBodyDriverConfigListConfigList()
                self.config_list.append(temp_model.from_map(k))
        return self


class BatchGetEdgeInstanceDriverConfigsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        driver_config_list: List[BatchGetEdgeInstanceDriverConfigsResponseBodyDriverConfigList] = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.driver_config_list = driver_config_list

    def validate(self):
        if self.driver_config_list:
            for k in self.driver_config_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        result['DriverConfigList'] = []
        if self.driver_config_list is not None:
            for k in self.driver_config_list:
                result['DriverConfigList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        self.driver_config_list = []
        if m.get('DriverConfigList') is not None:
            for k in m.get('DriverConfigList'):
                temp_model = BatchGetEdgeInstanceDriverConfigsResponseBodyDriverConfigList()
                self.driver_config_list.append(temp_model.from_map(k))
        return self


class BatchGetEdgeInstanceDriverConfigsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BatchGetEdgeInstanceDriverConfigsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchGetEdgeInstanceDriverConfigsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchPubRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        device_name: List[str] = None,
        product_key: str = None,
        qos: int = None,
        topic_short_name: str = None,
        message_content: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.device_name = device_name
        self.product_key = product_key
        self.qos = qos
        self.topic_short_name = topic_short_name
        self.message_content = message_content

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.qos is not None:
            result['Qos'] = self.qos
        if self.topic_short_name is not None:
            result['TopicShortName'] = self.topic_short_name
        if self.message_content is not None:
            result['MessageContent'] = self.message_content
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Qos') is not None:
            self.qos = m.get('Qos')
        if m.get('TopicShortName') is not None:
            self.topic_short_name = m.get('TopicShortName')
        if m.get('MessageContent') is not None:
            self.message_content = m.get('MessageContent')
        return self


class BatchPubResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class BatchPubResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BatchPubResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchPubResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchQueryDeviceDetailRequest(TeaModel):
    def __init__(
        self,
        device_name: List[str] = None,
        product_key: str = None,
        iot_instance_id: str = None,
    ):
        self.device_name = device_name
        self.product_key = product_key
        self.iot_instance_id = iot_instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class BatchQueryDeviceDetailResponseBodyDataData(TeaModel):
    def __init__(
        self,
        product_key: str = None,
        product_name: str = None,
        device_name: str = None,
        nickname: str = None,
        device_secret: str = None,
        iot_id: str = None,
        utc_create: str = None,
        gmt_create: str = None,
        utc_active: str = None,
        gmt_active: str = None,
        status: str = None,
        firmware_version: str = None,
        node_type: int = None,
        region: str = None,
    ):
        self.product_key = product_key
        self.product_name = product_name
        self.device_name = device_name
        self.nickname = nickname
        self.device_secret = device_secret
        self.iot_id = iot_id
        self.utc_create = utc_create
        self.gmt_create = gmt_create
        self.utc_active = utc_active
        self.gmt_active = gmt_active
        self.status = status
        self.firmware_version = firmware_version
        self.node_type = node_type
        self.region = region

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.nickname is not None:
            result['Nickname'] = self.nickname
        if self.device_secret is not None:
            result['DeviceSecret'] = self.device_secret
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.utc_active is not None:
            result['UtcActive'] = self.utc_active
        if self.gmt_active is not None:
            result['GmtActive'] = self.gmt_active
        if self.status is not None:
            result['Status'] = self.status
        if self.firmware_version is not None:
            result['FirmwareVersion'] = self.firmware_version
        if self.node_type is not None:
            result['NodeType'] = self.node_type
        if self.region is not None:
            result['Region'] = self.region
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('Nickname') is not None:
            self.nickname = m.get('Nickname')
        if m.get('DeviceSecret') is not None:
            self.device_secret = m.get('DeviceSecret')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('UtcActive') is not None:
            self.utc_active = m.get('UtcActive')
        if m.get('GmtActive') is not None:
            self.gmt_active = m.get('GmtActive')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('FirmwareVersion') is not None:
            self.firmware_version = m.get('FirmwareVersion')
        if m.get('NodeType') is not None:
            self.node_type = m.get('NodeType')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        return self


class BatchQueryDeviceDetailResponseBodyData(TeaModel):
    def __init__(
        self,
        data: List[BatchQueryDeviceDetailResponseBodyDataData] = None,
    ):
        self.data = data

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = BatchQueryDeviceDetailResponseBodyDataData()
                self.data.append(temp_model.from_map(k))
        return self


class BatchQueryDeviceDetailResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: BatchQueryDeviceDetailResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = BatchQueryDeviceDetailResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class BatchQueryDeviceDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BatchQueryDeviceDetailResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchQueryDeviceDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchRegisterDeviceRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
        count: int = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.count = count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class BatchRegisterDeviceResponseBodyData(TeaModel):
    def __init__(
        self,
        apply_id: int = None,
    ):
        self.apply_id = apply_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_id is not None:
            result['ApplyId'] = self.apply_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplyId') is not None:
            self.apply_id = m.get('ApplyId')
        return self


class BatchRegisterDeviceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: BatchRegisterDeviceResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = BatchRegisterDeviceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class BatchRegisterDeviceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BatchRegisterDeviceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchRegisterDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchRegisterDeviceWithApplyIdRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
        apply_id: int = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.apply_id = apply_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.apply_id is not None:
            result['ApplyId'] = self.apply_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ApplyId') is not None:
            self.apply_id = m.get('ApplyId')
        return self


class BatchRegisterDeviceWithApplyIdResponseBodyData(TeaModel):
    def __init__(
        self,
        apply_id: int = None,
    ):
        self.apply_id = apply_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_id is not None:
            result['ApplyId'] = self.apply_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplyId') is not None:
            self.apply_id = m.get('ApplyId')
        return self


class BatchRegisterDeviceWithApplyIdResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: BatchRegisterDeviceWithApplyIdResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = BatchRegisterDeviceWithApplyIdResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class BatchRegisterDeviceWithApplyIdResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BatchRegisterDeviceWithApplyIdResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchRegisterDeviceWithApplyIdResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchSetEdgeInstanceDeviceChannelRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
        driver_id: str = None,
        channel_id: str = None,
        iot_ids: List[str] = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.driver_id = driver_id
        self.channel_id = channel_id
        self.iot_ids = iot_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        return self


class BatchSetEdgeInstanceDeviceChannelResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class BatchSetEdgeInstanceDeviceChannelResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BatchSetEdgeInstanceDeviceChannelResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchSetEdgeInstanceDeviceChannelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchSetEdgeInstanceDeviceConfigRequestDeviceConfigs(TeaModel):
    def __init__(
        self,
        iot_id: str = None,
        content: str = None,
    ):
        self.iot_id = iot_id
        self.content = content

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.content is not None:
            result['Content'] = self.content
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        return self


class BatchSetEdgeInstanceDeviceConfigRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
        device_configs: List[BatchSetEdgeInstanceDeviceConfigRequestDeviceConfigs] = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.device_configs = device_configs

    def validate(self):
        if self.device_configs:
            for k in self.device_configs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        result['DeviceConfigs'] = []
        if self.device_configs is not None:
            for k in self.device_configs:
                result['DeviceConfigs'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        self.device_configs = []
        if m.get('DeviceConfigs') is not None:
            for k in m.get('DeviceConfigs'):
                temp_model = BatchSetEdgeInstanceDeviceConfigRequestDeviceConfigs()
                self.device_configs.append(temp_model.from_map(k))
        return self


class BatchSetEdgeInstanceDeviceConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class BatchSetEdgeInstanceDeviceConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BatchSetEdgeInstanceDeviceConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchSetEdgeInstanceDeviceConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchUnbindDeviceFromEdgeInstanceRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
        iot_ids: List[str] = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.iot_ids = iot_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        return self


class BatchUnbindDeviceFromEdgeInstanceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class BatchUnbindDeviceFromEdgeInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BatchUnbindDeviceFromEdgeInstanceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchUnbindDeviceFromEdgeInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchUnbindProjectDevicesRequestDevices(TeaModel):
    def __init__(
        self,
        product_key: str = None,
        device_name: str = None,
    ):
        self.product_key = product_key
        self.device_name = device_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        return self


class BatchUnbindProjectDevicesRequest(TeaModel):
    def __init__(
        self,
        devices: List[BatchUnbindProjectDevicesRequestDevices] = None,
        iot_instance_id: str = None,
        project_id: str = None,
    ):
        self.devices = devices
        self.iot_instance_id = iot_instance_id
        self.project_id = project_id

    def validate(self):
        if self.devices:
            for k in self.devices:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Devices'] = []
        if self.devices is not None:
            for k in self.devices:
                result['Devices'].append(k.to_map() if k else None)
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.devices = []
        if m.get('Devices') is not None:
            for k in m.get('Devices'):
                temp_model = BatchUnbindProjectDevicesRequestDevices()
                self.devices.append(temp_model.from_map(k))
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class BatchUnbindProjectDevicesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: bool = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class BatchUnbindProjectDevicesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BatchUnbindProjectDevicesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchUnbindProjectDevicesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchUnbindProjectProductsRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_keys: List[str] = None,
        project_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_keys = product_keys
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_keys is not None:
            result['ProductKeys'] = self.product_keys
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKeys') is not None:
            self.product_keys = m.get('ProductKeys')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class BatchUnbindProjectProductsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: bool = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class BatchUnbindProjectProductsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BatchUnbindProjectProductsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchUnbindProjectProductsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchUpdateDeviceNicknameRequestDeviceNicknameInfo(TeaModel):
    def __init__(
        self,
        product_key: str = None,
        device_name: str = None,
        nickname: str = None,
        iot_id: str = None,
    ):
        self.product_key = product_key
        self.device_name = device_name
        self.nickname = nickname
        self.iot_id = iot_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.nickname is not None:
            result['Nickname'] = self.nickname
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('Nickname') is not None:
            self.nickname = m.get('Nickname')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class BatchUpdateDeviceNicknameRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        device_nickname_info: List[BatchUpdateDeviceNicknameRequestDeviceNicknameInfo] = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.device_nickname_info = device_nickname_info

    def validate(self):
        if self.device_nickname_info:
            for k in self.device_nickname_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        result['DeviceNicknameInfo'] = []
        if self.device_nickname_info is not None:
            for k in self.device_nickname_info:
                result['DeviceNicknameInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        self.device_nickname_info = []
        if m.get('DeviceNicknameInfo') is not None:
            for k in m.get('DeviceNicknameInfo'):
                temp_model = BatchUpdateDeviceNicknameRequestDeviceNicknameInfo()
                self.device_nickname_info.append(temp_model.from_map(k))
        return self


class BatchUpdateDeviceNicknameResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class BatchUpdateDeviceNicknameResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BatchUpdateDeviceNicknameResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchUpdateDeviceNicknameResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BindApplicationToEdgeInstanceRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
        application_id: str = None,
        application_version: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.application_id = application_id
        self.application_version = application_version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.application_version is not None:
            result['ApplicationVersion'] = self.application_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('ApplicationVersion') is not None:
            self.application_version = m.get('ApplicationVersion')
        return self


class BindApplicationToEdgeInstanceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class BindApplicationToEdgeInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BindApplicationToEdgeInstanceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BindApplicationToEdgeInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BindDriverToEdgeInstanceRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
        driver_id: str = None,
        driver_version: str = None,
        order_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.driver_id = driver_id
        self.driver_version = driver_version
        self.order_id = order_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.driver_version is not None:
            result['DriverVersion'] = self.driver_version
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('DriverVersion') is not None:
            self.driver_version = m.get('DriverVersion')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        return self


class BindDriverToEdgeInstanceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class BindDriverToEdgeInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BindDriverToEdgeInstanceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BindDriverToEdgeInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BindGatewayToEdgeInstanceRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
        product_key: str = None,
        device_name: str = None,
        iot_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.product_key = product_key
        self.device_name = device_name
        self.iot_id = iot_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class BindGatewayToEdgeInstanceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class BindGatewayToEdgeInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BindGatewayToEdgeInstanceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BindGatewayToEdgeInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BindRoleToEdgeInstanceRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
        role_arn: str = None,
        role_name: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.role_arn = role_arn
        self.role_name = role_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.role_arn is not None:
            result['RoleArn'] = self.role_arn
        if self.role_name is not None:
            result['RoleName'] = self.role_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RoleArn') is not None:
            self.role_arn = m.get('RoleArn')
        if m.get('RoleName') is not None:
            self.role_name = m.get('RoleName')
        return self


class BindRoleToEdgeInstanceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class BindRoleToEdgeInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BindRoleToEdgeInstanceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BindRoleToEdgeInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BindSceneRuleToEdgeInstanceRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
        rule_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.rule_id = rule_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class BindSceneRuleToEdgeInstanceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_message: str = None,
        code: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_message = error_message
        self.code = code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        return self


class BindSceneRuleToEdgeInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BindSceneRuleToEdgeInstanceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BindSceneRuleToEdgeInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelJobRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        job_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.job_id = job_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class CancelJobResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class CancelJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CancelJobResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CancelJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelOTAStrategyByJobRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        job_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.job_id = job_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class CancelOTAStrategyByJobResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class CancelOTAStrategyByJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CancelOTAStrategyByJobResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CancelOTAStrategyByJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelOTATaskByDeviceRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        firmware_id: str = None,
        product_key: str = None,
        device_name: List[str] = None,
        job_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.firmware_id = firmware_id
        self.product_key = product_key
        self.device_name = device_name
        self.job_id = job_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class CancelOTATaskByDeviceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class CancelOTATaskByDeviceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CancelOTATaskByDeviceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CancelOTATaskByDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelOTATaskByJobRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        job_id: str = None,
        cancel_scheduled_task: bool = None,
        cancel_queued_task: bool = None,
        cancel_in_progress_task: bool = None,
        cancel_notified_task: bool = None,
        cancel_unconfirmed_task: bool = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.job_id = job_id
        self.cancel_scheduled_task = cancel_scheduled_task
        self.cancel_queued_task = cancel_queued_task
        self.cancel_in_progress_task = cancel_in_progress_task
        self.cancel_notified_task = cancel_notified_task
        self.cancel_unconfirmed_task = cancel_unconfirmed_task

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.cancel_scheduled_task is not None:
            result['CancelScheduledTask'] = self.cancel_scheduled_task
        if self.cancel_queued_task is not None:
            result['CancelQueuedTask'] = self.cancel_queued_task
        if self.cancel_in_progress_task is not None:
            result['CancelInProgressTask'] = self.cancel_in_progress_task
        if self.cancel_notified_task is not None:
            result['CancelNotifiedTask'] = self.cancel_notified_task
        if self.cancel_unconfirmed_task is not None:
            result['CancelUnconfirmedTask'] = self.cancel_unconfirmed_task
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('CancelScheduledTask') is not None:
            self.cancel_scheduled_task = m.get('CancelScheduledTask')
        if m.get('CancelQueuedTask') is not None:
            self.cancel_queued_task = m.get('CancelQueuedTask')
        if m.get('CancelInProgressTask') is not None:
            self.cancel_in_progress_task = m.get('CancelInProgressTask')
        if m.get('CancelNotifiedTask') is not None:
            self.cancel_notified_task = m.get('CancelNotifiedTask')
        if m.get('CancelUnconfirmedTask') is not None:
            self.cancel_unconfirmed_task = m.get('CancelUnconfirmedTask')
        return self


class CancelOTATaskByJobResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class CancelOTATaskByJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CancelOTATaskByJobResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CancelOTATaskByJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelReleaseProductRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class CancelReleaseProductResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_message: str = None,
        code: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_message = error_message
        self.code = code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        return self


class CancelReleaseProductResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CancelReleaseProductResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CancelReleaseProductResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ClearEdgeInstanceDriverConfigsRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
        driver_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.driver_id = driver_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        return self


class ClearEdgeInstanceDriverConfigsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class ClearEdgeInstanceDriverConfigsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ClearEdgeInstanceDriverConfigsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ClearEdgeInstanceDriverConfigsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CloseEdgeInstanceDeploymentRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class CloseEdgeInstanceDeploymentResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class CloseEdgeInstanceDeploymentResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CloseEdgeInstanceDeploymentResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CloseEdgeInstanceDeploymentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ConfirmOTATaskRequest(TeaModel):
    def __init__(
        self,
        task_id: List[str] = None,
        iot_instance_id: str = None,
    ):
        self.task_id = task_id
        self.iot_instance_id = iot_instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class ConfirmOTATaskResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class ConfirmOTATaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ConfirmOTATaskResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ConfirmOTATaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CopyThingModelRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        resource_group_id: str = None,
        source_product_key: str = None,
        target_product_key: str = None,
        source_model_version: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.resource_group_id = resource_group_id
        self.source_product_key = source_product_key
        self.target_product_key = target_product_key
        self.source_model_version = source_model_version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.source_product_key is not None:
            result['SourceProductKey'] = self.source_product_key
        if self.target_product_key is not None:
            result['TargetProductKey'] = self.target_product_key
        if self.source_model_version is not None:
            result['SourceModelVersion'] = self.source_model_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('SourceProductKey') is not None:
            self.source_product_key = m.get('SourceProductKey')
        if m.get('TargetProductKey') is not None:
            self.target_product_key = m.get('TargetProductKey')
        if m.get('SourceModelVersion') is not None:
            self.source_model_version = m.get('SourceModelVersion')
        return self


class CopyThingModelResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class CopyThingModelResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CopyThingModelResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CopyThingModelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateConsumerGroupRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        group_name: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.group_name = group_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        return self


class CreateConsumerGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_message: str = None,
        group_id: str = None,
        code: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_message = error_message
        self.group_id = group_id
        self.code = code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.code is not None:
            result['Code'] = self.code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        return self


class CreateConsumerGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateConsumerGroupResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateConsumerGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateConsumerGroupSubscribeRelationRequest(TeaModel):
    def __init__(
        self,
        consumer_group_id: str = None,
        iot_instance_id: str = None,
        product_key: str = None,
    ):
        self.consumer_group_id = consumer_group_id
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.consumer_group_id is not None:
            result['ConsumerGroupId'] = self.consumer_group_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConsumerGroupId') is not None:
            self.consumer_group_id = m.get('ConsumerGroupId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class CreateConsumerGroupSubscribeRelationResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class CreateConsumerGroupSubscribeRelationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateConsumerGroupSubscribeRelationResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateConsumerGroupSubscribeRelationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDataAPIServiceRequestRequestParam(TeaModel):
    def __init__(
        self,
        name: str = None,
        type: str = None,
        desc: str = None,
        example: str = None,
        required: bool = None,
    ):
        self.name = name
        self.type = type
        self.desc = desc
        self.example = example
        self.required = required

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.example is not None:
            result['Example'] = self.example
        if self.required is not None:
            result['Required'] = self.required
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('Example') is not None:
            self.example = m.get('Example')
        if m.get('Required') is not None:
            self.required = m.get('Required')
        return self


class CreateDataAPIServiceRequestResponseParam(TeaModel):
    def __init__(
        self,
        name: str = None,
        type: str = None,
        desc: str = None,
        example: str = None,
        required: bool = None,
    ):
        self.name = name
        self.type = type
        self.desc = desc
        self.example = example
        self.required = required

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.example is not None:
            result['Example'] = self.example
        if self.required is not None:
            result['Required'] = self.required
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('Example') is not None:
            self.example = m.get('Example')
        if m.get('Required') is not None:
            self.required = m.get('Required')
        return self


class CreateDataAPIServiceRequest(TeaModel):
    def __init__(
        self,
        display_name: str = None,
        origin_sql: str = None,
        request_param: List[CreateDataAPIServiceRequestRequestParam] = None,
        desc: str = None,
        response_param: List[CreateDataAPIServiceRequestResponseParam] = None,
        template_sql: str = None,
        api_path: str = None,
        iot_instance_id: str = None,
    ):
        self.display_name = display_name
        self.origin_sql = origin_sql
        self.request_param = request_param
        self.desc = desc
        self.response_param = response_param
        self.template_sql = template_sql
        self.api_path = api_path
        self.iot_instance_id = iot_instance_id

    def validate(self):
        if self.request_param:
            for k in self.request_param:
                if k:
                    k.validate()
        if self.response_param:
            for k in self.response_param:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.origin_sql is not None:
            result['OriginSql'] = self.origin_sql
        result['RequestParam'] = []
        if self.request_param is not None:
            for k in self.request_param:
                result['RequestParam'].append(k.to_map() if k else None)
        if self.desc is not None:
            result['Desc'] = self.desc
        result['ResponseParam'] = []
        if self.response_param is not None:
            for k in self.response_param:
                result['ResponseParam'].append(k.to_map() if k else None)
        if self.template_sql is not None:
            result['TemplateSql'] = self.template_sql
        if self.api_path is not None:
            result['ApiPath'] = self.api_path
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('OriginSql') is not None:
            self.origin_sql = m.get('OriginSql')
        self.request_param = []
        if m.get('RequestParam') is not None:
            for k in m.get('RequestParam'):
                temp_model = CreateDataAPIServiceRequestRequestParam()
                self.request_param.append(temp_model.from_map(k))
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        self.response_param = []
        if m.get('ResponseParam') is not None:
            for k in m.get('ResponseParam'):
                temp_model = CreateDataAPIServiceRequestResponseParam()
                self.response_param.append(temp_model.from_map(k))
        if m.get('TemplateSql') is not None:
            self.template_sql = m.get('TemplateSql')
        if m.get('ApiPath') is not None:
            self.api_path = m.get('ApiPath')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class CreateDataAPIServiceResponseBodyData(TeaModel):
    def __init__(
        self,
        api_srn: str = None,
        create_time: int = None,
        last_update_time: int = None,
    ):
        self.api_srn = api_srn
        self.create_time = create_time
        self.last_update_time = last_update_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_srn is not None:
            result['ApiSrn'] = self.api_srn
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.last_update_time is not None:
            result['LastUpdateTime'] = self.last_update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiSrn') is not None:
            self.api_srn = m.get('ApiSrn')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('LastUpdateTime') is not None:
            self.last_update_time = m.get('LastUpdateTime')
        return self


class CreateDataAPIServiceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: CreateDataAPIServiceResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = CreateDataAPIServiceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CreateDataAPIServiceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateDataAPIServiceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDataAPIServiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDeviceDistributeJobRequestTargetInstanceConfig(TeaModel):
    def __init__(
        self,
        target_instance_id: str = None,
    ):
        self.target_instance_id = target_instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.target_instance_id is not None:
            result['TargetInstanceId'] = self.target_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TargetInstanceId') is not None:
            self.target_instance_id = m.get('TargetInstanceId')
        return self


class CreateDeviceDistributeJobRequest(TeaModel):
    def __init__(
        self,
        device_name: List[str] = None,
        source_instance_id: str = None,
        product_key: str = None,
        target_uid: str = None,
        target_aliyun_id: str = None,
        target_instance_config: List[CreateDeviceDistributeJobRequestTargetInstanceConfig] = None,
        strategy: int = None,
    ):
        self.device_name = device_name
        self.source_instance_id = source_instance_id
        self.product_key = product_key
        self.target_uid = target_uid
        self.target_aliyun_id = target_aliyun_id
        self.target_instance_config = target_instance_config
        self.strategy = strategy

    def validate(self):
        if self.target_instance_config:
            for k in self.target_instance_config:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.source_instance_id is not None:
            result['SourceInstanceId'] = self.source_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.target_uid is not None:
            result['TargetUid'] = self.target_uid
        if self.target_aliyun_id is not None:
            result['TargetAliyunId'] = self.target_aliyun_id
        result['TargetInstanceConfig'] = []
        if self.target_instance_config is not None:
            for k in self.target_instance_config:
                result['TargetInstanceConfig'].append(k.to_map() if k else None)
        if self.strategy is not None:
            result['Strategy'] = self.strategy
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('SourceInstanceId') is not None:
            self.source_instance_id = m.get('SourceInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('TargetUid') is not None:
            self.target_uid = m.get('TargetUid')
        if m.get('TargetAliyunId') is not None:
            self.target_aliyun_id = m.get('TargetAliyunId')
        self.target_instance_config = []
        if m.get('TargetInstanceConfig') is not None:
            for k in m.get('TargetInstanceConfig'):
                temp_model = CreateDeviceDistributeJobRequestTargetInstanceConfig()
                self.target_instance_config.append(temp_model.from_map(k))
        if m.get('Strategy') is not None:
            self.strategy = m.get('Strategy')
        return self


class CreateDeviceDistributeJobResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        job_id: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.job_id = job_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class CreateDeviceDistributeJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateDeviceDistributeJobResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDeviceDistributeJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDeviceGroupRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        super_group_id: str = None,
        group_desc: str = None,
        group_name: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.super_group_id = super_group_id
        self.group_desc = group_desc
        self.group_name = group_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.super_group_id is not None:
            result['SuperGroupId'] = self.super_group_id
        if self.group_desc is not None:
            result['GroupDesc'] = self.group_desc
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('SuperGroupId') is not None:
            self.super_group_id = m.get('SuperGroupId')
        if m.get('GroupDesc') is not None:
            self.group_desc = m.get('GroupDesc')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        return self


class CreateDeviceGroupResponseBodyData(TeaModel):
    def __init__(
        self,
        group_id: str = None,
        utc_create: str = None,
        group_name: str = None,
        group_desc: str = None,
    ):
        self.group_id = group_id
        self.utc_create = utc_create
        self.group_name = group_name
        self.group_desc = group_desc

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.group_desc is not None:
            result['GroupDesc'] = self.group_desc
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('GroupDesc') is not None:
            self.group_desc = m.get('GroupDesc')
        return self


class CreateDeviceGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: CreateDeviceGroupResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = CreateDeviceGroupResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CreateDeviceGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateDeviceGroupResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDeviceGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateEdgeDriverRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        driver_name: str = None,
        driver_protocol: str = None,
        runtime: str = None,
        cpu_arch: str = None,
        is_built_in: bool = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.driver_name = driver_name
        self.driver_protocol = driver_protocol
        self.runtime = runtime
        self.cpu_arch = cpu_arch
        self.is_built_in = is_built_in

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.driver_name is not None:
            result['DriverName'] = self.driver_name
        if self.driver_protocol is not None:
            result['DriverProtocol'] = self.driver_protocol
        if self.runtime is not None:
            result['Runtime'] = self.runtime
        if self.cpu_arch is not None:
            result['CpuArch'] = self.cpu_arch
        if self.is_built_in is not None:
            result['IsBuiltIn'] = self.is_built_in
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('DriverName') is not None:
            self.driver_name = m.get('DriverName')
        if m.get('DriverProtocol') is not None:
            self.driver_protocol = m.get('DriverProtocol')
        if m.get('Runtime') is not None:
            self.runtime = m.get('Runtime')
        if m.get('CpuArch') is not None:
            self.cpu_arch = m.get('CpuArch')
        if m.get('IsBuiltIn') is not None:
            self.is_built_in = m.get('IsBuiltIn')
        return self


class CreateEdgeDriverResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        driver_id: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.driver_id = driver_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        return self


class CreateEdgeDriverResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateEdgeDriverResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateEdgeDriverResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateEdgeDriverVersionRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        driver_id: str = None,
        driver_version: str = None,
        edge_version: str = None,
        description: str = None,
        source_config: str = None,
        driver_config: str = None,
        container_config: str = None,
        config_check_rule: str = None,
        argument: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.driver_id = driver_id
        self.driver_version = driver_version
        self.edge_version = edge_version
        self.description = description
        self.source_config = source_config
        self.driver_config = driver_config
        self.container_config = container_config
        self.config_check_rule = config_check_rule
        self.argument = argument

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.driver_version is not None:
            result['DriverVersion'] = self.driver_version
        if self.edge_version is not None:
            result['EdgeVersion'] = self.edge_version
        if self.description is not None:
            result['Description'] = self.description
        if self.source_config is not None:
            result['SourceConfig'] = self.source_config
        if self.driver_config is not None:
            result['DriverConfig'] = self.driver_config
        if self.container_config is not None:
            result['ContainerConfig'] = self.container_config
        if self.config_check_rule is not None:
            result['ConfigCheckRule'] = self.config_check_rule
        if self.argument is not None:
            result['Argument'] = self.argument
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('DriverVersion') is not None:
            self.driver_version = m.get('DriverVersion')
        if m.get('EdgeVersion') is not None:
            self.edge_version = m.get('EdgeVersion')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('SourceConfig') is not None:
            self.source_config = m.get('SourceConfig')
        if m.get('DriverConfig') is not None:
            self.driver_config = m.get('DriverConfig')
        if m.get('ContainerConfig') is not None:
            self.container_config = m.get('ContainerConfig')
        if m.get('ConfigCheckRule') is not None:
            self.config_check_rule = m.get('ConfigCheckRule')
        if m.get('Argument') is not None:
            self.argument = m.get('Argument')
        return self


class CreateEdgeDriverVersionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class CreateEdgeDriverVersionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateEdgeDriverVersionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateEdgeDriverVersionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateEdgeInstanceRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        name: str = None,
        tags: str = None,
        spec: int = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.name = name
        self.tags = tags
        self.spec = spec

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.spec is not None:
            result['Spec'] = self.spec
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('Spec') is not None:
            self.spec = m.get('Spec')
        return self


class CreateEdgeInstanceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_message: str = None,
        code: str = None,
        instance_id: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_message = error_message
        self.code = code
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class CreateEdgeInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateEdgeInstanceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateEdgeInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateEdgeInstanceChannelRequestConfigs(TeaModel):
    def __init__(
        self,
        format: str = None,
        content: str = None,
        key: str = None,
    ):
        self.format = format
        self.content = content
        self.key = key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.format is not None:
            result['Format'] = self.format
        if self.content is not None:
            result['Content'] = self.content
        if self.key is not None:
            result['Key'] = self.key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        return self


class CreateEdgeInstanceChannelRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
        driver_id: str = None,
        channel_name: str = None,
        configs: List[CreateEdgeInstanceChannelRequestConfigs] = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.driver_id = driver_id
        self.channel_name = channel_name
        self.configs = configs

    def validate(self):
        if self.configs:
            for k in self.configs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.channel_name is not None:
            result['ChannelName'] = self.channel_name
        result['Configs'] = []
        if self.configs is not None:
            for k in self.configs:
                result['Configs'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('ChannelName') is not None:
            self.channel_name = m.get('ChannelName')
        self.configs = []
        if m.get('Configs') is not None:
            for k in m.get('Configs'):
                temp_model = CreateEdgeInstanceChannelRequestConfigs()
                self.configs.append(temp_model.from_map(k))
        return self


class CreateEdgeInstanceChannelResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class CreateEdgeInstanceChannelResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateEdgeInstanceChannelResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateEdgeInstanceChannelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateEdgeInstanceDeploymentRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
        type: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateEdgeInstanceDeploymentResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        deployment_id: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.deployment_id = deployment_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.deployment_id is not None:
            result['DeploymentId'] = self.deployment_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('DeploymentId') is not None:
            self.deployment_id = m.get('DeploymentId')
        return self


class CreateEdgeInstanceDeploymentResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateEdgeInstanceDeploymentResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateEdgeInstanceDeploymentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateEdgeInstanceMessageRoutingRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
        name: str = None,
        topic_filter: str = None,
        source_type: str = None,
        source_data: str = None,
        target_type: str = None,
        target_data: str = None,
        target_iot_hub_qos: int = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.name = name
        self.topic_filter = topic_filter
        self.source_type = source_type
        self.source_data = source_data
        self.target_type = target_type
        self.target_data = target_data
        self.target_iot_hub_qos = target_iot_hub_qos

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.topic_filter is not None:
            result['TopicFilter'] = self.topic_filter
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.source_data is not None:
            result['SourceData'] = self.source_data
        if self.target_type is not None:
            result['TargetType'] = self.target_type
        if self.target_data is not None:
            result['TargetData'] = self.target_data
        if self.target_iot_hub_qos is not None:
            result['TargetIotHubQos'] = self.target_iot_hub_qos
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('TopicFilter') is not None:
            self.topic_filter = m.get('TopicFilter')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('SourceData') is not None:
            self.source_data = m.get('SourceData')
        if m.get('TargetType') is not None:
            self.target_type = m.get('TargetType')
        if m.get('TargetData') is not None:
            self.target_data = m.get('TargetData')
        if m.get('TargetIotHubQos') is not None:
            self.target_iot_hub_qos = m.get('TargetIotHubQos')
        return self


class CreateEdgeInstanceMessageRoutingResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        route_id: int = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.route_id = route_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.route_id is not None:
            result['RouteId'] = self.route_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RouteId') is not None:
            self.route_id = m.get('RouteId')
        return self


class CreateEdgeInstanceMessageRoutingResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateEdgeInstanceMessageRoutingResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateEdgeInstanceMessageRoutingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateEdgeOssPreSignedAddressRequest(TeaModel):
    def __init__(
        self,
        resource_id: str = None,
        file_name: str = None,
        iot_instance_id: str = None,
        type: str = None,
        instance_id: str = None,
        resource_version: str = None,
    ):
        self.resource_id = resource_id
        self.file_name = file_name
        self.iot_instance_id = iot_instance_id
        self.type = type
        self.instance_id = instance_id
        self.resource_version = resource_version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.type is not None:
            result['Type'] = self.type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.resource_version is not None:
            result['ResourceVersion'] = self.resource_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ResourceVersion') is not None:
            self.resource_version = m.get('ResourceVersion')
        return self


class CreateEdgeOssPreSignedAddressResponseBodyData(TeaModel):
    def __init__(
        self,
        oss_pre_signed_address: str = None,
        oss_address: str = None,
    ):
        self.oss_pre_signed_address = oss_pre_signed_address
        self.oss_address = oss_address

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.oss_pre_signed_address is not None:
            result['OssPreSignedAddress'] = self.oss_pre_signed_address
        if self.oss_address is not None:
            result['OssAddress'] = self.oss_address
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OssPreSignedAddress') is not None:
            self.oss_pre_signed_address = m.get('OssPreSignedAddress')
        if m.get('OssAddress') is not None:
            self.oss_address = m.get('OssAddress')
        return self


class CreateEdgeOssPreSignedAddressResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: CreateEdgeOssPreSignedAddressResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = CreateEdgeOssPreSignedAddressResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CreateEdgeOssPreSignedAddressResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateEdgeOssPreSignedAddressResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateEdgeOssPreSignedAddressResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateJobRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        description: str = None,
        job_document: str = None,
        type: str = None,
        job_file: str = None,
        job_name: str = None,
        timeout_config: str = None,
        rollout_config: str = None,
        target_config: str = None,
        scheduled_time: int = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.description = description
        self.job_document = job_document
        self.type = type
        self.job_file = job_file
        self.job_name = job_name
        self.timeout_config = timeout_config
        self.rollout_config = rollout_config
        self.target_config = target_config
        self.scheduled_time = scheduled_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.description is not None:
            result['Description'] = self.description
        if self.job_document is not None:
            result['JobDocument'] = self.job_document
        if self.type is not None:
            result['Type'] = self.type
        if self.job_file is not None:
            result['JobFile'] = self.job_file
        if self.job_name is not None:
            result['JobName'] = self.job_name
        if self.timeout_config is not None:
            result['TimeoutConfig'] = self.timeout_config
        if self.rollout_config is not None:
            result['RolloutConfig'] = self.rollout_config
        if self.target_config is not None:
            result['TargetConfig'] = self.target_config
        if self.scheduled_time is not None:
            result['ScheduledTime'] = self.scheduled_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('JobDocument') is not None:
            self.job_document = m.get('JobDocument')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('JobFile') is not None:
            self.job_file = m.get('JobFile')
        if m.get('JobName') is not None:
            self.job_name = m.get('JobName')
        if m.get('TimeoutConfig') is not None:
            self.timeout_config = m.get('TimeoutConfig')
        if m.get('RolloutConfig') is not None:
            self.rollout_config = m.get('RolloutConfig')
        if m.get('TargetConfig') is not None:
            self.target_config = m.get('TargetConfig')
        if m.get('ScheduledTime') is not None:
            self.scheduled_time = m.get('ScheduledTime')
        return self


class CreateJobResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        job_id: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.job_id = job_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class CreateJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateJobResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateLoRaNodesTaskRequestDeviceInfo(TeaModel):
    def __init__(
        self,
        dev_eui: str = None,
        pin_code: str = None,
    ):
        self.dev_eui = dev_eui
        self.pin_code = pin_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dev_eui is not None:
            result['DevEui'] = self.dev_eui
        if self.pin_code is not None:
            result['PinCode'] = self.pin_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DevEui') is not None:
            self.dev_eui = m.get('DevEui')
        if m.get('PinCode') is not None:
            self.pin_code = m.get('PinCode')
        return self


class CreateLoRaNodesTaskRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
        device_info: List[CreateLoRaNodesTaskRequestDeviceInfo] = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.device_info = device_info

    def validate(self):
        if self.device_info:
            for k in self.device_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        result['DeviceInfo'] = []
        if self.device_info is not None:
            for k in self.device_info:
                result['DeviceInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        self.device_info = []
        if m.get('DeviceInfo') is not None:
            for k in m.get('DeviceInfo'):
                temp_model = CreateLoRaNodesTaskRequestDeviceInfo()
                self.device_info.append(temp_model.from_map(k))
        return self


class CreateLoRaNodesTaskResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        task_id: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class CreateLoRaNodesTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateLoRaNodesTaskResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateLoRaNodesTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOTADynamicUpgradeJobRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateOTADynamicUpgradeJobRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        firmware_id: str = None,
        product_key: str = None,
        src_version: List[str] = None,
        retry_interval: int = None,
        retry_count: int = None,
        timeout_in_minutes: int = None,
        maximum_per_minute: int = None,
        overwrite_mode: int = None,
        dynamic_mode: int = None,
        tag: List[CreateOTADynamicUpgradeJobRequestTag] = None,
        need_push: bool = None,
        need_confirm: bool = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.firmware_id = firmware_id
        self.product_key = product_key
        self.src_version = src_version
        self.retry_interval = retry_interval
        self.retry_count = retry_count
        self.timeout_in_minutes = timeout_in_minutes
        self.maximum_per_minute = maximum_per_minute
        self.overwrite_mode = overwrite_mode
        self.dynamic_mode = dynamic_mode
        self.tag = tag
        self.need_push = need_push
        self.need_confirm = need_confirm

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.src_version is not None:
            result['SrcVersion'] = self.src_version
        if self.retry_interval is not None:
            result['RetryInterval'] = self.retry_interval
        if self.retry_count is not None:
            result['RetryCount'] = self.retry_count
        if self.timeout_in_minutes is not None:
            result['TimeoutInMinutes'] = self.timeout_in_minutes
        if self.maximum_per_minute is not None:
            result['MaximumPerMinute'] = self.maximum_per_minute
        if self.overwrite_mode is not None:
            result['OverwriteMode'] = self.overwrite_mode
        if self.dynamic_mode is not None:
            result['DynamicMode'] = self.dynamic_mode
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.need_push is not None:
            result['NeedPush'] = self.need_push
        if self.need_confirm is not None:
            result['NeedConfirm'] = self.need_confirm
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('SrcVersion') is not None:
            self.src_version = m.get('SrcVersion')
        if m.get('RetryInterval') is not None:
            self.retry_interval = m.get('RetryInterval')
        if m.get('RetryCount') is not None:
            self.retry_count = m.get('RetryCount')
        if m.get('TimeoutInMinutes') is not None:
            self.timeout_in_minutes = m.get('TimeoutInMinutes')
        if m.get('MaximumPerMinute') is not None:
            self.maximum_per_minute = m.get('MaximumPerMinute')
        if m.get('OverwriteMode') is not None:
            self.overwrite_mode = m.get('OverwriteMode')
        if m.get('DynamicMode') is not None:
            self.dynamic_mode = m.get('DynamicMode')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateOTADynamicUpgradeJobRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('NeedPush') is not None:
            self.need_push = m.get('NeedPush')
        if m.get('NeedConfirm') is not None:
            self.need_confirm = m.get('NeedConfirm')
        return self


class CreateOTADynamicUpgradeJobResponseBodyData(TeaModel):
    def __init__(
        self,
        job_id: str = None,
        utc_create: str = None,
    ):
        self.job_id = job_id
        self.utc_create = utc_create

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        return self


class CreateOTADynamicUpgradeJobResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: CreateOTADynamicUpgradeJobResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = CreateOTADynamicUpgradeJobResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CreateOTADynamicUpgradeJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateOTADynamicUpgradeJobResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateOTADynamicUpgradeJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOTAFirmwareRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        firmware_name: str = None,
        dest_version: str = None,
        firmware_url: str = None,
        firmware_sign: str = None,
        sign_method: str = None,
        firmware_size: int = None,
        product_key: str = None,
        firmware_desc: str = None,
        type: int = None,
        src_version: str = None,
        module_name: str = None,
        need_to_verify: bool = None,
        udi: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.firmware_name = firmware_name
        self.dest_version = dest_version
        self.firmware_url = firmware_url
        self.firmware_sign = firmware_sign
        self.sign_method = sign_method
        self.firmware_size = firmware_size
        self.product_key = product_key
        self.firmware_desc = firmware_desc
        self.type = type
        self.src_version = src_version
        self.module_name = module_name
        self.need_to_verify = need_to_verify
        self.udi = udi

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.firmware_name is not None:
            result['FirmwareName'] = self.firmware_name
        if self.dest_version is not None:
            result['DestVersion'] = self.dest_version
        if self.firmware_url is not None:
            result['FirmwareUrl'] = self.firmware_url
        if self.firmware_sign is not None:
            result['FirmwareSign'] = self.firmware_sign
        if self.sign_method is not None:
            result['SignMethod'] = self.sign_method
        if self.firmware_size is not None:
            result['FirmwareSize'] = self.firmware_size
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.firmware_desc is not None:
            result['FirmwareDesc'] = self.firmware_desc
        if self.type is not None:
            result['Type'] = self.type
        if self.src_version is not None:
            result['SrcVersion'] = self.src_version
        if self.module_name is not None:
            result['ModuleName'] = self.module_name
        if self.need_to_verify is not None:
            result['NeedToVerify'] = self.need_to_verify
        if self.udi is not None:
            result['Udi'] = self.udi
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('FirmwareName') is not None:
            self.firmware_name = m.get('FirmwareName')
        if m.get('DestVersion') is not None:
            self.dest_version = m.get('DestVersion')
        if m.get('FirmwareUrl') is not None:
            self.firmware_url = m.get('FirmwareUrl')
        if m.get('FirmwareSign') is not None:
            self.firmware_sign = m.get('FirmwareSign')
        if m.get('SignMethod') is not None:
            self.sign_method = m.get('SignMethod')
        if m.get('FirmwareSize') is not None:
            self.firmware_size = m.get('FirmwareSize')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('FirmwareDesc') is not None:
            self.firmware_desc = m.get('FirmwareDesc')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('SrcVersion') is not None:
            self.src_version = m.get('SrcVersion')
        if m.get('ModuleName') is not None:
            self.module_name = m.get('ModuleName')
        if m.get('NeedToVerify') is not None:
            self.need_to_verify = m.get('NeedToVerify')
        if m.get('Udi') is not None:
            self.udi = m.get('Udi')
        return self


class CreateOTAFirmwareResponseBodyData(TeaModel):
    def __init__(
        self,
        firmware_id: str = None,
        utc_create: str = None,
    ):
        self.firmware_id = firmware_id
        self.utc_create = utc_create

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        return self


class CreateOTAFirmwareResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: CreateOTAFirmwareResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = CreateOTAFirmwareResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CreateOTAFirmwareResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateOTAFirmwareResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateOTAFirmwareResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOTAModuleRequest(TeaModel):
    def __init__(
        self,
        alias_name: str = None,
        iot_instance_id: str = None,
        module_name: str = None,
        desc: str = None,
        product_key: str = None,
    ):
        self.alias_name = alias_name
        self.iot_instance_id = iot_instance_id
        self.module_name = module_name
        self.desc = desc
        self.product_key = product_key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.module_name is not None:
            result['ModuleName'] = self.module_name
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ModuleName') is not None:
            self.module_name = m.get('ModuleName')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class CreateOTAModuleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class CreateOTAModuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateOTAModuleResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateOTAModuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOTAStaticUpgradeJobRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateOTAStaticUpgradeJobRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        firmware_id: str = None,
        product_key: str = None,
        target_selection: str = None,
        src_version: List[str] = None,
        schedule_time: int = None,
        retry_interval: int = None,
        retry_count: int = None,
        timeout_in_minutes: int = None,
        maximum_per_minute: int = None,
        gray_percent: str = None,
        target_device_name: List[str] = None,
        schedule_finish_time: int = None,
        overwrite_mode: int = None,
        tag: List[CreateOTAStaticUpgradeJobRequestTag] = None,
        dn_list_file_url: str = None,
        need_push: bool = None,
        need_confirm: bool = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.firmware_id = firmware_id
        self.product_key = product_key
        self.target_selection = target_selection
        self.src_version = src_version
        self.schedule_time = schedule_time
        self.retry_interval = retry_interval
        self.retry_count = retry_count
        self.timeout_in_minutes = timeout_in_minutes
        self.maximum_per_minute = maximum_per_minute
        self.gray_percent = gray_percent
        self.target_device_name = target_device_name
        self.schedule_finish_time = schedule_finish_time
        self.overwrite_mode = overwrite_mode
        self.tag = tag
        self.dn_list_file_url = dn_list_file_url
        self.need_push = need_push
        self.need_confirm = need_confirm

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.target_selection is not None:
            result['TargetSelection'] = self.target_selection
        if self.src_version is not None:
            result['SrcVersion'] = self.src_version
        if self.schedule_time is not None:
            result['ScheduleTime'] = self.schedule_time
        if self.retry_interval is not None:
            result['RetryInterval'] = self.retry_interval
        if self.retry_count is not None:
            result['RetryCount'] = self.retry_count
        if self.timeout_in_minutes is not None:
            result['TimeoutInMinutes'] = self.timeout_in_minutes
        if self.maximum_per_minute is not None:
            result['MaximumPerMinute'] = self.maximum_per_minute
        if self.gray_percent is not None:
            result['GrayPercent'] = self.gray_percent
        if self.target_device_name is not None:
            result['TargetDeviceName'] = self.target_device_name
        if self.schedule_finish_time is not None:
            result['ScheduleFinishTime'] = self.schedule_finish_time
        if self.overwrite_mode is not None:
            result['OverwriteMode'] = self.overwrite_mode
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.dn_list_file_url is not None:
            result['DnListFileUrl'] = self.dn_list_file_url
        if self.need_push is not None:
            result['NeedPush'] = self.need_push
        if self.need_confirm is not None:
            result['NeedConfirm'] = self.need_confirm
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('TargetSelection') is not None:
            self.target_selection = m.get('TargetSelection')
        if m.get('SrcVersion') is not None:
            self.src_version = m.get('SrcVersion')
        if m.get('ScheduleTime') is not None:
            self.schedule_time = m.get('ScheduleTime')
        if m.get('RetryInterval') is not None:
            self.retry_interval = m.get('RetryInterval')
        if m.get('RetryCount') is not None:
            self.retry_count = m.get('RetryCount')
        if m.get('TimeoutInMinutes') is not None:
            self.timeout_in_minutes = m.get('TimeoutInMinutes')
        if m.get('MaximumPerMinute') is not None:
            self.maximum_per_minute = m.get('MaximumPerMinute')
        if m.get('GrayPercent') is not None:
            self.gray_percent = m.get('GrayPercent')
        if m.get('TargetDeviceName') is not None:
            self.target_device_name = m.get('TargetDeviceName')
        if m.get('ScheduleFinishTime') is not None:
            self.schedule_finish_time = m.get('ScheduleFinishTime')
        if m.get('OverwriteMode') is not None:
            self.overwrite_mode = m.get('OverwriteMode')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateOTAStaticUpgradeJobRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('DnListFileUrl') is not None:
            self.dn_list_file_url = m.get('DnListFileUrl')
        if m.get('NeedPush') is not None:
            self.need_push = m.get('NeedPush')
        if m.get('NeedConfirm') is not None:
            self.need_confirm = m.get('NeedConfirm')
        return self


class CreateOTAStaticUpgradeJobResponseBodyData(TeaModel):
    def __init__(
        self,
        job_id: str = None,
        utc_create: str = None,
    ):
        self.job_id = job_id
        self.utc_create = utc_create

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        return self


class CreateOTAStaticUpgradeJobResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: CreateOTAStaticUpgradeJobResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = CreateOTAStaticUpgradeJobResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CreateOTAStaticUpgradeJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateOTAStaticUpgradeJobResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateOTAStaticUpgradeJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOTAVerifyJobRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        firmware_id: str = None,
        timeout_in_minutes: int = None,
        product_key: str = None,
        target_device_name: List[str] = None,
        need_push: bool = None,
        need_confirm: bool = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.firmware_id = firmware_id
        self.timeout_in_minutes = timeout_in_minutes
        self.product_key = product_key
        self.target_device_name = target_device_name
        self.need_push = need_push
        self.need_confirm = need_confirm

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.timeout_in_minutes is not None:
            result['TimeoutInMinutes'] = self.timeout_in_minutes
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.target_device_name is not None:
            result['TargetDeviceName'] = self.target_device_name
        if self.need_push is not None:
            result['NeedPush'] = self.need_push
        if self.need_confirm is not None:
            result['NeedConfirm'] = self.need_confirm
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('TimeoutInMinutes') is not None:
            self.timeout_in_minutes = m.get('TimeoutInMinutes')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('TargetDeviceName') is not None:
            self.target_device_name = m.get('TargetDeviceName')
        if m.get('NeedPush') is not None:
            self.need_push = m.get('NeedPush')
        if m.get('NeedConfirm') is not None:
            self.need_confirm = m.get('NeedConfirm')
        return self


class CreateOTAVerifyJobResponseBodyData(TeaModel):
    def __init__(
        self,
        job_id: str = None,
        utc_create: str = None,
    ):
        self.job_id = job_id
        self.utc_create = utc_create

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        return self


class CreateOTAVerifyJobResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: CreateOTAVerifyJobResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = CreateOTAVerifyJobResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CreateOTAVerifyJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateOTAVerifyJobResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateOTAVerifyJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateProductRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_name: str = None,
        node_type: int = None,
        data_format: int = None,
        description: str = None,
        aliyun_commodity_code: str = None,
        id_2: bool = None,
        protocol_type: str = None,
        net_type: str = None,
        join_permission_id: str = None,
        resource_group_id: str = None,
        auth_type: str = None,
        category_key: str = None,
        publish_auto: bool = None,
        validate_type: int = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_name = product_name
        self.node_type = node_type
        self.data_format = data_format
        self.description = description
        self.aliyun_commodity_code = aliyun_commodity_code
        self.id_2 = id_2
        self.protocol_type = protocol_type
        self.net_type = net_type
        self.join_permission_id = join_permission_id
        self.resource_group_id = resource_group_id
        self.auth_type = auth_type
        self.category_key = category_key
        self.publish_auto = publish_auto
        self.validate_type = validate_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.node_type is not None:
            result['NodeType'] = self.node_type
        if self.data_format is not None:
            result['DataFormat'] = self.data_format
        if self.description is not None:
            result['Description'] = self.description
        if self.aliyun_commodity_code is not None:
            result['AliyunCommodityCode'] = self.aliyun_commodity_code
        if self.id_2 is not None:
            result['Id2'] = self.id_2
        if self.protocol_type is not None:
            result['ProtocolType'] = self.protocol_type
        if self.net_type is not None:
            result['NetType'] = self.net_type
        if self.join_permission_id is not None:
            result['JoinPermissionId'] = self.join_permission_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.auth_type is not None:
            result['AuthType'] = self.auth_type
        if self.category_key is not None:
            result['CategoryKey'] = self.category_key
        if self.publish_auto is not None:
            result['PublishAuto'] = self.publish_auto
        if self.validate_type is not None:
            result['ValidateType'] = self.validate_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('NodeType') is not None:
            self.node_type = m.get('NodeType')
        if m.get('DataFormat') is not None:
            self.data_format = m.get('DataFormat')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('AliyunCommodityCode') is not None:
            self.aliyun_commodity_code = m.get('AliyunCommodityCode')
        if m.get('Id2') is not None:
            self.id_2 = m.get('Id2')
        if m.get('ProtocolType') is not None:
            self.protocol_type = m.get('ProtocolType')
        if m.get('NetType') is not None:
            self.net_type = m.get('NetType')
        if m.get('JoinPermissionId') is not None:
            self.join_permission_id = m.get('JoinPermissionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('AuthType') is not None:
            self.auth_type = m.get('AuthType')
        if m.get('CategoryKey') is not None:
            self.category_key = m.get('CategoryKey')
        if m.get('PublishAuto') is not None:
            self.publish_auto = m.get('PublishAuto')
        if m.get('ValidateType') is not None:
            self.validate_type = m.get('ValidateType')
        return self


class CreateProductResponseBodyData(TeaModel):
    def __init__(
        self,
        data_format: int = None,
        description: str = None,
        node_type: int = None,
        product_key: str = None,
        product_name: str = None,
        aliyun_commodity_code: str = None,
        id_2: bool = None,
        protocol_type: str = None,
        auth_type: str = None,
        product_secret: str = None,
    ):
        self.data_format = data_format
        self.description = description
        self.node_type = node_type
        self.product_key = product_key
        self.product_name = product_name
        self.aliyun_commodity_code = aliyun_commodity_code
        self.id_2 = id_2
        self.protocol_type = protocol_type
        self.auth_type = auth_type
        self.product_secret = product_secret

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_format is not None:
            result['DataFormat'] = self.data_format
        if self.description is not None:
            result['Description'] = self.description
        if self.node_type is not None:
            result['NodeType'] = self.node_type
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.aliyun_commodity_code is not None:
            result['AliyunCommodityCode'] = self.aliyun_commodity_code
        if self.id_2 is not None:
            result['Id2'] = self.id_2
        if self.protocol_type is not None:
            result['ProtocolType'] = self.protocol_type
        if self.auth_type is not None:
            result['AuthType'] = self.auth_type
        if self.product_secret is not None:
            result['ProductSecret'] = self.product_secret
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DataFormat') is not None:
            self.data_format = m.get('DataFormat')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('NodeType') is not None:
            self.node_type = m.get('NodeType')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('AliyunCommodityCode') is not None:
            self.aliyun_commodity_code = m.get('AliyunCommodityCode')
        if m.get('Id2') is not None:
            self.id_2 = m.get('Id2')
        if m.get('ProtocolType') is not None:
            self.protocol_type = m.get('ProtocolType')
        if m.get('AuthType') is not None:
            self.auth_type = m.get('AuthType')
        if m.get('ProductSecret') is not None:
            self.product_secret = m.get('ProductSecret')
        return self


class CreateProductResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        product_key: str = None,
        data: CreateProductResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.product_key = product_key
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Data') is not None:
            temp_model = CreateProductResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CreateProductResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateProductResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateProductResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateProductDistributeJobRequest(TeaModel):
    def __init__(
        self,
        source_instance_id: str = None,
        product_key: str = None,
        target_instance_id: str = None,
        target_uid: str = None,
        target_aliyun_id: str = None,
    ):
        self.source_instance_id = source_instance_id
        self.product_key = product_key
        self.target_instance_id = target_instance_id
        self.target_uid = target_uid
        self.target_aliyun_id = target_aliyun_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_instance_id is not None:
            result['SourceInstanceId'] = self.source_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.target_instance_id is not None:
            result['TargetInstanceId'] = self.target_instance_id
        if self.target_uid is not None:
            result['TargetUid'] = self.target_uid
        if self.target_aliyun_id is not None:
            result['TargetAliyunId'] = self.target_aliyun_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceInstanceId') is not None:
            self.source_instance_id = m.get('SourceInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('TargetInstanceId') is not None:
            self.target_instance_id = m.get('TargetInstanceId')
        if m.get('TargetUid') is not None:
            self.target_uid = m.get('TargetUid')
        if m.get('TargetAliyunId') is not None:
            self.target_aliyun_id = m.get('TargetAliyunId')
        return self


class CreateProductDistributeJobResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        job_id: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.job_id = job_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class CreateProductDistributeJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateProductDistributeJobResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateProductDistributeJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateProductTagsRequestProductTag(TeaModel):
    def __init__(
        self,
        tag_key: str = None,
        tag_value: str = None,
    ):
        self.tag_key = tag_key
        self.tag_value = tag_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class CreateProductTagsRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
        product_tag: List[CreateProductTagsRequestProductTag] = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.product_tag = product_tag

    def validate(self):
        if self.product_tag:
            for k in self.product_tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        result['ProductTag'] = []
        if self.product_tag is not None:
            for k in self.product_tag:
                result['ProductTag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        self.product_tag = []
        if m.get('ProductTag') is not None:
            for k in m.get('ProductTag'):
                temp_model = CreateProductTagsRequestProductTag()
                self.product_tag.append(temp_model.from_map(k))
        return self


class CreateProductTagsResponseBodyInvalidProductTagsProductTag(TeaModel):
    def __init__(
        self,
        tag_key: str = None,
        tag_value: str = None,
    ):
        self.tag_key = tag_key
        self.tag_value = tag_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class CreateProductTagsResponseBodyInvalidProductTags(TeaModel):
    def __init__(
        self,
        product_tag: List[CreateProductTagsResponseBodyInvalidProductTagsProductTag] = None,
    ):
        self.product_tag = product_tag

    def validate(self):
        if self.product_tag:
            for k in self.product_tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ProductTag'] = []
        if self.product_tag is not None:
            for k in self.product_tag:
                result['ProductTag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.product_tag = []
        if m.get('ProductTag') is not None:
            for k in m.get('ProductTag'):
                temp_model = CreateProductTagsResponseBodyInvalidProductTagsProductTag()
                self.product_tag.append(temp_model.from_map(k))
        return self


class CreateProductTagsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_message: str = None,
        code: str = None,
        invalid_product_tags: CreateProductTagsResponseBodyInvalidProductTags = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_message = error_message
        self.code = code
        self.invalid_product_tags = invalid_product_tags

    def validate(self):
        if self.invalid_product_tags:
            self.invalid_product_tags.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.invalid_product_tags is not None:
            result['InvalidProductTags'] = self.invalid_product_tags.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('InvalidProductTags') is not None:
            temp_model = CreateProductTagsResponseBodyInvalidProductTags()
            self.invalid_product_tags = temp_model.from_map(m['InvalidProductTags'])
        return self


class CreateProductTagsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateProductTagsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateProductTagsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateProductTopicRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
        topic_short_name: str = None,
        operation: str = None,
        desc: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.topic_short_name = topic_short_name
        self.operation = operation
        self.desc = desc

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.topic_short_name is not None:
            result['TopicShortName'] = self.topic_short_name
        if self.operation is not None:
            result['Operation'] = self.operation
        if self.desc is not None:
            result['Desc'] = self.desc
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('TopicShortName') is not None:
            self.topic_short_name = m.get('TopicShortName')
        if m.get('Operation') is not None:
            self.operation = m.get('Operation')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        return self


class CreateProductTopicResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        topic_id: int = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.topic_id = topic_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.topic_id is not None:
            result['TopicId'] = self.topic_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('TopicId') is not None:
            self.topic_id = m.get('TopicId')
        return self


class CreateProductTopicResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateProductTopicResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateProductTopicResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateRuleRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        select: str = None,
        short_topic: str = None,
        where: str = None,
        product_key: str = None,
        name: str = None,
        rule_desc: str = None,
        data_type: str = None,
        topic_type: int = None,
        resource_group_id: str = None,
        topic: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.select = select
        self.short_topic = short_topic
        self.where = where
        self.product_key = product_key
        self.name = name
        self.rule_desc = rule_desc
        self.data_type = data_type
        self.topic_type = topic_type
        self.resource_group_id = resource_group_id
        self.topic = topic

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.select is not None:
            result['Select'] = self.select
        if self.short_topic is not None:
            result['ShortTopic'] = self.short_topic
        if self.where is not None:
            result['Where'] = self.where
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.name is not None:
            result['Name'] = self.name
        if self.rule_desc is not None:
            result['RuleDesc'] = self.rule_desc
        if self.data_type is not None:
            result['DataType'] = self.data_type
        if self.topic_type is not None:
            result['TopicType'] = self.topic_type
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.topic is not None:
            result['Topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Select') is not None:
            self.select = m.get('Select')
        if m.get('ShortTopic') is not None:
            self.short_topic = m.get('ShortTopic')
        if m.get('Where') is not None:
            self.where = m.get('Where')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RuleDesc') is not None:
            self.rule_desc = m.get('RuleDesc')
        if m.get('DataType') is not None:
            self.data_type = m.get('DataType')
        if m.get('TopicType') is not None:
            self.topic_type = m.get('TopicType')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        return self


class CreateRuleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        rule_id: int = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.rule_id = rule_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class CreateRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateRuleResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateRuleActionRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        rule_id: int = None,
        type: str = None,
        configuration: str = None,
        error_action_flag: bool = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.rule_id = rule_id
        self.type = type
        self.configuration = configuration
        self.error_action_flag = error_action_flag

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.type is not None:
            result['Type'] = self.type
        if self.configuration is not None:
            result['Configuration'] = self.configuration
        if self.error_action_flag is not None:
            result['ErrorActionFlag'] = self.error_action_flag
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Configuration') is not None:
            self.configuration = m.get('Configuration')
        if m.get('ErrorActionFlag') is not None:
            self.error_action_flag = m.get('ErrorActionFlag')
        return self


class CreateRuleActionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        code: str = None,
        success: bool = None,
        error_message: str = None,
        action_id: int = None,
    ):
        self.request_id = request_id
        self.code = code
        self.success = success
        self.error_message = error_message
        self.action_id = action_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.action_id is not None:
            result['ActionId'] = self.action_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ActionId') is not None:
            self.action_id = m.get('ActionId')
        return self


class CreateRuleActionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateRuleActionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateRuleActionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateRulengDistributeJobRequest(TeaModel):
    def __init__(
        self,
        product_key: str = None,
        source_instance_id: str = None,
        target_instance_id: str = None,
    ):
        self.product_key = product_key
        self.source_instance_id = source_instance_id
        self.target_instance_id = target_instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.source_instance_id is not None:
            result['SourceInstanceId'] = self.source_instance_id
        if self.target_instance_id is not None:
            result['TargetInstanceId'] = self.target_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('SourceInstanceId') is not None:
            self.source_instance_id = m.get('SourceInstanceId')
        if m.get('TargetInstanceId') is not None:
            self.target_instance_id = m.get('TargetInstanceId')
        return self


class CreateRulengDistributeJobResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class CreateRulengDistributeJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateRulengDistributeJobResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateRulengDistributeJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSceneRuleRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        rule_name: str = None,
        rule_content: str = None,
        rule_description: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.rule_name = rule_name
        self.rule_content = rule_content
        self.rule_description = rule_description

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.rule_content is not None:
            result['RuleContent'] = self.rule_content
        if self.rule_description is not None:
            result['RuleDescription'] = self.rule_description
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('RuleContent') is not None:
            self.rule_content = m.get('RuleContent')
        if m.get('RuleDescription') is not None:
            self.rule_description = m.get('RuleDescription')
        return self


class CreateSceneRuleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        rule_id: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.rule_id = rule_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class CreateSceneRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateSceneRuleResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateSceneRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSpeechRequest(TeaModel):
    def __init__(
        self,
        voice: str = None,
        speech_type: str = None,
        iot_instance_id: str = None,
        biz_code: str = None,
        speech_rate: int = None,
        volume: int = None,
        project_code: str = None,
        text: str = None,
    ):
        self.voice = voice
        self.speech_type = speech_type
        self.iot_instance_id = iot_instance_id
        self.biz_code = biz_code
        self.speech_rate = speech_rate
        self.volume = volume
        self.project_code = project_code
        self.text = text

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.voice is not None:
            result['Voice'] = self.voice
        if self.speech_type is not None:
            result['SpeechType'] = self.speech_type
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.biz_code is not None:
            result['BizCode'] = self.biz_code
        if self.speech_rate is not None:
            result['SpeechRate'] = self.speech_rate
        if self.volume is not None:
            result['Volume'] = self.volume
        if self.project_code is not None:
            result['ProjectCode'] = self.project_code
        if self.text is not None:
            result['Text'] = self.text
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Voice') is not None:
            self.voice = m.get('Voice')
        if m.get('SpeechType') is not None:
            self.speech_type = m.get('SpeechType')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('BizCode') is not None:
            self.biz_code = m.get('BizCode')
        if m.get('SpeechRate') is not None:
            self.speech_rate = m.get('SpeechRate')
        if m.get('Volume') is not None:
            self.volume = m.get('Volume')
        if m.get('ProjectCode') is not None:
            self.project_code = m.get('ProjectCode')
        if m.get('Text') is not None:
            self.text = m.get('Text')
        return self


class CreateSpeechResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class CreateSpeechResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateSpeechResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateSpeechResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateStudioAppDomainOpenRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        host: str = None,
        protocol: str = None,
        project_id: str = None,
        iot_instance_id: str = None,
    ):
        self.app_id = app_id
        self.host = host
        self.protocol = protocol
        self.project_id = project_id
        self.iot_instance_id = iot_instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.host is not None:
            result['Host'] = self.host
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('Host') is not None:
            self.host = m.get('Host')
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class CreateStudioAppDomainOpenResponseBodyData(TeaModel):
    def __init__(
        self,
        tenant_id: str = None,
        app_id: str = None,
        project_id: str = None,
        host: str = None,
        id: int = None,
        is_beian: str = None,
        protocol: str = None,
    ):
        self.tenant_id = tenant_id
        self.app_id = app_id
        self.project_id = project_id
        self.host = host
        self.id = id
        self.is_beian = is_beian
        self.protocol = protocol

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.host is not None:
            result['Host'] = self.host
        if self.id is not None:
            result['Id'] = self.id
        if self.is_beian is not None:
            result['IsBeian'] = self.is_beian
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Host') is not None:
            self.host = m.get('Host')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('IsBeian') is not None:
            self.is_beian = m.get('IsBeian')
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        return self


class CreateStudioAppDomainOpenResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: CreateStudioAppDomainOpenResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = CreateStudioAppDomainOpenResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CreateStudioAppDomainOpenResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateStudioAppDomainOpenResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateStudioAppDomainOpenResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSubscribeRelationRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
        device_data_flag: bool = None,
        device_life_cycle_flag: bool = None,
        device_status_change_flag: bool = None,
        device_topo_life_cycle_flag: bool = None,
        found_device_list_flag: bool = None,
        mns_configuration: str = None,
        type: str = None,
        consumer_group_ids: List[str] = None,
        ota_event_flag: bool = None,
        thing_history_flag: bool = None,
        device_tag_flag: bool = None,
        ota_version_flag: bool = None,
        ota_job_flag: bool = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.device_data_flag = device_data_flag
        self.device_life_cycle_flag = device_life_cycle_flag
        self.device_status_change_flag = device_status_change_flag
        self.device_topo_life_cycle_flag = device_topo_life_cycle_flag
        self.found_device_list_flag = found_device_list_flag
        self.mns_configuration = mns_configuration
        self.type = type
        self.consumer_group_ids = consumer_group_ids
        self.ota_event_flag = ota_event_flag
        self.thing_history_flag = thing_history_flag
        self.device_tag_flag = device_tag_flag
        self.ota_version_flag = ota_version_flag
        self.ota_job_flag = ota_job_flag

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_data_flag is not None:
            result['DeviceDataFlag'] = self.device_data_flag
        if self.device_life_cycle_flag is not None:
            result['DeviceLifeCycleFlag'] = self.device_life_cycle_flag
        if self.device_status_change_flag is not None:
            result['DeviceStatusChangeFlag'] = self.device_status_change_flag
        if self.device_topo_life_cycle_flag is not None:
            result['DeviceTopoLifeCycleFlag'] = self.device_topo_life_cycle_flag
        if self.found_device_list_flag is not None:
            result['FoundDeviceListFlag'] = self.found_device_list_flag
        if self.mns_configuration is not None:
            result['MnsConfiguration'] = self.mns_configuration
        if self.type is not None:
            result['Type'] = self.type
        if self.consumer_group_ids is not None:
            result['ConsumerGroupIds'] = self.consumer_group_ids
        if self.ota_event_flag is not None:
            result['OtaEventFlag'] = self.ota_event_flag
        if self.thing_history_flag is not None:
            result['ThingHistoryFlag'] = self.thing_history_flag
        if self.device_tag_flag is not None:
            result['DeviceTagFlag'] = self.device_tag_flag
        if self.ota_version_flag is not None:
            result['OtaVersionFlag'] = self.ota_version_flag
        if self.ota_job_flag is not None:
            result['OtaJobFlag'] = self.ota_job_flag
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceDataFlag') is not None:
            self.device_data_flag = m.get('DeviceDataFlag')
        if m.get('DeviceLifeCycleFlag') is not None:
            self.device_life_cycle_flag = m.get('DeviceLifeCycleFlag')
        if m.get('DeviceStatusChangeFlag') is not None:
            self.device_status_change_flag = m.get('DeviceStatusChangeFlag')
        if m.get('DeviceTopoLifeCycleFlag') is not None:
            self.device_topo_life_cycle_flag = m.get('DeviceTopoLifeCycleFlag')
        if m.get('FoundDeviceListFlag') is not None:
            self.found_device_list_flag = m.get('FoundDeviceListFlag')
        if m.get('MnsConfiguration') is not None:
            self.mns_configuration = m.get('MnsConfiguration')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('ConsumerGroupIds') is not None:
            self.consumer_group_ids = m.get('ConsumerGroupIds')
        if m.get('OtaEventFlag') is not None:
            self.ota_event_flag = m.get('OtaEventFlag')
        if m.get('ThingHistoryFlag') is not None:
            self.thing_history_flag = m.get('ThingHistoryFlag')
        if m.get('DeviceTagFlag') is not None:
            self.device_tag_flag = m.get('DeviceTagFlag')
        if m.get('OtaVersionFlag') is not None:
            self.ota_version_flag = m.get('OtaVersionFlag')
        if m.get('OtaJobFlag') is not None:
            self.ota_job_flag = m.get('OtaJobFlag')
        return self


class CreateSubscribeRelationResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class CreateSubscribeRelationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateSubscribeRelationResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateSubscribeRelationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateThingModelRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
        thing_model_json: str = None,
        function_block_id: str = None,
        function_block_name: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.thing_model_json = thing_model_json
        self.function_block_id = function_block_id
        self.function_block_name = function_block_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.thing_model_json is not None:
            result['ThingModelJson'] = self.thing_model_json
        if self.function_block_id is not None:
            result['FunctionBlockId'] = self.function_block_id
        if self.function_block_name is not None:
            result['FunctionBlockName'] = self.function_block_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ThingModelJson') is not None:
            self.thing_model_json = m.get('ThingModelJson')
        if m.get('FunctionBlockId') is not None:
            self.function_block_id = m.get('FunctionBlockId')
        if m.get('FunctionBlockName') is not None:
            self.function_block_name = m.get('FunctionBlockName')
        return self


class CreateThingModelResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class CreateThingModelResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateThingModelResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateThingModelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateThingScriptRequest(TeaModel):
    def __init__(
        self,
        script_content: str = None,
        iot_instance_id: str = None,
        product_key: str = None,
        script_type: str = None,
    ):
        self.script_content = script_content
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.script_type = script_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.script_content is not None:
            result['ScriptContent'] = self.script_content
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.script_type is not None:
            result['ScriptType'] = self.script_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ScriptContent') is not None:
            self.script_content = m.get('ScriptContent')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ScriptType') is not None:
            self.script_type = m.get('ScriptType')
        return self


class CreateThingScriptResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class CreateThingScriptResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateThingScriptResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateThingScriptResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateTopicRouteTableRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        dst_topic: List[str] = None,
        src_topic: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.dst_topic = dst_topic
        self.src_topic = src_topic

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.dst_topic is not None:
            result['DstTopic'] = self.dst_topic
        if self.src_topic is not None:
            result['SrcTopic'] = self.src_topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('DstTopic') is not None:
            self.dst_topic = m.get('DstTopic')
        if m.get('SrcTopic') is not None:
            self.src_topic = m.get('SrcTopic')
        return self


class CreateTopicRouteTableResponseBodyFailureTopics(TeaModel):
    def __init__(
        self,
        topic: List[Dict[str, str]] = None,
    ):
        self.topic = topic

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.topic is not None:
            result['Topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        return self


class CreateTopicRouteTableResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        is_all_succeed: bool = None,
        error_message: str = None,
        failure_topics: CreateTopicRouteTableResponseBodyFailureTopics = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.is_all_succeed = is_all_succeed
        self.error_message = error_message
        self.failure_topics = failure_topics

    def validate(self):
        if self.failure_topics:
            self.failure_topics.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.is_all_succeed is not None:
            result['IsAllSucceed'] = self.is_all_succeed
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.failure_topics is not None:
            result['FailureTopics'] = self.failure_topics.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('IsAllSucceed') is not None:
            self.is_all_succeed = m.get('IsAllSucceed')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('FailureTopics') is not None:
            temp_model = CreateTopicRouteTableResponseBodyFailureTopics()
            self.failure_topics = temp_model.from_map(m['FailureTopics'])
        return self


class CreateTopicRouteTableResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateTopicRouteTableResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateTopicRouteTableResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteConsumerGroupRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        group_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.group_id = group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        return self


class DeleteConsumerGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_message: str = None,
        code: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_message = error_message
        self.code = code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        return self


class DeleteConsumerGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteConsumerGroupResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteConsumerGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteConsumerGroupSubscribeRelationRequest(TeaModel):
    def __init__(
        self,
        consumer_group_id: str = None,
        iot_instance_id: str = None,
        product_key: str = None,
    ):
        self.consumer_group_id = consumer_group_id
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.consumer_group_id is not None:
            result['ConsumerGroupId'] = self.consumer_group_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConsumerGroupId') is not None:
            self.consumer_group_id = m.get('ConsumerGroupId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class DeleteConsumerGroupSubscribeRelationResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class DeleteConsumerGroupSubscribeRelationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteConsumerGroupSubscribeRelationResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteConsumerGroupSubscribeRelationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDeviceRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
        device_name: str = None,
        iot_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.device_name = device_name
        self.iot_id = iot_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class DeleteDeviceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class DeleteDeviceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteDeviceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDeviceDistributeJobRequest(TeaModel):
    def __init__(
        self,
        job_id: str = None,
    ):
        self.job_id = job_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class DeleteDeviceDistributeJobResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class DeleteDeviceDistributeJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteDeviceDistributeJobResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteDeviceDistributeJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDeviceFileRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
        device_name: str = None,
        iot_id: str = None,
        file_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.device_name = device_name
        self.iot_id = iot_id
        self.file_id = file_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.file_id is not None:
            result['FileId'] = self.file_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        return self


class DeleteDeviceFileResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class DeleteDeviceFileResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteDeviceFileResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteDeviceFileResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDeviceGroupRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        group_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.group_id = group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        return self


class DeleteDeviceGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class DeleteDeviceGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteDeviceGroupResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteDeviceGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDevicePropRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
        device_name: str = None,
        prop_key: str = None,
        iot_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.device_name = device_name
        self.prop_key = prop_key
        self.iot_id = iot_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.prop_key is not None:
            result['PropKey'] = self.prop_key
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('PropKey') is not None:
            self.prop_key = m.get('PropKey')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class DeleteDevicePropResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class DeleteDevicePropResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteDevicePropResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteDevicePropResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteEdgeDriverRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        driver_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.driver_id = driver_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        return self


class DeleteEdgeDriverResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class DeleteEdgeDriverResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteEdgeDriverResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteEdgeDriverResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteEdgeDriverVersionRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        driver_id: str = None,
        driver_version: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.driver_id = driver_id
        self.driver_version = driver_version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.driver_version is not None:
            result['DriverVersion'] = self.driver_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('DriverVersion') is not None:
            self.driver_version = m.get('DriverVersion')
        return self


class DeleteEdgeDriverVersionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class DeleteEdgeDriverVersionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteEdgeDriverVersionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteEdgeDriverVersionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteEdgeInstanceRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DeleteEdgeInstanceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class DeleteEdgeInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteEdgeInstanceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteEdgeInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteEdgeInstanceMessageRoutingRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
        route_id: int = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.route_id = route_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.route_id is not None:
            result['RouteId'] = self.route_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RouteId') is not None:
            self.route_id = m.get('RouteId')
        return self


class DeleteEdgeInstanceMessageRoutingResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class DeleteEdgeInstanceMessageRoutingResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteEdgeInstanceMessageRoutingResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteEdgeInstanceMessageRoutingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteJobRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        job_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.job_id = job_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class DeleteJobResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class DeleteJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteJobResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteOTAFirmwareRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        firmware_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.firmware_id = firmware_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        return self


class DeleteOTAFirmwareResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class DeleteOTAFirmwareResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteOTAFirmwareResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteOTAFirmwareResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteOTAModuleRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
        module_name: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.module_name = module_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.module_name is not None:
            result['ModuleName'] = self.module_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ModuleName') is not None:
            self.module_name = m.get('ModuleName')
        return self


class DeleteOTAModuleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class DeleteOTAModuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteOTAModuleResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteOTAModuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteProductRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class DeleteProductResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class DeleteProductResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteProductResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteProductResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteProductTagsRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_tag_key: List[str] = None,
        product_key: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_tag_key = product_tag_key
        self.product_key = product_key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_tag_key is not None:
            result['ProductTagKey'] = self.product_tag_key
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductTagKey') is not None:
            self.product_tag_key = m.get('ProductTagKey')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class DeleteProductTagsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_message: str = None,
        code: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_message = error_message
        self.code = code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        return self


class DeleteProductTagsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteProductTagsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteProductTagsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteProductTopicRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        topic_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.topic_id = topic_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.topic_id is not None:
            result['TopicId'] = self.topic_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('TopicId') is not None:
            self.topic_id = m.get('TopicId')
        return self


class DeleteProductTopicResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class DeleteProductTopicResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteProductTopicResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteProductTopicResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteRuleRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        rule_id: int = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.rule_id = rule_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class DeleteRuleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class DeleteRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteRuleResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteRuleActionRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        action_id: int = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.action_id = action_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.action_id is not None:
            result['ActionId'] = self.action_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ActionId') is not None:
            self.action_id = m.get('ActionId')
        return self


class DeleteRuleActionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class DeleteRuleActionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteRuleActionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteRuleActionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSceneRuleRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        rule_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.rule_id = rule_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class DeleteSceneRuleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_message: str = None,
        code: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_message = error_message
        self.code = code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        return self


class DeleteSceneRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteSceneRuleResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteSceneRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSpeechRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        speech_code_list: List[str] = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.speech_code_list = speech_code_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.speech_code_list is not None:
            result['SpeechCodeList'] = self.speech_code_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('SpeechCodeList') is not None:
            self.speech_code_list = m.get('SpeechCodeList')
        return self


class DeleteSpeechResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class DeleteSpeechResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteSpeechResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteSpeechResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteStudioAppDomainOpenRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        domain_id: int = None,
        project_id: str = None,
        iot_instance_id: str = None,
    ):
        self.app_id = app_id
        self.domain_id = domain_id
        self.project_id = project_id
        self.iot_instance_id = iot_instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.domain_id is not None:
            result['DomainId'] = self.domain_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('DomainId') is not None:
            self.domain_id = m.get('DomainId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class DeleteStudioAppDomainOpenResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: bool = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class DeleteStudioAppDomainOpenResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteStudioAppDomainOpenResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteStudioAppDomainOpenResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSubscribeRelationRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
        type: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DeleteSubscribeRelationResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class DeleteSubscribeRelationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteSubscribeRelationResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteSubscribeRelationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteThingModelRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        resource_group_id: str = None,
        product_key: str = None,
        property_identifier: List[str] = None,
        service_identifier: List[str] = None,
        event_identifier: List[str] = None,
        function_block_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.resource_group_id = resource_group_id
        self.product_key = product_key
        self.property_identifier = property_identifier
        self.service_identifier = service_identifier
        self.event_identifier = event_identifier
        self.function_block_id = function_block_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.property_identifier is not None:
            result['PropertyIdentifier'] = self.property_identifier
        if self.service_identifier is not None:
            result['ServiceIdentifier'] = self.service_identifier
        if self.event_identifier is not None:
            result['EventIdentifier'] = self.event_identifier
        if self.function_block_id is not None:
            result['FunctionBlockId'] = self.function_block_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('PropertyIdentifier') is not None:
            self.property_identifier = m.get('PropertyIdentifier')
        if m.get('ServiceIdentifier') is not None:
            self.service_identifier = m.get('ServiceIdentifier')
        if m.get('EventIdentifier') is not None:
            self.event_identifier = m.get('EventIdentifier')
        if m.get('FunctionBlockId') is not None:
            self.function_block_id = m.get('FunctionBlockId')
        return self


class DeleteThingModelResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class DeleteThingModelResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteThingModelResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteThingModelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteTopicRouteTableRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        dst_topic: List[str] = None,
        src_topic: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.dst_topic = dst_topic
        self.src_topic = src_topic

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.dst_topic is not None:
            result['DstTopic'] = self.dst_topic
        if self.src_topic is not None:
            result['SrcTopic'] = self.src_topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('DstTopic') is not None:
            self.dst_topic = m.get('DstTopic')
        if m.get('SrcTopic') is not None:
            self.src_topic = m.get('SrcTopic')
        return self


class DeleteTopicRouteTableResponseBodyFailureTopics(TeaModel):
    def __init__(
        self,
        topic: List[Dict[str, str]] = None,
    ):
        self.topic = topic

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.topic is not None:
            result['Topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        return self


class DeleteTopicRouteTableResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        is_all_succeed: bool = None,
        error_message: str = None,
        failure_topics: DeleteTopicRouteTableResponseBodyFailureTopics = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.is_all_succeed = is_all_succeed
        self.error_message = error_message
        self.failure_topics = failure_topics

    def validate(self):
        if self.failure_topics:
            self.failure_topics.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.is_all_succeed is not None:
            result['IsAllSucceed'] = self.is_all_succeed
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.failure_topics is not None:
            result['FailureTopics'] = self.failure_topics.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('IsAllSucceed') is not None:
            self.is_all_succeed = m.get('IsAllSucceed')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('FailureTopics') is not None:
            temp_model = DeleteTopicRouteTableResponseBodyFailureTopics()
            self.failure_topics = temp_model.from_map(m['FailureTopics'])
        return self


class DeleteTopicRouteTableResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteTopicRouteTableResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteTopicRouteTableResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DisableDeviceTunnelRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
        device_name: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.device_name = device_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        return self


class DisableDeviceTunnelResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class DisableDeviceTunnelResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DisableDeviceTunnelResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DisableDeviceTunnelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DisableDeviceTunnelShareRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
        device_name: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.device_name = device_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        return self


class DisableDeviceTunnelShareResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_message: str = None,
        code: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_message = error_message
        self.code = code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        return self


class DisableDeviceTunnelShareResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DisableDeviceTunnelShareResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DisableDeviceTunnelShareResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DisableSceneRuleRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        rule_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.rule_id = rule_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class DisableSceneRuleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_message: str = None,
        code: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_message = error_message
        self.code = code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        return self


class DisableSceneRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DisableSceneRuleResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DisableSceneRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DisableThingRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
        device_name: str = None,
        iot_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.device_name = device_name
        self.iot_id = iot_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class DisableThingResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class DisableThingResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DisableThingResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DisableThingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EnableDeviceTunnelRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
        device_name: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.device_name = device_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        return self


class EnableDeviceTunnelResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class EnableDeviceTunnelResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: EnableDeviceTunnelResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = EnableDeviceTunnelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EnableDeviceTunnelShareRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
        device_name: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.device_name = device_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        return self


class EnableDeviceTunnelShareResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_message: str = None,
        code: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_message = error_message
        self.code = code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        return self


class EnableDeviceTunnelShareResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: EnableDeviceTunnelShareResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = EnableDeviceTunnelShareResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EnableSceneRuleRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        rule_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.rule_id = rule_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class EnableSceneRuleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_message: str = None,
        code: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_message = error_message
        self.code = code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        return self


class EnableSceneRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: EnableSceneRuleResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = EnableSceneRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EnableThingRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
        device_name: str = None,
        iot_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.device_name = device_name
        self.iot_id = iot_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class EnableThingResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class EnableThingResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: EnableThingResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = EnableThingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GenerateDeviceNameListURLRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class GenerateDeviceNameListURLResponseBodyData(TeaModel):
    def __init__(
        self,
        key: str = None,
        host: str = None,
        policy: str = None,
        access_key_id: str = None,
        signature: str = None,
        file_url: str = None,
        utc_create: str = None,
        object_storage: str = None,
    ):
        self.key = key
        self.host = host
        self.policy = policy
        self.access_key_id = access_key_id
        self.signature = signature
        self.file_url = file_url
        self.utc_create = utc_create
        self.object_storage = object_storage

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.host is not None:
            result['Host'] = self.host
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.access_key_id is not None:
            result['AccessKeyId'] = self.access_key_id
        if self.signature is not None:
            result['Signature'] = self.signature
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.object_storage is not None:
            result['ObjectStorage'] = self.object_storage
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Host') is not None:
            self.host = m.get('Host')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('AccessKeyId') is not None:
            self.access_key_id = m.get('AccessKeyId')
        if m.get('Signature') is not None:
            self.signature = m.get('Signature')
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('ObjectStorage') is not None:
            self.object_storage = m.get('ObjectStorage')
        return self


class GenerateDeviceNameListURLResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: GenerateDeviceNameListURLResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = GenerateDeviceNameListURLResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GenerateDeviceNameListURLResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GenerateDeviceNameListURLResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GenerateDeviceNameListURLResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GenerateFileUploadURLRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        file_suffix: str = None,
        biz_code: str = None,
        file_name: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.file_suffix = file_suffix
        self.biz_code = biz_code
        self.file_name = file_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.file_suffix is not None:
            result['FileSuffix'] = self.file_suffix
        if self.biz_code is not None:
            result['BizCode'] = self.biz_code
        if self.file_name is not None:
            result['FileName'] = self.file_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('FileSuffix') is not None:
            self.file_suffix = m.get('FileSuffix')
        if m.get('BizCode') is not None:
            self.biz_code = m.get('BizCode')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        return self


class GenerateFileUploadURLResponseBodyData(TeaModel):
    def __init__(
        self,
        key: str = None,
        host: str = None,
        policy: str = None,
        oss_access_key_id: str = None,
        signature: str = None,
        object_storage: str = None,
    ):
        self.key = key
        self.host = host
        self.policy = policy
        self.oss_access_key_id = oss_access_key_id
        self.signature = signature
        self.object_storage = object_storage

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.host is not None:
            result['Host'] = self.host
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.oss_access_key_id is not None:
            result['OssAccessKeyId'] = self.oss_access_key_id
        if self.signature is not None:
            result['Signature'] = self.signature
        if self.object_storage is not None:
            result['ObjectStorage'] = self.object_storage
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Host') is not None:
            self.host = m.get('Host')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('OssAccessKeyId') is not None:
            self.oss_access_key_id = m.get('OssAccessKeyId')
        if m.get('Signature') is not None:
            self.signature = m.get('Signature')
        if m.get('ObjectStorage') is not None:
            self.object_storage = m.get('ObjectStorage')
        return self


class GenerateFileUploadURLResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: GenerateFileUploadURLResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = GenerateFileUploadURLResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GenerateFileUploadURLResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GenerateFileUploadURLResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GenerateFileUploadURLResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GenerateOTAUploadURLRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        file_suffix: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.file_suffix = file_suffix

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.file_suffix is not None:
            result['FileSuffix'] = self.file_suffix
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('FileSuffix') is not None:
            self.file_suffix = m.get('FileSuffix')
        return self


class GenerateOTAUploadURLResponseBodyData(TeaModel):
    def __init__(
        self,
        key: str = None,
        host: str = None,
        policy: str = None,
        ossaccess_key_id: str = None,
        signature: str = None,
        firmware_url: str = None,
        utc_create: str = None,
        object_storage: str = None,
    ):
        self.key = key
        self.host = host
        self.policy = policy
        self.ossaccess_key_id = ossaccess_key_id
        self.signature = signature
        self.firmware_url = firmware_url
        self.utc_create = utc_create
        self.object_storage = object_storage

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.host is not None:
            result['Host'] = self.host
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.ossaccess_key_id is not None:
            result['OSSAccessKeyId'] = self.ossaccess_key_id
        if self.signature is not None:
            result['Signature'] = self.signature
        if self.firmware_url is not None:
            result['FirmwareUrl'] = self.firmware_url
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.object_storage is not None:
            result['ObjectStorage'] = self.object_storage
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Host') is not None:
            self.host = m.get('Host')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('OSSAccessKeyId') is not None:
            self.ossaccess_key_id = m.get('OSSAccessKeyId')
        if m.get('Signature') is not None:
            self.signature = m.get('Signature')
        if m.get('FirmwareUrl') is not None:
            self.firmware_url = m.get('FirmwareUrl')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('ObjectStorage') is not None:
            self.object_storage = m.get('ObjectStorage')
        return self


class GenerateOTAUploadURLResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: GenerateOTAUploadURLResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = GenerateOTAUploadURLResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GenerateOTAUploadURLResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GenerateOTAUploadURLResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GenerateOTAUploadURLResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDataAPIServiceDetailRequest(TeaModel):
    def __init__(
        self,
        api_srn: str = None,
        iot_instance_id: str = None,
    ):
        self.api_srn = api_srn
        self.iot_instance_id = iot_instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_srn is not None:
            result['ApiSrn'] = self.api_srn
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiSrn') is not None:
            self.api_srn = m.get('ApiSrn')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTORequestParamsRequestParams(TeaModel):
    def __init__(
        self,
        name: str = None,
        type: str = None,
        desc: str = None,
        example: str = None,
        required: bool = None,
    ):
        self.name = name
        self.type = type
        self.desc = desc
        self.example = example
        self.required = required

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.example is not None:
            result['Example'] = self.example
        if self.required is not None:
            result['Required'] = self.required
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('Example') is not None:
            self.example = m.get('Example')
        if m.get('Required') is not None:
            self.required = m.get('Required')
        return self


class GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTORequestParams(TeaModel):
    def __init__(
        self,
        request_params: List[GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTORequestParamsRequestParams] = None,
    ):
        self.request_params = request_params

    def validate(self):
        if self.request_params:
            for k in self.request_params:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['RequestParams'] = []
        if self.request_params is not None:
            for k in self.request_params:
                result['RequestParams'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.request_params = []
        if m.get('RequestParams') is not None:
            for k in m.get('RequestParams'):
                temp_model = GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTORequestParamsRequestParams()
                self.request_params.append(temp_model.from_map(k))
        return self


class GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTOResponseParamsResponseParams(TeaModel):
    def __init__(
        self,
        name: str = None,
        type: str = None,
        desc: str = None,
        example: str = None,
        required: bool = None,
    ):
        self.name = name
        self.type = type
        self.desc = desc
        self.example = example
        self.required = required

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.example is not None:
            result['Example'] = self.example
        if self.required is not None:
            result['Required'] = self.required
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('Example') is not None:
            self.example = m.get('Example')
        if m.get('Required') is not None:
            self.required = m.get('Required')
        return self


class GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTOResponseParams(TeaModel):
    def __init__(
        self,
        response_params: List[GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTOResponseParamsResponseParams] = None,
    ):
        self.response_params = response_params

    def validate(self):
        if self.response_params:
            for k in self.response_params:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ResponseParams'] = []
        if self.response_params is not None:
            for k in self.response_params:
                result['ResponseParams'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.response_params = []
        if m.get('ResponseParams') is not None:
            for k in m.get('ResponseParams'):
                temp_model = GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTOResponseParamsResponseParams()
                self.response_params.append(temp_model.from_map(k))
        return self


class GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTO(TeaModel):
    def __init__(
        self,
        origin_sql: str = None,
        template_sql: str = None,
        request_params: GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTORequestParams = None,
        response_params: GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTOResponseParams = None,
    ):
        self.origin_sql = origin_sql
        self.template_sql = template_sql
        self.request_params = request_params
        self.response_params = response_params

    def validate(self):
        if self.request_params:
            self.request_params.validate()
        if self.response_params:
            self.response_params.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.origin_sql is not None:
            result['OriginSql'] = self.origin_sql
        if self.template_sql is not None:
            result['TemplateSql'] = self.template_sql
        if self.request_params is not None:
            result['RequestParams'] = self.request_params.to_map()
        if self.response_params is not None:
            result['ResponseParams'] = self.response_params.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OriginSql') is not None:
            self.origin_sql = m.get('OriginSql')
        if m.get('TemplateSql') is not None:
            self.template_sql = m.get('TemplateSql')
        if m.get('RequestParams') is not None:
            temp_model = GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTORequestParams()
            self.request_params = temp_model.from_map(m['RequestParams'])
        if m.get('ResponseParams') is not None:
            temp_model = GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTOResponseParams()
            self.response_params = temp_model.from_map(m['ResponseParams'])
        return self


class GetDataAPIServiceDetailResponseBodyData(TeaModel):
    def __init__(
        self,
        api_srn: str = None,
        status: int = None,
        display_name: str = None,
        api_path: str = None,
        create_time: int = None,
        last_update_time: int = None,
        date_format: str = None,
        request_method: str = None,
        request_protocol: str = None,
        description: str = None,
        sql_template_dto: GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTO = None,
    ):
        self.api_srn = api_srn
        self.status = status
        self.display_name = display_name
        self.api_path = api_path
        self.create_time = create_time
        self.last_update_time = last_update_time
        self.date_format = date_format
        self.request_method = request_method
        self.request_protocol = request_protocol
        self.description = description
        self.sql_template_dto = sql_template_dto

    def validate(self):
        if self.sql_template_dto:
            self.sql_template_dto.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_srn is not None:
            result['ApiSrn'] = self.api_srn
        if self.status is not None:
            result['Status'] = self.status
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.api_path is not None:
            result['ApiPath'] = self.api_path
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.last_update_time is not None:
            result['LastUpdateTime'] = self.last_update_time
        if self.date_format is not None:
            result['DateFormat'] = self.date_format
        if self.request_method is not None:
            result['RequestMethod'] = self.request_method
        if self.request_protocol is not None:
            result['RequestProtocol'] = self.request_protocol
        if self.description is not None:
            result['Description'] = self.description
        if self.sql_template_dto is not None:
            result['SqlTemplateDTO'] = self.sql_template_dto.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiSrn') is not None:
            self.api_srn = m.get('ApiSrn')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('ApiPath') is not None:
            self.api_path = m.get('ApiPath')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('LastUpdateTime') is not None:
            self.last_update_time = m.get('LastUpdateTime')
        if m.get('DateFormat') is not None:
            self.date_format = m.get('DateFormat')
        if m.get('RequestMethod') is not None:
            self.request_method = m.get('RequestMethod')
        if m.get('RequestProtocol') is not None:
            self.request_protocol = m.get('RequestProtocol')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('SqlTemplateDTO') is not None:
            temp_model = GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTO()
            self.sql_template_dto = temp_model.from_map(m['SqlTemplateDTO'])
        return self


class GetDataAPIServiceDetailResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: GetDataAPIServiceDetailResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = GetDataAPIServiceDetailResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetDataAPIServiceDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetDataAPIServiceDetailResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDataAPIServiceDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDeviceShadowRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
        device_name: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.device_name = device_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        return self


class GetDeviceShadowResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        shadow_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.shadow_message = shadow_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.shadow_message is not None:
            result['ShadowMessage'] = self.shadow_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ShadowMessage') is not None:
            self.shadow_message = m.get('ShadowMessage')
        return self


class GetDeviceShadowResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetDeviceShadowResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDeviceShadowResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDeviceStatusRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
        device_name: str = None,
        iot_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.device_name = device_name
        self.iot_id = iot_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class GetDeviceStatusResponseBodyData(TeaModel):
    def __init__(
        self,
        status: str = None,
        timestamp: int = None,
    ):
        self.status = status
        self.timestamp = timestamp

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        return self


class GetDeviceStatusResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: GetDeviceStatusResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = GetDeviceStatusResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetDeviceStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetDeviceStatusResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDeviceStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDeviceTunnelShareStatusRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
        device_name: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.device_name = device_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        return self


class GetDeviceTunnelShareStatusResponseBodyData(TeaModel):
    def __init__(
        self,
        share_id: str = None,
        password: str = None,
        is_open: bool = None,
        gmt_opened: int = None,
    ):
        self.share_id = share_id
        self.password = password
        self.is_open = is_open
        self.gmt_opened = gmt_opened

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.share_id is not None:
            result['ShareId'] = self.share_id
        if self.password is not None:
            result['Password'] = self.password
        if self.is_open is not None:
            result['IsOpen'] = self.is_open
        if self.gmt_opened is not None:
            result['GmtOpened'] = self.gmt_opened
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ShareId') is not None:
            self.share_id = m.get('ShareId')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('IsOpen') is not None:
            self.is_open = m.get('IsOpen')
        if m.get('GmtOpened') is not None:
            self.gmt_opened = m.get('GmtOpened')
        return self


class GetDeviceTunnelShareStatusResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_message: str = None,
        code: str = None,
        data: GetDeviceTunnelShareStatusResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_message = error_message
        self.code = code
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetDeviceTunnelShareStatusResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetDeviceTunnelShareStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetDeviceTunnelShareStatusResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDeviceTunnelShareStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDeviceTunnelStatusRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
        device_name: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.device_name = device_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        return self


class GetDeviceTunnelStatusResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_message: str = None,
        code: str = None,
        data: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_message = error_message
        self.code = code
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class GetDeviceTunnelStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetDeviceTunnelStatusResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDeviceTunnelStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetEdgeDriverVersionRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        driver_id: str = None,
        driver_version: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.driver_id = driver_id
        self.driver_version = driver_version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.driver_version is not None:
            result['DriverVersion'] = self.driver_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('DriverVersion') is not None:
            self.driver_version = m.get('DriverVersion')
        return self


class GetEdgeDriverVersionResponseBodyData(TeaModel):
    def __init__(
        self,
        driver_id: str = None,
        driver_version: str = None,
        version_state: str = None,
        edge_version: str = None,
        description: str = None,
        source_config: str = None,
        driver_config: str = None,
        container_config: str = None,
        config_check_rule: str = None,
        gmt_create_timestamp: int = None,
        gmt_modified_timestamp: int = None,
        argument: str = None,
    ):
        self.driver_id = driver_id
        self.driver_version = driver_version
        self.version_state = version_state
        self.edge_version = edge_version
        self.description = description
        self.source_config = source_config
        self.driver_config = driver_config
        self.container_config = container_config
        self.config_check_rule = config_check_rule
        self.gmt_create_timestamp = gmt_create_timestamp
        self.gmt_modified_timestamp = gmt_modified_timestamp
        self.argument = argument

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.driver_version is not None:
            result['DriverVersion'] = self.driver_version
        if self.version_state is not None:
            result['VersionState'] = self.version_state
        if self.edge_version is not None:
            result['EdgeVersion'] = self.edge_version
        if self.description is not None:
            result['Description'] = self.description
        if self.source_config is not None:
            result['SourceConfig'] = self.source_config
        if self.driver_config is not None:
            result['DriverConfig'] = self.driver_config
        if self.container_config is not None:
            result['ContainerConfig'] = self.container_config
        if self.config_check_rule is not None:
            result['ConfigCheckRule'] = self.config_check_rule
        if self.gmt_create_timestamp is not None:
            result['GmtCreateTimestamp'] = self.gmt_create_timestamp
        if self.gmt_modified_timestamp is not None:
            result['GmtModifiedTimestamp'] = self.gmt_modified_timestamp
        if self.argument is not None:
            result['Argument'] = self.argument
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('DriverVersion') is not None:
            self.driver_version = m.get('DriverVersion')
        if m.get('VersionState') is not None:
            self.version_state = m.get('VersionState')
        if m.get('EdgeVersion') is not None:
            self.edge_version = m.get('EdgeVersion')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('SourceConfig') is not None:
            self.source_config = m.get('SourceConfig')
        if m.get('DriverConfig') is not None:
            self.driver_config = m.get('DriverConfig')
        if m.get('ContainerConfig') is not None:
            self.container_config = m.get('ContainerConfig')
        if m.get('ConfigCheckRule') is not None:
            self.config_check_rule = m.get('ConfigCheckRule')
        if m.get('GmtCreateTimestamp') is not None:
            self.gmt_create_timestamp = m.get('GmtCreateTimestamp')
        if m.get('GmtModifiedTimestamp') is not None:
            self.gmt_modified_timestamp = m.get('GmtModifiedTimestamp')
        if m.get('Argument') is not None:
            self.argument = m.get('Argument')
        return self


class GetEdgeDriverVersionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: GetEdgeDriverVersionResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = GetEdgeDriverVersionResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetEdgeDriverVersionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetEdgeDriverVersionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetEdgeDriverVersionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetEdgeInstanceRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetEdgeInstanceResponseBodyData(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        name: str = None,
        tags: str = None,
        type: str = None,
        spec: int = None,
        biz_enable: bool = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        role_arn: str = None,
        role_name: str = None,
        role_attach_time: str = None,
        latest_deployment_status: int = None,
        latest_deployment_type: str = None,
        gmt_create_timestamp: int = None,
        gmt_modified_timestamp: int = None,
        role_attach_timestamp: int = None,
    ):
        self.instance_id = instance_id
        self.name = name
        self.tags = tags
        self.type = type
        self.spec = spec
        self.biz_enable = biz_enable
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.role_arn = role_arn
        self.role_name = role_name
        self.role_attach_time = role_attach_time
        self.latest_deployment_status = latest_deployment_status
        self.latest_deployment_type = latest_deployment_type
        self.gmt_create_timestamp = gmt_create_timestamp
        self.gmt_modified_timestamp = gmt_modified_timestamp
        self.role_attach_timestamp = role_attach_timestamp

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.type is not None:
            result['Type'] = self.type
        if self.spec is not None:
            result['Spec'] = self.spec
        if self.biz_enable is not None:
            result['BizEnable'] = self.biz_enable
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.role_arn is not None:
            result['RoleArn'] = self.role_arn
        if self.role_name is not None:
            result['RoleName'] = self.role_name
        if self.role_attach_time is not None:
            result['RoleAttachTime'] = self.role_attach_time
        if self.latest_deployment_status is not None:
            result['LatestDeploymentStatus'] = self.latest_deployment_status
        if self.latest_deployment_type is not None:
            result['LatestDeploymentType'] = self.latest_deployment_type
        if self.gmt_create_timestamp is not None:
            result['GmtCreateTimestamp'] = self.gmt_create_timestamp
        if self.gmt_modified_timestamp is not None:
            result['GmtModifiedTimestamp'] = self.gmt_modified_timestamp
        if self.role_attach_timestamp is not None:
            result['RoleAttachTimestamp'] = self.role_attach_timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Spec') is not None:
            self.spec = m.get('Spec')
        if m.get('BizEnable') is not None:
            self.biz_enable = m.get('BizEnable')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('RoleArn') is not None:
            self.role_arn = m.get('RoleArn')
        if m.get('RoleName') is not None:
            self.role_name = m.get('RoleName')
        if m.get('RoleAttachTime') is not None:
            self.role_attach_time = m.get('RoleAttachTime')
        if m.get('LatestDeploymentStatus') is not None:
            self.latest_deployment_status = m.get('LatestDeploymentStatus')
        if m.get('LatestDeploymentType') is not None:
            self.latest_deployment_type = m.get('LatestDeploymentType')
        if m.get('GmtCreateTimestamp') is not None:
            self.gmt_create_timestamp = m.get('GmtCreateTimestamp')
        if m.get('GmtModifiedTimestamp') is not None:
            self.gmt_modified_timestamp = m.get('GmtModifiedTimestamp')
        if m.get('RoleAttachTimestamp') is not None:
            self.role_attach_timestamp = m.get('RoleAttachTimestamp')
        return self


class GetEdgeInstanceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: GetEdgeInstanceResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = GetEdgeInstanceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetEdgeInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetEdgeInstanceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetEdgeInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetEdgeInstanceDeploymentRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
        deployment_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.deployment_id = deployment_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.deployment_id is not None:
            result['DeploymentId'] = self.deployment_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DeploymentId') is not None:
            self.deployment_id = m.get('DeploymentId')
        return self


class GetEdgeInstanceDeploymentResponseBodyDataTaskListResourceSnapshotList(TeaModel):
    def __init__(
        self,
        gmt_create: str = None,
        gmt_modified: str = None,
        gmt_completed: str = None,
        snapshot_id: str = None,
        resource_type: str = None,
        resource_id: str = None,
        resource_name: str = None,
        operate_type: int = None,
        stage: int = None,
        status: int = None,
        log: str = None,
        gmt_create_timestamp: int = None,
        gmt_modified_timestamp: int = None,
        gmt_completed_timestamp: int = None,
    ):
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.gmt_completed = gmt_completed
        self.snapshot_id = snapshot_id
        self.resource_type = resource_type
        self.resource_id = resource_id
        self.resource_name = resource_name
        self.operate_type = operate_type
        self.stage = stage
        self.status = status
        self.log = log
        self.gmt_create_timestamp = gmt_create_timestamp
        self.gmt_modified_timestamp = gmt_modified_timestamp
        self.gmt_completed_timestamp = gmt_completed_timestamp

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.gmt_completed is not None:
            result['GmtCompleted'] = self.gmt_completed
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_name is not None:
            result['ResourceName'] = self.resource_name
        if self.operate_type is not None:
            result['OperateType'] = self.operate_type
        if self.stage is not None:
            result['Stage'] = self.stage
        if self.status is not None:
            result['Status'] = self.status
        if self.log is not None:
            result['Log'] = self.log
        if self.gmt_create_timestamp is not None:
            result['GmtCreateTimestamp'] = self.gmt_create_timestamp
        if self.gmt_modified_timestamp is not None:
            result['GmtModifiedTimestamp'] = self.gmt_modified_timestamp
        if self.gmt_completed_timestamp is not None:
            result['GmtCompletedTimestamp'] = self.gmt_completed_timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('GmtCompleted') is not None:
            self.gmt_completed = m.get('GmtCompleted')
        if m.get('SnapshotId') is not None:
            self.snapshot_id = m.get('SnapshotId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceName') is not None:
            self.resource_name = m.get('ResourceName')
        if m.get('OperateType') is not None:
            self.operate_type = m.get('OperateType')
        if m.get('Stage') is not None:
            self.stage = m.get('Stage')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Log') is not None:
            self.log = m.get('Log')
        if m.get('GmtCreateTimestamp') is not None:
            self.gmt_create_timestamp = m.get('GmtCreateTimestamp')
        if m.get('GmtModifiedTimestamp') is not None:
            self.gmt_modified_timestamp = m.get('GmtModifiedTimestamp')
        if m.get('GmtCompletedTimestamp') is not None:
            self.gmt_completed_timestamp = m.get('GmtCompletedTimestamp')
        return self


class GetEdgeInstanceDeploymentResponseBodyDataTaskList(TeaModel):
    def __init__(
        self,
        gmt_create: str = None,
        gmt_modified: str = None,
        gmt_completed: str = None,
        gateway_id: str = None,
        task_id: str = None,
        stage: int = None,
        status: int = None,
        gmt_create_timestamp: int = None,
        gmt_modified_timestamp: int = None,
        gmt_completed_timestamp: int = None,
        resource_snapshot_list: List[GetEdgeInstanceDeploymentResponseBodyDataTaskListResourceSnapshotList] = None,
    ):
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.gmt_completed = gmt_completed
        self.gateway_id = gateway_id
        self.task_id = task_id
        self.stage = stage
        self.status = status
        self.gmt_create_timestamp = gmt_create_timestamp
        self.gmt_modified_timestamp = gmt_modified_timestamp
        self.gmt_completed_timestamp = gmt_completed_timestamp
        self.resource_snapshot_list = resource_snapshot_list

    def validate(self):
        if self.resource_snapshot_list:
            for k in self.resource_snapshot_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.gmt_completed is not None:
            result['GmtCompleted'] = self.gmt_completed
        if self.gateway_id is not None:
            result['GatewayId'] = self.gateway_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.stage is not None:
            result['Stage'] = self.stage
        if self.status is not None:
            result['Status'] = self.status
        if self.gmt_create_timestamp is not None:
            result['GmtCreateTimestamp'] = self.gmt_create_timestamp
        if self.gmt_modified_timestamp is not None:
            result['GmtModifiedTimestamp'] = self.gmt_modified_timestamp
        if self.gmt_completed_timestamp is not None:
            result['GmtCompletedTimestamp'] = self.gmt_completed_timestamp
        result['ResourceSnapshotList'] = []
        if self.resource_snapshot_list is not None:
            for k in self.resource_snapshot_list:
                result['ResourceSnapshotList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('GmtCompleted') is not None:
            self.gmt_completed = m.get('GmtCompleted')
        if m.get('GatewayId') is not None:
            self.gateway_id = m.get('GatewayId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('Stage') is not None:
            self.stage = m.get('Stage')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('GmtCreateTimestamp') is not None:
            self.gmt_create_timestamp = m.get('GmtCreateTimestamp')
        if m.get('GmtModifiedTimestamp') is not None:
            self.gmt_modified_timestamp = m.get('GmtModifiedTimestamp')
        if m.get('GmtCompletedTimestamp') is not None:
            self.gmt_completed_timestamp = m.get('GmtCompletedTimestamp')
        self.resource_snapshot_list = []
        if m.get('ResourceSnapshotList') is not None:
            for k in m.get('ResourceSnapshotList'):
                temp_model = GetEdgeInstanceDeploymentResponseBodyDataTaskListResourceSnapshotList()
                self.resource_snapshot_list.append(temp_model.from_map(k))
        return self


class GetEdgeInstanceDeploymentResponseBodyData(TeaModel):
    def __init__(
        self,
        gmt_create: str = None,
        gmt_modified: str = None,
        gmt_completed: str = None,
        deployment_id: str = None,
        description: str = None,
        status: int = None,
        type: str = None,
        gmt_create_timestamp: int = None,
        gmt_modified_timestamp: int = None,
        gmt_completed_timestamp: int = None,
        task_list: List[GetEdgeInstanceDeploymentResponseBodyDataTaskList] = None,
    ):
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.gmt_completed = gmt_completed
        self.deployment_id = deployment_id
        self.description = description
        self.status = status
        self.type = type
        self.gmt_create_timestamp = gmt_create_timestamp
        self.gmt_modified_timestamp = gmt_modified_timestamp
        self.gmt_completed_timestamp = gmt_completed_timestamp
        self.task_list = task_list

    def validate(self):
        if self.task_list:
            for k in self.task_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.gmt_completed is not None:
            result['GmtCompleted'] = self.gmt_completed
        if self.deployment_id is not None:
            result['DeploymentId'] = self.deployment_id
        if self.description is not None:
            result['Description'] = self.description
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.gmt_create_timestamp is not None:
            result['GmtCreateTimestamp'] = self.gmt_create_timestamp
        if self.gmt_modified_timestamp is not None:
            result['GmtModifiedTimestamp'] = self.gmt_modified_timestamp
        if self.gmt_completed_timestamp is not None:
            result['GmtCompletedTimestamp'] = self.gmt_completed_timestamp
        result['TaskList'] = []
        if self.task_list is not None:
            for k in self.task_list:
                result['TaskList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('GmtCompleted') is not None:
            self.gmt_completed = m.get('GmtCompleted')
        if m.get('DeploymentId') is not None:
            self.deployment_id = m.get('DeploymentId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('GmtCreateTimestamp') is not None:
            self.gmt_create_timestamp = m.get('GmtCreateTimestamp')
        if m.get('GmtModifiedTimestamp') is not None:
            self.gmt_modified_timestamp = m.get('GmtModifiedTimestamp')
        if m.get('GmtCompletedTimestamp') is not None:
            self.gmt_completed_timestamp = m.get('GmtCompletedTimestamp')
        self.task_list = []
        if m.get('TaskList') is not None:
            for k in m.get('TaskList'):
                temp_model = GetEdgeInstanceDeploymentResponseBodyDataTaskList()
                self.task_list.append(temp_model.from_map(k))
        return self


class GetEdgeInstanceDeploymentResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: GetEdgeInstanceDeploymentResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = GetEdgeInstanceDeploymentResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetEdgeInstanceDeploymentResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetEdgeInstanceDeploymentResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetEdgeInstanceDeploymentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetEdgeInstanceMessageRoutingRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
        route_id: int = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.route_id = route_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.route_id is not None:
            result['RouteId'] = self.route_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RouteId') is not None:
            self.route_id = m.get('RouteId')
        return self


class GetEdgeInstanceMessageRoutingResponseBodyDataRouteContext(TeaModel):
    def __init__(
        self,
        source_fc_service_name: str = None,
        source_fc_function_name: str = None,
        source_application_name: str = None,
        target_fc_service_name: str = None,
        target_fc_function_name: str = None,
        target_application_name: str = None,
        qos: str = None,
    ):
        self.source_fc_service_name = source_fc_service_name
        self.source_fc_function_name = source_fc_function_name
        self.source_application_name = source_application_name
        self.target_fc_service_name = target_fc_service_name
        self.target_fc_function_name = target_fc_function_name
        self.target_application_name = target_application_name
        self.qos = qos

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_fc_service_name is not None:
            result['SourceFcServiceName'] = self.source_fc_service_name
        if self.source_fc_function_name is not None:
            result['SourceFcFunctionName'] = self.source_fc_function_name
        if self.source_application_name is not None:
            result['SourceApplicationName'] = self.source_application_name
        if self.target_fc_service_name is not None:
            result['TargetFcServiceName'] = self.target_fc_service_name
        if self.target_fc_function_name is not None:
            result['TargetFcFunctionName'] = self.target_fc_function_name
        if self.target_application_name is not None:
            result['TargetApplicationName'] = self.target_application_name
        if self.qos is not None:
            result['Qos'] = self.qos
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceFcServiceName') is not None:
            self.source_fc_service_name = m.get('SourceFcServiceName')
        if m.get('SourceFcFunctionName') is not None:
            self.source_fc_function_name = m.get('SourceFcFunctionName')
        if m.get('SourceApplicationName') is not None:
            self.source_application_name = m.get('SourceApplicationName')
        if m.get('TargetFcServiceName') is not None:
            self.target_fc_service_name = m.get('TargetFcServiceName')
        if m.get('TargetFcFunctionName') is not None:
            self.target_fc_function_name = m.get('TargetFcFunctionName')
        if m.get('TargetApplicationName') is not None:
            self.target_application_name = m.get('TargetApplicationName')
        if m.get('Qos') is not None:
            self.qos = m.get('Qos')
        return self


class GetEdgeInstanceMessageRoutingResponseBodyData(TeaModel):
    def __init__(
        self,
        topic_filter: str = None,
        source_type: str = None,
        name: str = None,
        source_data: str = None,
        target_type: str = None,
        target_data: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        gmt_create_timestamp: int = None,
        gmt_modified_timestamp: int = None,
        route_context: GetEdgeInstanceMessageRoutingResponseBodyDataRouteContext = None,
    ):
        self.topic_filter = topic_filter
        self.source_type = source_type
        self.name = name
        self.source_data = source_data
        self.target_type = target_type
        self.target_data = target_data
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.gmt_create_timestamp = gmt_create_timestamp
        self.gmt_modified_timestamp = gmt_modified_timestamp
        self.route_context = route_context

    def validate(self):
        if self.route_context:
            self.route_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.topic_filter is not None:
            result['TopicFilter'] = self.topic_filter
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.name is not None:
            result['Name'] = self.name
        if self.source_data is not None:
            result['SourceData'] = self.source_data
        if self.target_type is not None:
            result['TargetType'] = self.target_type
        if self.target_data is not None:
            result['TargetData'] = self.target_data
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.gmt_create_timestamp is not None:
            result['GmtCreateTimestamp'] = self.gmt_create_timestamp
        if self.gmt_modified_timestamp is not None:
            result['GmtModifiedTimestamp'] = self.gmt_modified_timestamp
        if self.route_context is not None:
            result['RouteContext'] = self.route_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TopicFilter') is not None:
            self.topic_filter = m.get('TopicFilter')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('SourceData') is not None:
            self.source_data = m.get('SourceData')
        if m.get('TargetType') is not None:
            self.target_type = m.get('TargetType')
        if m.get('TargetData') is not None:
            self.target_data = m.get('TargetData')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('GmtCreateTimestamp') is not None:
            self.gmt_create_timestamp = m.get('GmtCreateTimestamp')
        if m.get('GmtModifiedTimestamp') is not None:
            self.gmt_modified_timestamp = m.get('GmtModifiedTimestamp')
        if m.get('RouteContext') is not None:
            temp_model = GetEdgeInstanceMessageRoutingResponseBodyDataRouteContext()
            self.route_context = temp_model.from_map(m['RouteContext'])
        return self


class GetEdgeInstanceMessageRoutingResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: GetEdgeInstanceMessageRoutingResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = GetEdgeInstanceMessageRoutingResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetEdgeInstanceMessageRoutingResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetEdgeInstanceMessageRoutingResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetEdgeInstanceMessageRoutingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetGatewayBySubDeviceRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
        device_name: str = None,
        iot_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.device_name = device_name
        self.iot_id = iot_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class GetGatewayBySubDeviceResponseBodyData(TeaModel):
    def __init__(
        self,
        product_key: str = None,
        product_name: str = None,
        device_secret: str = None,
        device_name: str = None,
        firmware_version: str = None,
        gmt_create: str = None,
        utc_create: str = None,
        gmt_active: str = None,
        utc_active: str = None,
        gmt_online: str = None,
        utc_online: str = None,
        status: str = None,
        ip_address: str = None,
        node_type: str = None,
        region: str = None,
        iot_id: str = None,
    ):
        self.product_key = product_key
        self.product_name = product_name
        self.device_secret = device_secret
        self.device_name = device_name
        self.firmware_version = firmware_version
        self.gmt_create = gmt_create
        self.utc_create = utc_create
        self.gmt_active = gmt_active
        self.utc_active = utc_active
        self.gmt_online = gmt_online
        self.utc_online = utc_online
        self.status = status
        self.ip_address = ip_address
        self.node_type = node_type
        self.region = region
        self.iot_id = iot_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.device_secret is not None:
            result['DeviceSecret'] = self.device_secret
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.firmware_version is not None:
            result['FirmwareVersion'] = self.firmware_version
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.gmt_active is not None:
            result['GmtActive'] = self.gmt_active
        if self.utc_active is not None:
            result['UtcActive'] = self.utc_active
        if self.gmt_online is not None:
            result['GmtOnline'] = self.gmt_online
        if self.utc_online is not None:
            result['UtcOnline'] = self.utc_online
        if self.status is not None:
            result['Status'] = self.status
        if self.ip_address is not None:
            result['IpAddress'] = self.ip_address
        if self.node_type is not None:
            result['NodeType'] = self.node_type
        if self.region is not None:
            result['region'] = self.region
        if self.iot_id is not None:
            result['iotId'] = self.iot_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('DeviceSecret') is not None:
            self.device_secret = m.get('DeviceSecret')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('FirmwareVersion') is not None:
            self.firmware_version = m.get('FirmwareVersion')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('GmtActive') is not None:
            self.gmt_active = m.get('GmtActive')
        if m.get('UtcActive') is not None:
            self.utc_active = m.get('UtcActive')
        if m.get('GmtOnline') is not None:
            self.gmt_online = m.get('GmtOnline')
        if m.get('UtcOnline') is not None:
            self.utc_online = m.get('UtcOnline')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('IpAddress') is not None:
            self.ip_address = m.get('IpAddress')
        if m.get('NodeType') is not None:
            self.node_type = m.get('NodeType')
        if m.get('region') is not None:
            self.region = m.get('region')
        if m.get('iotId') is not None:
            self.iot_id = m.get('iotId')
        return self


class GetGatewayBySubDeviceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: GetGatewayBySubDeviceResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = GetGatewayBySubDeviceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetGatewayBySubDeviceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetGatewayBySubDeviceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetGatewayBySubDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetLoraNodesTaskRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        task_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class GetLoraNodesTaskResponseBodySuccessDevEuis(TeaModel):
    def __init__(
        self,
        success_dev_eui: List[str] = None,
    ):
        self.success_dev_eui = success_dev_eui

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success_dev_eui is not None:
            result['SuccessDevEui'] = self.success_dev_eui
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SuccessDevEui') is not None:
            self.success_dev_eui = m.get('SuccessDevEui')
        return self


class GetLoraNodesTaskResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        task_id: str = None,
        task_state: str = None,
        total_count: int = None,
        success_count: int = None,
        success_dev_euis: GetLoraNodesTaskResponseBodySuccessDevEuis = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.task_id = task_id
        self.task_state = task_state
        self.total_count = total_count
        self.success_count = success_count
        self.success_dev_euis = success_dev_euis

    def validate(self):
        if self.success_dev_euis:
            self.success_dev_euis.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_state is not None:
            result['TaskState'] = self.task_state
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.success_count is not None:
            result['SuccessCount'] = self.success_count
        if self.success_dev_euis is not None:
            result['SuccessDevEuis'] = self.success_dev_euis.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskState') is not None:
            self.task_state = m.get('TaskState')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('SuccessCount') is not None:
            self.success_count = m.get('SuccessCount')
        if m.get('SuccessDevEuis') is not None:
            temp_model = GetLoraNodesTaskResponseBodySuccessDevEuis()
            self.success_dev_euis = temp_model.from_map(m['SuccessDevEuis'])
        return self


class GetLoraNodesTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetLoraNodesTaskResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetLoraNodesTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetNodesAddingTaskRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        task_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class GetNodesAddingTaskResponseBodySuccessDevEuis(TeaModel):
    def __init__(
        self,
        success_dev_eui: List[str] = None,
    ):
        self.success_dev_eui = success_dev_eui

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success_dev_eui is not None:
            result['SuccessDevEui'] = self.success_dev_eui
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SuccessDevEui') is not None:
            self.success_dev_eui = m.get('SuccessDevEui')
        return self


class GetNodesAddingTaskResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        task_id: str = None,
        task_state: str = None,
        total_count: int = None,
        success_count: int = None,
        success_dev_euis: GetNodesAddingTaskResponseBodySuccessDevEuis = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.task_id = task_id
        self.task_state = task_state
        self.total_count = total_count
        self.success_count = success_count
        self.success_dev_euis = success_dev_euis

    def validate(self):
        if self.success_dev_euis:
            self.success_dev_euis.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_state is not None:
            result['TaskState'] = self.task_state
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.success_count is not None:
            result['SuccessCount'] = self.success_count
        if self.success_dev_euis is not None:
            result['SuccessDevEuis'] = self.success_dev_euis.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskState') is not None:
            self.task_state = m.get('TaskState')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('SuccessCount') is not None:
            self.success_count = m.get('SuccessCount')
        if m.get('SuccessDevEuis') is not None:
            temp_model = GetNodesAddingTaskResponseBodySuccessDevEuis()
            self.success_dev_euis = temp_model.from_map(m['SuccessDevEuis'])
        return self


class GetNodesAddingTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetNodesAddingTaskResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetNodesAddingTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetRuleRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        rule_id: int = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.rule_id = rule_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class GetRuleResponseBodyRuleInfo(TeaModel):
    def __init__(
        self,
        id: int = None,
        select: str = None,
        topic: str = None,
        short_topic: str = None,
        where: str = None,
        status: str = None,
        create_user_id: int = None,
        product_key: str = None,
        name: str = None,
        rule_desc: str = None,
        data_type: str = None,
        created: str = None,
        utc_created: str = None,
        modified: str = None,
        utc_modified: str = None,
        topic_type: int = None,
    ):
        self.id = id
        self.select = select
        self.topic = topic
        self.short_topic = short_topic
        self.where = where
        self.status = status
        self.create_user_id = create_user_id
        self.product_key = product_key
        self.name = name
        self.rule_desc = rule_desc
        self.data_type = data_type
        self.created = created
        self.utc_created = utc_created
        self.modified = modified
        self.utc_modified = utc_modified
        self.topic_type = topic_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.select is not None:
            result['Select'] = self.select
        if self.topic is not None:
            result['Topic'] = self.topic
        if self.short_topic is not None:
            result['ShortTopic'] = self.short_topic
        if self.where is not None:
            result['Where'] = self.where
        if self.status is not None:
            result['Status'] = self.status
        if self.create_user_id is not None:
            result['CreateUserId'] = self.create_user_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.name is not None:
            result['Name'] = self.name
        if self.rule_desc is not None:
            result['RuleDesc'] = self.rule_desc
        if self.data_type is not None:
            result['DataType'] = self.data_type
        if self.created is not None:
            result['Created'] = self.created
        if self.utc_created is not None:
            result['UtcCreated'] = self.utc_created
        if self.modified is not None:
            result['Modified'] = self.modified
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.topic_type is not None:
            result['TopicType'] = self.topic_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Select') is not None:
            self.select = m.get('Select')
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        if m.get('ShortTopic') is not None:
            self.short_topic = m.get('ShortTopic')
        if m.get('Where') is not None:
            self.where = m.get('Where')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('CreateUserId') is not None:
            self.create_user_id = m.get('CreateUserId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RuleDesc') is not None:
            self.rule_desc = m.get('RuleDesc')
        if m.get('DataType') is not None:
            self.data_type = m.get('DataType')
        if m.get('Created') is not None:
            self.created = m.get('Created')
        if m.get('UtcCreated') is not None:
            self.utc_created = m.get('UtcCreated')
        if m.get('Modified') is not None:
            self.modified = m.get('Modified')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('TopicType') is not None:
            self.topic_type = m.get('TopicType')
        return self


class GetRuleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        rule_info: GetRuleResponseBodyRuleInfo = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.rule_info = rule_info

    def validate(self):
        if self.rule_info:
            self.rule_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.rule_info is not None:
            result['RuleInfo'] = self.rule_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RuleInfo') is not None:
            temp_model = GetRuleResponseBodyRuleInfo()
            self.rule_info = temp_model.from_map(m['RuleInfo'])
        return self


class GetRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetRuleResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetRuleActionRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        action_id: int = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.action_id = action_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.action_id is not None:
            result['ActionId'] = self.action_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ActionId') is not None:
            self.action_id = m.get('ActionId')
        return self


class GetRuleActionResponseBodyRuleActionInfo(TeaModel):
    def __init__(
        self,
        id: int = None,
        rule_id: int = None,
        type: str = None,
        configuration: str = None,
        error_action_flag: bool = None,
    ):
        self.id = id
        self.rule_id = rule_id
        self.type = type
        self.configuration = configuration
        self.error_action_flag = error_action_flag

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.type is not None:
            result['Type'] = self.type
        if self.configuration is not None:
            result['Configuration'] = self.configuration
        if self.error_action_flag is not None:
            result['ErrorActionFlag'] = self.error_action_flag
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Configuration') is not None:
            self.configuration = m.get('Configuration')
        if m.get('ErrorActionFlag') is not None:
            self.error_action_flag = m.get('ErrorActionFlag')
        return self


class GetRuleActionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        rule_action_info: GetRuleActionResponseBodyRuleActionInfo = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.rule_action_info = rule_action_info

    def validate(self):
        if self.rule_action_info:
            self.rule_action_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.rule_action_info is not None:
            result['RuleActionInfo'] = self.rule_action_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RuleActionInfo') is not None:
            temp_model = GetRuleActionResponseBodyRuleActionInfo()
            self.rule_action_info = temp_model.from_map(m['RuleActionInfo'])
        return self


class GetRuleActionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetRuleActionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetRuleActionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSceneRuleRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        rule_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.rule_id = rule_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class GetSceneRuleResponseBodyData(TeaModel):
    def __init__(
        self,
        gmt_create: int = None,
        gmt_modified: int = None,
        rule_name: str = None,
        rule_content: str = None,
        rule_description: str = None,
        rule_status: int = None,
    ):
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.rule_name = rule_name
        self.rule_content = rule_content
        self.rule_description = rule_description
        self.rule_status = rule_status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.rule_content is not None:
            result['RuleContent'] = self.rule_content
        if self.rule_description is not None:
            result['RuleDescription'] = self.rule_description
        if self.rule_status is not None:
            result['RuleStatus'] = self.rule_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('RuleContent') is not None:
            self.rule_content = m.get('RuleContent')
        if m.get('RuleDescription') is not None:
            self.rule_description = m.get('RuleDescription')
        if m.get('RuleStatus') is not None:
            self.rule_status = m.get('RuleStatus')
        return self


class GetSceneRuleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_message: str = None,
        code: str = None,
        data: GetSceneRuleResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_message = error_message
        self.code = code
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetSceneRuleResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetSceneRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetSceneRuleResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetSceneRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSpeechVoiceResponseBodyDataItemsVoiceListItems(TeaModel):
    def __init__(
        self,
        value: str = None,
        label: str = None,
    ):
        self.value = value
        self.label = label

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.value is not None:
            result['Value'] = self.value
        if self.label is not None:
            result['Label'] = self.label
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('Label') is not None:
            self.label = m.get('Label')
        return self


class GetSpeechVoiceResponseBodyDataItemsVoiceList(TeaModel):
    def __init__(
        self,
        items: List[GetSpeechVoiceResponseBodyDataItemsVoiceListItems] = None,
    ):
        self.items = items

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Items'] = []
        if self.items is not None:
            for k in self.items:
                result['Items'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.items = []
        if m.get('Items') is not None:
            for k in m.get('Items'):
                temp_model = GetSpeechVoiceResponseBodyDataItemsVoiceListItems()
                self.items.append(temp_model.from_map(k))
        return self


class GetSpeechVoiceResponseBodyDataItems(TeaModel):
    def __init__(
        self,
        value: str = None,
        label: str = None,
        voice_list: GetSpeechVoiceResponseBodyDataItemsVoiceList = None,
    ):
        self.value = value
        self.label = label
        self.voice_list = voice_list

    def validate(self):
        if self.voice_list:
            self.voice_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.value is not None:
            result['Value'] = self.value
        if self.label is not None:
            result['Label'] = self.label
        if self.voice_list is not None:
            result['VoiceList'] = self.voice_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('VoiceList') is not None:
            temp_model = GetSpeechVoiceResponseBodyDataItemsVoiceList()
            self.voice_list = temp_model.from_map(m['VoiceList'])
        return self


class GetSpeechVoiceResponseBodyData(TeaModel):
    def __init__(
        self,
        items: List[GetSpeechVoiceResponseBodyDataItems] = None,
    ):
        self.items = items

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Items'] = []
        if self.items is not None:
            for k in self.items:
                result['Items'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.items = []
        if m.get('Items') is not None:
            for k in m.get('Items'):
                temp_model = GetSpeechVoiceResponseBodyDataItems()
                self.items.append(temp_model.from_map(k))
        return self


class GetSpeechVoiceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: GetSpeechVoiceResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = GetSpeechVoiceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetSpeechVoiceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetSpeechVoiceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetSpeechVoiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetStudioAppTokenOpenRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        app_id: str = None,
        project_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.app_id = app_id
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class GetStudioAppTokenOpenResponseBodyData(TeaModel):
    def __init__(
        self,
        is_enable: str = None,
        type: str = None,
        biz_type: str = None,
        token: str = None,
        biz_id: str = None,
    ):
        self.is_enable = is_enable
        self.type = type
        self.biz_type = biz_type
        self.token = token
        self.biz_id = biz_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_enable is not None:
            result['IsEnable'] = self.is_enable
        if self.type is not None:
            result['Type'] = self.type
        if self.biz_type is not None:
            result['BizType'] = self.biz_type
        if self.token is not None:
            result['Token'] = self.token
        if self.biz_id is not None:
            result['BizId'] = self.biz_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IsEnable') is not None:
            self.is_enable = m.get('IsEnable')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('BizType') is not None:
            self.biz_type = m.get('BizType')
        if m.get('Token') is not None:
            self.token = m.get('Token')
        if m.get('BizId') is not None:
            self.biz_id = m.get('BizId')
        return self


class GetStudioAppTokenOpenResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: GetStudioAppTokenOpenResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = GetStudioAppTokenOpenResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetStudioAppTokenOpenResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetStudioAppTokenOpenResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetStudioAppTokenOpenResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetThingModelTslRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
        model_version: str = None,
        simple: bool = None,
        function_block_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.model_version = model_version
        self.simple = simple
        self.function_block_id = function_block_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.model_version is not None:
            result['ModelVersion'] = self.model_version
        if self.simple is not None:
            result['Simple'] = self.simple
        if self.function_block_id is not None:
            result['FunctionBlockId'] = self.function_block_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ModelVersion') is not None:
            self.model_version = m.get('ModelVersion')
        if m.get('Simple') is not None:
            self.simple = m.get('Simple')
        if m.get('FunctionBlockId') is not None:
            self.function_block_id = m.get('FunctionBlockId')
        return self


class GetThingModelTslResponseBodyData(TeaModel):
    def __init__(
        self,
        tsl_str: str = None,
        tsl_uri: str = None,
    ):
        self.tsl_str = tsl_str
        self.tsl_uri = tsl_uri

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tsl_str is not None:
            result['TslStr'] = self.tsl_str
        if self.tsl_uri is not None:
            result['TslUri'] = self.tsl_uri
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TslStr') is not None:
            self.tsl_str = m.get('TslStr')
        if m.get('TslUri') is not None:
            self.tsl_uri = m.get('TslUri')
        return self


class GetThingModelTslResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: GetThingModelTslResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = GetThingModelTslResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetThingModelTslResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetThingModelTslResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetThingModelTslResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetThingModelTslPublishedRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
        resource_group_id: str = None,
        simple: bool = None,
        model_version: str = None,
        function_block_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.resource_group_id = resource_group_id
        self.simple = simple
        self.model_version = model_version
        self.function_block_id = function_block_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.simple is not None:
            result['Simple'] = self.simple
        if self.model_version is not None:
            result['ModelVersion'] = self.model_version
        if self.function_block_id is not None:
            result['FunctionBlockId'] = self.function_block_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('Simple') is not None:
            self.simple = m.get('Simple')
        if m.get('ModelVersion') is not None:
            self.model_version = m.get('ModelVersion')
        if m.get('FunctionBlockId') is not None:
            self.function_block_id = m.get('FunctionBlockId')
        return self


class GetThingModelTslPublishedResponseBodyData(TeaModel):
    def __init__(
        self,
        tsl_str: str = None,
        tsl_uri: str = None,
    ):
        self.tsl_str = tsl_str
        self.tsl_uri = tsl_uri

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tsl_str is not None:
            result['TslStr'] = self.tsl_str
        if self.tsl_uri is not None:
            result['TslUri'] = self.tsl_uri
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TslStr') is not None:
            self.tsl_str = m.get('TslStr')
        if m.get('TslUri') is not None:
            self.tsl_uri = m.get('TslUri')
        return self


class GetThingModelTslPublishedResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: GetThingModelTslPublishedResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = GetThingModelTslPublishedResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetThingModelTslPublishedResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetThingModelTslPublishedResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetThingModelTslPublishedResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetThingScriptRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class GetThingScriptResponseBodyData(TeaModel):
    def __init__(
        self,
        script_type: str = None,
        script_url: str = None,
    ):
        self.script_type = script_type
        self.script_url = script_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.script_type is not None:
            result['ScriptType'] = self.script_type
        if self.script_url is not None:
            result['ScriptUrl'] = self.script_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ScriptType') is not None:
            self.script_type = m.get('ScriptType')
        if m.get('ScriptUrl') is not None:
            self.script_url = m.get('ScriptUrl')
        return self


class GetThingScriptResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: GetThingScriptResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = GetThingScriptResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetThingScriptResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetThingScriptResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetThingScriptResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetThingTemplateRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        resource_group_id: str = None,
        category_key: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.resource_group_id = resource_group_id
        self.category_key = category_key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.category_key is not None:
            result['CategoryKey'] = self.category_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('CategoryKey') is not None:
            self.category_key = m.get('CategoryKey')
        return self


class GetThingTemplateResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        thing_model_json: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.thing_model_json = thing_model_json

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.thing_model_json is not None:
            result['ThingModelJSON'] = self.thing_model_json
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ThingModelJSON') is not None:
            self.thing_model_json = m.get('ThingModelJSON')
        return self


class GetThingTemplateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetThingTemplateResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetThingTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetThingTopoRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        page_size: int = None,
        product_key: str = None,
        device_name: str = None,
        page_no: int = None,
        iot_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.page_size = page_size
        self.product_key = product_key
        self.device_name = device_name
        self.page_no = page_no
        self.iot_id = iot_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class GetThingTopoResponseBodyDataListDeviceInfo(TeaModel):
    def __init__(
        self,
        iot_id: str = None,
        product_key: str = None,
        device_name: str = None,
    ):
        self.iot_id = iot_id
        self.product_key = product_key
        self.device_name = device_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        return self


class GetThingTopoResponseBodyDataList(TeaModel):
    def __init__(
        self,
        device_info: List[GetThingTopoResponseBodyDataListDeviceInfo] = None,
    ):
        self.device_info = device_info

    def validate(self):
        if self.device_info:
            for k in self.device_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['deviceInfo'] = []
        if self.device_info is not None:
            for k in self.device_info:
                result['deviceInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.device_info = []
        if m.get('deviceInfo') is not None:
            for k in m.get('deviceInfo'):
                temp_model = GetThingTopoResponseBodyDataListDeviceInfo()
                self.device_info.append(temp_model.from_map(k))
        return self


class GetThingTopoResponseBodyData(TeaModel):
    def __init__(
        self,
        total: int = None,
        current_page: int = None,
        page_size: int = None,
        page_count: int = None,
        list: GetThingTopoResponseBodyDataList = None,
    ):
        self.total = total
        self.current_page = current_page
        self.page_size = page_size
        self.page_count = page_count
        self.list = list

    def validate(self):
        if self.list:
            self.list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total is not None:
            result['Total'] = self.total
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.list is not None:
            result['List'] = self.list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('List') is not None:
            temp_model = GetThingTopoResponseBodyDataList()
            self.list = temp_model.from_map(m['List'])
        return self


class GetThingTopoResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: GetThingTopoResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = GetThingTopoResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetThingTopoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetThingTopoResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetThingTopoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ImportThingModelTslRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        resource_group_id: str = None,
        product_key: str = None,
        tsl_str: str = None,
        tsl_url: str = None,
        function_block_id: str = None,
        function_block_name: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.resource_group_id = resource_group_id
        self.product_key = product_key
        self.tsl_str = tsl_str
        self.tsl_url = tsl_url
        self.function_block_id = function_block_id
        self.function_block_name = function_block_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.tsl_str is not None:
            result['TslStr'] = self.tsl_str
        if self.tsl_url is not None:
            result['TslUrl'] = self.tsl_url
        if self.function_block_id is not None:
            result['FunctionBlockId'] = self.function_block_id
        if self.function_block_name is not None:
            result['FunctionBlockName'] = self.function_block_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('TslStr') is not None:
            self.tsl_str = m.get('TslStr')
        if m.get('TslUrl') is not None:
            self.tsl_url = m.get('TslUrl')
        if m.get('FunctionBlockId') is not None:
            self.function_block_id = m.get('FunctionBlockId')
        if m.get('FunctionBlockName') is not None:
            self.function_block_name = m.get('FunctionBlockName')
        return self


class ImportThingModelTslResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class ImportThingModelTslResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ImportThingModelTslResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ImportThingModelTslResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class InvokeDataAPIServiceRequestParam(TeaModel):
    def __init__(
        self,
        param_type: str = None,
        list_param_value: List[str] = None,
        list_param_type: str = None,
        param_name: str = None,
        param_value: str = None,
    ):
        self.param_type = param_type
        self.list_param_value = list_param_value
        self.list_param_type = list_param_type
        self.param_name = param_name
        self.param_value = param_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.param_type is not None:
            result['ParamType'] = self.param_type
        if self.list_param_value is not None:
            result['ListParamValue'] = self.list_param_value
        if self.list_param_type is not None:
            result['ListParamType'] = self.list_param_type
        if self.param_name is not None:
            result['ParamName'] = self.param_name
        if self.param_value is not None:
            result['ParamValue'] = self.param_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ParamType') is not None:
            self.param_type = m.get('ParamType')
        if m.get('ListParamValue') is not None:
            self.list_param_value = m.get('ListParamValue')
        if m.get('ListParamType') is not None:
            self.list_param_type = m.get('ListParamType')
        if m.get('ParamName') is not None:
            self.param_name = m.get('ParamName')
        if m.get('ParamValue') is not None:
            self.param_value = m.get('ParamValue')
        return self


class InvokeDataAPIServiceRequest(TeaModel):
    def __init__(
        self,
        api_srn: str = None,
        param: List[InvokeDataAPIServiceRequestParam] = None,
        iot_instance_id: str = None,
    ):
        self.api_srn = api_srn
        self.param = param
        self.iot_instance_id = iot_instance_id

    def validate(self):
        if self.param:
            for k in self.param:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_srn is not None:
            result['ApiSrn'] = self.api_srn
        result['Param'] = []
        if self.param is not None:
            for k in self.param:
                result['Param'].append(k.to_map() if k else None)
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiSrn') is not None:
            self.api_srn = m.get('ApiSrn')
        self.param = []
        if m.get('Param') is not None:
            for k in m.get('Param'):
                temp_model = InvokeDataAPIServiceRequestParam()
                self.param.append(temp_model.from_map(k))
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class InvokeDataAPIServiceResponseBodyDataFieldNameList(TeaModel):
    def __init__(
        self,
        field_name_list: List[str] = None,
    ):
        self.field_name_list = field_name_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.field_name_list is not None:
            result['FieldNameList'] = self.field_name_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FieldNameList') is not None:
            self.field_name_list = m.get('FieldNameList')
        return self


class InvokeDataAPIServiceResponseBodyDataResultList(TeaModel):
    def __init__(
        self,
        result_list: List[Dict[str, str]] = None,
    ):
        self.result_list = result_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result_list is not None:
            result['ResultList'] = self.result_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResultList') is not None:
            self.result_list = m.get('ResultList')
        return self


class InvokeDataAPIServiceResponseBodyData(TeaModel):
    def __init__(
        self,
        page_no: int = None,
        page_size: int = None,
        api_srn: str = None,
        field_name_list: InvokeDataAPIServiceResponseBodyDataFieldNameList = None,
        result_list: InvokeDataAPIServiceResponseBodyDataResultList = None,
    ):
        self.page_no = page_no
        self.page_size = page_size
        self.api_srn = api_srn
        self.field_name_list = field_name_list
        self.result_list = result_list

    def validate(self):
        if self.field_name_list:
            self.field_name_list.validate()
        if self.result_list:
            self.result_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.api_srn is not None:
            result['ApiSrn'] = self.api_srn
        if self.field_name_list is not None:
            result['FieldNameList'] = self.field_name_list.to_map()
        if self.result_list is not None:
            result['ResultList'] = self.result_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ApiSrn') is not None:
            self.api_srn = m.get('ApiSrn')
        if m.get('FieldNameList') is not None:
            temp_model = InvokeDataAPIServiceResponseBodyDataFieldNameList()
            self.field_name_list = temp_model.from_map(m['FieldNameList'])
        if m.get('ResultList') is not None:
            temp_model = InvokeDataAPIServiceResponseBodyDataResultList()
            self.result_list = temp_model.from_map(m['ResultList'])
        return self


class InvokeDataAPIServiceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: InvokeDataAPIServiceResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = InvokeDataAPIServiceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class InvokeDataAPIServiceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: InvokeDataAPIServiceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = InvokeDataAPIServiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class InvokeThingServiceRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
        device_name: str = None,
        identifier: str = None,
        args: str = None,
        iot_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.device_name = device_name
        self.identifier = identifier
        self.args = args
        self.iot_id = iot_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.identifier is not None:
            result['Identifier'] = self.identifier
        if self.args is not None:
            result['Args'] = self.args
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('Identifier') is not None:
            self.identifier = m.get('Identifier')
        if m.get('Args') is not None:
            self.args = m.get('Args')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class InvokeThingServiceResponseBodyData(TeaModel):
    def __init__(
        self,
        result: str = None,
        message_id: str = None,
    ):
        self.result = result
        self.message_id = message_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['Result'] = self.result
        if self.message_id is not None:
            result['MessageId'] = self.message_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Result') is not None:
            self.result = m.get('Result')
        if m.get('MessageId') is not None:
            self.message_id = m.get('MessageId')
        return self


class InvokeThingServiceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_message: str = None,
        code: str = None,
        data: InvokeThingServiceResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_message = error_message
        self.code = code
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = InvokeThingServiceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class InvokeThingServiceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: InvokeThingServiceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = InvokeThingServiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class InvokeThingsServiceRequest(TeaModel):
    def __init__(
        self,
        device_name: List[str] = None,
        iot_instance_id: str = None,
        product_key: str = None,
        identifier: str = None,
        args: str = None,
    ):
        self.device_name = device_name
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.identifier = identifier
        self.args = args

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.identifier is not None:
            result['Identifier'] = self.identifier
        if self.args is not None:
            result['Args'] = self.args
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Identifier') is not None:
            self.identifier = m.get('Identifier')
        if m.get('Args') is not None:
            self.args = m.get('Args')
        return self


class InvokeThingsServiceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_message: str = None,
        code: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_message = error_message
        self.code = code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        return self


class InvokeThingsServiceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: InvokeThingsServiceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = InvokeThingsServiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAnalyticsDataRequestCondition(TeaModel):
    def __init__(
        self,
        field_name: str = None,
        operate: str = None,
        value: str = None,
        between_start: str = None,
        between_end: str = None,
    ):
        self.field_name = field_name
        self.operate = operate
        self.value = value
        self.between_start = between_start
        self.between_end = between_end

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.field_name is not None:
            result['FieldName'] = self.field_name
        if self.operate is not None:
            result['Operate'] = self.operate
        if self.value is not None:
            result['Value'] = self.value
        if self.between_start is not None:
            result['BetweenStart'] = self.between_start
        if self.between_end is not None:
            result['BetweenEnd'] = self.between_end
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FieldName') is not None:
            self.field_name = m.get('FieldName')
        if m.get('Operate') is not None:
            self.operate = m.get('Operate')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('BetweenStart') is not None:
            self.between_start = m.get('BetweenStart')
        if m.get('BetweenEnd') is not None:
            self.between_end = m.get('BetweenEnd')
        return self


class ListAnalyticsDataRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        iso_id: str = None,
        api_path: str = None,
        page_size: int = None,
        condition: List[ListAnalyticsDataRequestCondition] = None,
        page_num: int = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.iso_id = iso_id
        self.api_path = api_path
        self.page_size = page_size
        self.condition = condition
        self.page_num = page_num

    def validate(self):
        if self.condition:
            for k in self.condition:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.iso_id is not None:
            result['IsoId'] = self.iso_id
        if self.api_path is not None:
            result['ApiPath'] = self.api_path
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['Condition'] = []
        if self.condition is not None:
            for k in self.condition:
                result['Condition'].append(k.to_map() if k else None)
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('IsoId') is not None:
            self.iso_id = m.get('IsoId')
        if m.get('ApiPath') is not None:
            self.api_path = m.get('ApiPath')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.condition = []
        if m.get('Condition') is not None:
            for k in m.get('Condition'):
                temp_model = ListAnalyticsDataRequestCondition()
                self.condition.append(temp_model.from_map(k))
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        return self


class ListAnalyticsDataResponseBodyData(TeaModel):
    def __init__(
        self,
        has_next: bool = None,
        result_json: str = None,
        count: int = None,
        page_num: int = None,
        page_size: int = None,
    ):
        self.has_next = has_next
        self.result_json = result_json
        self.count = count
        self.page_num = page_num
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.has_next is not None:
            result['HasNext'] = self.has_next
        if self.result_json is not None:
            result['ResultJson'] = self.result_json
        if self.count is not None:
            result['Count'] = self.count
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HasNext') is not None:
            self.has_next = m.get('HasNext')
        if m.get('ResultJson') is not None:
            self.result_json = m.get('ResultJson')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListAnalyticsDataResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: ListAnalyticsDataResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = ListAnalyticsDataResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListAnalyticsDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListAnalyticsDataResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListAnalyticsDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListDeviceDistributeJobRequest(TeaModel):
    def __init__(
        self,
        target_uid: str = None,
        current_page: int = None,
        page_size: int = None,
        status: int = None,
        job_id: str = None,
        next_token: str = None,
    ):
        self.target_uid = target_uid
        self.current_page = current_page
        self.page_size = page_size
        self.status = status
        self.job_id = job_id
        self.next_token = next_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.target_uid is not None:
            result['TargetUid'] = self.target_uid
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.status is not None:
            result['Status'] = self.status
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TargetUid') is not None:
            self.target_uid = m.get('TargetUid')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        return self


class ListDeviceDistributeJobResponseBodyDataJobInfoItemsTargetInstanceConfigsTargetInstanceConfigs(TeaModel):
    def __init__(
        self,
        target_instance_id: str = None,
        target_region: str = None,
        target_instance_name: str = None,
    ):
        self.target_instance_id = target_instance_id
        self.target_region = target_region
        self.target_instance_name = target_instance_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.target_instance_id is not None:
            result['TargetInstanceId'] = self.target_instance_id
        if self.target_region is not None:
            result['TargetRegion'] = self.target_region
        if self.target_instance_name is not None:
            result['TargetInstanceName'] = self.target_instance_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TargetInstanceId') is not None:
            self.target_instance_id = m.get('TargetInstanceId')
        if m.get('TargetRegion') is not None:
            self.target_region = m.get('TargetRegion')
        if m.get('TargetInstanceName') is not None:
            self.target_instance_name = m.get('TargetInstanceName')
        return self


class ListDeviceDistributeJobResponseBodyDataJobInfoItemsTargetInstanceConfigs(TeaModel):
    def __init__(
        self,
        target_instance_configs: List[ListDeviceDistributeJobResponseBodyDataJobInfoItemsTargetInstanceConfigsTargetInstanceConfigs] = None,
    ):
        self.target_instance_configs = target_instance_configs

    def validate(self):
        if self.target_instance_configs:
            for k in self.target_instance_configs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['targetInstanceConfigs'] = []
        if self.target_instance_configs is not None:
            for k in self.target_instance_configs:
                result['targetInstanceConfigs'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.target_instance_configs = []
        if m.get('targetInstanceConfigs') is not None:
            for k in m.get('targetInstanceConfigs'):
                temp_model = ListDeviceDistributeJobResponseBodyDataJobInfoItemsTargetInstanceConfigsTargetInstanceConfigs()
                self.target_instance_configs.append(temp_model.from_map(k))
        return self


class ListDeviceDistributeJobResponseBodyDataJobInfoItems(TeaModel):
    def __init__(
        self,
        gmt_create: int = None,
        source_uid: str = None,
        target_uid: str = None,
        job_id: str = None,
        source_instance_id: str = None,
        product_key: str = None,
        total: int = None,
        status: int = None,
        strategy: int = None,
        source_region: str = None,
        source_instance_name: str = None,
        target_instance_configs: ListDeviceDistributeJobResponseBodyDataJobInfoItemsTargetInstanceConfigs = None,
    ):
        self.gmt_create = gmt_create
        self.source_uid = source_uid
        self.target_uid = target_uid
        self.job_id = job_id
        self.source_instance_id = source_instance_id
        self.product_key = product_key
        self.total = total
        self.status = status
        self.strategy = strategy
        self.source_region = source_region
        self.source_instance_name = source_instance_name
        self.target_instance_configs = target_instance_configs

    def validate(self):
        if self.target_instance_configs:
            self.target_instance_configs.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.source_uid is not None:
            result['SourceUid'] = self.source_uid
        if self.target_uid is not None:
            result['TargetUid'] = self.target_uid
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.source_instance_id is not None:
            result['SourceInstanceId'] = self.source_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.total is not None:
            result['Total'] = self.total
        if self.status is not None:
            result['Status'] = self.status
        if self.strategy is not None:
            result['Strategy'] = self.strategy
        if self.source_region is not None:
            result['SourceRegion'] = self.source_region
        if self.source_instance_name is not None:
            result['SourceInstanceName'] = self.source_instance_name
        if self.target_instance_configs is not None:
            result['TargetInstanceConfigs'] = self.target_instance_configs.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('SourceUid') is not None:
            self.source_uid = m.get('SourceUid')
        if m.get('TargetUid') is not None:
            self.target_uid = m.get('TargetUid')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('SourceInstanceId') is not None:
            self.source_instance_id = m.get('SourceInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Strategy') is not None:
            self.strategy = m.get('Strategy')
        if m.get('SourceRegion') is not None:
            self.source_region = m.get('SourceRegion')
        if m.get('SourceInstanceName') is not None:
            self.source_instance_name = m.get('SourceInstanceName')
        if m.get('TargetInstanceConfigs') is not None:
            temp_model = ListDeviceDistributeJobResponseBodyDataJobInfoItemsTargetInstanceConfigs()
            self.target_instance_configs = temp_model.from_map(m['TargetInstanceConfigs'])
        return self


class ListDeviceDistributeJobResponseBodyDataJobInfo(TeaModel):
    def __init__(
        self,
        items: List[ListDeviceDistributeJobResponseBodyDataJobInfoItems] = None,
    ):
        self.items = items

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['items'] = []
        if self.items is not None:
            for k in self.items:
                result['items'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.items = []
        if m.get('items') is not None:
            for k in m.get('items'):
                temp_model = ListDeviceDistributeJobResponseBodyDataJobInfoItems()
                self.items.append(temp_model.from_map(k))
        return self


class ListDeviceDistributeJobResponseBodyData(TeaModel):
    def __init__(
        self,
        total: int = None,
        next_token: str = None,
        job_info: ListDeviceDistributeJobResponseBodyDataJobInfo = None,
    ):
        self.total = total
        self.next_token = next_token
        self.job_info = job_info

    def validate(self):
        if self.job_info:
            self.job_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total is not None:
            result['Total'] = self.total
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.job_info is not None:
            result['JobInfo'] = self.job_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('JobInfo') is not None:
            temp_model = ListDeviceDistributeJobResponseBodyDataJobInfo()
            self.job_info = temp_model.from_map(m['JobInfo'])
        return self


class ListDeviceDistributeJobResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: ListDeviceDistributeJobResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = ListDeviceDistributeJobResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListDeviceDistributeJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListDeviceDistributeJobResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListDeviceDistributeJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListDistributedDeviceRequest(TeaModel):
    def __init__(
        self,
        page_size: int = None,
        product_key: str = None,
        device_name: str = None,
        current_page: int = None,
        target_uid: str = None,
        source_instance_id: str = None,
    ):
        self.page_size = page_size
        self.product_key = product_key
        self.device_name = device_name
        self.current_page = current_page
        self.target_uid = target_uid
        self.source_instance_id = source_instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.target_uid is not None:
            result['TargetUid'] = self.target_uid
        if self.source_instance_id is not None:
            result['SourceInstanceId'] = self.source_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('TargetUid') is not None:
            self.target_uid = m.get('TargetUid')
        if m.get('SourceInstanceId') is not None:
            self.source_instance_id = m.get('SourceInstanceId')
        return self


class ListDistributedDeviceResponseBodyDataInfoItems(TeaModel):
    def __init__(
        self,
        source_uid: str = None,
        target_uid: str = None,
        product_key: str = None,
        device_name: str = None,
        source_instance_id: str = None,
        target_instance_id: str = None,
        gmt_create: int = None,
        target_aliyun_id: str = None,
        source_region: str = None,
        target_region: str = None,
        source_instance_name: str = None,
        target_instance_name: str = None,
        gmt_modified: int = None,
    ):
        self.source_uid = source_uid
        self.target_uid = target_uid
        self.product_key = product_key
        self.device_name = device_name
        self.source_instance_id = source_instance_id
        self.target_instance_id = target_instance_id
        self.gmt_create = gmt_create
        self.target_aliyun_id = target_aliyun_id
        self.source_region = source_region
        self.target_region = target_region
        self.source_instance_name = source_instance_name
        self.target_instance_name = target_instance_name
        self.gmt_modified = gmt_modified

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_uid is not None:
            result['SourceUid'] = self.source_uid
        if self.target_uid is not None:
            result['TargetUid'] = self.target_uid
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.source_instance_id is not None:
            result['SourceInstanceId'] = self.source_instance_id
        if self.target_instance_id is not None:
            result['TargetInstanceId'] = self.target_instance_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.target_aliyun_id is not None:
            result['TargetAliyunId'] = self.target_aliyun_id
        if self.source_region is not None:
            result['SourceRegion'] = self.source_region
        if self.target_region is not None:
            result['TargetRegion'] = self.target_region
        if self.source_instance_name is not None:
            result['SourceInstanceName'] = self.source_instance_name
        if self.target_instance_name is not None:
            result['TargetInstanceName'] = self.target_instance_name
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceUid') is not None:
            self.source_uid = m.get('SourceUid')
        if m.get('TargetUid') is not None:
            self.target_uid = m.get('TargetUid')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('SourceInstanceId') is not None:
            self.source_instance_id = m.get('SourceInstanceId')
        if m.get('TargetInstanceId') is not None:
            self.target_instance_id = m.get('TargetInstanceId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('TargetAliyunId') is not None:
            self.target_aliyun_id = m.get('TargetAliyunId')
        if m.get('SourceRegion') is not None:
            self.source_region = m.get('SourceRegion')
        if m.get('TargetRegion') is not None:
            self.target_region = m.get('TargetRegion')
        if m.get('SourceInstanceName') is not None:
            self.source_instance_name = m.get('SourceInstanceName')
        if m.get('TargetInstanceName') is not None:
            self.target_instance_name = m.get('TargetInstanceName')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        return self


class ListDistributedDeviceResponseBodyDataInfo(TeaModel):
    def __init__(
        self,
        items: List[ListDistributedDeviceResponseBodyDataInfoItems] = None,
    ):
        self.items = items

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['items'] = []
        if self.items is not None:
            for k in self.items:
                result['items'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.items = []
        if m.get('items') is not None:
            for k in m.get('items'):
                temp_model = ListDistributedDeviceResponseBodyDataInfoItems()
                self.items.append(temp_model.from_map(k))
        return self


class ListDistributedDeviceResponseBodyData(TeaModel):
    def __init__(
        self,
        total: int = None,
        info: ListDistributedDeviceResponseBodyDataInfo = None,
    ):
        self.total = total
        self.info = info

    def validate(self):
        if self.info:
            self.info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total is not None:
            result['Total'] = self.total
        if self.info is not None:
            result['Info'] = self.info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Info') is not None:
            temp_model = ListDistributedDeviceResponseBodyDataInfo()
            self.info = temp_model.from_map(m['Info'])
        return self


class ListDistributedDeviceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: ListDistributedDeviceResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = ListDistributedDeviceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListDistributedDeviceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListDistributedDeviceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListDistributedDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListDistributedProductRequest(TeaModel):
    def __init__(
        self,
        page_size: int = None,
        source_instance_id: str = None,
        product_key: str = None,
        target_instance_id: str = None,
        target_uid: str = None,
        current_page: int = None,
    ):
        self.page_size = page_size
        self.source_instance_id = source_instance_id
        self.product_key = product_key
        self.target_instance_id = target_instance_id
        self.target_uid = target_uid
        self.current_page = current_page

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.source_instance_id is not None:
            result['SourceInstanceId'] = self.source_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.target_instance_id is not None:
            result['TargetInstanceId'] = self.target_instance_id
        if self.target_uid is not None:
            result['TargetUid'] = self.target_uid
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SourceInstanceId') is not None:
            self.source_instance_id = m.get('SourceInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('TargetInstanceId') is not None:
            self.target_instance_id = m.get('TargetInstanceId')
        if m.get('TargetUid') is not None:
            self.target_uid = m.get('TargetUid')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class ListDistributedProductResponseBodyDataInfoItems(TeaModel):
    def __init__(
        self,
        source_uid: str = None,
        target_uid: str = None,
        product_key: str = None,
        source_instance_id: str = None,
        target_instance_id: str = None,
        gmt_create: int = None,
        target_aliyun_id: str = None,
        source_region: str = None,
        target_region: str = None,
        source_instance_name: str = None,
        target_instance_name: str = None,
    ):
        self.source_uid = source_uid
        self.target_uid = target_uid
        self.product_key = product_key
        self.source_instance_id = source_instance_id
        self.target_instance_id = target_instance_id
        self.gmt_create = gmt_create
        self.target_aliyun_id = target_aliyun_id
        self.source_region = source_region
        self.target_region = target_region
        self.source_instance_name = source_instance_name
        self.target_instance_name = target_instance_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_uid is not None:
            result['SourceUid'] = self.source_uid
        if self.target_uid is not None:
            result['TargetUid'] = self.target_uid
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.source_instance_id is not None:
            result['SourceInstanceId'] = self.source_instance_id
        if self.target_instance_id is not None:
            result['TargetInstanceId'] = self.target_instance_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.target_aliyun_id is not None:
            result['TargetAliyunId'] = self.target_aliyun_id
        if self.source_region is not None:
            result['SourceRegion'] = self.source_region
        if self.target_region is not None:
            result['TargetRegion'] = self.target_region
        if self.source_instance_name is not None:
            result['SourceInstanceName'] = self.source_instance_name
        if self.target_instance_name is not None:
            result['TargetInstanceName'] = self.target_instance_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceUid') is not None:
            self.source_uid = m.get('SourceUid')
        if m.get('TargetUid') is not None:
            self.target_uid = m.get('TargetUid')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('SourceInstanceId') is not None:
            self.source_instance_id = m.get('SourceInstanceId')
        if m.get('TargetInstanceId') is not None:
            self.target_instance_id = m.get('TargetInstanceId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('TargetAliyunId') is not None:
            self.target_aliyun_id = m.get('TargetAliyunId')
        if m.get('SourceRegion') is not None:
            self.source_region = m.get('SourceRegion')
        if m.get('TargetRegion') is not None:
            self.target_region = m.get('TargetRegion')
        if m.get('SourceInstanceName') is not None:
            self.source_instance_name = m.get('SourceInstanceName')
        if m.get('TargetInstanceName') is not None:
            self.target_instance_name = m.get('TargetInstanceName')
        return self


class ListDistributedProductResponseBodyDataInfo(TeaModel):
    def __init__(
        self,
        items: List[ListDistributedProductResponseBodyDataInfoItems] = None,
    ):
        self.items = items

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['items'] = []
        if self.items is not None:
            for k in self.items:
                result['items'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.items = []
        if m.get('items') is not None:
            for k in m.get('items'):
                temp_model = ListDistributedProductResponseBodyDataInfoItems()
                self.items.append(temp_model.from_map(k))
        return self


class ListDistributedProductResponseBodyData(TeaModel):
    def __init__(
        self,
        total: int = None,
        info: ListDistributedProductResponseBodyDataInfo = None,
    ):
        self.total = total
        self.info = info

    def validate(self):
        if self.info:
            self.info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total is not None:
            result['Total'] = self.total
        if self.info is not None:
            result['Info'] = self.info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Info') is not None:
            temp_model = ListDistributedProductResponseBodyDataInfo()
            self.info = temp_model.from_map(m['Info'])
        return self


class ListDistributedProductResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: ListDistributedProductResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = ListDistributedProductResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListDistributedProductResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListDistributedProductResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListDistributedProductResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListJobRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        status: str = None,
        page_size: int = None,
        current_page: int = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.status = status
        self.page_size = page_size
        self.current_page = current_page

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.status is not None:
            result['Status'] = self.status
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class ListJobResponseBodyDataData(TeaModel):
    def __init__(
        self,
        job_id: str = None,
        job_name: str = None,
        utc_create: str = None,
        utc_modified: str = None,
        status: str = None,
        description: str = None,
        type: str = None,
        scheduled_time: int = None,
    ):
        self.job_id = job_id
        self.job_name = job_name
        self.utc_create = utc_create
        self.utc_modified = utc_modified
        self.status = status
        self.description = description
        self.type = type
        self.scheduled_time = scheduled_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.job_name is not None:
            result['JobName'] = self.job_name
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.status is not None:
            result['Status'] = self.status
        if self.description is not None:
            result['Description'] = self.description
        if self.type is not None:
            result['Type'] = self.type
        if self.scheduled_time is not None:
            result['ScheduledTime'] = self.scheduled_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('JobName') is not None:
            self.job_name = m.get('JobName')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('ScheduledTime') is not None:
            self.scheduled_time = m.get('ScheduledTime')
        return self


class ListJobResponseBodyData(TeaModel):
    def __init__(
        self,
        data: List[ListJobResponseBodyDataData] = None,
    ):
        self.data = data

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['data'] = []
        if self.data is not None:
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data = []
        if m.get('data') is not None:
            for k in m.get('data'):
                temp_model = ListJobResponseBodyDataData()
                self.data.append(temp_model.from_map(k))
        return self


class ListJobResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        total: int = None,
        page_size: int = None,
        page: int = None,
        data: ListJobResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.total = total
        self.page_size = page_size
        self.page = page
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page is not None:
            result['Page'] = self.page
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('Data') is not None:
            temp_model = ListJobResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListJobResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListOTAFirmwareRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
        page_size: int = None,
        current_page: int = None,
        dest_version: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.page_size = page_size
        self.current_page = current_page
        self.dest_version = dest_version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dest_version is not None:
            result['DestVersion'] = self.dest_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DestVersion') is not None:
            self.dest_version = m.get('DestVersion')
        return self


class ListOTAFirmwareResponseBodyFirmwareInfoSimpleFirmwareInfo(TeaModel):
    def __init__(
        self,
        firmware_name: str = None,
        firmware_id: str = None,
        src_version: str = None,
        dest_version: str = None,
        utc_create: str = None,
        utc_modified: str = None,
        status: int = None,
        firmware_desc: str = None,
        firmware_sign: str = None,
        firmware_size: int = None,
        product_key: str = None,
        sign_method: str = None,
        product_name: str = None,
        type: int = None,
        module_name: str = None,
    ):
        self.firmware_name = firmware_name
        self.firmware_id = firmware_id
        self.src_version = src_version
        self.dest_version = dest_version
        self.utc_create = utc_create
        self.utc_modified = utc_modified
        self.status = status
        self.firmware_desc = firmware_desc
        self.firmware_sign = firmware_sign
        self.firmware_size = firmware_size
        self.product_key = product_key
        self.sign_method = sign_method
        self.product_name = product_name
        self.type = type
        self.module_name = module_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.firmware_name is not None:
            result['FirmwareName'] = self.firmware_name
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.src_version is not None:
            result['SrcVersion'] = self.src_version
        if self.dest_version is not None:
            result['DestVersion'] = self.dest_version
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.status is not None:
            result['Status'] = self.status
        if self.firmware_desc is not None:
            result['FirmwareDesc'] = self.firmware_desc
        if self.firmware_sign is not None:
            result['FirmwareSign'] = self.firmware_sign
        if self.firmware_size is not None:
            result['FirmwareSize'] = self.firmware_size
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.sign_method is not None:
            result['SignMethod'] = self.sign_method
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.type is not None:
            result['Type'] = self.type
        if self.module_name is not None:
            result['ModuleName'] = self.module_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FirmwareName') is not None:
            self.firmware_name = m.get('FirmwareName')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('SrcVersion') is not None:
            self.src_version = m.get('SrcVersion')
        if m.get('DestVersion') is not None:
            self.dest_version = m.get('DestVersion')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('FirmwareDesc') is not None:
            self.firmware_desc = m.get('FirmwareDesc')
        if m.get('FirmwareSign') is not None:
            self.firmware_sign = m.get('FirmwareSign')
        if m.get('FirmwareSize') is not None:
            self.firmware_size = m.get('FirmwareSize')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('SignMethod') is not None:
            self.sign_method = m.get('SignMethod')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('ModuleName') is not None:
            self.module_name = m.get('ModuleName')
        return self


class ListOTAFirmwareResponseBodyFirmwareInfo(TeaModel):
    def __init__(
        self,
        simple_firmware_info: List[ListOTAFirmwareResponseBodyFirmwareInfoSimpleFirmwareInfo] = None,
    ):
        self.simple_firmware_info = simple_firmware_info

    def validate(self):
        if self.simple_firmware_info:
            for k in self.simple_firmware_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SimpleFirmwareInfo'] = []
        if self.simple_firmware_info is not None:
            for k in self.simple_firmware_info:
                result['SimpleFirmwareInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.simple_firmware_info = []
        if m.get('SimpleFirmwareInfo') is not None:
            for k in m.get('SimpleFirmwareInfo'):
                temp_model = ListOTAFirmwareResponseBodyFirmwareInfoSimpleFirmwareInfo()
                self.simple_firmware_info.append(temp_model.from_map(k))
        return self


class ListOTAFirmwareResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        total: int = None,
        page_size: int = None,
        page_count: int = None,
        current_page: int = None,
        firmware_info: ListOTAFirmwareResponseBodyFirmwareInfo = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.total = total
        self.page_size = page_size
        self.page_count = page_count
        self.current_page = current_page
        self.firmware_info = firmware_info

    def validate(self):
        if self.firmware_info:
            self.firmware_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.firmware_info is not None:
            result['FirmwareInfo'] = self.firmware_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('FirmwareInfo') is not None:
            temp_model = ListOTAFirmwareResponseBodyFirmwareInfo()
            self.firmware_info = temp_model.from_map(m['FirmwareInfo'])
        return self


class ListOTAFirmwareResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListOTAFirmwareResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListOTAFirmwareResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListOTAJobByDeviceRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        firmware_id: str = None,
        page_size: int = None,
        product_key: str = None,
        device_name: str = None,
        current_page: int = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.firmware_id = firmware_id
        self.page_size = page_size
        self.product_key = product_key
        self.device_name = device_name
        self.current_page = current_page

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class ListOTAJobByDeviceResponseBodyDataSimpleOTAJobInfoTagsOtaTagDTO(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListOTAJobByDeviceResponseBodyDataSimpleOTAJobInfoTags(TeaModel):
    def __init__(
        self,
        ota_tag_dto: List[ListOTAJobByDeviceResponseBodyDataSimpleOTAJobInfoTagsOtaTagDTO] = None,
    ):
        self.ota_tag_dto = ota_tag_dto

    def validate(self):
        if self.ota_tag_dto:
            for k in self.ota_tag_dto:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['OtaTagDTO'] = []
        if self.ota_tag_dto is not None:
            for k in self.ota_tag_dto:
                result['OtaTagDTO'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.ota_tag_dto = []
        if m.get('OtaTagDTO') is not None:
            for k in m.get('OtaTagDTO'):
                temp_model = ListOTAJobByDeviceResponseBodyDataSimpleOTAJobInfoTagsOtaTagDTO()
                self.ota_tag_dto.append(temp_model.from_map(k))
        return self


class ListOTAJobByDeviceResponseBodyDataSimpleOTAJobInfo(TeaModel):
    def __init__(
        self,
        job_id: str = None,
        utc_create: str = None,
        utc_modified: str = None,
        product_key: str = None,
        firmware_id: str = None,
        utc_start_time: str = None,
        utc_end_time: str = None,
        job_status: str = None,
        job_type: str = None,
        target_selection: str = None,
        selection_type: str = None,
        tags: ListOTAJobByDeviceResponseBodyDataSimpleOTAJobInfoTags = None,
    ):
        self.job_id = job_id
        self.utc_create = utc_create
        self.utc_modified = utc_modified
        self.product_key = product_key
        self.firmware_id = firmware_id
        self.utc_start_time = utc_start_time
        self.utc_end_time = utc_end_time
        self.job_status = job_status
        self.job_type = job_type
        self.target_selection = target_selection
        self.selection_type = selection_type
        self.tags = tags

    def validate(self):
        if self.tags:
            self.tags.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.utc_start_time is not None:
            result['UtcStartTime'] = self.utc_start_time
        if self.utc_end_time is not None:
            result['UtcEndTime'] = self.utc_end_time
        if self.job_status is not None:
            result['JobStatus'] = self.job_status
        if self.job_type is not None:
            result['JobType'] = self.job_type
        if self.target_selection is not None:
            result['TargetSelection'] = self.target_selection
        if self.selection_type is not None:
            result['SelectionType'] = self.selection_type
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('UtcStartTime') is not None:
            self.utc_start_time = m.get('UtcStartTime')
        if m.get('UtcEndTime') is not None:
            self.utc_end_time = m.get('UtcEndTime')
        if m.get('JobStatus') is not None:
            self.job_status = m.get('JobStatus')
        if m.get('JobType') is not None:
            self.job_type = m.get('JobType')
        if m.get('TargetSelection') is not None:
            self.target_selection = m.get('TargetSelection')
        if m.get('SelectionType') is not None:
            self.selection_type = m.get('SelectionType')
        if m.get('Tags') is not None:
            temp_model = ListOTAJobByDeviceResponseBodyDataSimpleOTAJobInfoTags()
            self.tags = temp_model.from_map(m['Tags'])
        return self


class ListOTAJobByDeviceResponseBodyData(TeaModel):
    def __init__(
        self,
        simple_otajob_info: List[ListOTAJobByDeviceResponseBodyDataSimpleOTAJobInfo] = None,
    ):
        self.simple_otajob_info = simple_otajob_info

    def validate(self):
        if self.simple_otajob_info:
            for k in self.simple_otajob_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SimpleOTAJobInfo'] = []
        if self.simple_otajob_info is not None:
            for k in self.simple_otajob_info:
                result['SimpleOTAJobInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.simple_otajob_info = []
        if m.get('SimpleOTAJobInfo') is not None:
            for k in m.get('SimpleOTAJobInfo'):
                temp_model = ListOTAJobByDeviceResponseBodyDataSimpleOTAJobInfo()
                self.simple_otajob_info.append(temp_model.from_map(k))
        return self


class ListOTAJobByDeviceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        total: int = None,
        page_size: int = None,
        page_count: int = None,
        current_page: int = None,
        data: ListOTAJobByDeviceResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.total = total
        self.page_size = page_size
        self.page_count = page_count
        self.current_page = current_page
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Data') is not None:
            temp_model = ListOTAJobByDeviceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListOTAJobByDeviceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListOTAJobByDeviceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListOTAJobByDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListOTAJobByFirmwareRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        firmware_id: str = None,
        page_size: int = None,
        current_page: int = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.firmware_id = firmware_id
        self.page_size = page_size
        self.current_page = current_page

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class ListOTAJobByFirmwareResponseBodyDataSimpleOTAJobInfoTagsOtaTagDTO(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListOTAJobByFirmwareResponseBodyDataSimpleOTAJobInfoTags(TeaModel):
    def __init__(
        self,
        ota_tag_dto: List[ListOTAJobByFirmwareResponseBodyDataSimpleOTAJobInfoTagsOtaTagDTO] = None,
    ):
        self.ota_tag_dto = ota_tag_dto

    def validate(self):
        if self.ota_tag_dto:
            for k in self.ota_tag_dto:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['OtaTagDTO'] = []
        if self.ota_tag_dto is not None:
            for k in self.ota_tag_dto:
                result['OtaTagDTO'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.ota_tag_dto = []
        if m.get('OtaTagDTO') is not None:
            for k in m.get('OtaTagDTO'):
                temp_model = ListOTAJobByFirmwareResponseBodyDataSimpleOTAJobInfoTagsOtaTagDTO()
                self.ota_tag_dto.append(temp_model.from_map(k))
        return self


class ListOTAJobByFirmwareResponseBodyDataSimpleOTAJobInfo(TeaModel):
    def __init__(
        self,
        job_id: str = None,
        utc_create: str = None,
        utc_modified: str = None,
        product_key: str = None,
        firmware_id: str = None,
        utc_start_time: str = None,
        utc_end_time: str = None,
        job_status: str = None,
        job_type: str = None,
        target_selection: str = None,
        selection_type: str = None,
        tags: ListOTAJobByFirmwareResponseBodyDataSimpleOTAJobInfoTags = None,
    ):
        self.job_id = job_id
        self.utc_create = utc_create
        self.utc_modified = utc_modified
        self.product_key = product_key
        self.firmware_id = firmware_id
        self.utc_start_time = utc_start_time
        self.utc_end_time = utc_end_time
        self.job_status = job_status
        self.job_type = job_type
        self.target_selection = target_selection
        self.selection_type = selection_type
        self.tags = tags

    def validate(self):
        if self.tags:
            self.tags.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.utc_start_time is not None:
            result['UtcStartTime'] = self.utc_start_time
        if self.utc_end_time is not None:
            result['UtcEndTime'] = self.utc_end_time
        if self.job_status is not None:
            result['JobStatus'] = self.job_status
        if self.job_type is not None:
            result['JobType'] = self.job_type
        if self.target_selection is not None:
            result['TargetSelection'] = self.target_selection
        if self.selection_type is not None:
            result['SelectionType'] = self.selection_type
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('UtcStartTime') is not None:
            self.utc_start_time = m.get('UtcStartTime')
        if m.get('UtcEndTime') is not None:
            self.utc_end_time = m.get('UtcEndTime')
        if m.get('JobStatus') is not None:
            self.job_status = m.get('JobStatus')
        if m.get('JobType') is not None:
            self.job_type = m.get('JobType')
        if m.get('TargetSelection') is not None:
            self.target_selection = m.get('TargetSelection')
        if m.get('SelectionType') is not None:
            self.selection_type = m.get('SelectionType')
        if m.get('Tags') is not None:
            temp_model = ListOTAJobByFirmwareResponseBodyDataSimpleOTAJobInfoTags()
            self.tags = temp_model.from_map(m['Tags'])
        return self


class ListOTAJobByFirmwareResponseBodyData(TeaModel):
    def __init__(
        self,
        simple_otajob_info: List[ListOTAJobByFirmwareResponseBodyDataSimpleOTAJobInfo] = None,
    ):
        self.simple_otajob_info = simple_otajob_info

    def validate(self):
        if self.simple_otajob_info:
            for k in self.simple_otajob_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SimpleOTAJobInfo'] = []
        if self.simple_otajob_info is not None:
            for k in self.simple_otajob_info:
                result['SimpleOTAJobInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.simple_otajob_info = []
        if m.get('SimpleOTAJobInfo') is not None:
            for k in m.get('SimpleOTAJobInfo'):
                temp_model = ListOTAJobByFirmwareResponseBodyDataSimpleOTAJobInfo()
                self.simple_otajob_info.append(temp_model.from_map(k))
        return self


class ListOTAJobByFirmwareResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        total: int = None,
        page_size: int = None,
        page_count: int = None,
        current_page: int = None,
        data: ListOTAJobByFirmwareResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.total = total
        self.page_size = page_size
        self.page_count = page_count
        self.current_page = current_page
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Data') is not None:
            temp_model = ListOTAJobByFirmwareResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListOTAJobByFirmwareResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListOTAJobByFirmwareResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListOTAJobByFirmwareResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListOTAModuleByProductRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class ListOTAModuleByProductResponseBodyData(TeaModel):
    def __init__(
        self,
        product_key: str = None,
        module_name: str = None,
        alias_name: str = None,
        desc: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
    ):
        self.product_key = product_key
        self.module_name = module_name
        self.alias_name = alias_name
        self.desc = desc
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.module_name is not None:
            result['ModuleName'] = self.module_name
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ModuleName') is not None:
            self.module_name = m.get('ModuleName')
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        return self


class ListOTAModuleByProductResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: List[ListOTAModuleByProductResponseBodyData] = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListOTAModuleByProductResponseBodyData()
                self.data.append(temp_model.from_map(k))
        return self


class ListOTAModuleByProductResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListOTAModuleByProductResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListOTAModuleByProductResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListOTAModuleVersionsByDeviceRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        page_size: int = None,
        product_key: str = None,
        device_name: str = None,
        iot_id: str = None,
        current_page: int = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.page_size = page_size
        self.product_key = product_key
        self.device_name = device_name
        self.iot_id = iot_id
        self.current_page = current_page

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class ListOTAModuleVersionsByDeviceResponseBodyDataSimpleOTAModuleInfo(TeaModel):
    def __init__(
        self,
        product_key: str = None,
        device_name: str = None,
        iot_id: str = None,
        module_version: str = None,
        module_name: str = None,
    ):
        self.product_key = product_key
        self.device_name = device_name
        self.iot_id = iot_id
        self.module_version = module_version
        self.module_name = module_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.module_version is not None:
            result['ModuleVersion'] = self.module_version
        if self.module_name is not None:
            result['ModuleName'] = self.module_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('ModuleVersion') is not None:
            self.module_version = m.get('ModuleVersion')
        if m.get('ModuleName') is not None:
            self.module_name = m.get('ModuleName')
        return self


class ListOTAModuleVersionsByDeviceResponseBodyData(TeaModel):
    def __init__(
        self,
        simple_otamodule_info: List[ListOTAModuleVersionsByDeviceResponseBodyDataSimpleOTAModuleInfo] = None,
    ):
        self.simple_otamodule_info = simple_otamodule_info

    def validate(self):
        if self.simple_otamodule_info:
            for k in self.simple_otamodule_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SimpleOTAModuleInfo'] = []
        if self.simple_otamodule_info is not None:
            for k in self.simple_otamodule_info:
                result['SimpleOTAModuleInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.simple_otamodule_info = []
        if m.get('SimpleOTAModuleInfo') is not None:
            for k in m.get('SimpleOTAModuleInfo'):
                temp_model = ListOTAModuleVersionsByDeviceResponseBodyDataSimpleOTAModuleInfo()
                self.simple_otamodule_info.append(temp_model.from_map(k))
        return self


class ListOTAModuleVersionsByDeviceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        total: int = None,
        page_size: int = None,
        page_count: int = None,
        current_page: int = None,
        data: ListOTAModuleVersionsByDeviceResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.total = total
        self.page_size = page_size
        self.page_count = page_count
        self.current_page = current_page
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Data') is not None:
            temp_model = ListOTAModuleVersionsByDeviceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListOTAModuleVersionsByDeviceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListOTAModuleVersionsByDeviceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListOTAModuleVersionsByDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListOTATaskByJobRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        page_size: int = None,
        task_status: str = None,
        job_id: str = None,
        current_page: int = None,
        device_names: List[str] = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.page_size = page_size
        self.task_status = task_status
        self.job_id = job_id
        self.current_page = current_page
        self.device_names = device_names

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.device_names is not None:
            result['DeviceNames'] = self.device_names
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DeviceNames') is not None:
            self.device_names = m.get('DeviceNames')
        return self


class ListOTATaskByJobResponseBodyDataSimpleOTATaskInfo(TeaModel):
    def __init__(
        self,
        task_id: str = None,
        utc_modified: str = None,
        product_key: str = None,
        firmware_id: str = None,
        task_status: str = None,
        job_id: str = None,
        product_name: str = None,
        device_name: str = None,
        src_version: str = None,
        dest_version: str = None,
        task_desc: str = None,
        progress: str = None,
        iot_id: str = None,
        utc_create: str = None,
        timeout: str = None,
    ):
        self.task_id = task_id
        self.utc_modified = utc_modified
        self.product_key = product_key
        self.firmware_id = firmware_id
        self.task_status = task_status
        self.job_id = job_id
        self.product_name = product_name
        self.device_name = device_name
        self.src_version = src_version
        self.dest_version = dest_version
        self.task_desc = task_desc
        self.progress = progress
        self.iot_id = iot_id
        self.utc_create = utc_create
        self.timeout = timeout

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.src_version is not None:
            result['SrcVersion'] = self.src_version
        if self.dest_version is not None:
            result['DestVersion'] = self.dest_version
        if self.task_desc is not None:
            result['TaskDesc'] = self.task_desc
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.timeout is not None:
            result['Timeout'] = self.timeout
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('SrcVersion') is not None:
            self.src_version = m.get('SrcVersion')
        if m.get('DestVersion') is not None:
            self.dest_version = m.get('DestVersion')
        if m.get('TaskDesc') is not None:
            self.task_desc = m.get('TaskDesc')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('Timeout') is not None:
            self.timeout = m.get('Timeout')
        return self


class ListOTATaskByJobResponseBodyData(TeaModel):
    def __init__(
        self,
        simple_otatask_info: List[ListOTATaskByJobResponseBodyDataSimpleOTATaskInfo] = None,
    ):
        self.simple_otatask_info = simple_otatask_info

    def validate(self):
        if self.simple_otatask_info:
            for k in self.simple_otatask_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SimpleOTATaskInfo'] = []
        if self.simple_otatask_info is not None:
            for k in self.simple_otatask_info:
                result['SimpleOTATaskInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.simple_otatask_info = []
        if m.get('SimpleOTATaskInfo') is not None:
            for k in m.get('SimpleOTATaskInfo'):
                temp_model = ListOTATaskByJobResponseBodyDataSimpleOTATaskInfo()
                self.simple_otatask_info.append(temp_model.from_map(k))
        return self


class ListOTATaskByJobResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        total: int = None,
        page_size: int = None,
        page_count: int = None,
        current_page: int = None,
        data: ListOTATaskByJobResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.total = total
        self.page_size = page_size
        self.page_count = page_count
        self.current_page = current_page
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Data') is not None:
            temp_model = ListOTATaskByJobResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListOTATaskByJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListOTATaskByJobResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListOTATaskByJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListOTAUnfinishedTaskByDeviceRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        module_name: str = None,
        product_key: str = None,
        device_name: str = None,
        task_status: str = None,
        iot_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.module_name = module_name
        self.product_key = product_key
        self.device_name = device_name
        self.task_status = task_status
        self.iot_id = iot_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.module_name is not None:
            result['ModuleName'] = self.module_name
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ModuleName') is not None:
            self.module_name = m.get('ModuleName')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class ListOTAUnfinishedTaskByDeviceResponseBodyDataSimpleOTATaskInfo(TeaModel):
    def __init__(
        self,
        task_id: str = None,
        utc_modified: str = None,
        product_key: str = None,
        task_status: str = None,
        job_id: str = None,
        product_name: str = None,
        device_name: str = None,
        src_version: str = None,
        dest_version: str = None,
        iot_id: str = None,
        utc_create: str = None,
        module_name: str = None,
        firmware_id: str = None,
    ):
        self.task_id = task_id
        self.utc_modified = utc_modified
        self.product_key = product_key
        self.task_status = task_status
        self.job_id = job_id
        self.product_name = product_name
        self.device_name = device_name
        self.src_version = src_version
        self.dest_version = dest_version
        self.iot_id = iot_id
        self.utc_create = utc_create
        self.module_name = module_name
        self.firmware_id = firmware_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.src_version is not None:
            result['SrcVersion'] = self.src_version
        if self.dest_version is not None:
            result['DestVersion'] = self.dest_version
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.module_name is not None:
            result['ModuleName'] = self.module_name
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('SrcVersion') is not None:
            self.src_version = m.get('SrcVersion')
        if m.get('DestVersion') is not None:
            self.dest_version = m.get('DestVersion')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('ModuleName') is not None:
            self.module_name = m.get('ModuleName')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        return self


class ListOTAUnfinishedTaskByDeviceResponseBodyData(TeaModel):
    def __init__(
        self,
        simple_otatask_info: List[ListOTAUnfinishedTaskByDeviceResponseBodyDataSimpleOTATaskInfo] = None,
    ):
        self.simple_otatask_info = simple_otatask_info

    def validate(self):
        if self.simple_otatask_info:
            for k in self.simple_otatask_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SimpleOTATaskInfo'] = []
        if self.simple_otatask_info is not None:
            for k in self.simple_otatask_info:
                result['SimpleOTATaskInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.simple_otatask_info = []
        if m.get('SimpleOTATaskInfo') is not None:
            for k in m.get('SimpleOTATaskInfo'):
                temp_model = ListOTAUnfinishedTaskByDeviceResponseBodyDataSimpleOTATaskInfo()
                self.simple_otatask_info.append(temp_model.from_map(k))
        return self


class ListOTAUnfinishedTaskByDeviceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: ListOTAUnfinishedTaskByDeviceResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = ListOTAUnfinishedTaskByDeviceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListOTAUnfinishedTaskByDeviceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListOTAUnfinishedTaskByDeviceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListOTAUnfinishedTaskByDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListProductByTagsRequestProductTag(TeaModel):
    def __init__(
        self,
        tag_key: str = None,
        tag_value: str = None,
    ):
        self.tag_key = tag_key
        self.tag_value = tag_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class ListProductByTagsRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        current_page: int = None,
        page_size: int = None,
        product_tag: List[ListProductByTagsRequestProductTag] = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.current_page = current_page
        self.page_size = page_size
        self.product_tag = product_tag

    def validate(self):
        if self.product_tag:
            for k in self.product_tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['ProductTag'] = []
        if self.product_tag is not None:
            for k in self.product_tag:
                result['ProductTag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.product_tag = []
        if m.get('ProductTag') is not None:
            for k in m.get('ProductTag'):
                temp_model = ListProductByTagsRequestProductTag()
                self.product_tag.append(temp_model.from_map(k))
        return self


class ListProductByTagsResponseBodyProductInfosProductInfo(TeaModel):
    def __init__(
        self,
        product_name: str = None,
        product_key: str = None,
        create_time: int = None,
        description: str = None,
        node_type: int = None,
    ):
        self.product_name = product_name
        self.product_key = product_key
        self.create_time = create_time
        self.description = description
        self.node_type = node_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.node_type is not None:
            result['NodeType'] = self.node_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('NodeType') is not None:
            self.node_type = m.get('NodeType')
        return self


class ListProductByTagsResponseBodyProductInfos(TeaModel):
    def __init__(
        self,
        product_info: List[ListProductByTagsResponseBodyProductInfosProductInfo] = None,
    ):
        self.product_info = product_info

    def validate(self):
        if self.product_info:
            for k in self.product_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ProductInfo'] = []
        if self.product_info is not None:
            for k in self.product_info:
                result['ProductInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.product_info = []
        if m.get('ProductInfo') is not None:
            for k in m.get('ProductInfo'):
                temp_model = ListProductByTagsResponseBodyProductInfosProductInfo()
                self.product_info.append(temp_model.from_map(k))
        return self


class ListProductByTagsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_message: str = None,
        code: str = None,
        product_infos: ListProductByTagsResponseBodyProductInfos = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_message = error_message
        self.code = code
        self.product_infos = product_infos

    def validate(self):
        if self.product_infos:
            self.product_infos.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.product_infos is not None:
            result['ProductInfos'] = self.product_infos.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ProductInfos') is not None:
            temp_model = ListProductByTagsResponseBodyProductInfos()
            self.product_infos = temp_model.from_map(m['ProductInfos'])
        return self


class ListProductByTagsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListProductByTagsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListProductByTagsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListProductTagsRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class ListProductTagsResponseBodyDataProductTag(TeaModel):
    def __init__(
        self,
        tag_key: str = None,
        tag_value: str = None,
    ):
        self.tag_key = tag_key
        self.tag_value = tag_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class ListProductTagsResponseBodyData(TeaModel):
    def __init__(
        self,
        product_tag: List[ListProductTagsResponseBodyDataProductTag] = None,
    ):
        self.product_tag = product_tag

    def validate(self):
        if self.product_tag:
            for k in self.product_tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ProductTag'] = []
        if self.product_tag is not None:
            for k in self.product_tag:
                result['ProductTag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.product_tag = []
        if m.get('ProductTag') is not None:
            for k in m.get('ProductTag'):
                temp_model = ListProductTagsResponseBodyDataProductTag()
                self.product_tag.append(temp_model.from_map(k))
        return self


class ListProductTagsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_message: str = None,
        code: str = None,
        data: ListProductTagsResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_message = error_message
        self.code = code
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListProductTagsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListProductTagsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListProductTagsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListProductTagsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListRuleRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        current_page: int = None,
        page_size: int = None,
        resource_group_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.current_page = current_page
        self.page_size = page_size
        self.resource_group_id = resource_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class ListRuleResponseBodyDataRuleInfo(TeaModel):
    def __init__(
        self,
        id: int = None,
        select: str = None,
        topic: str = None,
        short_topic: str = None,
        where: str = None,
        status: str = None,
        create_user_id: int = None,
        product_key: str = None,
        name: str = None,
        data_type: str = None,
        rule_desc: str = None,
        created: str = None,
        utc_created: str = None,
        modified: str = None,
        utc_modified: str = None,
    ):
        self.id = id
        self.select = select
        self.topic = topic
        self.short_topic = short_topic
        self.where = where
        self.status = status
        self.create_user_id = create_user_id
        self.product_key = product_key
        self.name = name
        self.data_type = data_type
        self.rule_desc = rule_desc
        self.created = created
        self.utc_created = utc_created
        self.modified = modified
        self.utc_modified = utc_modified

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.select is not None:
            result['Select'] = self.select
        if self.topic is not None:
            result['Topic'] = self.topic
        if self.short_topic is not None:
            result['ShortTopic'] = self.short_topic
        if self.where is not None:
            result['Where'] = self.where
        if self.status is not None:
            result['Status'] = self.status
        if self.create_user_id is not None:
            result['CreateUserId'] = self.create_user_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.name is not None:
            result['Name'] = self.name
        if self.data_type is not None:
            result['DataType'] = self.data_type
        if self.rule_desc is not None:
            result['RuleDesc'] = self.rule_desc
        if self.created is not None:
            result['Created'] = self.created
        if self.utc_created is not None:
            result['UtcCreated'] = self.utc_created
        if self.modified is not None:
            result['Modified'] = self.modified
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Select') is not None:
            self.select = m.get('Select')
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        if m.get('ShortTopic') is not None:
            self.short_topic = m.get('ShortTopic')
        if m.get('Where') is not None:
            self.where = m.get('Where')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('CreateUserId') is not None:
            self.create_user_id = m.get('CreateUserId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('DataType') is not None:
            self.data_type = m.get('DataType')
        if m.get('RuleDesc') is not None:
            self.rule_desc = m.get('RuleDesc')
        if m.get('Created') is not None:
            self.created = m.get('Created')
        if m.get('UtcCreated') is not None:
            self.utc_created = m.get('UtcCreated')
        if m.get('Modified') is not None:
            self.modified = m.get('Modified')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        return self


class ListRuleResponseBodyData(TeaModel):
    def __init__(
        self,
        rule_info: List[ListRuleResponseBodyDataRuleInfo] = None,
    ):
        self.rule_info = rule_info

    def validate(self):
        if self.rule_info:
            for k in self.rule_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['RuleInfo'] = []
        if self.rule_info is not None:
            for k in self.rule_info:
                result['RuleInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.rule_info = []
        if m.get('RuleInfo') is not None:
            for k in m.get('RuleInfo'):
                temp_model = ListRuleResponseBodyDataRuleInfo()
                self.rule_info.append(temp_model.from_map(k))
        return self


class ListRuleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        page: int = None,
        total: int = None,
        page_size: int = None,
        data: ListRuleResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.page = page
        self.total = total
        self.page_size = page_size
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.page is not None:
            result['Page'] = self.page
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Data') is not None:
            temp_model = ListRuleResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListRuleResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListRuleActionsRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        rule_id: int = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.rule_id = rule_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class ListRuleActionsResponseBodyRuleActionListRuleActionInfo(TeaModel):
    def __init__(
        self,
        id: int = None,
        rule_id: int = None,
        type: str = None,
        configuration: str = None,
        error_action_flag: bool = None,
    ):
        self.id = id
        self.rule_id = rule_id
        self.type = type
        self.configuration = configuration
        self.error_action_flag = error_action_flag

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.type is not None:
            result['Type'] = self.type
        if self.configuration is not None:
            result['Configuration'] = self.configuration
        if self.error_action_flag is not None:
            result['ErrorActionFlag'] = self.error_action_flag
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Configuration') is not None:
            self.configuration = m.get('Configuration')
        if m.get('ErrorActionFlag') is not None:
            self.error_action_flag = m.get('ErrorActionFlag')
        return self


class ListRuleActionsResponseBodyRuleActionList(TeaModel):
    def __init__(
        self,
        rule_action_info: List[ListRuleActionsResponseBodyRuleActionListRuleActionInfo] = None,
    ):
        self.rule_action_info = rule_action_info

    def validate(self):
        if self.rule_action_info:
            for k in self.rule_action_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['RuleActionInfo'] = []
        if self.rule_action_info is not None:
            for k in self.rule_action_info:
                result['RuleActionInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.rule_action_info = []
        if m.get('RuleActionInfo') is not None:
            for k in m.get('RuleActionInfo'):
                temp_model = ListRuleActionsResponseBodyRuleActionListRuleActionInfo()
                self.rule_action_info.append(temp_model.from_map(k))
        return self


class ListRuleActionsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        rule_action_list: ListRuleActionsResponseBodyRuleActionList = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.rule_action_list = rule_action_list

    def validate(self):
        if self.rule_action_list:
            self.rule_action_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.rule_action_list is not None:
            result['RuleActionList'] = self.rule_action_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RuleActionList') is not None:
            temp_model = ListRuleActionsResponseBodyRuleActionList()
            self.rule_action_list = temp_model.from_map(m['RuleActionList'])
        return self


class ListRuleActionsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListRuleActionsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListRuleActionsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListTaskRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        limit: int = None,
        job_id: str = None,
        next_token: str = None,
        device: str = None,
        status: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.limit = limit
        self.job_id = job_id
        self.next_token = next_token
        self.device = device
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.limit is not None:
            result['Limit'] = self.limit
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.device is not None:
            result['Device'] = self.device
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Limit') is not None:
            self.limit = m.get('Limit')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Device') is not None:
            self.device = m.get('Device')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListTaskResponseBodyDataData(TeaModel):
    def __init__(
        self,
        job_id: str = None,
        job_name: str = None,
        task_id: str = None,
        product_key: str = None,
        device_name: str = None,
        iot_id: str = None,
        progress: str = None,
        utc_queue_time: str = None,
        utc_modified: str = None,
        status: str = None,
    ):
        self.job_id = job_id
        self.job_name = job_name
        self.task_id = task_id
        self.product_key = product_key
        self.device_name = device_name
        self.iot_id = iot_id
        self.progress = progress
        self.utc_queue_time = utc_queue_time
        self.utc_modified = utc_modified
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.job_name is not None:
            result['JobName'] = self.job_name
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.utc_queue_time is not None:
            result['UtcQueueTime'] = self.utc_queue_time
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('JobName') is not None:
            self.job_name = m.get('JobName')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('UtcQueueTime') is not None:
            self.utc_queue_time = m.get('UtcQueueTime')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListTaskResponseBodyData(TeaModel):
    def __init__(
        self,
        data: List[ListTaskResponseBodyDataData] = None,
    ):
        self.data = data

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['data'] = []
        if self.data is not None:
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data = []
        if m.get('data') is not None:
            for k in m.get('data'):
                temp_model = ListTaskResponseBodyDataData()
                self.data.append(temp_model.from_map(k))
        return self


class ListTaskResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        next_token: str = None,
        data: ListTaskResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.next_token = next_token
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Data') is not None:
            temp_model = ListTaskResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListTaskResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListTaskByPageRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        page_size: str = None,
        page_no: str = None,
        job_id: str = None,
        device: str = None,
        status: str = None,
        device_name: str = None,
        job_name: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.page_size = page_size
        self.page_no = page_no
        self.job_id = job_id
        self.device = device
        self.status = status
        self.device_name = device_name
        self.job_name = job_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.device is not None:
            result['Device'] = self.device
        if self.status is not None:
            result['Status'] = self.status
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.job_name is not None:
            result['JobName'] = self.job_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Device') is not None:
            self.device = m.get('Device')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('JobName') is not None:
            self.job_name = m.get('JobName')
        return self


class ListTaskByPageResponseBodyDataData(TeaModel):
    def __init__(
        self,
        job_id: str = None,
        job_name: str = None,
        task_id: str = None,
        product_key: str = None,
        device_name: str = None,
        iot_id: str = None,
        progress: int = None,
        utc_queue_time: str = None,
        utc_modified: str = None,
        status_detail: str = None,
        status: str = None,
        product_name: str = None,
    ):
        self.job_id = job_id
        self.job_name = job_name
        self.task_id = task_id
        self.product_key = product_key
        self.device_name = device_name
        self.iot_id = iot_id
        self.progress = progress
        self.utc_queue_time = utc_queue_time
        self.utc_modified = utc_modified
        self.status_detail = status_detail
        self.status = status
        self.product_name = product_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.job_name is not None:
            result['JobName'] = self.job_name
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.utc_queue_time is not None:
            result['UtcQueueTime'] = self.utc_queue_time
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.status_detail is not None:
            result['StatusDetail'] = self.status_detail
        if self.status is not None:
            result['Status'] = self.status
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('JobName') is not None:
            self.job_name = m.get('JobName')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('UtcQueueTime') is not None:
            self.utc_queue_time = m.get('UtcQueueTime')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('StatusDetail') is not None:
            self.status_detail = m.get('StatusDetail')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        return self


class ListTaskByPageResponseBodyData(TeaModel):
    def __init__(
        self,
        data: List[ListTaskByPageResponseBodyDataData] = None,
    ):
        self.data = data

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['data'] = []
        if self.data is not None:
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data = []
        if m.get('data') is not None:
            for k in m.get('data'):
                temp_model = ListTaskByPageResponseBodyDataData()
                self.data.append(temp_model.from_map(k))
        return self


class ListTaskByPageResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        total: int = None,
        page_size: int = None,
        page_count: int = None,
        page: int = None,
        data: ListTaskByPageResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.total = total
        self.page_size = page_size
        self.page_count = page_count
        self.page = page
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.page is not None:
            result['Page'] = self.page
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('Data') is not None:
            temp_model = ListTaskByPageResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListTaskByPageResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListTaskByPageResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListTaskByPageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListThingModelVersionRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class ListThingModelVersionResponseBodyDataModelVersions(TeaModel):
    def __init__(
        self,
        model_version: str = None,
        description: str = None,
        gmt_create: int = None,
    ):
        self.model_version = model_version
        self.description = description
        self.gmt_create = gmt_create

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.model_version is not None:
            result['ModelVersion'] = self.model_version
        if self.description is not None:
            result['Description'] = self.description
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ModelVersion') is not None:
            self.model_version = m.get('ModelVersion')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        return self


class ListThingModelVersionResponseBodyData(TeaModel):
    def __init__(
        self,
        model_versions: List[ListThingModelVersionResponseBodyDataModelVersions] = None,
    ):
        self.model_versions = model_versions

    def validate(self):
        if self.model_versions:
            for k in self.model_versions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ModelVersions'] = []
        if self.model_versions is not None:
            for k in self.model_versions:
                result['ModelVersions'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.model_versions = []
        if m.get('ModelVersions') is not None:
            for k in m.get('ModelVersions'):
                temp_model = ListThingModelVersionResponseBodyDataModelVersions()
                self.model_versions.append(temp_model.from_map(k))
        return self


class ListThingModelVersionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: ListThingModelVersionResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = ListThingModelVersionResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListThingModelVersionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListThingModelVersionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListThingModelVersionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListThingTemplatesRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class ListThingTemplatesResponseBodyData(TeaModel):
    def __init__(
        self,
        category_key: str = None,
        category_name: str = None,
    ):
        self.category_key = category_key
        self.category_name = category_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_key is not None:
            result['CategoryKey'] = self.category_key
        if self.category_name is not None:
            result['CategoryName'] = self.category_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CategoryKey') is not None:
            self.category_key = m.get('CategoryKey')
        if m.get('CategoryName') is not None:
            self.category_name = m.get('CategoryName')
        return self


class ListThingTemplatesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: List[ListThingTemplatesResponseBodyData] = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListThingTemplatesResponseBodyData()
                self.data.append(temp_model.from_map(k))
        return self


class ListThingTemplatesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListThingTemplatesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListThingTemplatesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class NotifyAddThingTopoRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        device_list_str: str = None,
        gw_iot_id: str = None,
        gw_product_key: str = None,
        gw_device_name: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.device_list_str = device_list_str
        self.gw_iot_id = gw_iot_id
        self.gw_product_key = gw_product_key
        self.gw_device_name = gw_device_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.device_list_str is not None:
            result['DeviceListStr'] = self.device_list_str
        if self.gw_iot_id is not None:
            result['GwIotId'] = self.gw_iot_id
        if self.gw_product_key is not None:
            result['GwProductKey'] = self.gw_product_key
        if self.gw_device_name is not None:
            result['GwDeviceName'] = self.gw_device_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('DeviceListStr') is not None:
            self.device_list_str = m.get('DeviceListStr')
        if m.get('GwIotId') is not None:
            self.gw_iot_id = m.get('GwIotId')
        if m.get('GwProductKey') is not None:
            self.gw_product_key = m.get('GwProductKey')
        if m.get('GwDeviceName') is not None:
            self.gw_device_name = m.get('GwDeviceName')
        return self


class NotifyAddThingTopoResponseBodyData(TeaModel):
    def __init__(
        self,
        message_id: str = None,
    ):
        self.message_id = message_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message_id is not None:
            result['MessageId'] = self.message_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MessageId') is not None:
            self.message_id = m.get('MessageId')
        return self


class NotifyAddThingTopoResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_message: str = None,
        code: str = None,
        data: NotifyAddThingTopoResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_message = error_message
        self.code = code
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = NotifyAddThingTopoResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class NotifyAddThingTopoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: NotifyAddThingTopoResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = NotifyAddThingTopoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class OpenIotServiceRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
    ):
        self.owner_id = owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class OpenIotServiceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        order_id: str = None,
    ):
        self.request_id = request_id
        self.order_id = order_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        return self


class OpenIotServiceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: OpenIotServiceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = OpenIotServiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class PrintByTemplateRequest(TeaModel):
    def __init__(
        self,
        params_json_string: str = None,
        iot_id: str = None,
        project_code: str = None,
        iot_instance_id: str = None,
        template_biz_code: str = None,
        product_key: str = None,
        device_name: str = None,
    ):
        self.params_json_string = params_json_string
        self.iot_id = iot_id
        self.project_code = project_code
        self.iot_instance_id = iot_instance_id
        self.template_biz_code = template_biz_code
        self.product_key = product_key
        self.device_name = device_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.params_json_string is not None:
            result['ParamsJsonString'] = self.params_json_string
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.project_code is not None:
            result['ProjectCode'] = self.project_code
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.template_biz_code is not None:
            result['TemplateBizCode'] = self.template_biz_code
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ParamsJsonString') is not None:
            self.params_json_string = m.get('ParamsJsonString')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('ProjectCode') is not None:
            self.project_code = m.get('ProjectCode')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('TemplateBizCode') is not None:
            self.template_biz_code = m.get('TemplateBizCode')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        return self


class PrintByTemplateResponseBodyData(TeaModel):
    def __init__(
        self,
        success: bool = None,
        device_error_code: str = None,
        device_error_message: str = None,
        id: str = None,
        retry_count: int = None,
        max_retry_count: int = None,
    ):
        self.success = success
        self.device_error_code = device_error_code
        self.device_error_message = device_error_message
        self.id = id
        self.retry_count = retry_count
        self.max_retry_count = max_retry_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        if self.device_error_code is not None:
            result['DeviceErrorCode'] = self.device_error_code
        if self.device_error_message is not None:
            result['DeviceErrorMessage'] = self.device_error_message
        if self.id is not None:
            result['Id'] = self.id
        if self.retry_count is not None:
            result['RetryCount'] = self.retry_count
        if self.max_retry_count is not None:
            result['MaxRetryCount'] = self.max_retry_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('DeviceErrorCode') is not None:
            self.device_error_code = m.get('DeviceErrorCode')
        if m.get('DeviceErrorMessage') is not None:
            self.device_error_message = m.get('DeviceErrorMessage')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RetryCount') is not None:
            self.retry_count = m.get('RetryCount')
        if m.get('MaxRetryCount') is not None:
            self.max_retry_count = m.get('MaxRetryCount')
        return self


class PrintByTemplateResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: PrintByTemplateResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = PrintByTemplateResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class PrintByTemplateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: PrintByTemplateResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = PrintByTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class PubRequestUserProp(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class PubRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
        qos: int = None,
        topic_full_name: str = None,
        message_content: str = None,
        response_topic: str = None,
        correlation_data: str = None,
        user_prop: List[PubRequestUserProp] = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.qos = qos
        self.topic_full_name = topic_full_name
        self.message_content = message_content
        self.response_topic = response_topic
        self.correlation_data = correlation_data
        self.user_prop = user_prop

    def validate(self):
        if self.user_prop:
            for k in self.user_prop:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.qos is not None:
            result['Qos'] = self.qos
        if self.topic_full_name is not None:
            result['TopicFullName'] = self.topic_full_name
        if self.message_content is not None:
            result['MessageContent'] = self.message_content
        if self.response_topic is not None:
            result['ResponseTopic'] = self.response_topic
        if self.correlation_data is not None:
            result['CorrelationData'] = self.correlation_data
        result['UserProp'] = []
        if self.user_prop is not None:
            for k in self.user_prop:
                result['UserProp'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Qos') is not None:
            self.qos = m.get('Qos')
        if m.get('TopicFullName') is not None:
            self.topic_full_name = m.get('TopicFullName')
        if m.get('MessageContent') is not None:
            self.message_content = m.get('MessageContent')
        if m.get('ResponseTopic') is not None:
            self.response_topic = m.get('ResponseTopic')
        if m.get('CorrelationData') is not None:
            self.correlation_data = m.get('CorrelationData')
        self.user_prop = []
        if m.get('UserProp') is not None:
            for k in m.get('UserProp'):
                temp_model = PubRequestUserProp()
                self.user_prop.append(temp_model.from_map(k))
        return self


class PubResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        message_id: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.message_id = message_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.message_id is not None:
            result['MessageId'] = self.message_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('MessageId') is not None:
            self.message_id = m.get('MessageId')
        return self


class PubResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: PubResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = PubResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class PubBroadcastRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
        topic_full_name: str = None,
        message_content: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.topic_full_name = topic_full_name
        self.message_content = message_content

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.topic_full_name is not None:
            result['TopicFullName'] = self.topic_full_name
        if self.message_content is not None:
            result['MessageContent'] = self.message_content
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('TopicFullName') is not None:
            self.topic_full_name = m.get('TopicFullName')
        if m.get('MessageContent') is not None:
            self.message_content = m.get('MessageContent')
        return self


class PubBroadcastResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        message_id: int = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.message_id = message_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.message_id is not None:
            result['MessageId'] = self.message_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('MessageId') is not None:
            self.message_id = m.get('MessageId')
        return self


class PubBroadcastResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: PubBroadcastResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = PubBroadcastResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class PublishStudioAppRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        app_id: str = None,
        description: str = None,
        project_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.app_id = app_id
        self.description = description
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.description is not None:
            result['Description'] = self.description
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class PublishStudioAppResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: bool = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class PublishStudioAppResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: PublishStudioAppResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = PublishStudioAppResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class PublishThingModelRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        resource_group_id: str = None,
        product_key: str = None,
        model_version: str = None,
        description: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.resource_group_id = resource_group_id
        self.product_key = product_key
        self.model_version = model_version
        self.description = description

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.model_version is not None:
            result['ModelVersion'] = self.model_version
        if self.description is not None:
            result['Description'] = self.description
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ModelVersion') is not None:
            self.model_version = m.get('ModelVersion')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        return self


class PublishThingModelResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class PublishThingModelResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: PublishThingModelResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = PublishThingModelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class PushSpeechRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        push_mode: str = None,
        group_id: str = None,
        speech_code_list: List[str] = None,
        iot_id: str = None,
        project_code: str = None,
        device_name: str = None,
        product_key: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.push_mode = push_mode
        self.group_id = group_id
        self.speech_code_list = speech_code_list
        self.iot_id = iot_id
        self.project_code = project_code
        self.device_name = device_name
        self.product_key = product_key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.push_mode is not None:
            result['PushMode'] = self.push_mode
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.speech_code_list is not None:
            result['SpeechCodeList'] = self.speech_code_list
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.project_code is not None:
            result['ProjectCode'] = self.project_code
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PushMode') is not None:
            self.push_mode = m.get('PushMode')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('SpeechCodeList') is not None:
            self.speech_code_list = m.get('SpeechCodeList')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('ProjectCode') is not None:
            self.project_code = m.get('ProjectCode')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class PushSpeechResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class PushSpeechResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: PushSpeechResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = PushSpeechResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryAppDeviceListRequestTagList(TeaModel):
    def __init__(
        self,
        tag_name: str = None,
        tag_value: str = None,
    ):
        self.tag_name = tag_name
        self.tag_value = tag_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_name is not None:
            result['TagName'] = self.tag_name
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagName') is not None:
            self.tag_name = m.get('TagName')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class QueryAppDeviceListRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        page_size: int = None,
        product_key_list: List[str] = None,
        category_key_list: List[str] = None,
        app_key: str = None,
        tag_list: List[QueryAppDeviceListRequestTagList] = None,
        current_page: int = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.page_size = page_size
        self.product_key_list = product_key_list
        self.category_key_list = category_key_list
        self.app_key = app_key
        self.tag_list = tag_list
        self.current_page = current_page

    def validate(self):
        if self.tag_list:
            for k in self.tag_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_key_list is not None:
            result['ProductKeyList'] = self.product_key_list
        if self.category_key_list is not None:
            result['CategoryKeyList'] = self.category_key_list
        if self.app_key is not None:
            result['AppKey'] = self.app_key
        result['TagList'] = []
        if self.tag_list is not None:
            for k in self.tag_list:
                result['TagList'].append(k.to_map() if k else None)
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductKeyList') is not None:
            self.product_key_list = m.get('ProductKeyList')
        if m.get('CategoryKeyList') is not None:
            self.category_key_list = m.get('CategoryKeyList')
        if m.get('AppKey') is not None:
            self.app_key = m.get('AppKey')
        self.tag_list = []
        if m.get('TagList') is not None:
            for k in m.get('TagList'):
                temp_model = QueryAppDeviceListRequestTagList()
                self.tag_list.append(temp_model.from_map(k))
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class QueryAppDeviceListResponseBodyDataData(TeaModel):
    def __init__(
        self,
        product_name: str = None,
        product_key: str = None,
        device_name: str = None,
        node_type: int = None,
        status: str = None,
        active_time: str = None,
        last_online_time: str = None,
        create_time: str = None,
        child_device_count: int = None,
        utc_active_time: str = None,
        utc_last_online_time: str = None,
        utc_create_time: str = None,
    ):
        self.product_name = product_name
        self.product_key = product_key
        self.device_name = device_name
        self.node_type = node_type
        self.status = status
        self.active_time = active_time
        self.last_online_time = last_online_time
        self.create_time = create_time
        self.child_device_count = child_device_count
        self.utc_active_time = utc_active_time
        self.utc_last_online_time = utc_last_online_time
        self.utc_create_time = utc_create_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.node_type is not None:
            result['NodeType'] = self.node_type
        if self.status is not None:
            result['Status'] = self.status
        if self.active_time is not None:
            result['ActiveTime'] = self.active_time
        if self.last_online_time is not None:
            result['LastOnlineTime'] = self.last_online_time
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.child_device_count is not None:
            result['ChildDeviceCount'] = self.child_device_count
        if self.utc_active_time is not None:
            result['UtcActiveTime'] = self.utc_active_time
        if self.utc_last_online_time is not None:
            result['UtcLastOnlineTime'] = self.utc_last_online_time
        if self.utc_create_time is not None:
            result['UtcCreateTime'] = self.utc_create_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('NodeType') is not None:
            self.node_type = m.get('NodeType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ActiveTime') is not None:
            self.active_time = m.get('ActiveTime')
        if m.get('LastOnlineTime') is not None:
            self.last_online_time = m.get('LastOnlineTime')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ChildDeviceCount') is not None:
            self.child_device_count = m.get('ChildDeviceCount')
        if m.get('UtcActiveTime') is not None:
            self.utc_active_time = m.get('UtcActiveTime')
        if m.get('UtcLastOnlineTime') is not None:
            self.utc_last_online_time = m.get('UtcLastOnlineTime')
        if m.get('UtcCreateTime') is not None:
            self.utc_create_time = m.get('UtcCreateTime')
        return self


class QueryAppDeviceListResponseBodyData(TeaModel):
    def __init__(
        self,
        data: List[QueryAppDeviceListResponseBodyDataData] = None,
    ):
        self.data = data

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = QueryAppDeviceListResponseBodyDataData()
                self.data.append(temp_model.from_map(k))
        return self


class QueryAppDeviceListResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_message: str = None,
        code: str = None,
        page: int = None,
        page_size: int = None,
        page_count: int = None,
        total: int = None,
        data: QueryAppDeviceListResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_message = error_message
        self.code = code
        self.page = page
        self.page_size = page_size
        self.page_count = page_count
        self.total = total
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.page is not None:
            result['Page'] = self.page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.total is not None:
            result['Total'] = self.total
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Data') is not None:
            temp_model = QueryAppDeviceListResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryAppDeviceListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryAppDeviceListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryAppDeviceListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryBatchRegisterDeviceStatusRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
        apply_id: int = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.apply_id = apply_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.apply_id is not None:
            result['ApplyId'] = self.apply_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ApplyId') is not None:
            self.apply_id = m.get('ApplyId')
        return self


class QueryBatchRegisterDeviceStatusResponseBodyDataValidList(TeaModel):
    def __init__(
        self,
        name: List[str] = None,
    ):
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class QueryBatchRegisterDeviceStatusResponseBodyDataInvalidList(TeaModel):
    def __init__(
        self,
        name: List[str] = None,
    ):
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class QueryBatchRegisterDeviceStatusResponseBodyData(TeaModel):
    def __init__(
        self,
        status: str = None,
        valid_list: QueryBatchRegisterDeviceStatusResponseBodyDataValidList = None,
        invalid_list: QueryBatchRegisterDeviceStatusResponseBodyDataInvalidList = None,
    ):
        self.status = status
        self.valid_list = valid_list
        self.invalid_list = invalid_list

    def validate(self):
        if self.valid_list:
            self.valid_list.validate()
        if self.invalid_list:
            self.invalid_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.valid_list is not None:
            result['ValidList'] = self.valid_list.to_map()
        if self.invalid_list is not None:
            result['InvalidList'] = self.invalid_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ValidList') is not None:
            temp_model = QueryBatchRegisterDeviceStatusResponseBodyDataValidList()
            self.valid_list = temp_model.from_map(m['ValidList'])
        if m.get('InvalidList') is not None:
            temp_model = QueryBatchRegisterDeviceStatusResponseBodyDataInvalidList()
            self.invalid_list = temp_model.from_map(m['InvalidList'])
        return self


class QueryBatchRegisterDeviceStatusResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: QueryBatchRegisterDeviceStatusResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryBatchRegisterDeviceStatusResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryBatchRegisterDeviceStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryBatchRegisterDeviceStatusResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryBatchRegisterDeviceStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryCertUrlByApplyIdRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        apply_id: int = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.apply_id = apply_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.apply_id is not None:
            result['ApplyId'] = self.apply_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ApplyId') is not None:
            self.apply_id = m.get('ApplyId')
        return self


class QueryCertUrlByApplyIdResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        cert_url: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.cert_url = cert_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.cert_url is not None:
            result['CertUrl'] = self.cert_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('CertUrl') is not None:
            self.cert_url = m.get('CertUrl')
        return self


class QueryCertUrlByApplyIdResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryCertUrlByApplyIdResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryCertUrlByApplyIdResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryConsumerGroupByGroupIdRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        group_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.group_id = group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        return self


class QueryConsumerGroupByGroupIdResponseBodyData(TeaModel):
    def __init__(
        self,
        group_id: str = None,
        group_name: str = None,
        create_time: str = None,
    ):
        self.group_id = group_id
        self.group_name = group_name
        self.create_time = create_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        return self


class QueryConsumerGroupByGroupIdResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_message: str = None,
        code: str = None,
        data: QueryConsumerGroupByGroupIdResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_message = error_message
        self.code = code
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = QueryConsumerGroupByGroupIdResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryConsumerGroupByGroupIdResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryConsumerGroupByGroupIdResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryConsumerGroupByGroupIdResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryConsumerGroupListRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        page_size: int = None,
        current_page: int = None,
        fuzzy: bool = None,
        group_name: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.page_size = page_size
        self.current_page = current_page
        self.fuzzy = fuzzy
        self.group_name = group_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.fuzzy is not None:
            result['Fuzzy'] = self.fuzzy
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Fuzzy') is not None:
            self.fuzzy = m.get('Fuzzy')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        return self


class QueryConsumerGroupListResponseBodyDataConsumerGroupDTO(TeaModel):
    def __init__(
        self,
        group_id: str = None,
        group_name: str = None,
        create_time: str = None,
    ):
        self.group_id = group_id
        self.group_name = group_name
        self.create_time = create_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        return self


class QueryConsumerGroupListResponseBodyData(TeaModel):
    def __init__(
        self,
        consumer_group_dto: List[QueryConsumerGroupListResponseBodyDataConsumerGroupDTO] = None,
    ):
        self.consumer_group_dto = consumer_group_dto

    def validate(self):
        if self.consumer_group_dto:
            for k in self.consumer_group_dto:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ConsumerGroupDTO'] = []
        if self.consumer_group_dto is not None:
            for k in self.consumer_group_dto:
                result['ConsumerGroupDTO'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.consumer_group_dto = []
        if m.get('ConsumerGroupDTO') is not None:
            for k in m.get('ConsumerGroupDTO'):
                temp_model = QueryConsumerGroupListResponseBodyDataConsumerGroupDTO()
                self.consumer_group_dto.append(temp_model.from_map(k))
        return self


class QueryConsumerGroupListResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_message: str = None,
        page_size: int = None,
        page_count: int = None,
        total: int = None,
        current_page: int = None,
        code: str = None,
        data: QueryConsumerGroupListResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_message = error_message
        self.page_size = page_size
        self.page_count = page_count
        self.total = total
        self.current_page = current_page
        self.code = code
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.total is not None:
            result['Total'] = self.total
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = QueryConsumerGroupListResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryConsumerGroupListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryConsumerGroupListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryConsumerGroupListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryConsumerGroupStatusRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        group_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.group_id = group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        return self


class QueryConsumerGroupStatusResponseBodyClientConnectionStatusListConsumerGroupClientConnectionInfo(TeaModel):
    def __init__(
        self,
        client_id: str = None,
        client_ip_port: str = None,
        online_time: int = None,
        real_time_consume_count_per_minute: int = None,
        accumulated_consume_count_per_minute: int = None,
    ):
        self.client_id = client_id
        self.client_ip_port = client_ip_port
        self.online_time = online_time
        self.real_time_consume_count_per_minute = real_time_consume_count_per_minute
        self.accumulated_consume_count_per_minute = accumulated_consume_count_per_minute

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_id is not None:
            result['ClientId'] = self.client_id
        if self.client_ip_port is not None:
            result['ClientIpPort'] = self.client_ip_port
        if self.online_time is not None:
            result['OnlineTime'] = self.online_time
        if self.real_time_consume_count_per_minute is not None:
            result['RealTimeConsumeCountPerMinute'] = self.real_time_consume_count_per_minute
        if self.accumulated_consume_count_per_minute is not None:
            result['AccumulatedConsumeCountPerMinute'] = self.accumulated_consume_count_per_minute
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientId') is not None:
            self.client_id = m.get('ClientId')
        if m.get('ClientIpPort') is not None:
            self.client_ip_port = m.get('ClientIpPort')
        if m.get('OnlineTime') is not None:
            self.online_time = m.get('OnlineTime')
        if m.get('RealTimeConsumeCountPerMinute') is not None:
            self.real_time_consume_count_per_minute = m.get('RealTimeConsumeCountPerMinute')
        if m.get('AccumulatedConsumeCountPerMinute') is not None:
            self.accumulated_consume_count_per_minute = m.get('AccumulatedConsumeCountPerMinute')
        return self


class QueryConsumerGroupStatusResponseBodyClientConnectionStatusList(TeaModel):
    def __init__(
        self,
        consumer_group_client_connection_info: List[QueryConsumerGroupStatusResponseBodyClientConnectionStatusListConsumerGroupClientConnectionInfo] = None,
    ):
        self.consumer_group_client_connection_info = consumer_group_client_connection_info

    def validate(self):
        if self.consumer_group_client_connection_info:
            for k in self.consumer_group_client_connection_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ConsumerGroupClientConnectionInfo'] = []
        if self.consumer_group_client_connection_info is not None:
            for k in self.consumer_group_client_connection_info:
                result['ConsumerGroupClientConnectionInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.consumer_group_client_connection_info = []
        if m.get('ConsumerGroupClientConnectionInfo') is not None:
            for k in m.get('ConsumerGroupClientConnectionInfo'):
                temp_model = QueryConsumerGroupStatusResponseBodyClientConnectionStatusListConsumerGroupClientConnectionInfo()
                self.consumer_group_client_connection_info.append(temp_model.from_map(k))
        return self


class QueryConsumerGroupStatusResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_message: str = None,
        accumulation_count: int = None,
        consumer_speed: int = None,
        last_consumer_time: str = None,
        code: str = None,
        accumulated_consume_count_per_minute: int = None,
        real_time_consume_count_per_minute: int = None,
        client_connection_status_list: QueryConsumerGroupStatusResponseBodyClientConnectionStatusList = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_message = error_message
        self.accumulation_count = accumulation_count
        self.consumer_speed = consumer_speed
        self.last_consumer_time = last_consumer_time
        self.code = code
        self.accumulated_consume_count_per_minute = accumulated_consume_count_per_minute
        self.real_time_consume_count_per_minute = real_time_consume_count_per_minute
        self.client_connection_status_list = client_connection_status_list

    def validate(self):
        if self.client_connection_status_list:
            self.client_connection_status_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.accumulation_count is not None:
            result['AccumulationCount'] = self.accumulation_count
        if self.consumer_speed is not None:
            result['ConsumerSpeed'] = self.consumer_speed
        if self.last_consumer_time is not None:
            result['LastConsumerTime'] = self.last_consumer_time
        if self.code is not None:
            result['Code'] = self.code
        if self.accumulated_consume_count_per_minute is not None:
            result['AccumulatedConsumeCountPerMinute'] = self.accumulated_consume_count_per_minute
        if self.real_time_consume_count_per_minute is not None:
            result['RealTimeConsumeCountPerMinute'] = self.real_time_consume_count_per_minute
        if self.client_connection_status_list is not None:
            result['ClientConnectionStatusList'] = self.client_connection_status_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('AccumulationCount') is not None:
            self.accumulation_count = m.get('AccumulationCount')
        if m.get('ConsumerSpeed') is not None:
            self.consumer_speed = m.get('ConsumerSpeed')
        if m.get('LastConsumerTime') is not None:
            self.last_consumer_time = m.get('LastConsumerTime')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('AccumulatedConsumeCountPerMinute') is not None:
            self.accumulated_consume_count_per_minute = m.get('AccumulatedConsumeCountPerMinute')
        if m.get('RealTimeConsumeCountPerMinute') is not None:
            self.real_time_consume_count_per_minute = m.get('RealTimeConsumeCountPerMinute')
        if m.get('ClientConnectionStatusList') is not None:
            temp_model = QueryConsumerGroupStatusResponseBodyClientConnectionStatusList()
            self.client_connection_status_list = temp_model.from_map(m['ClientConnectionStatusList'])
        return self


class QueryConsumerGroupStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryConsumerGroupStatusResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryConsumerGroupStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryDetailSceneRuleLogRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        rule_id: str = None,
        start_time: int = None,
        end_time: int = None,
        trace_id: str = None,
        page_size: int = None,
        current_page: int = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.rule_id = rule_id
        self.start_time = start_time
        self.end_time = end_time
        self.trace_id = trace_id
        self.page_size = page_size
        self.current_page = current_page

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class QueryDetailSceneRuleLogResponseBodyDataLogList(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        pk_dn: str = None,
    ):
        self.code = code
        self.message = message
        self.pk_dn = pk_dn

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.pk_dn is not None:
            result['PkDn'] = self.pk_dn
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PkDn') is not None:
            self.pk_dn = m.get('PkDn')
        return self


class QueryDetailSceneRuleLogResponseBodyData(TeaModel):
    def __init__(
        self,
        total: int = None,
        page_size: int = None,
        current_page: int = None,
        log_list: List[QueryDetailSceneRuleLogResponseBodyDataLogList] = None,
    ):
        self.total = total
        self.page_size = page_size
        self.current_page = current_page
        self.log_list = log_list

    def validate(self):
        if self.log_list:
            for k in self.log_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        result['LogList'] = []
        if self.log_list is not None:
            for k in self.log_list:
                result['LogList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        self.log_list = []
        if m.get('LogList') is not None:
            for k in m.get('LogList'):
                temp_model = QueryDetailSceneRuleLogResponseBodyDataLogList()
                self.log_list.append(temp_model.from_map(k))
        return self


class QueryDetailSceneRuleLogResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_message: str = None,
        code: str = None,
        data: QueryDetailSceneRuleLogResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_message = error_message
        self.code = code
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = QueryDetailSceneRuleLogResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryDetailSceneRuleLogResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryDetailSceneRuleLogResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryDetailSceneRuleLogResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryDeviceRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        page_size: int = None,
        product_key: str = None,
        current_page: int = None,
        next_token: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.page_size = page_size
        self.product_key = product_key
        self.current_page = current_page
        self.next_token = next_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        return self


class QueryDeviceResponseBodyDataDeviceInfo(TeaModel):
    def __init__(
        self,
        device_id: str = None,
        device_secret: str = None,
        product_key: str = None,
        device_status: str = None,
        device_name: str = None,
        device_type: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        utc_create: str = None,
        utc_modified: str = None,
        iot_id: str = None,
        nickname: str = None,
    ):
        self.device_id = device_id
        self.device_secret = device_secret
        self.product_key = product_key
        self.device_status = device_status
        self.device_name = device_name
        self.device_type = device_type
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.utc_create = utc_create
        self.utc_modified = utc_modified
        self.iot_id = iot_id
        self.nickname = nickname

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.device_secret is not None:
            result['DeviceSecret'] = self.device_secret
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_status is not None:
            result['DeviceStatus'] = self.device_status
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.device_type is not None:
            result['DeviceType'] = self.device_type
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.nickname is not None:
            result['Nickname'] = self.nickname
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('DeviceSecret') is not None:
            self.device_secret = m.get('DeviceSecret')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceStatus') is not None:
            self.device_status = m.get('DeviceStatus')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('DeviceType') is not None:
            self.device_type = m.get('DeviceType')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('Nickname') is not None:
            self.nickname = m.get('Nickname')
        return self


class QueryDeviceResponseBodyData(TeaModel):
    def __init__(
        self,
        device_info: List[QueryDeviceResponseBodyDataDeviceInfo] = None,
    ):
        self.device_info = device_info

    def validate(self):
        if self.device_info:
            for k in self.device_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DeviceInfo'] = []
        if self.device_info is not None:
            for k in self.device_info:
                result['DeviceInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.device_info = []
        if m.get('DeviceInfo') is not None:
            for k in m.get('DeviceInfo'):
                temp_model = QueryDeviceResponseBodyDataDeviceInfo()
                self.device_info.append(temp_model.from_map(k))
        return self


class QueryDeviceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        total: int = None,
        page_size: int = None,
        page_count: int = None,
        page: int = None,
        next_token: str = None,
        data: QueryDeviceResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.total = total
        self.page_size = page_size
        self.page_count = page_count
        self.page = page
        self.next_token = next_token
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.page is not None:
            result['Page'] = self.page
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Data') is not None:
            temp_model = QueryDeviceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryDeviceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryDeviceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryDeviceBySQLRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        sql: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.sql = sql

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.sql is not None:
            result['SQL'] = self.sql
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('SQL') is not None:
            self.sql = m.get('SQL')
        return self


class QueryDeviceBySQLResponseBodyDataGroups(TeaModel):
    def __init__(
        self,
        group_id: str = None,
    ):
        self.group_id = group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        return self


class QueryDeviceBySQLResponseBodyDataTags(TeaModel):
    def __init__(
        self,
        tag_name: str = None,
        tag_value: str = None,
    ):
        self.tag_name = tag_name
        self.tag_value = tag_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_name is not None:
            result['TagName'] = self.tag_name
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagName') is not None:
            self.tag_name = m.get('TagName')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class QueryDeviceBySQLResponseBodyDataOTAModules(TeaModel):
    def __init__(
        self,
        module_name: str = None,
        firmware_version: str = None,
    ):
        self.module_name = module_name
        self.firmware_version = firmware_version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.module_name is not None:
            result['ModuleName'] = self.module_name
        if self.firmware_version is not None:
            result['FirmwareVersion'] = self.firmware_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ModuleName') is not None:
            self.module_name = m.get('ModuleName')
        if m.get('FirmwareVersion') is not None:
            self.firmware_version = m.get('FirmwareVersion')
        return self


class QueryDeviceBySQLResponseBodyData(TeaModel):
    def __init__(
        self,
        product_key: str = None,
        device_name: str = None,
        nickname: str = None,
        status: str = None,
        active_time: str = None,
        iot_id: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        groups: List[QueryDeviceBySQLResponseBodyDataGroups] = None,
        tags: List[QueryDeviceBySQLResponseBodyDataTags] = None,
        otamodules: List[QueryDeviceBySQLResponseBodyDataOTAModules] = None,
    ):
        self.product_key = product_key
        self.device_name = device_name
        self.nickname = nickname
        self.status = status
        self.active_time = active_time
        self.iot_id = iot_id
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.groups = groups
        self.tags = tags
        self.otamodules = otamodules

    def validate(self):
        if self.groups:
            for k in self.groups:
                if k:
                    k.validate()
        if self.tags:
            for k in self.tags:
                if k:
                    k.validate()
        if self.otamodules:
            for k in self.otamodules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.nickname is not None:
            result['Nickname'] = self.nickname
        if self.status is not None:
            result['Status'] = self.status
        if self.active_time is not None:
            result['ActiveTime'] = self.active_time
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        result['Groups'] = []
        if self.groups is not None:
            for k in self.groups:
                result['Groups'].append(k.to_map() if k else None)
        result['Tags'] = []
        if self.tags is not None:
            for k in self.tags:
                result['Tags'].append(k.to_map() if k else None)
        result['OTAModules'] = []
        if self.otamodules is not None:
            for k in self.otamodules:
                result['OTAModules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('Nickname') is not None:
            self.nickname = m.get('Nickname')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ActiveTime') is not None:
            self.active_time = m.get('ActiveTime')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        self.groups = []
        if m.get('Groups') is not None:
            for k in m.get('Groups'):
                temp_model = QueryDeviceBySQLResponseBodyDataGroups()
                self.groups.append(temp_model.from_map(k))
        self.tags = []
        if m.get('Tags') is not None:
            for k in m.get('Tags'):
                temp_model = QueryDeviceBySQLResponseBodyDataTags()
                self.tags.append(temp_model.from_map(k))
        self.otamodules = []
        if m.get('OTAModules') is not None:
            for k in m.get('OTAModules'):
                temp_model = QueryDeviceBySQLResponseBodyDataOTAModules()
                self.otamodules.append(temp_model.from_map(k))
        return self


class QueryDeviceBySQLResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        total_count: int = None,
        data: List[QueryDeviceBySQLResponseBodyData] = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.total_count = total_count
        self.data = data

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = QueryDeviceBySQLResponseBodyData()
                self.data.append(temp_model.from_map(k))
        return self


class QueryDeviceBySQLResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryDeviceBySQLResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryDeviceBySQLResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryDeviceByStatusRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
        status: int = None,
        current_page: int = None,
        page_size: int = None,
        resource_group_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.status = status
        self.current_page = current_page
        self.page_size = page_size
        self.resource_group_id = resource_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.status is not None:
            result['Status'] = self.status
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class QueryDeviceByStatusResponseBodyDataSimpleDeviceInfo(TeaModel):
    def __init__(
        self,
        product_key: str = None,
        device_name: str = None,
        status: str = None,
        iot_id: str = None,
        nickname: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        utc_create: str = None,
        utc_modified: str = None,
        device_secret: str = None,
    ):
        self.product_key = product_key
        self.device_name = device_name
        self.status = status
        self.iot_id = iot_id
        self.nickname = nickname
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.utc_create = utc_create
        self.utc_modified = utc_modified
        self.device_secret = device_secret

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.status is not None:
            result['Status'] = self.status
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.nickname is not None:
            result['Nickname'] = self.nickname
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.device_secret is not None:
            result['DeviceSecret'] = self.device_secret
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('Nickname') is not None:
            self.nickname = m.get('Nickname')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('DeviceSecret') is not None:
            self.device_secret = m.get('DeviceSecret')
        return self


class QueryDeviceByStatusResponseBodyData(TeaModel):
    def __init__(
        self,
        simple_device_info: List[QueryDeviceByStatusResponseBodyDataSimpleDeviceInfo] = None,
    ):
        self.simple_device_info = simple_device_info

    def validate(self):
        if self.simple_device_info:
            for k in self.simple_device_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SimpleDeviceInfo'] = []
        if self.simple_device_info is not None:
            for k in self.simple_device_info:
                result['SimpleDeviceInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.simple_device_info = []
        if m.get('SimpleDeviceInfo') is not None:
            for k in m.get('SimpleDeviceInfo'):
                temp_model = QueryDeviceByStatusResponseBodyDataSimpleDeviceInfo()
                self.simple_device_info.append(temp_model.from_map(k))
        return self


class QueryDeviceByStatusResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        page: int = None,
        page_size: int = None,
        page_count: int = None,
        total: int = None,
        data: QueryDeviceByStatusResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.page = page
        self.page_size = page_size
        self.page_count = page_count
        self.total = total
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.page is not None:
            result['Page'] = self.page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.total is not None:
            result['Total'] = self.total
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Data') is not None:
            temp_model = QueryDeviceByStatusResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryDeviceByStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryDeviceByStatusResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryDeviceByStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryDeviceByTagsRequestTag(TeaModel):
    def __init__(
        self,
        tag_key: str = None,
        tag_value: str = None,
    ):
        self.tag_key = tag_key
        self.tag_value = tag_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class QueryDeviceByTagsRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        tag: List[QueryDeviceByTagsRequestTag] = None,
        current_page: int = None,
        page_size: int = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.tag = tag
        self.curren