"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Resolver = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const aws_appsync_1 = require("aws-cdk-lib/aws-appsync");
const caching_key_1 = require("./caching-key");
/**
 * An AppSync resolver
 */
class Resolver extends constructs_1.Construct {
    constructor(scope, id, props) {
        var _b, _c;
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_alpha_ResolverProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        const pipelineConfig = props.pipelineConfig && props.pipelineConfig.length ?
            { functions: props.pipelineConfig.map((func) => func.functionId) }
            : undefined;
        if (pipelineConfig && props.dataSource) {
            throw new Error(`Pipeline Resolver cannot have data source. Received: ${props.dataSource.name}`);
        }
        if (((_b = props.cachingConfig) === null || _b === void 0 ? void 0 : _b.ttl) && (props.cachingConfig.ttl.toSeconds() < 1 || props.cachingConfig.ttl.toSeconds() > 3600)) {
            throw new Error(`Caching config TTL must be between 1 and 3600 seconds. Received: ${props.cachingConfig.ttl.toSeconds()}`);
        }
        if ((_c = props.cachingConfig) === null || _c === void 0 ? void 0 : _c.cachingKeys) {
            if (props.cachingConfig.cachingKeys.find(cachingKey => !aws_cdk_lib_1.Token.isUnresolved(cachingKey) && !caching_key_1.BASE_CACHING_KEYS.find(baseCachingKey => cachingKey.startsWith(baseCachingKey)))) {
                throw new Error(`Caching config keys must begin with $context.arguments, $context.source or $context.identity. Received: ${props.cachingConfig.cachingKeys}`);
            }
        }
        this.resolver = new aws_appsync_1.CfnResolver(this, 'Resource', {
            apiId: props.api.apiId,
            typeName: props.typeName,
            fieldName: props.fieldName,
            dataSourceName: props.dataSource ? props.dataSource.name : undefined,
            kind: pipelineConfig ? 'PIPELINE' : 'UNIT',
            pipelineConfig: pipelineConfig,
            requestMappingTemplate: props.requestMappingTemplate ? props.requestMappingTemplate.renderTemplate() : undefined,
            responseMappingTemplate: props.responseMappingTemplate ? props.responseMappingTemplate.renderTemplate() : undefined,
            cachingConfig: this.createCachingConfig(props.cachingConfig),
        });
        props.api.addSchemaDependency(this.resolver);
        if (props.dataSource) {
            this.resolver.addDependsOn(props.dataSource.ds);
        }
        this.arn = this.resolver.attrResolverArn;
    }
    createCachingConfig(config) {
        var _b;
        return config ? {
            cachingKeys: config.cachingKeys,
            ttl: (_b = config.ttl) === null || _b === void 0 ? void 0 : _b.toSeconds(),
        } : undefined;
    }
}
exports.Resolver = Resolver;
_a = JSII_RTTI_SYMBOL_1;
Resolver[_a] = { fqn: "@aws-cdk/aws-appsync-alpha.Resolver", version: "2.23.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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