"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MappingTemplate = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs_1 = require("fs");
/**
 * MappingTemplates for AppSync resolvers
 */
class MappingTemplate {
    /**
     * Create a mapping template from the given string
     */
    static fromString(template) {
        return new StringMappingTemplate(template);
    }
    /**
     * Create a mapping template from the given file
     */
    static fromFile(fileName) {
        return new StringMappingTemplate(fs_1.readFileSync(fileName).toString('utf-8'));
    }
    /**
     * Mapping template for a result list from DynamoDB
     */
    static dynamoDbResultList() {
        return this.fromString('$util.toJson($ctx.result.items)');
    }
    /**
     * Mapping template for a single result item from DynamoDB
     */
    static dynamoDbResultItem() {
        return this.fromString('$util.toJson($ctx.result)');
    }
    /**
     * Mapping template to scan a DynamoDB table to fetch all entries
     */
    static dynamoDbScanTable() {
        return this.fromString('{"version" : "2017-02-28", "operation" : "Scan"}');
    }
    /**
     * Mapping template to query a set of items from a DynamoDB table
     *
     * @param cond the key condition for the query
     */
    static dynamoDbQuery(cond, indexName) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_alpha_KeyCondition(cond);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.dynamoDbQuery);
            }
            throw error;
        }
        return this.fromString(`{"version" : "2017-02-28", "operation" : "Query", ${indexName ? `"index" : "${indexName}", ` : ''}${cond.renderTemplate()}}`);
    }
    /**
     * Mapping template to get a single item from a DynamoDB table
     *
     * @param keyName the name of the hash key field
     * @param idArg the name of the Query argument
     */
    static dynamoDbGetItem(keyName, idArg) {
        return this.fromString(`{"version": "2017-02-28", "operation": "GetItem", "key": {"${keyName}": $util.dynamodb.toDynamoDBJson($ctx.args.${idArg})}}`);
    }
    /**
     * Mapping template to delete a single item from a DynamoDB table
     *
     * @param keyName the name of the hash key field
     * @param idArg the name of the Mutation argument
     */
    static dynamoDbDeleteItem(keyName, idArg) {
        return this.fromString(`{"version": "2017-02-28", "operation": "DeleteItem", "key": {"${keyName}": $util.dynamodb.toDynamoDBJson($ctx.args.${idArg})}}`);
    }
    /**
     * Mapping template to save a single item to a DynamoDB table
     *
     * @param key the assigment of Mutation values to the primary key
     * @param values the assignment of Mutation values to the table attributes
     */
    static dynamoDbPutItem(key, values) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_alpha_PrimaryKey(key);
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_alpha_AttributeValues(values);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.dynamoDbPutItem);
            }
            throw error;
        }
        return this.fromString(`
      ${values.renderVariables()}
      {
        "version": "2017-02-28",
        "operation": "PutItem",
        ${key.renderTemplate()},
        ${values.renderTemplate()}
      }`);
    }
    /**
     * Mapping template to invoke a Lambda function
     *
     * @param payload the VTL template snippet of the payload to send to the lambda.
     * If no payload is provided all available context fields are sent to the Lambda function
     * @param operation the type of operation AppSync should perform on the data source
     */
    static lambdaRequest(payload = '$util.toJson($ctx)', operation = 'Invoke') {
        return this.fromString(`{"version": "2017-02-28", "operation": "${operation}", "payload": ${payload}}`);
    }
    /**
     * Mapping template to return the Lambda result to the caller
     */
    static lambdaResult() {
        return this.fromString('$util.toJson($ctx.result)');
    }
}
exports.MappingTemplate = MappingTemplate;
_a = JSII_RTTI_SYMBOL_1;
MappingTemplate[_a] = { fqn: "@aws-cdk/aws-appsync-alpha.MappingTemplate", version: "2.23.0-alpha.0" };
class StringMappingTemplate extends MappingTemplate {
    constructor(template) {
        super();
        this.template = template;
    }
    renderTemplate() {
        return this.template;
    }
}
//# sourceMappingURL=data:application/json;base64,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