"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h, _j;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Values = exports.AttributeValuesStep = exports.AttributeValues = exports.PartitionKey = exports.PrimaryKey = exports.SortKeyStep = exports.PartitionKeyStep = exports.Assign = exports.KeyCondition = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const private_1 = require("./private");
/**
 * Factory class for DynamoDB key conditions.
 */
class KeyCondition {
    constructor(cond) {
        this.cond = cond;
    }
    /**
     * Condition k = arg, true if the key attribute k is equal to the Query argument
     */
    static eq(keyName, arg) {
        return new KeyCondition(new private_1.BinaryCondition(keyName, '=', arg));
    }
    /**
     * Condition k < arg, true if the key attribute k is less than the Query argument
     */
    static lt(keyName, arg) {
        return new KeyCondition(new private_1.BinaryCondition(keyName, '<', arg));
    }
    /**
     * Condition k <= arg, true if the key attribute k is less than or equal to the Query argument
     */
    static le(keyName, arg) {
        return new KeyCondition(new private_1.BinaryCondition(keyName, '<=', arg));
    }
    /**
     * Condition k > arg, true if the key attribute k is greater than the the Query argument
     */
    static gt(keyName, arg) {
        return new KeyCondition(new private_1.BinaryCondition(keyName, '>', arg));
    }
    /**
     * Condition k >= arg, true if the key attribute k is greater or equal to the Query argument
     */
    static ge(keyName, arg) {
        return new KeyCondition(new private_1.BinaryCondition(keyName, '>=', arg));
    }
    /**
     * Condition (k, arg). True if the key attribute k begins with the Query argument.
     */
    static beginsWith(keyName, arg) {
        return new KeyCondition(new private_1.BeginsWith(keyName, arg));
    }
    /**
     * Condition k BETWEEN arg1 AND arg2, true if k >= arg1 and k <= arg2.
     */
    static between(keyName, arg1, arg2) {
        return new KeyCondition(new private_1.Between(keyName, arg1, arg2));
    }
    /**
     * Conjunction between two conditions.
     */
    and(keyCond) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_alpha_KeyCondition(keyCond);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.and);
            }
            throw error;
        }
        return new KeyCondition(this.cond.and(keyCond.cond));
    }
    /**
     * Renders the key condition to a VTL string.
     */
    renderTemplate() {
        return `"query" : {
              "expression" : "${this.cond.renderCondition()}",
              "expressionNames" : {
                ${this.cond.renderExpressionNames()}
              },
              "expressionValues" : {
                ${this.cond.renderExpressionValues()}
              }
            }`;
    }
}
exports.KeyCondition = KeyCondition;
_a = JSII_RTTI_SYMBOL_1;
KeyCondition[_a] = { fqn: "@aws-cdk/aws-appsync-alpha.KeyCondition", version: "2.23.0-alpha.0" };
/**
 * Utility class representing the assigment of a value to an attribute.
 */
class Assign {
    constructor(attr, arg) {
        this.attr = attr;
        this.arg = arg;
    }
    /**
     * Renders the assignment as a VTL string.
     */
    renderAsAssignment() {
        return `"${this.attr}" : $util.dynamodb.toDynamoDBJson(${this.arg})`;
    }
    /**
     * Renders the assignment as a map element.
     */
    putInMap(map) {
        return `$util.qr($${map}.put("${this.attr}", ${this.arg}))`;
    }
}
exports.Assign = Assign;
_b = JSII_RTTI_SYMBOL_1;
Assign[_b] = { fqn: "@aws-cdk/aws-appsync-alpha.Assign", version: "2.23.0-alpha.0" };
/**
 * Utility class to allow assigning a value or an auto-generated id
 * to a partition key.
 */
class PartitionKeyStep {
    constructor(key) {
        this.key = key;
    }
    /**
     * Assign an auto-generated value to the partition key.
     */
    is(val) {
        return new PartitionKey(new Assign(this.key, `$ctx.args.${val}`));
    }
    /**
     * Assign an auto-generated value to the partition key.
     */
    auto() {
        return new PartitionKey(new Assign(this.key, '$util.autoId()'));
    }
}
exports.PartitionKeyStep = PartitionKeyStep;
_c = JSII_RTTI_SYMBOL_1;
PartitionKeyStep[_c] = { fqn: "@aws-cdk/aws-appsync-alpha.PartitionKeyStep", version: "2.23.0-alpha.0" };
/**
 * Utility class to allow assigning a value or an auto-generated id
 * to a sort key.
 */
class SortKeyStep {
    constructor(pkey, skey) {
        this.pkey = pkey;
        this.skey = skey;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_alpha_Assign(pkey);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
    }
    /**
     * Assign an auto-generated value to the sort key.
     */
    is(val) {
        return new PrimaryKey(this.pkey, new Assign(this.skey, `$ctx.args.${val}`));
    }
    /**
     * Assign an auto-generated value to the sort key.
     */
    auto() {
        return new PrimaryKey(this.pkey, new Assign(this.skey, '$util.autoId()'));
    }
}
exports.SortKeyStep = SortKeyStep;
_d = JSII_RTTI_SYMBOL_1;
SortKeyStep[_d] = { fqn: "@aws-cdk/aws-appsync-alpha.SortKeyStep", version: "2.23.0-alpha.0" };
/**
 * Specifies the assignment to the primary key. It either
 * contains the full primary key or only the partition key.
 */
class PrimaryKey {
    constructor(pkey, skey) {
        this.pkey = pkey;
        this.skey = skey;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_alpha_Assign(pkey);
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_alpha_Assign(skey);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
    }
    /**
     * Allows assigning a value to the partition key.
     */
    static partition(key) {
        return new PartitionKeyStep(key);
    }
    /**
     * Renders the key assignment to a VTL string.
     */
    renderTemplate() {
        const assignments = [this.pkey.renderAsAssignment()];
        if (this.skey) {
            assignments.push(this.skey.renderAsAssignment());
        }
        return `"key" : {
      ${assignments.join(',')}
    }`;
    }
}
exports.PrimaryKey = PrimaryKey;
_e = JSII_RTTI_SYMBOL_1;
PrimaryKey[_e] = { fqn: "@aws-cdk/aws-appsync-alpha.PrimaryKey", version: "2.23.0-alpha.0" };
/**
 * Specifies the assignment to the partition key. It can be
 * enhanced with the assignment of the sort key.
 */
class PartitionKey extends PrimaryKey {
    constructor(pkey) {
        super(pkey);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_alpha_Assign(pkey);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
    }
    /**
     * Allows assigning a value to the sort key.
     */
    sort(key) {
        return new SortKeyStep(this.pkey, key);
    }
}
exports.PartitionKey = PartitionKey;
_f = JSII_RTTI_SYMBOL_1;
PartitionKey[_f] = { fqn: "@aws-cdk/aws-appsync-alpha.PartitionKey", version: "2.23.0-alpha.0" };
/**
 * Specifies the attribute value assignments.
 */
class AttributeValues {
    constructor(container, assignments = []) {
        this.container = container;
        this.assignments = assignments;
    }
    /**
     * Allows assigning a value to the specified attribute.
     */
    attribute(attr) {
        return new AttributeValuesStep(attr, this.container, this.assignments);
    }
    /**
     * Renders the variables required for `renderTemplate`.
     */
    renderVariables() {
        return `#set($input = ${this.container})
      ${this.assignments.map(a => a.putInMap('input')).join('\n')}`;
    }
    /**
     * Renders the attribute value assingments to a VTL string.
     */
    renderTemplate() {
        return '"attributeValues": $util.dynamodb.toMapValuesJson($input)';
    }
}
exports.AttributeValues = AttributeValues;
_g = JSII_RTTI_SYMBOL_1;
AttributeValues[_g] = { fqn: "@aws-cdk/aws-appsync-alpha.AttributeValues", version: "2.23.0-alpha.0" };
/**
 * Utility class to allow assigning a value to an attribute.
 */
class AttributeValuesStep {
    constructor(attr, container, assignments) {
        this.attr = attr;
        this.container = container;
        this.assignments = assignments;
    }
    /**
     * Assign the value to the current attribute.
     */
    is(val) {
        this.assignments.push(new Assign(this.attr, val));
        return new AttributeValues(this.container, this.assignments);
    }
}
exports.AttributeValuesStep = AttributeValuesStep;
_h = JSII_RTTI_SYMBOL_1;
AttributeValuesStep[_h] = { fqn: "@aws-cdk/aws-appsync-alpha.AttributeValuesStep", version: "2.23.0-alpha.0" };
/**
 * Factory class for attribute value assignments.
 */
class Values {
    /**
     * Treats the specified object as a map of assignments, where the property
     * names represent attribute names. It’s opinionated about how it represents
     * some of the nested objects: e.g., it will use lists (“L”) rather than sets
     * (“SS”, “NS”, “BS”). By default it projects the argument container ("$ctx.args").
     */
    static projecting(arg) {
        return new AttributeValues('$ctx.args' + (arg ? `.${arg}` : ''));
    }
    /**
     * Allows assigning a value to the specified attribute.
     */
    static attribute(attr) {
        return new AttributeValues('{}').attribute(attr);
    }
}
exports.Values = Values;
_j = JSII_RTTI_SYMBOL_1;
Values[_j] = { fqn: "@aws-cdk/aws-appsync-alpha.Values", version: "2.23.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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