"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h, _j;
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpenSearchDataSource = exports.ElasticsearchDataSource = exports.RdsDataSource = exports.LambdaDataSource = exports.HttpDataSource = exports.DynamoDbDataSource = exports.NoneDataSource = exports.BackedDataSource = exports.BaseDataSource = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const appsync_function_1 = require("./appsync-function");
const aws_appsync_1 = require("aws-cdk-lib/aws-appsync");
const resolver_1 = require("./resolver");
/**
 * Abstract AppSync datasource implementation. Do not use directly but use subclasses for concrete datasources
 */
class BaseDataSource extends constructs_1.Construct {
    constructor(scope, id, props, extended) {
        var _k, _l;
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_alpha_BackedDataSourceProps(props);
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_alpha_ExtendedDataSourceProps(extended);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        if (extended.type !== 'NONE') {
            this.serviceRole = props.serviceRole || new aws_iam_1.Role(this, 'ServiceRole', { assumedBy: new aws_iam_1.ServicePrincipal('appsync') });
        }
        // Replace unsupported characters from DataSource name. The only allowed pattern is: {[_A-Za-z][_0-9A-Za-z]*}
        const name = ((_k = props.name) !== null && _k !== void 0 ? _k : id).replace(/[\W]+/g, '');
        this.ds = new aws_appsync_1.CfnDataSource(this, 'Resource', {
            apiId: props.api.apiId,
            name: name,
            description: props.description,
            serviceRoleArn: (_l = this.serviceRole) === null || _l === void 0 ? void 0 : _l.roleArn,
            ...extended,
        });
        this.name = name;
        this.api = props.api;
    }
    /**
     * creates a new resolver for this datasource and API using the given properties
     */
    createResolver(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_alpha_BaseResolverProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.createResolver);
            }
            throw error;
        }
        return new resolver_1.Resolver(this, `${props.typeName}${props.fieldName}Resolver`, {
            api: this.api,
            dataSource: this,
            ...props,
        });
    }
    /**
     * creates a new appsync function for this datasource and API using the given properties
     */
    createFunction(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_alpha_BaseAppsyncFunctionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.createFunction);
            }
            throw error;
        }
        return new appsync_function_1.AppsyncFunction(this, `${props.name}Function`, {
            api: this.api,
            dataSource: this,
            ...props,
        });
    }
}
exports.BaseDataSource = BaseDataSource;
_a = JSII_RTTI_SYMBOL_1;
BaseDataSource[_a] = { fqn: "@aws-cdk/aws-appsync-alpha.BaseDataSource", version: "2.23.0-alpha.0" };
/**
 * Abstract AppSync datasource implementation. Do not use directly but use subclasses for resource backed datasources
 */
class BackedDataSource extends BaseDataSource {
    constructor(scope, id, props, extended) {
        super(scope, id, props, extended);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_alpha_BackedDataSourceProps(props);
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_alpha_ExtendedDataSourceProps(extended);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        this.grantPrincipal = this.serviceRole;
    }
}
exports.BackedDataSource = BackedDataSource;
_b = JSII_RTTI_SYMBOL_1;
BackedDataSource[_b] = { fqn: "@aws-cdk/aws-appsync-alpha.BackedDataSource", version: "2.23.0-alpha.0" };
/**
 * An AppSync dummy datasource
 */
class NoneDataSource extends BaseDataSource {
    constructor(scope, id, props) {
        super(scope, id, props, {
            type: 'NONE',
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_alpha_NoneDataSourceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
    }
}
exports.NoneDataSource = NoneDataSource;
_c = JSII_RTTI_SYMBOL_1;
NoneDataSource[_c] = { fqn: "@aws-cdk/aws-appsync-alpha.NoneDataSource", version: "2.23.0-alpha.0" };
/**
 * An AppSync datasource backed by a DynamoDB table
 */
class DynamoDbDataSource extends BackedDataSource {
    constructor(scope, id, props) {
        super(scope, id, props, {
            type: 'AMAZON_DYNAMODB',
            dynamoDbConfig: {
                tableName: props.table.tableName,
                awsRegion: props.table.stack.region,
                useCallerCredentials: props.useCallerCredentials,
            },
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_alpha_DynamoDbDataSourceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        if (props.readOnlyAccess) {
            props.table.grantReadData(this);
        }
        else {
            props.table.grantReadWriteData(this);
        }
    }
}
exports.DynamoDbDataSource = DynamoDbDataSource;
_d = JSII_RTTI_SYMBOL_1;
DynamoDbDataSource[_d] = { fqn: "@aws-cdk/aws-appsync-alpha.DynamoDbDataSource", version: "2.23.0-alpha.0" };
/**
 * An AppSync datasource backed by a http endpoint
 */
class HttpDataSource extends BackedDataSource {
    constructor(scope, id, props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_alpha_HttpDataSourceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        const authorizationConfig = props.authorizationConfig ? {
            authorizationType: 'AWS_IAM',
            awsIamConfig: props.authorizationConfig,
        } : undefined;
        super(scope, id, props, {
            type: 'HTTP',
            httpConfig: {
                endpoint: props.endpoint,
                authorizationConfig,
            },
        });
    }
}
exports.HttpDataSource = HttpDataSource;
_e = JSII_RTTI_SYMBOL_1;
HttpDataSource[_e] = { fqn: "@aws-cdk/aws-appsync-alpha.HttpDataSource", version: "2.23.0-alpha.0" };
/**
 * An AppSync datasource backed by a Lambda function
 */
class LambdaDataSource extends BackedDataSource {
    constructor(scope, id, props) {
        super(scope, id, props, {
            type: 'AWS_LAMBDA',
            lambdaConfig: {
                lambdaFunctionArn: props.lambdaFunction.functionArn,
            },
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_alpha_LambdaDataSourceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        props.lambdaFunction.grantInvoke(this);
    }
}
exports.LambdaDataSource = LambdaDataSource;
_f = JSII_RTTI_SYMBOL_1;
LambdaDataSource[_f] = { fqn: "@aws-cdk/aws-appsync-alpha.LambdaDataSource", version: "2.23.0-alpha.0" };
/**
 * An AppSync datasource backed by RDS
 */
class RdsDataSource extends BackedDataSource {
    constructor(scope, id, props) {
        super(scope, id, props, {
            type: 'RELATIONAL_DATABASE',
            relationalDatabaseConfig: {
                rdsHttpEndpointConfig: {
                    awsRegion: props.serverlessCluster.stack.region,
                    dbClusterIdentifier: aws_cdk_lib_1.Lazy.string({
                        produce: () => {
                            return aws_cdk_lib_1.Stack.of(this).formatArn({
                                service: 'rds',
                                resource: `cluster:${props.serverlessCluster.clusterIdentifier}`,
                            });
                        },
                    }),
                    awsSecretStoreArn: props.secretStore.secretArn,
                    databaseName: props.databaseName,
                },
                relationalDatabaseSourceType: 'RDS_HTTP_ENDPOINT',
            },
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_alpha_RdsDataSourceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        const clusterArn = aws_cdk_lib_1.Stack.of(this).formatArn({
            service: 'rds',
            resource: `cluster:${props.serverlessCluster.clusterIdentifier}`,
        });
        props.secretStore.grantRead(this);
        // Change to grant with RDS grant becomes implemented
        props.serverlessCluster.grantDataApiAccess(this);
        aws_iam_1.Grant.addToPrincipal({
            grantee: this,
            actions: [
                'rds-data:DeleteItems',
                'rds-data:ExecuteSql',
                'rds-data:GetItems',
                'rds-data:InsertItems',
                'rds-data:UpdateItems',
            ],
            resourceArns: [clusterArn, `${clusterArn}:*`],
            scope: this,
        });
    }
}
exports.RdsDataSource = RdsDataSource;
_g = JSII_RTTI_SYMBOL_1;
RdsDataSource[_g] = { fqn: "@aws-cdk/aws-appsync-alpha.RdsDataSource", version: "2.23.0-alpha.0" };
/**
 * An Appsync datasource backed by Elasticsearch
 *
 * @deprecated - use `OpenSearchDataSource`
 */
class ElasticsearchDataSource extends BackedDataSource {
    constructor(scope, id, props) {
        super(scope, id, props, {
            type: 'AMAZON_ELASTICSEARCH',
            elasticsearchConfig: {
                awsRegion: props.domain.stack.region,
                endpoint: `https://${props.domain.domainEndpoint}`,
            },
        });
        try {
            jsiiDeprecationWarnings.print("@aws-cdk/aws-appsync-alpha.ElasticsearchDataSource", "- use `OpenSearchDataSource`");
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_alpha_ElasticsearchDataSourceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        props.domain.grantReadWrite(this);
    }
}
exports.ElasticsearchDataSource = ElasticsearchDataSource;
_h = JSII_RTTI_SYMBOL_1;
ElasticsearchDataSource[_h] = { fqn: "@aws-cdk/aws-appsync-alpha.ElasticsearchDataSource", version: "2.23.0-alpha.0" };
/**
 * An Appsync datasource backed by OpenSearch
 */
class OpenSearchDataSource extends BackedDataSource {
    constructor(scope, id, props) {
        super(scope, id, props, {
            type: 'AMAZON_OPENSEARCH_SERVICE',
            openSearchServiceConfig: {
                awsRegion: props.domain.stack.region,
                endpoint: `https://${props.domain.domainEndpoint}`,
            },
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_alpha_OpenSearchDataSourceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        props.domain.grantReadWrite(this);
    }
}
exports.OpenSearchDataSource = OpenSearchDataSource;
_j = JSII_RTTI_SYMBOL_1;
OpenSearchDataSource[_j] = { fqn: "@aws-cdk/aws-appsync-alpha.OpenSearchDataSource", version: "2.23.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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