"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TopicRule = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_iot_1 = require("aws-cdk-lib/aws-iot");
/**
 * Defines an AWS IoT Rule in this stack.
 */
class TopicRule extends aws_cdk_lib_1.Resource {
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.topicRuleName,
        });
        this.actions = [];
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iot_alpha_TopicRuleProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, TopicRule);
            }
            throw error;
        }
        const sqlConfig = props.sql.bind(this);
        const resource = new aws_iot_1.CfnTopicRule(this, 'Resource', {
            ruleName: this.physicalName,
            topicRulePayload: {
                actions: aws_cdk_lib_1.Lazy.any({ produce: () => this.actions }),
                awsIotSqlVersion: sqlConfig.awsIotSqlVersion,
                description: props.description,
                errorAction: props.errorAction?._bind(this).configuration,
                ruleDisabled: props.enabled === undefined ? undefined : !props.enabled,
                sql: sqlConfig.sql,
            },
        });
        this.topicRuleArn = this.getResourceArnAttribute(resource.attrArn, {
            service: 'iot',
            resource: 'rule',
            resourceName: this.physicalName,
        });
        this.topicRuleName = this.getResourceNameAttribute(resource.ref);
        props.actions?.forEach(action => {
            this.addAction(action);
        });
    }
    /**
     * Import an existing AWS IoT Rule provided an ARN
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param topicRuleArn AWS IoT Rule ARN (i.e. arn:aws:iot:<region>:<account-id>:rule/MyRule).
     */
    static fromTopicRuleArn(scope, id, topicRuleArn) {
        const parts = aws_cdk_lib_1.Stack.of(scope).splitArn(topicRuleArn, aws_cdk_lib_1.ArnFormat.SLASH_RESOURCE_NAME);
        if (!parts.resourceName) {
            throw new Error(`Missing topic rule name in ARN: '${topicRuleArn}'`);
        }
        const resourceName = parts.resourceName;
        class Import extends aws_cdk_lib_1.Resource {
            constructor() {
                super(...arguments);
                this.topicRuleArn = topicRuleArn;
                this.topicRuleName = resourceName;
            }
        }
        return new Import(scope, id, {
            environmentFromArn: topicRuleArn,
        });
    }
    /**
     * Add a action to the topic rule.
     *
     * @param action the action to associate with the topic rule.
     */
    addAction(action) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iot_alpha_IAction(action);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addAction);
            }
            throw error;
        }
        const { configuration } = action._bind(this);
        const keys = Object.keys(configuration);
        if (keys.length === 0) {
            throw new Error('An action property cannot be an empty object.');
        }
        if (keys.length > 1) {
            throw new Error(`An action property cannot have multiple keys, received: ${keys}`);
        }
        this.actions.push(configuration);
    }
}
exports.TopicRule = TopicRule;
_a = JSII_RTTI_SYMBOL_1;
TopicRule[_a] = { fqn: "@aws-cdk/aws-iot-alpha.TopicRule", version: "2.39.1-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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