"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.S3EventSource = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const notifs = require("@aws-cdk/aws-s3-notifications");
/**
 * Use S3 bucket notifications as an event source for AWS Lambda.
 *
 * @stability stable
 */
class S3EventSource {
    /**
     * @stability stable
     */
    constructor(bucket, props) {
        this.bucket = bucket;
        this.props = props;
        jsiiDeprecationWarnings._aws_cdk_aws_lambda_event_sources_S3EventSourceProps(props);
    }
    /**
     * Called by `lambda.addEventSource` to allow the event source to bind to this function.
     *
     * @stability stable
     */
    bind(target) {
        const filters = this.props.filters || [];
        for (const event of this.props.events) {
            this.bucket.addEventNotification(event, new notifs.LambdaDestination(target), ...filters);
        }
    }
}
exports.S3EventSource = S3EventSource;
_a = JSII_RTTI_SYMBOL_1;
S3EventSource[_a] = { fqn: "@aws-cdk/aws-lambda-event-sources.S3EventSource", version: "1.134.0" };
//# sourceMappingURL=data:application/json;base64,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