"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("@aws-cdk/assert/jest");
const lambda = require("@aws-cdk/aws-lambda");
const logs = require("@aws-cdk/aws-logs");
const cdk = require("@aws-cdk/core");
const dests = require("../lib");
let stack;
let fn;
let logGroup;
beforeEach(() => {
    // GIVEN
    stack = new cdk.Stack();
    fn = new lambda.Function(stack, 'MyLambda', {
        code: new lambda.InlineCode('foo'),
        handler: 'index.handler',
        runtime: lambda.Runtime.NODEJS_10_X,
    });
    logGroup = new logs.LogGroup(stack, 'LogGroup');
});
test('lambda can be used as metric subscription destination', () => {
    // WHEN
    new logs.SubscriptionFilter(stack, 'Subscription', {
        logGroup,
        destination: new dests.LambdaDestination(fn),
        filterPattern: logs.FilterPattern.allEvents()
    });
    // THEN: subscription target is Lambda
    expect(stack).toHaveResource('AWS::Logs::SubscriptionFilter', {
        DestinationArn: { 'Fn::GetAtt': ['MyLambdaCCE802FB', 'Arn'] },
    });
    // THEN: Lambda has permissions to be invoked by CWL
    expect(stack).toHaveResource('AWS::Lambda::Permission', {
        Action: 'lambda:InvokeFunction',
        FunctionName: { 'Fn::GetAtt': ['MyLambdaCCE802FB', 'Arn'] },
        Principal: 'logs.amazonaws.com',
    });
});
test('can have multiple subscriptions use the same Lambda', () => {
    // WHEN
    new logs.SubscriptionFilter(stack, 'Subscription', {
        logGroup,
        destination: new dests.LambdaDestination(fn),
        filterPattern: logs.FilterPattern.allEvents()
    });
    new logs.SubscriptionFilter(stack, 'Subscription2', {
        logGroup: new logs.LogGroup(stack, 'LG2'),
        destination: new dests.LambdaDestination(fn),
        filterPattern: logs.FilterPattern.allEvents()
    });
    // THEN: Lambda has permissions to be invoked by CWL from both Source Arns
    expect(stack).toHaveResource('AWS::Lambda::Permission', {
        Action: 'lambda:InvokeFunction',
        FunctionName: { 'Fn::GetAtt': ['MyLambdaCCE802FB', 'Arn'] },
        SourceArn: { 'Fn::GetAtt': ['LogGroupF5B46931', 'Arn'] },
        Principal: 'logs.amazonaws.com',
    });
    expect(stack).toHaveResource('AWS::Lambda::Permission', {
        Action: 'lambda:InvokeFunction',
        FunctionName: { 'Fn::GetAtt': ['MyLambdaCCE802FB', 'Arn'] },
        SourceArn: { 'Fn::GetAtt': ['LG224A94C8F', 'Arn'] },
        Principal: 'logs.amazonaws.com',
    });
});
//# sourceMappingURL=data:application/json;base64,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