# Generated by Django 5.2 on 2026-02-15 18:58

import django.db.models.deletion
import django.db.models.functions.datetime
import lamindb.base.fields
import lamindb.base.users
import lamindb.models.can_curate
import lamindb.models.has_parents
import lamindb.models.run
import lamindb.models.sqlrecord
from django.db import migrations, models

import bionty.uids


class Migration(migrations.Migration):
    replaces = [
        ("bionty", "0064_squashed"),
        ("bionty", "0065_lamindb_v2_2"),
    ]

    dependencies = [
        ("lamindb", "0181_squashed"),
    ]

    operations = [
        migrations.CreateModel(
            name="ArtifactCellLine",
            fields=[
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "artifact",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_cell_line",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        editable=False,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "feature",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_artifactcellline",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.run.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
            ],
            bases=(lamindb.models.sqlrecord.IsLink, models.Model),
        ),
        migrations.CreateModel(
            name="ArtifactCellMarker",
            fields=[
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "artifact",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_cell_marker",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        editable=False,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "feature",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_artifactcellmarker",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.run.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
            ],
            bases=(lamindb.models.sqlrecord.IsLink, models.Model),
        ),
        migrations.CreateModel(
            name="ArtifactCellType",
            fields=[
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "artifact",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_cell_type",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        editable=False,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "feature",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_artifactcelltype",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.run.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
            ],
            bases=(lamindb.models.sqlrecord.IsLink, models.Model),
        ),
        migrations.CreateModel(
            name="ArtifactDevelopmentalStage",
            fields=[
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "artifact",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_developmental_stage",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        editable=False,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "feature",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_artifactdevelopmentalstage",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.run.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
            ],
            bases=(lamindb.models.sqlrecord.IsLink, models.Model),
        ),
        migrations.CreateModel(
            name="ArtifactDisease",
            fields=[
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "artifact",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_disease",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        editable=False,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "feature",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_artifactdisease",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.run.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
            ],
            bases=(lamindb.models.sqlrecord.IsLink, models.Model),
        ),
        migrations.CreateModel(
            name="ArtifactEthnicity",
            fields=[
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "artifact",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_ethnicity",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        editable=False,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "feature",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_artifactethnicity",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.run.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
            ],
            bases=(lamindb.models.sqlrecord.IsLink, models.Model),
        ),
        migrations.CreateModel(
            name="ArtifactExperimentalFactor",
            fields=[
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "artifact",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_experimental_factor",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        editable=False,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "feature",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_artifactexperimentalfactor",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.run.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
            ],
            bases=(lamindb.models.sqlrecord.IsLink, models.Model),
        ),
        migrations.CreateModel(
            name="ArtifactGene",
            fields=[
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "artifact",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_gene",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        editable=False,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "feature",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_artifactgene",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.run.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
            ],
            bases=(lamindb.models.sqlrecord.IsLink, models.Model),
        ),
        migrations.CreateModel(
            name="ArtifactOrganism",
            fields=[
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "artifact",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_organism",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        editable=False,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "feature",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_artifactorganism",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.run.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
            ],
            bases=(lamindb.models.sqlrecord.IsLink, models.Model),
        ),
        migrations.CreateModel(
            name="ArtifactPathway",
            fields=[
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "artifact",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_pathway",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        editable=False,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "feature",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_artifactpathway",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.run.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
            ],
            bases=(lamindb.models.sqlrecord.IsLink, models.Model),
        ),
        migrations.CreateModel(
            name="ArtifactPhenotype",
            fields=[
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "artifact",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_phenotype",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        editable=False,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "feature",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_artifactphenotype",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.run.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
            ],
            bases=(lamindb.models.sqlrecord.IsLink, models.Model),
        ),
        migrations.CreateModel(
            name="ArtifactProtein",
            fields=[
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "artifact",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_protein",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        editable=False,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "feature",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_artifactprotein",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.run.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
            ],
            bases=(lamindb.models.sqlrecord.IsLink, models.Model),
        ),
        migrations.CreateModel(
            name="ArtifactTissue",
            fields=[
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "artifact",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_tissue",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        editable=False,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "feature",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_artifacttissue",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.run.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
            ],
            bases=(lamindb.models.sqlrecord.IsLink, models.Model),
        ),
        migrations.CreateModel(
            name="CellLine",
            fields=[
                (
                    "is_locked",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_default=False, default=False
                    ),
                ),
                (
                    "_aux",
                    lamindb.base.fields.JSONField(
                        blank=True, db_default=None, default=None, null=True
                    ),
                ),
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                (
                    "updated_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                (
                    "name",
                    lamindb.base.fields.CharField(
                        blank=True, db_index=True, default=None, max_length=255
                    ),
                ),
                (
                    "ontology_id",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=255,
                        null=True,
                    ),
                ),
                ("id", models.AutoField(primary_key=True, serialize=False)),
                (
                    "uid",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=bionty.uids.ontology,
                        max_length=14,
                        unique=True,
                    ),
                ),
                (
                    "abbr",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=32,
                        null=True,
                        unique=True,
                    ),
                ),
                (
                    "synonyms",
                    lamindb.base.fields.TextField(
                        blank=True, db_index=True, default=None, null=True
                    ),
                ),
                (
                    "description",
                    lamindb.base.fields.TextField(
                        blank=True, db_index=True, default=None, null=True
                    ),
                ),
                (
                    "artifacts",
                    models.ManyToManyField(
                        related_name="cell_lines",
                        through="bionty.ArtifactCellLine",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "branch",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        db_default=1,
                        default=1,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.branch",
                    ),
                ),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        editable=False,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "created_on",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        db_default=1,
                        default=1,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.branch",
                    ),
                ),
                (
                    "parents",
                    models.ManyToManyField(
                        related_name="children", to="bionty.cellline"
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.run.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
                (
                    "space",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        db_default=1,
                        default=1,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.space",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(
                models.Model,
                lamindb.models.can_curate.CanCurate,
                lamindb.models.has_parents.HasParents,
            ),
        ),
        migrations.AddField(
            model_name="artifactcellline",
            name="cellline",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="links_artifact",
                to="bionty.cellline",
            ),
        ),
        migrations.CreateModel(
            name="CellMarker",
            fields=[
                (
                    "is_locked",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_default=False, default=False
                    ),
                ),
                (
                    "_aux",
                    lamindb.base.fields.JSONField(
                        blank=True, db_default=None, default=None, null=True
                    ),
                ),
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                (
                    "updated_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("id", models.AutoField(primary_key=True, serialize=False)),
                (
                    "uid",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=bionty.uids.ontology,
                        max_length=14,
                        unique=True,
                    ),
                ),
                (
                    "abbr",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=32,
                        null=True,
                        unique=True,
                    ),
                ),
                (
                    "synonyms",
                    lamindb.base.fields.TextField(
                        blank=True, db_index=True, default=None, null=True
                    ),
                ),
                (
                    "description",
                    lamindb.base.fields.TextField(
                        blank=True, db_index=True, default=None, null=True
                    ),
                ),
                (
                    "name",
                    lamindb.base.fields.CharField(
                        blank=True, db_index=True, default=None, max_length=64
                    ),
                ),
                (
                    "gene_symbol",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=64,
                        null=True,
                    ),
                ),
                (
                    "ncbi_gene_id",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=32,
                        null=True,
                    ),
                ),
                (
                    "uniprotkb_id",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=10,
                        null=True,
                    ),
                ),
                (
                    "artifacts",
                    models.ManyToManyField(
                        related_name="cell_markers",
                        through="bionty.ArtifactCellMarker",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "branch",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        db_default=1,
                        default=1,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.branch",
                    ),
                ),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        editable=False,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "created_on",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        db_default=1,
                        default=1,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.branch",
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.run.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
                (
                    "space",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        db_default=1,
                        default=1,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.space",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model, lamindb.models.can_curate.CanCurate),
        ),
        migrations.AddField(
            model_name="artifactcellmarker",
            name="cellmarker",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="links_artifact",
                to="bionty.cellmarker",
            ),
        ),
        migrations.CreateModel(
            name="CellType",
            fields=[
                (
                    "is_locked",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_default=False, default=False
                    ),
                ),
                (
                    "_aux",
                    lamindb.base.fields.JSONField(
                        blank=True, db_default=None, default=None, null=True
                    ),
                ),
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                (
                    "updated_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                (
                    "name",
                    lamindb.base.fields.CharField(
                        blank=True, db_index=True, default=None, max_length=255
                    ),
                ),
                (
                    "ontology_id",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=255,
                        null=True,
                    ),
                ),
                ("id", models.AutoField(primary_key=True, serialize=False)),
                (
                    "uid",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=bionty.uids.ontology,
                        max_length=14,
                        unique=True,
                    ),
                ),
                (
                    "abbr",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=32,
                        null=True,
                        unique=True,
                    ),
                ),
                (
                    "synonyms",
                    lamindb.base.fields.TextField(
                        blank=True, db_index=True, default=None, null=True
                    ),
                ),
                (
                    "description",
                    lamindb.base.fields.TextField(
                        blank=True, db_index=True, default=None, null=True
                    ),
                ),
                (
                    "artifacts",
                    models.ManyToManyField(
                        related_name="cell_types",
                        through="bionty.ArtifactCellType",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "branch",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        db_default=1,
                        default=1,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.branch",
                    ),
                ),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        editable=False,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "created_on",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        db_default=1,
                        default=1,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.branch",
                    ),
                ),
                (
                    "parents",
                    models.ManyToManyField(
                        related_name="children", to="bionty.celltype"
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.run.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
                (
                    "space",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        db_default=1,
                        default=1,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.space",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(
                models.Model,
                lamindb.models.can_curate.CanCurate,
                lamindb.models.has_parents.HasParents,
            ),
        ),
        migrations.AddField(
            model_name="artifactcelltype",
            name="celltype",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="links_artifact",
                to="bionty.celltype",
            ),
        ),
        migrations.CreateModel(
            name="DevelopmentalStage",
            fields=[
                (
                    "is_locked",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_default=False, default=False
                    ),
                ),
                (
                    "_aux",
                    lamindb.base.fields.JSONField(
                        blank=True, db_default=None, default=None, null=True
                    ),
                ),
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                (
                    "updated_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                (
                    "name",
                    lamindb.base.fields.CharField(
                        blank=True, db_index=True, default=None, max_length=255
                    ),
                ),
                (
                    "ontology_id",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=255,
                        null=True,
                    ),
                ),
                ("id", models.AutoField(primary_key=True, serialize=False)),
                (
                    "uid",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=bionty.uids.ontology,
                        max_length=14,
                        unique=True,
                    ),
                ),
                (
                    "abbr",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=32,
                        null=True,
                        unique=True,
                    ),
                ),
                (
                    "synonyms",
                    lamindb.base.fields.TextField(
                        blank=True, db_index=True, default=None, null=True
                    ),
                ),
                (
                    "description",
                    lamindb.base.fields.TextField(
                        blank=True, db_index=True, default=None, null=True
                    ),
                ),
                (
                    "artifacts",
                    models.ManyToManyField(
                        related_name="developmental_stages",
                        through="bionty.ArtifactDevelopmentalStage",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "branch",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        db_default=1,
                        default=1,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.branch",
                    ),
                ),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        editable=False,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "created_on",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        db_default=1,
                        default=1,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.branch",
                    ),
                ),
                (
                    "parents",
                    models.ManyToManyField(
                        related_name="children", to="bionty.developmentalstage"
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.run.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
                (
                    "space",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        db_default=1,
                        default=1,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.space",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(
                models.Model,
                lamindb.models.can_curate.CanCurate,
                lamindb.models.has_parents.HasParents,
            ),
        ),
        migrations.AddField(
            model_name="artifactdevelopmentalstage",
            name="developmentalstage",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="links_artifact",
                to="bionty.developmentalstage",
            ),
        ),
        migrations.CreateModel(
            name="Disease",
            fields=[
                (
                    "is_locked",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_default=False, default=False
                    ),
                ),
                (
                    "_aux",
                    lamindb.base.fields.JSONField(
                        blank=True, db_default=None, default=None, null=True
                    ),
                ),
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                (
                    "updated_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                (
                    "name",
                    lamindb.base.fields.CharField(
                        blank=True, db_index=True, default=None, max_length=255
                    ),
                ),
                (
                    "ontology_id",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=255,
                        null=True,
                    ),
                ),
                ("id", models.AutoField(primary_key=True, serialize=False)),
                (
                    "uid",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=bionty.uids.ontology,
                        max_length=14,
                        unique=True,
                    ),
                ),
                (
                    "abbr",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=32,
                        null=True,
                        unique=True,
                    ),
                ),
                (
                    "synonyms",
                    lamindb.base.fields.TextField(
                        blank=True, db_index=True, default=None, null=True
                    ),
                ),
                (
                    "description",
                    lamindb.base.fields.TextField(
                        blank=True, db_index=True, default=None, null=True
                    ),
                ),
                (
                    "artifacts",
                    models.ManyToManyField(
                        related_name="diseases",
                        through="bionty.ArtifactDisease",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "branch",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        db_default=1,
                        default=1,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.branch",
                    ),
                ),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        editable=False,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "created_on",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        db_default=1,
                        default=1,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.branch",
                    ),
                ),
                (
                    "parents",
                    models.ManyToManyField(
                        related_name="children", to="bionty.disease"
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.run.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
                (
                    "space",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        db_default=1,
                        default=1,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.space",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(
                models.Model,
                lamindb.models.can_curate.CanCurate,
                lamindb.models.has_parents.HasParents,
            ),
        ),
        migrations.AddField(
            model_name="artifactdisease",
            name="disease",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="links_artifact",
                to="bionty.disease",
            ),
        ),
        migrations.CreateModel(
            name="Ethnicity",
            fields=[
                (
                    "is_locked",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_default=False, default=False
                    ),
                ),
                (
                    "_aux",
                    lamindb.base.fields.JSONField(
                        blank=True, db_default=None, default=None, null=True
                    ),
                ),
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                (
                    "updated_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                (
                    "name",
                    lamindb.base.fields.CharField(
                        blank=True, db_index=True, default=None, max_length=255
                    ),
                ),
                (
                    "ontology_id",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=255,
                        null=True,
                    ),
                ),
                ("id", models.AutoField(primary_key=True, serialize=False)),
                (
                    "uid",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=bionty.uids.ontology,
                        max_length=14,
                        unique=True,
                    ),
                ),
                (
                    "abbr",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=32,
                        null=True,
                        unique=True,
                    ),
                ),
                (
                    "synonyms",
                    lamindb.base.fields.TextField(
                        blank=True, db_index=True, default=None, null=True
                    ),
                ),
                (
                    "description",
                    lamindb.base.fields.TextField(
                        blank=True, db_index=True, default=None, null=True
                    ),
                ),
                (
                    "artifacts",
                    models.ManyToManyField(
                        related_name="ethnicities",
                        through="bionty.ArtifactEthnicity",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "branch",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        db_default=1,
                        default=1,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.branch",
                    ),
                ),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        editable=False,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "created_on",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        db_default=1,
                        default=1,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.branch",
                    ),
                ),
                (
                    "parents",
                    models.ManyToManyField(
                        related_name="children", to="bionty.ethnicity"
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.run.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
                (
                    "space",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        db_default=1,
                        default=1,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.space",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(
                models.Model,
                lamindb.models.can_curate.CanCurate,
                lamindb.models.has_parents.HasParents,
            ),
        ),
        migrations.AddField(
            model_name="artifactethnicity",
            name="ethnicity",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="links_artifact",
                to="bionty.ethnicity",
            ),
        ),
        migrations.CreateModel(
            name="ExperimentalFactor",
            fields=[
                (
                    "is_locked",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_default=False, default=False
                    ),
                ),
                (
                    "_aux",
                    lamindb.base.fields.JSONField(
                        blank=True, db_default=None, default=None, null=True
                    ),
                ),
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                (
                    "updated_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                (
                    "name",
                    lamindb.base.fields.CharField(
                        blank=True, db_index=True, default=None, max_length=255
                    ),
                ),
                (
                    "ontology_id",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=255,
                        null=True,
                    ),
                ),
                ("id", models.AutoField(primary_key=True, serialize=False)),
                (
                    "uid",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=bionty.uids.ontology,
                        max_length=14,
                        unique=True,
                    ),
                ),
                (
                    "abbr",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=32,
                        null=True,
                        unique=True,
                    ),
                ),
                (
                    "synonyms",
                    lamindb.base.fields.TextField(
                        blank=True, db_index=True, default=None, null=True
                    ),
                ),
                (
                    "description",
                    lamindb.base.fields.TextField(
                        blank=True, db_index=True, default=None, null=True
                    ),
                ),
                (
                    "artifacts",
                    models.ManyToManyField(
                        related_name="experimental_factors",
                        through="bionty.ArtifactExperimentalFactor",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "branch",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        db_default=1,
                        default=1,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.branch",
                    ),
                ),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        editable=False,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "created_on",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        db_default=1,
                        default=1,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.branch",
                    ),
                ),
                (
                    "parents",
                    models.ManyToManyField(
                        related_name="children", to="bionty.experimentalfactor"
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.run.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
                (
                    "space",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        db_default=1,
                        default=1,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.space",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(
                models.Model,
                lamindb.models.can_curate.CanCurate,
                lamindb.models.has_parents.HasParents,
            ),
        ),
        migrations.AddField(
            model_name="artifactexperimentalfactor",
            name="experimentalfactor",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="links_artifact",
                to="bionty.experimentalfactor",
            ),
        ),
        migrations.CreateModel(
            name="Gene",
            fields=[
                (
                    "is_locked",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_default=False, default=False
                    ),
                ),
                (
                    "_aux",
                    lamindb.base.fields.JSONField(
                        blank=True, db_default=None, default=None, null=True
                    ),
                ),
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                (
                    "updated_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("id", models.AutoField(primary_key=True, serialize=False)),
                (
                    "uid",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=bionty.uids.ontology,
                        max_length=14,
                        unique=True,
                    ),
                ),
                (
                    "abbr",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=32,
                        null=True,
                        unique=True,
                    ),
                ),
                (
                    "synonyms",
                    lamindb.base.fields.TextField(
                        blank=True, db_index=True, default=None, null=True
                    ),
                ),
                (
                    "description",
                    lamindb.base.fields.TextField(
                        blank=True, db_index=True, default=None, null=True
                    ),
                ),
                (
                    "symbol",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=64,
                        null=True,
                    ),
                ),
                (
                    "stable_id",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=255,
                        null=True,
                        unique=True,
                    ),
                ),
                (
                    "ensembl_gene_id",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=64,
                        null=True,
                        unique=True,
                    ),
                ),
                (
                    "ncbi_gene_ids",
                    lamindb.base.fields.TextField(
                        blank=True, db_index=True, default=None, null=True
                    ),
                ),
                (
                    "biotype",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=64,
                        null=True,
                    ),
                ),
                (
                    "artifacts",
                    models.ManyToManyField(
                        related_name="genes",
                        through="bionty.ArtifactGene",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "branch",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        db_default=1,
                        default=1,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.branch",
                    ),
                ),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        editable=False,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "created_on",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        db_default=1,
                        default=1,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.branch",
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.run.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
                (
                    "space",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        db_default=1,
                        default=1,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.space",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model, lamindb.models.can_curate.CanCurate),
        ),
        migrations.AddField(
            model_name="artifactgene",
            name="gene",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="links_artifact",
                to="bionty.gene",
            ),
        ),
        migrations.CreateModel(
            name="Organism",
            fields=[
                (
                    "is_locked",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_default=False, default=False
                    ),
                ),
                (
                    "_aux",
                    lamindb.base.fields.JSONField(
                        blank=True, db_default=None, default=None, null=True
                    ),
                ),
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                (
                    "updated_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                (
                    "name",
                    lamindb.base.fields.CharField(
                        blank=True, db_index=True, default=None, max_length=255
                    ),
                ),
                (
                    "ontology_id",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=255,
                        null=True,
                    ),
                ),
                ("id", models.AutoField(primary_key=True, serialize=False)),
                (
                    "uid",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=bionty.uids.ontology,
                        max_length=14,
                        unique=True,
                    ),
                ),
                (
                    "abbr",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=32,
                        null=True,
                        unique=True,
                    ),
                ),
                (
                    "synonyms",
                    lamindb.base.fields.TextField(
                        blank=True, db_index=True, default=None, null=True
                    ),
                ),
                (
                    "description",
                    lamindb.base.fields.TextField(
                        blank=True, db_index=True, default=None, null=True
                    ),
                ),
                (
                    "scientific_name",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=255,
                        null=True,
                        unique=True,
                    ),
                ),
                (
                    "artifacts",
                    models.ManyToManyField(
                        related_name="organisms",
                        through="bionty.ArtifactOrganism",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "branch",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        db_default=1,
                        default=1,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.branch",
                    ),
                ),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        editable=False,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "created_on",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        db_default=1,
                        default=1,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.branch",
                    ),
                ),
                (
                    "parents",
                    models.ManyToManyField(
                        related_name="children", to="bionty.organism"
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.run.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
                (
                    "space",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        db_default=1,
                        default=1,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.space",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(
                models.Model,
                lamindb.models.can_curate.CanCurate,
                lamindb.models.has_parents.HasParents,
            ),
        ),
        migrations.AddField(
            model_name="gene",
            name="organism",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=None,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="genes",
                to="bionty.organism",
            ),
        ),
        migrations.AddField(
            model_name="cellmarker",
            name="organism",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=None,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="cell_markers",
                to="bionty.organism",
            ),
        ),
        migrations.AddField(
            model_name="artifactorganism",
            name="organism",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="links_artifact",
                to="bionty.organism",
            ),
        ),
        migrations.CreateModel(
            name="Pathway",
            fields=[
                (
                    "is_locked",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_default=False, default=False
                    ),
                ),
                (
                    "_aux",
                    lamindb.base.fields.JSONField(
                        blank=True, db_default=None, default=None, null=True
                    ),
                ),
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                (
                    "updated_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                (
                    "name",
                    lamindb.base.fields.CharField(
                        blank=True, db_index=True, default=None, max_length=255
                    ),
                ),
                (
                    "ontology_id",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=255,
                        null=True,
                    ),
                ),
                ("id", models.AutoField(primary_key=True, serialize=False)),
                (
                    "uid",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=bionty.uids.ontology,
                        max_length=14,
                        unique=True,
                    ),
                ),
                (
                    "abbr",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=32,
                        null=True,
                        unique=True,
                    ),
                ),
                (
                    "synonyms",
                    lamindb.base.fields.TextField(
                        blank=True, db_index=True, default=None, null=True
                    ),
                ),
                (
                    "description",
                    lamindb.base.fields.TextField(
                        blank=True, db_index=True, default=None, null=True
                    ),
                ),
                (
                    "artifacts",
                    models.ManyToManyField(
                        related_name="pathways",
                        through="bionty.ArtifactPathway",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "branch",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        db_default=1,
                        default=1,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.branch",
                    ),
                ),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        editable=False,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "created_on",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        db_default=1,
                        default=1,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.branch",
                    ),
                ),
                (
                    "genes",
                    models.ManyToManyField(related_name="pathways", to="bionty.gene"),
                ),
                (
                    "parents",
                    models.ManyToManyField(
                        related_name="children", to="bionty.pathway"
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.run.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
                (
                    "space",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        db_default=1,
                        default=1,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.space",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(
                models.Model,
                lamindb.models.can_curate.CanCurate,
                lamindb.models.has_parents.HasParents,
            ),
        ),
        migrations.AddField(
            model_name="artifactpathway",
            name="pathway",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="links_artifact",
                to="bionty.pathway",
            ),
        ),
        migrations.CreateModel(
            name="Phenotype",
            fields=[
                (
                    "is_locked",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_default=False, default=False
                    ),
                ),
                (
                    "_aux",
                    lamindb.base.fields.JSONField(
                        blank=True, db_default=None, default=None, null=True
                    ),
                ),
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                (
                    "updated_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                (
                    "name",
                    lamindb.base.fields.CharField(
                        blank=True, db_index=True, default=None, max_length=255
                    ),
                ),
                (
                    "ontology_id",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=255,
                        null=True,
                    ),
                ),
                ("id", models.AutoField(primary_key=True, serialize=False)),
                (
                    "uid",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=bionty.uids.ontology,
                        max_length=14,
                        unique=True,
                    ),
                ),
                (
                    "abbr",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=32,
                        null=True,
                        unique=True,
                    ),
                ),
                (
                    "synonyms",
                    lamindb.base.fields.TextField(
                        blank=True, db_index=True, default=None, null=True
                    ),
                ),
                (
                    "description",
                    lamindb.base.fields.TextField(
                        blank=True, db_index=True, default=None, null=True
                    ),
                ),
                (
                    "artifacts",
                    models.ManyToManyField(
                        related_name="phenotypes",
                        through="bionty.ArtifactPhenotype",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "branch",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        db_default=1,
                        default=1,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.branch",
                    ),
                ),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        editable=False,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "created_on",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        db_default=1,
                        default=1,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.branch",
                    ),
                ),
                (
                    "parents",
                    models.ManyToManyField(
                        related_name="children", to="bionty.phenotype"
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.run.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
                (
                    "space",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        db_default=1,
                        default=1,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.space",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(
                models.Model,
                lamindb.models.can_curate.CanCurate,
                lamindb.models.has_parents.HasParents,
            ),
        ),
        migrations.AddField(
            model_name="artifactphenotype",
            name="phenotype",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="links_artifact",
                to="bionty.phenotype",
            ),
        ),
        migrations.CreateModel(
            name="Protein",
            fields=[
                (
                    "is_locked",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_default=False, default=False
                    ),
                ),
                (
                    "_aux",
                    lamindb.base.fields.JSONField(
                        blank=True, db_default=None, default=None, null=True
                    ),
                ),
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                (
                    "updated_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("id", models.AutoField(primary_key=True, serialize=False)),
                (
                    "uid",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=bionty.uids.ontology,
                        max_length=14,
                        unique=True,
                    ),
                ),
                (
                    "abbr",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=32,
                        null=True,
                        unique=True,
                    ),
                ),
                (
                    "synonyms",
                    lamindb.base.fields.TextField(
                        blank=True, db_index=True, default=None, null=True
                    ),
                ),
                (
                    "description",
                    lamindb.base.fields.TextField(
                        blank=True, db_index=True, default=None, null=True
                    ),
                ),
                (
                    "name",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "uniprotkb_id",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=10,
                        null=True,
                        unique=True,
                    ),
                ),
                (
                    "length",
                    lamindb.base.fields.BigIntegerField(
                        blank=True, db_index=True, default=None, null=True
                    ),
                ),
                (
                    "gene_symbol",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "ensembl_gene_ids",
                    lamindb.base.fields.TextField(blank=True, default=None, null=True),
                ),
                (
                    "artifacts",
                    models.ManyToManyField(
                        related_name="proteins",
                        through="bionty.ArtifactProtein",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "branch",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        db_default=1,
                        default=1,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.branch",
                    ),
                ),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        editable=False,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "created_on",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        db_default=1,
                        default=1,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.branch",
                    ),
                ),
                (
                    "organism",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=None,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="proteins",
                        to="bionty.organism",
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.run.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
                (
                    "space",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        db_default=1,
                        default=1,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.space",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model, lamindb.models.can_curate.CanCurate),
        ),
        migrations.AddField(
            model_name="artifactprotein",
            name="protein",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="links_artifact",
                to="bionty.protein",
            ),
        ),
        migrations.CreateModel(
            name="RecordCellLine",
            fields=[
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        editable=False,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "feature",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_recordcellline",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "record",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="values_cell_line",
                        to="lamindb.record",
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.run.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
                (
                    "value",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_record",
                        to="bionty.cellline",
                    ),
                ),
            ],
            options={
                "unique_together": {("record", "value", "feature")},
            },
            bases=(lamindb.models.sqlrecord.IsLink, models.Model),
        ),
        migrations.AddField(
            model_name="cellline",
            name="records",
            field=models.ManyToManyField(
                related_name="cell_lines",
                through="bionty.RecordCellLine",
                to="lamindb.record",
            ),
        ),
        migrations.CreateModel(
            name="RecordCellMarker",
            fields=[
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        editable=False,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "feature",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_recordcellmarker",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "record",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="values_cell_marker",
                        to="lamindb.record",
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.run.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
                (
                    "value",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_record",
                        to="bionty.cellmarker",
                    ),
                ),
            ],
            options={
                "unique_together": {("record", "value", "feature")},
            },
            bases=(lamindb.models.sqlrecord.IsLink, models.Model),
        ),
        migrations.AddField(
            model_name="cellmarker",
            name="records",
            field=models.ManyToManyField(
                related_name="cell_markers",
                through="bionty.RecordCellMarker",
                to="lamindb.record",
            ),
        ),
        migrations.CreateModel(
            name="RecordCellType",
            fields=[
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        editable=False,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "feature",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_recordcelltype",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "record",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="values_cell_type",
                        to="lamindb.record",
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.run.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
                (
                    "value",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_record",
                        to="bionty.celltype",
                    ),
                ),
            ],
            options={
                "unique_together": {("record", "value", "feature")},
            },
            bases=(lamindb.models.sqlrecord.IsLink, models.Model),
        ),
        migrations.AddField(
            model_name="celltype",
            name="records",
            field=models.ManyToManyField(
                related_name="cell_types",
                through="bionty.RecordCellType",
                to="lamindb.record",
            ),
        ),
        migrations.CreateModel(
            name="RecordDevelopmentalStage",
            fields=[
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        editable=False,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "feature",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_recorddevelopmentalstage",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "record",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="values_developmental_stage",
                        to="lamindb.record",
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.run.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
                (
                    "value",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_record",
                        to="bionty.developmentalstage",
                    ),
                ),
            ],
            options={
                "unique_together": {("record", "value", "feature")},
            },
            bases=(lamindb.models.sqlrecord.IsLink, models.Model),
        ),
        migrations.AddField(
            model_name="developmentalstage",
            name="records",
            field=models.ManyToManyField(
                related_name="developmental_stages",
                through="bionty.RecordDevelopmentalStage",
                to="lamindb.record",
            ),
        ),
        migrations.CreateModel(
            name="RecordDisease",
            fields=[
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        editable=False,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "feature",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_recorddisease",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "record",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="values_disease",
                        to="lamindb.record",
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.run.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
                (
                    "value",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_record",
                        to="bionty.disease",
                    ),
                ),
            ],
            options={
                "unique_together": {("record", "value", "feature")},
            },
            bases=(lamindb.models.sqlrecord.IsLink, models.Model),
        ),
        migrations.AddField(
            model_name="disease",
            name="records",
            field=models.ManyToManyField(
                related_name="diseases",
                through="bionty.RecordDisease",
                to="lamindb.record",
            ),
        ),
        migrations.CreateModel(
            name="RecordEthnicity",
            fields=[
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        editable=False,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "feature",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_recordethnicity",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "record",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="values_ethnicity",
                        to="lamindb.record",
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.run.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
                (
                    "value",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_record",
                        to="bionty.ethnicity",
                    ),
                ),
            ],
            options={
                "unique_together": {("record", "value", "feature")},
            },
            bases=(lamindb.models.sqlrecord.IsLink, models.Model),
        ),
        migrations.AddField(
            model_name="ethnicity",
            name="records",
            field=models.ManyToManyField(
                related_name="ethnicities",
                through="bionty.RecordEthnicity",
                to="lamindb.record",
            ),
        ),
        migrations.CreateModel(
            name="RecordExperimentalFactor",
            fields=[
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        editable=False,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "feature",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_recordexperimentalfactor",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "record",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="values_experimental_factor",
                        to="lamindb.record",
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.run.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
                (
                    "value",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_record",
                        to="bionty.experimentalfactor",
                    ),
                ),
            ],
            options={
                "unique_together": {("record", "value", "feature")},
            },
            bases=(lamindb.models.sqlrecord.IsLink, models.Model),
        ),
        migrations.AddField(
            model_name="experimentalfactor",
            name="records",
            field=models.ManyToManyField(
                related_name="experimental_factors",
                through="bionty.RecordExperimentalFactor",
                to="lamindb.record",
            ),
        ),
        migrations.CreateModel(
            name="RecordGene",
            fields=[
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        editable=False,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "feature",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_recordgene",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "record",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="values_gene",
                        to="lamindb.record",
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.run.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
                (
                    "value",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_record",
                        to="bionty.gene",
                    ),
                ),
            ],
            options={
                "unique_together": {("record", "value", "feature")},
            },
            bases=(lamindb.models.sqlrecord.IsLink, models.Model),
        ),
        migrations.AddField(
            model_name="gene",
            name="records",
            field=models.ManyToManyField(
                related_name="genes", through="bionty.RecordGene", to="lamindb.record"
            ),
        ),
        migrations.CreateModel(
            name="RecordOrganism",
            fields=[
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        editable=False,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "feature",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_recordorganism",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "record",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="values_organism",
                        to="lamindb.record",
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.run.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
                (
                    "value",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_record",
                        to="bionty.organism",
                    ),
                ),
            ],
            options={
                "unique_together": {("record", "value", "feature")},
            },
            bases=(lamindb.models.sqlrecord.IsLink, models.Model),
        ),
        migrations.AddField(
            model_name="organism",
            name="records",
            field=models.ManyToManyField(
                related_name="organisms",
                through="bionty.RecordOrganism",
                to="lamindb.record",
            ),
        ),
        migrations.CreateModel(
            name="RecordPathway",
            fields=[
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        editable=False,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "feature",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_recordpathway",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "record",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="values_pathway",
                        to="lamindb.record",
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.run.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
                (
                    "value",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_record",
                        to="bionty.pathway",
                    ),
                ),
            ],
            options={
                "unique_together": {("record", "value", "feature")},
            },
            bases=(lamindb.models.sqlrecord.IsLink, models.Model),
        ),
        migrations.AddField(
            model_name="pathway",
            name="records",
            field=models.ManyToManyField(
                related_name="pathways",
                through="bionty.RecordPathway",
                to="lamindb.record",
            ),
        ),
        migrations.CreateModel(
            name="RecordPhenotype",
            fields=[
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        editable=False,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "feature",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_recordphenotype",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "record",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="values_phenotype",
                        to="lamindb.record",
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.run.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
                (
                    "value",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_record",
                        to="bionty.phenotype",
                    ),
                ),
            ],
            options={
                "unique_together": {("record", "value", "feature")},
            },
            bases=(lamindb.models.sqlrecord.IsLink, models.Model),
        ),
        migrations.AddField(
            model_name="phenotype",
            name="records",
            field=models.ManyToManyField(
                related_name="phenotypes",
                through="bionty.RecordPhenotype",
                to="lamindb.record",
            ),
        ),
        migrations.CreateModel(
            name="RecordProtein",
            fields=[
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        editable=False,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "feature",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_recordprotein",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "record",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="values_protein",
                        to="lamindb.record",
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.run.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
                (
                    "value",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_record",
                        to="bionty.protein",
                    ),
                ),
            ],
            options={
                "unique_together": {("record", "value", "feature")},
            },
            bases=(lamindb.models.sqlrecord.IsLink, models.Model),
        ),
        migrations.AddField(
            model_name="protein",
            name="records",
            field=models.ManyToManyField(
                related_name="proteins",
                through="bionty.RecordProtein",
                to="lamindb.record",
            ),
        ),
        migrations.CreateModel(
            name="RecordTissue",
            fields=[
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        editable=False,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "feature",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_recordtissue",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "record",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="values_tissue",
                        to="lamindb.record",
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.run.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
            ],
            bases=(lamindb.models.sqlrecord.IsLink, models.Model),
        ),
        migrations.CreateModel(
            name="SchemaCellMarker",
            fields=[
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "cellmarker",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_schema",
                        to="bionty.cellmarker",
                    ),
                ),
                (
                    "schema",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_cellmarker",
                        to="lamindb.schema",
                    ),
                ),
            ],
            options={
                "unique_together": {("schema", "cellmarker")},
            },
            bases=(models.Model, lamindb.models.sqlrecord.IsLink),
        ),
        migrations.AddField(
            model_name="cellmarker",
            name="schemas",
            field=models.ManyToManyField(
                related_name="cell_markers",
                through="bionty.SchemaCellMarker",
                to="lamindb.schema",
            ),
        ),
        migrations.CreateModel(
            name="SchemaGene",
            fields=[
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "gene",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_schema",
                        to="bionty.gene",
                    ),
                ),
                (
                    "schema",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_gene",
                        to="lamindb.schema",
                    ),
                ),
            ],
            options={
                "unique_together": {("schema", "gene")},
            },
            bases=(models.Model, lamindb.models.sqlrecord.IsLink),
        ),
        migrations.AddField(
            model_name="gene",
            name="schemas",
            field=models.ManyToManyField(
                related_name="genes", through="bionty.SchemaGene", to="lamindb.schema"
            ),
        ),
        migrations.CreateModel(
            name="SchemaPathway",
            fields=[
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "pathway",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_schema",
                        to="bionty.pathway",
                    ),
                ),
                (
                    "schema",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_pathway",
                        to="lamindb.schema",
                    ),
                ),
            ],
            options={
                "unique_together": {("schema", "pathway")},
            },
            bases=(models.Model, lamindb.models.sqlrecord.IsLink),
        ),
        migrations.AddField(
            model_name="pathway",
            name="schemas",
            field=models.ManyToManyField(
                related_name="pathways",
                through="bionty.SchemaPathway",
                to="lamindb.schema",
            ),
        ),
        migrations.CreateModel(
            name="SchemaProtein",
            fields=[
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "protein",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_schema",
                        to="bionty.protein",
                    ),
                ),
                (
                    "schema",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_protein",
                        to="lamindb.schema",
                    ),
                ),
            ],
            options={
                "unique_together": {("schema", "protein")},
            },
            bases=(models.Model, lamindb.models.sqlrecord.IsLink),
        ),
        migrations.AddField(
            model_name="protein",
            name="schemas",
            field=models.ManyToManyField(
                related_name="proteins",
                through="bionty.SchemaProtein",
                to="lamindb.schema",
            ),
        ),
        migrations.CreateModel(
            name="Source",
            fields=[
                (
                    "is_locked",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_default=False, default=False
                    ),
                ),
                (
                    "_aux",
                    lamindb.base.fields.JSONField(
                        blank=True, db_default=None, default=None, null=True
                    ),
                ),
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                (
                    "updated_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("id", models.AutoField(primary_key=True, serialize=False)),
                (
                    "uid",
                    lamindb.base.fields.CharField(
                        blank=True,
                        default=bionty.uids.source,
                        max_length=8,
                        unique=True,
                    ),
                ),
                (
                    "entity",
                    lamindb.base.fields.CharField(
                        blank=True, db_index=True, default=None, max_length=255
                    ),
                ),
                (
                    "organism",
                    lamindb.base.fields.CharField(
                        blank=True, db_index=True, default=None, max_length=255
                    ),
                ),
                (
                    "name",
                    lamindb.base.fields.CharField(
                        blank=True, db_index=True, default=None, max_length=255
                    ),
                ),
                (
                    "version",
                    lamindb.base.fields.CharField(
                        blank=True, db_index=True, default=None, max_length=255
                    ),
                ),
                (
                    "in_db",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_index=True, default=False
                    ),
                ),
                (
                    "currently_used",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_index=True, default=False
                    ),
                ),
                (
                    "description",
                    lamindb.base.fields.TextField(
                        blank=True, db_index=True, default=None, null=True
                    ),
                ),
                (
                    "url",
                    lamindb.base.fields.TextField(blank=True, default=None, null=True),
                ),
                (
                    "md5",
                    lamindb.base.fields.TextField(blank=True, default=None, null=True),
                ),
                (
                    "source_website",
                    lamindb.base.fields.TextField(blank=True, default=None, null=True),
                ),
                (
                    "artifacts",
                    models.ManyToManyField(
                        related_name="_source_artifact_of", to="lamindb.artifact"
                    ),
                ),
                (
                    "branch",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        db_default=1,
                        default=1,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.branch",
                    ),
                ),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        editable=False,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "created_on",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        db_default=1,
                        default=1,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.branch",
                    ),
                ),
                (
                    "dataframe_artifact",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="_source_dataframe_of",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.run.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
                (
                    "space",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        db_default=1,
                        default=1,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.space",
                    ),
                ),
            ],
            options={
                "abstract": False,
                "unique_together": {("entity", "name", "organism", "version")},
            },
        ),
        migrations.AddField(
            model_name="protein",
            name="source",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="bionty.source",
            ),
        ),
        migrations.AddField(
            model_name="phenotype",
            name="source",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="bionty.source",
            ),
        ),
        migrations.AddField(
            model_name="pathway",
            name="source",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="bionty.source",
            ),
        ),
        migrations.AddField(
            model_name="organism",
            name="source",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="bionty.source",
            ),
        ),
        migrations.AddField(
            model_name="gene",
            name="source",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="bionty.source",
            ),
        ),
        migrations.AddField(
            model_name="experimentalfactor",
            name="source",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="bionty.source",
            ),
        ),
        migrations.AddField(
            model_name="ethnicity",
            name="source",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="bionty.source",
            ),
        ),
        migrations.AddField(
            model_name="disease",
            name="source",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="bionty.source",
            ),
        ),
        migrations.AddField(
            model_name="developmentalstage",
            name="source",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="bionty.source",
            ),
        ),
        migrations.AddField(
            model_name="celltype",
            name="source",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="bionty.source",
            ),
        ),
        migrations.AddField(
            model_name="cellmarker",
            name="source",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="bionty.source",
            ),
        ),
        migrations.AddField(
            model_name="cellline",
            name="source",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="bionty.source",
            ),
        ),
        migrations.CreateModel(
            name="Tissue",
            fields=[
                (
                    "is_locked",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_default=False, default=False
                    ),
                ),
                (
                    "_aux",
                    lamindb.base.fields.JSONField(
                        blank=True, db_default=None, default=None, null=True
                    ),
                ),
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                (
                    "updated_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                (
                    "name",
                    lamindb.base.fields.CharField(
                        blank=True, db_index=True, default=None, max_length=255
                    ),
                ),
                (
                    "ontology_id",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=255,
                        null=True,
                    ),
                ),
                ("id", models.AutoField(primary_key=True, serialize=False)),
                (
                    "uid",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=bionty.uids.ontology,
                        max_length=14,
                        unique=True,
                    ),
                ),
                (
                    "abbr",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=32,
                        null=True,
                        unique=True,
                    ),
                ),
                (
                    "synonyms",
                    lamindb.base.fields.TextField(
                        blank=True, db_index=True, default=None, null=True
                    ),
                ),
                (
                    "description",
                    lamindb.base.fields.TextField(
                        blank=True, db_index=True, default=None, null=True
                    ),
                ),
                (
                    "artifacts",
                    models.ManyToManyField(
                        related_name="tissues",
                        through="bionty.ArtifactTissue",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "branch",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        db_default=1,
                        default=1,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.branch",
                    ),
                ),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        editable=False,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "created_on",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        db_default=1,
                        default=1,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.branch",
                    ),
                ),
                (
                    "parents",
                    models.ManyToManyField(related_name="children", to="bionty.tissue"),
                ),
                (
                    "records",
                    models.ManyToManyField(
                        related_name="tissues",
                        through="bionty.RecordTissue",
                        to="lamindb.record",
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.run.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
                (
                    "source",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="bionty.source",
                    ),
                ),
                (
                    "space",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        db_default=1,
                        default=1,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.space",
                    ),
                ),
            ],
            options={
                "abstract": False,
                "unique_together": {("name", "ontology_id")},
            },
            bases=(
                models.Model,
                lamindb.models.can_curate.CanCurate,
                lamindb.models.has_parents.HasParents,
            ),
        ),
        migrations.AddField(
            model_name="recordtissue",
            name="value",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="links_record",
                to="bionty.tissue",
            ),
        ),
        migrations.AddField(
            model_name="artifacttissue",
            name="tissue",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="links_artifact",
                to="bionty.tissue",
            ),
        ),
        migrations.AlterUniqueTogether(
            name="artifactcellline",
            unique_together={("artifact", "cellline", "feature")},
        ),
        migrations.AlterUniqueTogether(
            name="artifactcellmarker",
            unique_together={("artifact", "cellmarker", "feature")},
        ),
        migrations.AlterUniqueTogether(
            name="artifactcelltype",
            unique_together={("artifact", "celltype", "feature")},
        ),
        migrations.AlterUniqueTogether(
            name="artifactdevelopmentalstage",
            unique_together={("artifact", "developmentalstage", "feature")},
        ),
        migrations.AlterUniqueTogether(
            name="artifactdisease",
            unique_together={("artifact", "disease", "feature")},
        ),
        migrations.AlterUniqueTogether(
            name="artifactethnicity",
            unique_together={("artifact", "ethnicity", "feature")},
        ),
        migrations.AlterUniqueTogether(
            name="artifactexperimentalfactor",
            unique_together={("artifact", "experimentalfactor", "feature")},
        ),
        migrations.AlterUniqueTogether(
            name="artifactgene",
            unique_together={("artifact", "gene", "feature")},
        ),
        migrations.AlterUniqueTogether(
            name="artifactorganism",
            unique_together={("artifact", "organism", "feature")},
        ),
        migrations.AlterUniqueTogether(
            name="artifactpathway",
            unique_together={("artifact", "pathway", "feature")},
        ),
        migrations.AlterUniqueTogether(
            name="artifactphenotype",
            unique_together={("artifact", "phenotype", "feature")},
        ),
        migrations.AlterUniqueTogether(
            name="artifactprotein",
            unique_together={("artifact", "protein", "feature")},
        ),
        migrations.AlterUniqueTogether(
            name="phenotype",
            unique_together={("name", "ontology_id")},
        ),
        migrations.AlterUniqueTogether(
            name="pathway",
            unique_together={("name", "ontology_id")},
        ),
        migrations.AlterUniqueTogether(
            name="organism",
            unique_together={("name", "ontology_id")},
        ),
        migrations.AlterUniqueTogether(
            name="experimentalfactor",
            unique_together={("name", "ontology_id")},
        ),
        migrations.AlterUniqueTogether(
            name="ethnicity",
            unique_together={("name", "ontology_id")},
        ),
        migrations.AlterUniqueTogether(
            name="disease",
            unique_together={("name", "ontology_id")},
        ),
        migrations.AlterUniqueTogether(
            name="developmentalstage",
            unique_together={("name", "ontology_id")},
        ),
        migrations.AlterUniqueTogether(
            name="celltype",
            unique_together={("name", "ontology_id")},
        ),
        migrations.AlterUniqueTogether(
            name="cellmarker",
            unique_together={("name", "organism")},
        ),
        migrations.AlterUniqueTogether(
            name="cellline",
            unique_together={("name", "ontology_id")},
        ),
        migrations.AlterUniqueTogether(
            name="recordtissue",
            unique_together={("record", "value", "feature")},
        ),
        migrations.AlterUniqueTogether(
            name="artifacttissue",
            unique_together={("artifact", "tissue", "feature")},
        ),
    ]
